/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.gson.Gson;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.utilization.Client;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.Job;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.NuixCaseStat;
import com.nuix.automate.utils.utilization.Operation;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.Server;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.VersionedUtilizationRecords;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.ScanCaseStatisticsOperation;
import com.nuix.automate.workflow.core.execution.operations.SessionStats;
import com.nuix.automate.workflow.core.licence.NuixLicenceFactory;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixCaseUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import nuix.Case;
import nuix.CaseNotesStore;
import nuix.CaseStatistics;
import nuix.CompoundCase;
import nuix.DateRange;
import nuix.HistoryEvent;
import nuix.Item;
import nuix.ItemSet;
import nuix.ProductionSet;
import nuix.Utilities;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.GrowingChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class ScanCaseStatisticsOperationImplementation
extends ScanCaseStatisticsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ScanCaseStatisticsOperation.class);
    private transient String stageName;
    private transient AtomicLong processedItems;
    private transient long stageTotalItems;
    private transient int stageId;
    private transient int stageCount;
    private transient long caseLastModifiedMillis;
    private transient NuixCase caseUtilizationModel;
    private transient List<NuixCaseStat> nuixCaseStats;
    private transient ResourcePool resourcePool;
    private transient Client client;
    private transient String customDigestSizeMetadataFieldName;

    private Set<String> getScanOptions() {
        HashSet<String> options = new HashSet<String>();
        if (this.scanEvidenceContainers) {
            options.add("scanEvidenceContainers");
        }
        if (this.scanCustodians) {
            options.add("scanCustodians");
        }
        if (this.scanLanguages) {
            options.add("scanLanguages");
        }
        if (this.scanTags) {
            options.add("scanTags");
        }
        if (this.scanDateRanges) {
            options.add("scanDateRanges");
        }
        if (this.scanItemSets) {
            options.add("scanItemSets");
        }
        if (this.scanProductionSets) {
            options.add("scanProductionSets");
        }
        if (this.scanExclusions) {
            options.add("scanExclusions");
        }
        if (this.scanHistory) {
            options.add("scanHistory");
        }
        options.add("maxScanDuration=" + this.maxScanDuration);
        return options;
    }

    private VersionedUtilizationRecords readExistingUtilizationRecords(AtomicReference<Path> mostRecentUtilizationPath) throws ParameterException, IOException {
        String statsFolder = this.executionContext.evalParameters("{case_folder}/Stores/Statistics", this);
        Path statsPath = Paths.get(statsFolder, new String[0]);
        if (!Files.exists(statsPath, new LinkOption[0])) {
            return null;
        }
        Set<String> scanOptions = this.getScanOptions();
        VersionedUtilizationRecords[] mostRecentValidVersion = new VersionedUtilizationRecords[]{null};
        try (Stream<Path> paths = Files.find(statsPath, 1, (path, attributes) -> attributes.isRegularFile(), new FileVisitOption[0]);){
            paths.forEach(path -> {
                try {
                    String fileName = path.getFileName().toString();
                    if (fileName.startsWith("VersionedCaseStatistics_") && fileName.endsWith(".json")) {
                        LOGGER.info("Testing " + String.valueOf(path));
                        List<String> fileLines = Files.readAllLines(path);
                        String fileContents = String.join((CharSequence)"", fileLines);
                        VersionedUtilizationRecords versionedUtilizationRecords = (VersionedUtilizationRecords)SerializationUtils.fromJson((String)fileContents, VersionedUtilizationRecords.class);
                        if (versionedUtilizationRecords.getWarnings() != null && versionedUtilizationRecords.getWarnings().size() > 0) {
                            LOGGER.info("Skipping previous utilization " + String.valueOf(path) + " because it has warnings");
                            return;
                        }
                        Set previousScanOptions = versionedUtilizationRecords.getScanOptions();
                        for (String scanOption : scanOptions) {
                            if (previousScanOptions.contains(scanOption)) continue;
                            LOGGER.info("Skipping previous utilization " + String.valueOf(path) + " because it did not use the scan option: " + scanOption);
                            return;
                        }
                        for (String previousScanOption : previousScanOptions) {
                            if (scanOptions.contains(previousScanOption)) continue;
                            LOGGER.info("Skipping previous utilization " + String.valueOf(path) + " because it used an old scan option: " + previousScanOption);
                            return;
                        }
                        Version currentVersion = new Version(this.executionContext.licenceSession.getProductVersion());
                        Version previousVersion = new Version(versionedUtilizationRecords.getProducerVersion());
                        if (currentVersion.getMajor() != previousVersion.getMajor() || currentVersion.getMinor() != previousVersion.getMinor()) {
                            LOGGER.info("Skipping previous utilization " + String.valueOf(path) + " because it used produced with an old version: " + versionedUtilizationRecords.getProducerVersion() + ", instead of " + this.executionContext.licenceSession.getProductVersion());
                            return;
                        }
                        if (mostRecentValidVersion[0] == null) {
                            LOGGER.info("Detected recent utilization from " + String.valueOf(new DateTime(versionedUtilizationRecords.getScanTime())));
                            mostRecentValidVersion[0] = versionedUtilizationRecords;
                            mostRecentUtilizationPath.set((Path)path);
                        } else if (mostRecentValidVersion[0].getScanTime() < versionedUtilizationRecords.getScanTime()) {
                            LOGGER.info("Detected more recent utilization from " + String.valueOf(new DateTime(versionedUtilizationRecords.getScanTime())));
                            mostRecentValidVersion[0] = versionedUtilizationRecords;
                            mostRecentUtilizationPath.set((Path)path);
                        } else {
                            LOGGER.info("Skipping older utilization from " + String.valueOf(new DateTime(versionedUtilizationRecords.getScanTime())));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse previous utilization" + String.valueOf(path) + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                }
            });
        }
        if (mostRecentValidVersion[0] != null) {
            LOGGER.info("Most recent utilization " + String.valueOf(new DateTime(mostRecentValidVersion[0].getScanTime())));
        }
        return mostRecentValidVersion[0];
    }

    private long getLatestModifyingEvent() {
        return this.caseLastModifiedMillis;
    }

    private long getLatestOpenCaseEvent() {
        return this.getLatestEventOfType(new String[]{"openSession"}, 1);
    }

    private long getLatestEventOfType(String[] types, int skipEvents) {
        List<String> eventTypes = Arrays.asList(types);
        long latestEventMillis = 0L;
        for (String eventType : eventTypes) {
            boolean eventCount = false;
            HashMap<String, String> historyOptions = new HashMap<String, String>();
            historyOptions.put("order", "start_date_descending");
            historyOptions.put("type", eventType);
            try {
                Iterable history = this.executionContext.nuixCase.getHistory(historyOptions);
                Iterator iterator = history.iterator();
                HistoryEvent firstEvent = (HistoryEvent)iterator.next();
                for (int i = 0; i < skipEvents; ++i) {
                    LOGGER.info("Skipping event " + i);
                    if (firstEvent == null) continue;
                    firstEvent = (HistoryEvent)iterator.next();
                }
                if (firstEvent == null) continue;
                long eventTime = firstEvent.getStartDate().getMillis();
                LOGGER.info("Discovered event " + eventType + " at " + String.valueOf(new DateTime(eventTime)));
                latestEventMillis = Math.max(latestEventMillis, eventTime);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot get first event of type " + eventType + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            }
        }
        return latestEventMillis;
    }

    @Override
    public void startTriggered() throws Exception {
        this.executionContext.closeAllTabs();
        ScanCaseStatisticsOperationImplementation currentOperation = this;
        this.nuixCaseStats = Collections.synchronizedList(new ArrayList());
        this.utilizationRecords.setNuixCaseStats(this.nuixCaseStats);
        this.processedItems = new AtomicLong(0L);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageCount = 0;
                if (this.scanEvidenceContainers) {
                    ++this.stageCount;
                }
                if (this.scanCustodians) {
                    ++this.stageCount;
                }
                if (this.scanLanguages) {
                    ++this.stageCount;
                }
                if (this.scanTags) {
                    ++this.stageCount;
                }
                if (this.scanDateRanges) {
                    ++this.stageCount;
                }
                if (this.scanItemSets) {
                    ++this.stageCount;
                }
                if (this.scanProductionSets) {
                    ++this.stageCount;
                }
                if (this.scanExclusions) {
                    ++this.stageCount;
                }
                if (this.scanHistory) {
                    ++this.stageCount;
                }
                this.stageId = 0;
                boolean usePreviousScanResults = false;
                if (!this.forceScanUpToDateCases) {
                    AtomicReference<Path> mostRecentUtilizationPath = new AtomicReference<Path>();
                    Iterator existingRecords = null;
                    try {
                        this.readExistingUtilizationRecords(mostRecentUtilizationPath);
                    }
                    catch (ParameterException | IOException ex) {
                        LOGGER.warn("Cannot read existing utilization records", ex);
                    }
                    if (existingRecords != null) {
                        long lastOpenEventMs = this.getLatestOpenCaseEvent();
                        LOGGER.info("Last utilization records: " + String.valueOf(new DateTime(existingRecords.getScanTime())));
                        LOGGER.info("Case last opened (except this time): " + String.valueOf(new DateTime(lastOpenEventMs)));
                        if (existingRecords.getScanTime() < lastOpenEventMs) {
                            LOGGER.info("Previous scan results are stale");
                        } else {
                            LOGGER.info("Using previous scan results");
                            this.utilizationRecords = existingRecords.getUtilizationRecords();
                            this.addExecutionLog(this.iu.getFormattedString("ScanCaseStatistics.Log.UsingCachedStats", (Object)FormattingUtils.dateTimeToLocalString((DateTime)new DateTime(existingRecords.getScanTime()))));
                            usePreviousScanResults = true;
                            LOGGER.info("Updating previous scan date");
                            if (mostRecentUtilizationPath.get() != null) {
                                existingRecords.setScanTime(new DateTime(DateTimeZone.UTC).getMillis());
                                try {
                                    Files.write(mostRecentUtilizationPath.get(), SerializationUtils.toJson(existingRecords).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                                }
                                catch (IOException e) {
                                    LOGGER.warn("Cannot update previous scan date");
                                }
                            }
                        }
                    }
                }
                if (!usePreviousScanResults) {
                    FixedSizeChunkPartitioner partitioner;
                    String nuixCaseId;
                    CaseStatistics caseStatistics;
                    ArrayList<Case> cases = new ArrayList<Case>();
                    if (this.executionContext.nuixCase instanceof CompoundCase) {
                        cases.addAll(((CompoundCase)this.executionContext.nuixCase).getChildCases());
                    } else {
                        cases.add(this.executionContext.nuixCase);
                    }
                    if (this.scanEvidenceContainers) {
                        this.stageName = this.iu.getString("ScanCaseStatistics.Stage.ScanEvidenceContainers");
                        this.stageTotalItems = 1L;
                        this.processedItems.set(0L);
                        for (Case nuixCase : cases) {
                            try {
                                caseStatistics = nuixCase.getStatistics();
                                nuixCaseId = nuixCase.getGuid();
                                ArrayList rootItems = new ArrayList();
                                rootItems.addAll(nuixCase.getRootItems());
                                this.stageTotalItems += (long)rootItems.size();
                                partitioner = new FixedSizeChunkPartitioner(rootItems, 100000);
                                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                    if (this.stopRequested) {
                                        throw new WorkflowExecutionStopRequested();
                                    }
                                    while (iterator.hasNext()) {
                                        if (this.stopRequested) {
                                            throw new WorkflowExecutionStopRequested();
                                        }
                                        try {
                                            Item rootItem = (Item)iterator.next();
                                            NuixCaseStat nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Evidence Container");
                                            nuixCaseStat.setMetricValue(rootItem.getName());
                                            String query = "path-guid:" + rootItem.getGuid();
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                            nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                            if (this.computeDigestSize) {
                                                nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                            }
                                            this.nuixCaseStats.add(nuixCaseStat);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Cannot compute Evidence Containers", (Throwable)e);
                                            this.addWarning("Cannot scan Evidence Containers, " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
                                        }
                                        this.processedItems.incrementAndGet();
                                    }
                                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            }
                            catch (WorkflowExecutionStopRequested e) {
                                this.trackStopped();
                                return;
                            }
                            catch (IOException e) {
                                LOGGER.error("Cannot scan evidence containers", (Throwable)e);
                                this.addWarning("Cannot scan Evidence Containers, " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
                            }
                        }
                        ++this.stageId;
                    }
                    if (this.scanCustodians) {
                        this.stageName = this.iu.getString("ScanCaseStatistics.Stage.ScanCustodians");
                        this.stageTotalItems = 1L;
                        this.processedItems.set(0L);
                        for (Case nuixCase : cases) {
                            try {
                                caseStatistics = nuixCase.getStatistics();
                                nuixCaseId = nuixCase.getGuid();
                                HashSet custodians = new HashSet();
                                custodians.addAll(nuixCase.getAllCustodians());
                                this.stageTotalItems += (long)custodians.size();
                                partitioner = new GrowingChunkPartitioner(custodians);
                                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                    if (this.stopRequested) {
                                        throw new WorkflowExecutionStopRequested();
                                    }
                                    while (iterator.hasNext()) {
                                        if (this.stopRequested) {
                                            throw new WorkflowExecutionStopRequested();
                                        }
                                        try {
                                            String custodian = (String)iterator.next();
                                            NuixCaseStat nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Custodian");
                                            nuixCaseStat.setMetricValue(custodian);
                                            String query = "custodian:\"" + custodian.replace("\"", "\\\"") + "\"";
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                            nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                            if (this.computeDigestSize) {
                                                nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                            }
                                            this.nuixCaseStats.add(nuixCaseStat);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Cannot scan Custodians", (Throwable)e);
                                            this.addWarning("Cannot scan Custodians, " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
                                        }
                                        this.processedItems.incrementAndGet();
                                    }
                                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            }
                            catch (WorkflowExecutionStopRequested e) {
                                this.trackStopped();
                                return;
                            }
                        }
                        ++this.stageId;
                    }
                    if (this.scanLanguages) {
                        this.stageName = this.iu.getString("ScanCaseStatistics.Stage.ScanLanguages");
                        this.stageTotalItems = 1L;
                        this.processedItems.set(0L);
                        for (Case nuixCase : cases) {
                            try {
                                caseStatistics = nuixCase.getStatistics();
                                nuixCaseId = nuixCase.getGuid();
                                HashSet languages = new HashSet();
                                languages.addAll(nuixCase.getLanguages());
                                this.stageTotalItems += (long)languages.size();
                                partitioner = new GrowingChunkPartitioner(languages);
                                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                    if (this.stopRequested) {
                                        throw new WorkflowExecutionStopRequested();
                                    }
                                    while (iterator.hasNext()) {
                                        if (this.stopRequested) {
                                            throw new WorkflowExecutionStopRequested();
                                        }
                                        try {
                                            String language = (String)iterator.next();
                                            NuixCaseStat nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Language");
                                            nuixCaseStat.setMetricValue(language);
                                            String query = "lang:\"" + language + "\"";
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                            nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                            if (this.computeDigestSize) {
                                                nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                            }
                                            this.nuixCaseStats.add(nuixCaseStat);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Cannot scan Languages", (Throwable)e);
                                            this.addWarning("Cannot scan Languages, " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
                                        }
                                        this.processedItems.incrementAndGet();
                                    }
                                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            }
                            catch (WorkflowExecutionStopRequested e) {
                                this.trackStopped();
                                return;
                            }
                        }
                        ++this.stageId;
                    }
                    if (this.scanTags) {
                        this.stageName = this.iu.getString("ScanCaseStatistics.Stage.ScanTags");
                        this.stageTotalItems = 1L;
                        this.processedItems.set(0L);
                        for (Case nuixCase : cases) {
                            try {
                                caseStatistics = nuixCase.getStatistics();
                                nuixCaseId = nuixCase.getGuid();
                                HashSet tags = new HashSet();
                                tags.addAll(nuixCase.getAllTags());
                                this.stageTotalItems += (long)tags.size();
                                partitioner = new GrowingChunkPartitioner(tags);
                                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                    if (this.stopRequested) {
                                        throw new WorkflowExecutionStopRequested();
                                    }
                                    while (iterator.hasNext()) {
                                        if (this.stopRequested) {
                                            throw new WorkflowExecutionStopRequested();
                                        }
                                        try {
                                            String tag = (String)iterator.next();
                                            NuixCaseStat nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Tag");
                                            nuixCaseStat.setMetricValue(tag);
                                            String query = "tag:\"" + tag.replace("\"", "\\\"") + "\"";
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                            nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                            if (this.computeDigestSize) {
                                                nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                            }
                                            this.nuixCaseStats.add(nuixCaseStat);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Cannot scan Tags", (Throwable)e);
                                            this.addWarning("Cannot scan Tags, " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
                                        }
                                        this.processedItems.incrementAndGet();
                                    }
                                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            }
                            catch (WorkflowExecutionStopRequested e) {
                                this.trackStopped();
                                return;
                            }
                        }
                        ++this.stageId;
                    }
                    if (this.scanDateRanges) {
                        this.stageName = this.iu.getString("ScanCaseStatistics.Stage.ScanDateRanges");
                        this.stageTotalItems = 1L;
                        this.processedItems.set(0L);
                        for (Case nuixCase : cases) {
                            try {
                                long startMonth;
                                caseStatistics = nuixCase.getStatistics();
                                nuixCaseId = nuixCase.getGuid();
                                DateRange dateRange = caseStatistics.getCaseDateRange();
                                long currentMonth = DateTime.now((DateTimeZone)DateTimeZone.UTC).getYear() * 12 + DateTime.now((DateTimeZone)DateTimeZone.UTC).getMonthOfYear() - 1;
                                long lastMonth = startMonth = (long)(DateTime.now((DateTimeZone)DateTimeZone.UTC).getYear() * 12 + DateTime.now((DateTimeZone)DateTimeZone.UTC).getMonthOfYear() - 1);
                                try {
                                    startMonth = dateRange.getEarliest().getYear() * 12 + dateRange.getEarliest().getMonthValue() - 1;
                                    lastMonth = dateRange.getLatest().getYear() * 12 + dateRange.getLatest().getMonthValue() - 1;
                                    if (lastMonth > currentMonth + 120L) {
                                        LOGGER.warn("Invalid latest date " + String.valueOf(dateRange.getLatest()) + ". Setting to 10 years in the future");
                                        lastMonth = currentMonth + 120L;
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.warn("Cannot get case daterange", (Throwable)e);
                                }
                                ArrayList<Long> months = new ArrayList<Long>();
                                for (long month = startMonth; month <= lastMonth; ++month) {
                                    months.add(month);
                                }
                                this.stageTotalItems += (long)months.size();
                                GrowingChunkPartitioner partitioner2 = new GrowingChunkPartitioner(months);
                                Parallel.forEachPartitioned((Partitioner)partitioner2, iterator -> {
                                    if (this.stopRequested) {
                                        throw new WorkflowExecutionStopRequested();
                                    }
                                    while (iterator.hasNext()) {
                                        if (this.stopRequested) {
                                            throw new WorkflowExecutionStopRequested();
                                        }
                                        try {
                                            Long month = (Long)iterator.next();
                                            NuixCaseStat nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Month");
                                            int year = (int)(month / 12L);
                                            int monthOfYear = (int)(month % 12L + 1L);
                                            String paddedMonthOfYear = String.format("%02d", monthOfYear);
                                            String printableMonth = year + "-" + paddedMonthOfYear;
                                            nuixCaseStat.setMetricValue(printableMonth);
                                            int lastDayOfMonth = 28;
                                            try {
                                                lastDayOfMonth = new DateTime(year, monthOfYear, 1, 0, 0, 1).dayOfMonth().withMaximumValue().getDayOfMonth();
                                            }
                                            catch (Exception e) {
                                                try {
                                                    lastDayOfMonth = new DateTime(year, monthOfYear, 2, 0, 0, 1).dayOfMonth().withMaximumValue().getDayOfMonth();
                                                }
                                                catch (Exception e2) {
                                                    LOGGER.error("Cannot get last month date");
                                                }
                                            }
                                            String query = "item-date:[" + year + paddedMonthOfYear + "01 TO " + year + paddedMonthOfYear + lastDayOfMonth + "]";
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            if (nuixCaseStat.getItemsCount() > 0L) {
                                                nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                                nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                                nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                                nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                                if (this.computeDigestSize) {
                                                    nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                                }
                                                this.nuixCaseStats.add(nuixCaseStat);
                                            }
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Cannot scan Date Ranges", (Throwable)e);
                                            this.addWarning("Cannot scan Date Ranges, " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
                                        }
                                        this.processedItems.incrementAndGet();
                                    }
                                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            }
                            catch (WorkflowExecutionStopRequested e) {
                                this.trackStopped();
                                return;
                            }
                        }
                        ++this.stageId;
                    }
                    if (this.scanItemSets) {
                        this.stageName = this.iu.getString("ScanCaseStatistics.Stage.ScanItemSets");
                        this.stageTotalItems = 1L;
                        this.processedItems.set(0L);
                        for (Case nuixCase : cases) {
                            try {
                                caseStatistics = nuixCase.getStatistics();
                                nuixCaseId = nuixCase.getGuid();
                                HashSet itemSets = new HashSet();
                                itemSets.addAll(nuixCase.getAllItemSets());
                                this.stageTotalItems += (long)itemSets.size();
                                partitioner = new GrowingChunkPartitioner(itemSets);
                                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                    if (this.stopRequested) {
                                        throw new WorkflowExecutionStopRequested();
                                    }
                                    while (iterator.hasNext()) {
                                        if (this.stopRequested) {
                                            throw new WorkflowExecutionStopRequested();
                                        }
                                        try {
                                            ItemSet itemSet = (ItemSet)iterator.next();
                                            NuixCaseStat nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Item Set");
                                            nuixCaseStat.setMetricValue(itemSet.getName());
                                            String query = "item-set:" + itemSet.getGuid();
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                            nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                            if (this.computeDigestSize) {
                                                nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                            }
                                            this.nuixCaseStats.add(nuixCaseStat);
                                            nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Item Set Originals");
                                            nuixCaseStat.setMetricValue(itemSet.getName());
                                            query = "item-set-originals:" + itemSet.getGuid();
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                            nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                            if (this.computeDigestSize) {
                                                nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                            }
                                            this.nuixCaseStats.add(nuixCaseStat);
                                            nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Item Set Duplicates");
                                            nuixCaseStat.setMetricValue(itemSet.getName());
                                            query = "item-set-duplicates:" + itemSet.getGuid();
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                            nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                            if (this.computeDigestSize) {
                                                nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                            }
                                            this.nuixCaseStats.add(nuixCaseStat);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Cannot scan Item Sets", (Throwable)e);
                                            this.addWarning("Cannot scan Item Sets, " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
                                        }
                                        this.processedItems.incrementAndGet();
                                    }
                                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            }
                            catch (WorkflowExecutionStopRequested e) {
                                this.trackStopped();
                                return;
                            }
                        }
                        ++this.stageId;
                    }
                    if (this.scanProductionSets) {
                        this.stageName = this.iu.getString("ScanCaseStatistics.Stage.ScanProductionSets");
                        this.stageTotalItems = 1L;
                        this.processedItems.set(0L);
                        for (Case nuixCase : cases) {
                            try {
                                caseStatistics = nuixCase.getStatistics();
                                nuixCaseId = nuixCase.getGuid();
                                ArrayList productionSets = new ArrayList();
                                productionSets.addAll(nuixCase.getProductionSets());
                                this.stageTotalItems += (long)productionSets.size();
                                partitioner = new GrowingChunkPartitioner(productionSets);
                                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                    if (this.stopRequested) {
                                        throw new WorkflowExecutionStopRequested();
                                    }
                                    while (iterator.hasNext()) {
                                        if (this.stopRequested) {
                                            throw new WorkflowExecutionStopRequested();
                                        }
                                        try {
                                            ProductionSet productionSet = (ProductionSet)iterator.next();
                                            NuixCaseStat nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Production Set");
                                            nuixCaseStat.setMetricValue(productionSet.getName());
                                            String query = "production-set-guid:" + productionSet.getGuid();
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                            nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                            if (this.computeDigestSize) {
                                                nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                            }
                                            this.nuixCaseStats.add(nuixCaseStat);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Cannot scan Production Sets", (Throwable)e);
                                            this.addWarning("Cannot scan Production Sets, " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
                                        }
                                        this.processedItems.incrementAndGet();
                                    }
                                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            }
                            catch (WorkflowExecutionStopRequested e) {
                                this.trackStopped();
                                return;
                            }
                        }
                        ++this.stageId;
                    }
                    if (this.scanExclusions) {
                        this.stageName = this.iu.getString("ScanCaseStatistics.Stage.ScanExclusions");
                        this.stageTotalItems = 1L;
                        this.processedItems.set(0L);
                        for (Case nuixCase : cases) {
                            try {
                                caseStatistics = nuixCase.getStatistics();
                                nuixCaseId = nuixCase.getGuid();
                                HashSet exclusions = new HashSet();
                                exclusions.addAll(nuixCase.getAllExclusions());
                                this.stageTotalItems += (long)exclusions.size();
                                partitioner = new GrowingChunkPartitioner(exclusions);
                                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                    if (this.stopRequested) {
                                        throw new WorkflowExecutionStopRequested();
                                    }
                                    while (iterator.hasNext()) {
                                        if (this.stopRequested) {
                                            throw new WorkflowExecutionStopRequested();
                                        }
                                        try {
                                            String exclusion = (String)iterator.next();
                                            NuixCaseStat nuixCaseStat = new NuixCaseStat();
                                            nuixCaseStat.setNuixCaseId(nuixCaseId);
                                            nuixCaseStat.setMetricType("Exclusion");
                                            nuixCaseStat.setMetricValue(exclusion);
                                            String query = "exclusion:\"" + exclusion.replace("\"", "\\\"") + "\"";
                                            nuixCaseStat.setItemsCount(nuixCase.count(query));
                                            nuixCaseStat.setAuditedCount(nuixCase.count(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalCount(nuixCase.count(query + " AND flag:physical_file"));
                                            nuixCaseStat.setAuditedSize(caseStatistics.getAuditSize(query + " AND flag:audited"));
                                            nuixCaseStat.setPhysicalSize(caseStatistics.getFileSize(query + " AND flag:physical_file"));
                                            if (this.computeDigestSize) {
                                                nuixCaseStat.setDigestSize(NuixUtils.getDigestSize(nuixCase, query, this.customDigestSizeMetadataFieldName));
                                            }
                                            this.nuixCaseStats.add(nuixCaseStat);
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Cannot scan Exclusions", (Throwable)e);
                                            this.addWarning("Cannot scan Exclusions, " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
                                        }
                                        this.processedItems.incrementAndGet();
                                    }
                                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            }
                            catch (WorkflowExecutionStopRequested e) {
                                this.trackStopped();
                                return;
                            }
                        }
                        ++this.stageId;
                    }
                    if (this.scanHistory) {
                        this.stageName = this.iu.getString("ScanCaseStatistics.Stage.ScanHistory");
                        this.stageTotalItems = 1L;
                        this.processedItems.set(0L);
                        try {
                            this.resourcePool = new ResourcePool();
                            CaseNotesStore notesStore = this.executionContext.nuixCase.getCaseNotesStore();
                            String resourcePoolName = notesStore.getNoteAsString("automate_resource_pool_name");
                            String resourcePoolId = notesStore.getNoteAsString("automate_resource_pool_id");
                            if (resourcePoolName != null && resourcePoolId != null) {
                                this.resourcePool.setResourcePoolName(resourcePoolName);
                            } else {
                                this.resourcePool.setResourcePoolName(OsUtils.getComputerName());
                                resourcePoolId = UidUtils.fromString((String)this.resourcePool.getResourcePoolName(), (String)"resourcePool").toString();
                            }
                            this.resourcePool.setResourcePoolId(resourcePoolId);
                            this.utilizationRecords.getResourcePools().add(this.resourcePool);
                            this.client = new Client();
                            String clientName = notesStore.getNoteAsString("automate_client_name");
                            String clientId = notesStore.getNoteAsString("automate_client_id");
                            if (clientName != null && clientId != null) {
                                this.client.setClientId(clientId);
                                this.client.setClientName(clientName);
                            } else {
                                this.client.setClientId(UidUtils.fromString((String)this.executionContext.nuixCase.getGuid(), (String)"client").toString());
                                this.client.setClientName(this.executionContext.nuixCase.getName());
                            }
                            this.utilizationRecords.getClients().add(this.client);
                            if (this.executionContext.nuixCase instanceof CompoundCase) {
                                Case c = this.executionContext.nuixCase;
                                this.caseUtilizationModel = new NuixCase();
                                this.caseUtilizationModel.setNuixCaseId(c.getGuid());
                                this.caseUtilizationModel.setNuixCaseName(c.getName());
                                this.caseUtilizationModel.setNuixCaseLocation(c.getLocation().getAbsolutePath());
                                this.caseUtilizationModel.setNuixCaseVersion(NuixCaseUtils.getNuixCaseVersion(c.getLocation().getAbsolutePath()));
                                this.caseUtilizationModel.setNuixCaseCreationEpoch(NuixCaseUtils.getNuixCaseCreationTime(c.getLocation().getAbsolutePath()));
                                this.utilizationRecords.getNuixCases().add(this.caseUtilizationModel);
                                for (Case childCase : ((CompoundCase)this.executionContext.nuixCase).getChildCases()) {
                                    this.processCase(childCase);
                                }
                                this.caseUtilizationModel.setNuixCaseLastModifiedEpoch(this.getLatestModifyingEvent());
                            } else {
                                this.processCase(this.executionContext.nuixCase);
                            }
                            LOGGER.info("Populating next event time");
                            HashMap<String, Long> sessionEndTimes = new HashMap<String, Long>();
                            for (Session session : this.utilizationRecords.getSessions()) {
                                sessionEndTimes.put(session.getSessionId(), session.getSessionEndEpoch());
                            }
                            Operation previousOperation = null;
                            for (Operation operation : this.utilizationRecords.getOperations()) {
                                if (previousOperation != null) {
                                    if (previousOperation.getSessionId().equals(operation.getSessionId())) {
                                        previousOperation.setOperationNextEventEpoch(operation.getOperationStartEpoch());
                                    } else {
                                        Long jobEndTime = (Long)sessionEndTimes.get(previousOperation.getSessionId());
                                        if (jobEndTime == null) {
                                            LOGGER.warn("Cannot get job end time for session " + previousOperation.getSessionId());
                                            previousOperation.setOperationNextEventEpoch(previousOperation.getOperationEndEpoch() + 1L);
                                        } else {
                                            previousOperation.setOperationNextEventEpoch(((Long)sessionEndTimes.get(previousOperation.getSessionId())).longValue());
                                        }
                                    }
                                }
                                previousOperation = operation;
                            }
                            for (Operation operation : this.utilizationRecords.getOperations()) {
                                if (operation.getOperationNextEventEpoch() == 0L) {
                                    operation.setOperationNextEventEpoch(operation.getOperationEndEpoch());
                                }
                                operation.setOperationNextEventEpoch(Math.max(operation.getOperationNextEventEpoch(), operation.getOperationEndEpoch()));
                            }
                        }
                        catch (WorkflowExecutionStopRequested e) {
                            this.trackStopped();
                            return;
                        }
                        ++this.stageId;
                    }
                    try {
                        String jsonLocation = this.executionContext.evalParameters("{case_folder}/Stores/Statistics/VersionedCaseStatistics_{date_time}.json", this);
                        File jsonFile = new File(jsonLocation);
                        File reportDirectory = jsonFile.getParentFile();
                        if (!reportDirectory.exists()) {
                            reportDirectory.mkdirs();
                        }
                        VersionedUtilizationRecords versionedUtilizationRecords = new VersionedUtilizationRecords();
                        LinkedHashSet<String> warningMessages = this.getWarningMessages();
                        if (warningMessages != null && warningMessages.size() > 0) {
                            versionedUtilizationRecords.setWarnings(new ArrayList<String>(warningMessages));
                        }
                        versionedUtilizationRecords.setScanTime(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
                        versionedUtilizationRecords.setUtilizationRecords(this.utilizationRecords);
                        versionedUtilizationRecords.setProducerProduct(String.valueOf(this.executionContext.licenceSession.getProduct()));
                        versionedUtilizationRecords.setProducerVersion(this.executionContext.licenceSession.getProductVersion());
                        versionedUtilizationRecords.setScanOptions(this.getScanOptions());
                        FileUtils.writeStringToFile((File)jsonFile, (String)new Gson().toJson((Object)versionedUtilizationRecords), (Charset)StandardCharsets.UTF_8);
                    }
                    catch (Exception t) {
                        LOGGER.error("Cannot write Nuix Case Stats", (Throwable)t);
                    }
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void processCase(Case c) throws IOException {
        Matter matter = new Matter();
        matter.setClientId(this.client.getClientId());
        CaseNotesStore notesStore = this.executionContext.nuixCase.getCaseNotesStore();
        String matterName = notesStore.getNoteAsString("automate_matter_name");
        String matterId = notesStore.getNoteAsString("automate_matter_id");
        if (matterName != null && matterId != null) {
            matter.setMatterId(matterId);
            matter.setMatterName(matterName);
        } else {
            matter.setMatterId(UidUtils.fromString((String)c.getGuid(), (String)"matter").toString());
            matter.setMatterName(c.getName());
        }
        this.utilizationRecords.getMatters().add(matter);
        this.caseUtilizationModel = new NuixCase();
        this.caseUtilizationModel.setNuixCaseId(c.getGuid());
        this.caseUtilizationModel.setNuixCaseName(c.getName());
        this.caseUtilizationModel.setNuixCaseLocation(c.getLocation().getAbsolutePath());
        this.caseUtilizationModel.setNuixCaseVersion(NuixCaseUtils.getNuixCaseVersion(c.getLocation().getAbsolutePath()));
        this.caseUtilizationModel.setNuixCaseCreationEpoch(NuixCaseUtils.getNuixCaseCreationTime(c.getLocation().getAbsolutePath()));
        this.utilizationRecords.getNuixCases().add(this.caseUtilizationModel);
        this.parseHistory(c, matter.getMatterId(), this.executionContext.nuixUtilities);
        this.caseUtilizationModel.setNuixCaseLastModifiedEpoch(this.getLatestModifyingEvent());
    }

    public void setScanEventType(String s) {
        this.stageName = this.iu.getFormattedString("ScanCaseStatistics.Log.ProcessingEvents", (Object)s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseHistory(Case nuixCase, String matterId, Utilities nuixUtilities) throws IOException {
        long processedEvents = 0L;
        List<HistoryEvent> events = this.loadHistoryEvents(nuixCase);
        try {
            this.customDigestSizeMetadataFieldName = this.executionContext.evalParametersIfSet("{custom_digest_size_metadata_field_name}", this);
            this.addExecutionLog(this.iu.getFormattedString("ProcessingReportOperation.Log.InferCustomDigestSizeMetadataFieldName", (Object)this.customDigestSizeMetadataFieldName));
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        LOGGER.info("Parsing history");
        SessionStats sessionStats = null;
        try {
            for (HistoryEvent event : events) {
                if (!this.stopRequested) {
                    try {
                        this.processedItems.set(++processedEvents);
                        double progress = (double)processedEvents / (double)events.size();
                        if (sessionStats == null) {
                            sessionStats = new SessionStats(nuixCase, nuixUtilities, matterId, this);
                        }
                        sessionStats.processEvent(event);
                        if (sessionStats.sessionEnded() && !sessionStats.isCurrentSession()) {
                            this.handleCompletedSession(sessionStats);
                        }
                        if (sessionStats.getSessionEndedUnexpectedly()) {
                            sessionStats = new SessionStats(nuixCase, nuixUtilities, matterId, this);
                            sessionStats.processEvent(event);
                        }
                        if (!sessionStats.sessionEnded()) continue;
                        sessionStats = null;
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot process event", (Throwable)e);
                        throw e;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot process events", (Throwable)e);
            throw e;
        }
        if (sessionStats != null && !sessionStats.isCurrentSession()) {
            sessionStats.endSession();
            this.handleCompletedSession(sessionStats);
        }
    }

    private List<HistoryEvent> loadHistoryEvents(Case nuixCase) throws IOException {
        ArrayList<HistoryEvent> events = new ArrayList<HistoryEvent>();
        ArrayList<String> eventTypes = new ArrayList<String>();
        eventTypes.add("loadData");
        eventTypes.add("openSession");
        eventTypes.add("closeSession");
        eventTypes.add("export");
        eventTypes.add("delete");
        eventTypes.add("script");
        eventTypes.add("printPreview");
        eventTypes.add("search");
        HashSet<String> modifyingEventTypes = new HashSet<String>();
        modifyingEventTypes.add("loadData");
        modifyingEventTypes.add("import");
        modifyingEventTypes.add("annotation");
        modifyingEventTypes.add("delete");
        modifyingEventTypes.add("script");
        modifyingEventTypes.add("printPreview");
        for (String eventType : eventTypes) {
            if (this.stopRequested) break;
            long startTime = DateTime.now().getMillis();
            LOGGER.info("Scanning events of type " + eventType);
            this.stageName = this.iu.getFormattedString("ScanCaseStatistics.Log.Listing", (Object)eventType);
            this.stageTotalItems = events.size();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("order", "start_date_descending");
            properties.put("type", eventType);
            Iterable historyEvents = nuixCase.getHistory(properties);
            Iterator iterator = historyEvents.iterator();
            long eventCount = 0L;
            while (iterator.hasNext()) {
                this.stageName = this.iu.getNumeralFormattedString("ScanCaseStatistics.Log.Discovering", eventCount, (Object)eventType);
                long currentTime = DateTime.now().getMillis();
                ++eventCount;
                if (this.stopRequested) break;
                HistoryEvent event = (HistoryEvent)iterator.next();
                this.stageTotalItems = events.size();
                long elapsedTime = currentTime - startTime;
                long elapsedSeconds = elapsedTime / 1000L;
                long remainingSeconds = this.maxScanDuration - elapsedSeconds;
                events.add(event);
                if (modifyingEventTypes.contains(event.getTypeString())) {
                    this.caseLastModifiedMillis = Math.max(this.caseLastModifiedMillis, event.getEndDate().getMillis());
                }
                if (remainingSeconds > 0L) continue;
                this.addWarning(this.iu.getFormattedString("ScanCaseStatistics.Log.SkippedEvents", new Object[]{eventType, eventCount}));
                break;
            }
            LOGGER.info("Detected events of type " + eventType + ": " + eventCount);
        }
        if (this.stopRequested) {
            return events;
        }
        events.sort(Comparator.comparing(HistoryEvent::getStartDate));
        return events;
    }

    public String getCustomDigestSizeMetadataFieldName() {
        return this.customDigestSizeMetadataFieldName;
    }

    private void handleCompletedSession(SessionStats sessionStats) {
        if (!this.includeAutomateEngineSessions && "Automate Engine".equals(sessionStats.getRampivaSessionProductName())) {
            LOGGER.info("Skipping Automate Engine session");
            sessionStats.setRampivaSessionProductName(null);
            return;
        }
        if ("Automate Baseline".equals(sessionStats.getRampivaSessionProductName())) {
            LOGGER.info("Skipping Rampiva Baseline session");
            sessionStats.setRampivaSessionProductName(null);
            return;
        }
        if (sessionStats.getSessionEndedUnexpectedly()) {
            LOGGER.info("Detected unexpected end");
        }
        if (sessionStats.getSessionStartDate() == null) {
            return;
        }
        if (sessionStats.getSessionEndDate() == null) {
            return;
        }
        if (sessionStats.getSessionStartDate().getMillis() == sessionStats.getSessionEndDate().getMillis()) {
            return;
        }
        long sessionDuration = sessionStats.getSessionEndDate().getMillis() - sessionStats.getSessionStartDate().getMillis();
        if (sessionDuration < 5000L) {
            LOGGER.info("Skipping session due to short duration: " + sessionDuration + " ms");
        }
        LOGGER.info("Session duration: " + sessionDuration + " ms");
        User user = new User();
        user.setUserTimeZone(TimeZone.getDefault().getID());
        user.setUserName(sessionStats.getUser());
        user.setUserId(User.getIdFromName((String)user.getUserName(), (String)"user"));
        this.utilizationRecords.getUsers().add(user);
        Job job = new Job();
        job.setJobId(UidUtils.fromString((String)sessionStats.getId(), (String)"job").toString());
        job.setJobStartEpoch(Long.valueOf(sessionStats.getSessionStartDate().getMillis()));
        job.setJobEndEpoch(Long.valueOf(sessionStats.getSessionEndDate().getMillis()));
        job.setResourcePoolId(this.resourcePool.getResourcePoolId());
        job.setJobSubmittedByUserId(user.getUserId());
        job.setJobPercentageComplete(100.0);
        job.setJobExecutionState(ExecutionState.FINISHED);
        job.setJobHasWarnings(Boolean.valueOf(false));
        job.setJobHasSoftErrors(Boolean.valueOf(false));
        job.setJobHasErrors(Boolean.valueOf(false));
        if (sessionStats.getIsRampivaSession()) {
            sessionStats.getSession().setProductName(sessionStats.getRampivaSessionProductName());
            job.setJobName("Automated Job");
        } else {
            sessionStats.getSession().setProductName("Nuix");
            job.setJobName("Manual Job");
        }
        sessionStats.setRampivaSessionProductName(null);
        Server serverUtilizationModel = new Server();
        String serverName = sessionStats.getServerName();
        String serverId = UidUtils.fromString((String)serverName, (String)"server").toString();
        serverUtilizationModel.setServerId(serverId);
        serverUtilizationModel.setServerName(serverName);
        this.utilizationRecords.getServers().add(serverUtilizationModel);
        Engine engine = new Engine();
        String engineName = "Engine " + sessionStats.getServerName();
        String engineId = UidUtils.fromString((String)engineName, (String)"engine").toString();
        engine.setServerId(engineId);
        engine.setEngineId(engineId);
        engine.setEngineName(engineName);
        job.setEngineId(engineId);
        this.utilizationRecords.getEngines().add(engine);
        job.setJobSubmissionEpoch(Long.valueOf(sessionStats.getSessionStartDate().getMillis()));
        job.setMatterId(sessionStats.getMatterId());
        this.utilizationRecords.getJobs().add(job);
        Session session = sessionStats.getSession();
        session.setSessionId(sessionStats.getId());
        session.setJobId(job.getJobId());
        session.setSessionStartEpoch(sessionStats.getSessionStartDate().getMillis());
        session.setSessionEndEpoch(sessionStats.getSessionEndDate().getMillis());
        session.setRemote(false);
        session.setNuixLicenseType("Unknown");
        session.setNuixVersion(sessionStats.getNuixVersion());
        try {
            session.setLicenseId(NuixLicenceFactory.getInstance().getDeployedLicenceInfo().getId());
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
        this.utilizationRecords.getSessions().add(session);
        for (Operation operation : sessionStats.getOperations()) {
            operation.setNuixCaseId(this.caseUtilizationModel.getNuixCaseId());
            operation.setSessionId(sessionStats.getId());
            this.utilizationRecords.getOperations().add(operation);
            if (operation.getMimeTypeVolumes() == null) continue;
            long auditedSize = 0L;
            for (MimeTypeVolume mimeTypeVolume : operation.getMimeTypeVolumes()) {
                auditedSize += mimeTypeVolume.getAuditedSize();
            }
            switch (operation.getOperationType()) {
                case LOAD: {
                    session.setVolumeLoaded(session.getVolumeLoaded() + auditedSize);
                    break;
                }
                case IMAGE: {
                    break;
                }
                case OCR: {
                    session.setVolumeOcred(session.getVolumeOcred() + auditedSize);
                    break;
                }
                case OTHER_WORKER: {
                    break;
                }
                case OTHER_NON_WORKER: {
                    break;
                }
                case LEGAL_EXPORT: {
                    session.setVolumeExported(session.getVolumeExported() + auditedSize);
                    break;
                }
                case NATIVE_EXPORT: {
                    session.setVolumeExported(session.getVolumeExported() + auditedSize);
                    break;
                }
                case OTHER_EXPORT: {
                    session.setVolumeExported(session.getVolumeExported() + auditedSize);
                }
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.processedItems != null && this.stageTotalItems > 0L) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageTotalItems;
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        return result;
    }
}

