/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.exceptions.ParameterNotDefinedException;
import com.nuix.automate.utils.exceptions.UserTriggeredScriptErrorException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.ResourceSubType;
import com.nuix.automate.utils.utilization.consumption.ResourceType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import com.nuix.automate.utils.workflow.DatasetMetadata;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.ScheduleEvent;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.DatasetOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.ScheduleEventOperation;
import com.nuix.automate.workflow.core.execution.operations.ScriptOperation;
import com.nuix.automate.workflow.core.execution.operations.ScriptOsExecution;
import com.nuix.automate.workflow.core.execution.operations.ScriptParameters;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.script.ScriptWorkflowExecution;
import com.nuix.automate.workflow.core.execution.script.WorkflowExecutionAutomateRestClient;
import com.nuix.automate.workflow.core.execution.script.WorkflowExecutionDiscoverRestClient;
import com.nuix.automate.workflow.core.execution.script.WorkflowExecutionGenAiClient;
import com.nuix.automate.workflow.core.execution.script.WorkflowExecutionGenericRestClient;
import com.nuix.automate.workflow.core.execution.script.WorkflowExecutionRelativityRestClient;
import com.nuix.automate.workflow.core.nuix.ApiMethodTrackingProcessor;
import com.nuix.automate.workflow.core.nuix.DynamicApiTrackingProxyBuilder;
import com.nuix.automate.workflow.core.utils.general.LineOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;

public class ScriptOperationImplementation
extends ScriptOperation
implements DatasetOperation,
ScheduleEventOperation,
ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ScriptOperationImplementation.class);
    private transient ScriptEngine scriptEngine;
    private transient StringBuffer scriptOutput;
    private transient StringBuffer scriptError;
    private transient String taskName;
    private transient double percentageComplete;
    private transient Map<String, DatasetMetadata> dataSetsMetadata;
    private transient ScheduleEvent scheduleEvent;
    private transient List<ConsumptionEvent> consumptionEvents;
    private transient long itemsProcessed = 0L;
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient Map<String, FileLibraryFile> libraryFiles;
    private transient Map<String, FileLibraryFile> updatedLibraryFiles = new HashMap<String, FileLibraryFile>();
    private transient List<Parameter> updatedParameters = new ArrayList<Parameter>();

    @Override
    public Consumption getOperationConsumption() {
        Consumption consumption = new Consumption();
        consumption.setConsumptionEvents(this.consumptionEvents);
        return consumption;
    }

    @Override
    public void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.startTriggerThread = new Thread(() -> {
            String previousLocalContextScope;
            block41: {
                String previousLocalVariableBehavior = null;
                previousLocalContextScope = null;
                ApiMethodTrackingProcessor apiMethodTrackingProcessor = this.buildApiMethodTrackingProcessor();
                try {
                    WorkflowExecutionRelativityRestClient restRelativity;
                    SimpleScriptContext simpleScriptContext;
                    block40: {
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((com.nuix.automate.utils.workflow.Parameter)new StaticParameter("{last_script_output}", "")));
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((com.nuix.automate.utils.workflow.Parameter)new StaticParameter("{last_script_error}", "")));
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((com.nuix.automate.utils.workflow.Parameter)new StaticParameter("{last_script_return_value}", "")));
                        this.executionContext.closeAllTabs();
                        previousLocalVariableBehavior = System.setProperty("org.jruby.embed.localvariable.behavior", "transient");
                        previousLocalContextScope = System.setProperty("org.jruby.embed.localcontext.scope", "singlethread");
                        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                        switch (this.scriptType) {
                            case PYTHON: {
                                this.scriptEngine = scriptEngineManager.getEngineByName("python");
                                break;
                            }
                            case ECMA_SCRIPT: {
                                this.scriptEngine = scriptEngineManager.getEngineByName("ECMAScript");
                                break;
                            }
                            case RUBY: {
                                this.scriptEngine = scriptEngineManager.getEngineByName("ruby");
                            }
                        }
                        simpleScriptContext = new SimpleScriptContext();
                        simpleScriptContext.setAttribute("AUTOMATE_VERSION", this.executionContext.getVersion(), 100);
                        if (this.executionContext.nuixVersion != null) {
                            simpleScriptContext.setAttribute("NUIX_VERSION", this.executionContext.nuixVersion.toString(), 100);
                        }
                        ScriptParameters scriptParameters = new ScriptParameters(this.executionContext, this);
                        simpleScriptContext.setAttribute("parameters", scriptParameters, 100);
                        simpleScriptContext.setAttribute("$parameters", scriptParameters, 100);
                        simpleScriptContext.setAttribute("dataSetsMetadata", this.dataSetsMetadata, 100);
                        simpleScriptContext.setAttribute("dataSetsMetadata", this.dataSetsMetadata, 100);
                        simpleScriptContext.setAttribute("data_sets_metadata", this.dataSetsMetadata, 100);
                        simpleScriptContext.setAttribute("data_sets_metadata", this.dataSetsMetadata, 100);
                        simpleScriptContext.setAttribute("scheduleEvent", this.scheduleEvent, 100);
                        simpleScriptContext.setAttribute("$scheduleEvent", this.scheduleEvent, 100);
                        simpleScriptContext.setAttribute("schedule_event", this.scheduleEvent, 100);
                        simpleScriptContext.setAttribute("$schedule_event", this.scheduleEvent, 100);
                        simpleScriptContext.setAttribute("schedule_trigger_info", this.scheduleEvent, 100);
                        WorkflowExecutionAutomateRestClient restAutomate = new WorkflowExecutionAutomateRestClient(this.executionContext.workflowExecution, this);
                        simpleScriptContext.setAttribute("restRampiva", restAutomate, 100);
                        simpleScriptContext.setAttribute("$restRampiva", restAutomate, 100);
                        simpleScriptContext.setAttribute("rest_rampiva", restAutomate, 100);
                        simpleScriptContext.setAttribute("$rest_rampiva", restAutomate, 100);
                        simpleScriptContext.setAttribute("restAutomate", restAutomate, 100);
                        simpleScriptContext.setAttribute("restAutomate", restAutomate, 100);
                        simpleScriptContext.setAttribute("rest_automate", restAutomate, 100);
                        simpleScriptContext.setAttribute("$rest_automate", restAutomate, 100);
                        ScriptWorkflowExecution scriptWorkflowExecution = new ScriptWorkflowExecution(this.executionContext.workflowExecution, restAutomate, this, this.libraryFiles);
                        simpleScriptContext.setAttribute("workflowExecution", scriptWorkflowExecution, 100);
                        simpleScriptContext.setAttribute("$workflowExecution", scriptWorkflowExecution, 100);
                        simpleScriptContext.setAttribute("workflow_execution", scriptWorkflowExecution, 100);
                        simpleScriptContext.setAttribute("$workflow_execution", scriptWorkflowExecution, 100);
                        ScriptOsExecution scriptOsExecution = new ScriptOsExecution();
                        simpleScriptContext.setAttribute("osExecution", scriptOsExecution, 100);
                        simpleScriptContext.setAttribute("$osExecution", scriptOsExecution, 100);
                        simpleScriptContext.setAttribute("os_execution", scriptOsExecution, 100);
                        simpleScriptContext.setAttribute("$os_execution", scriptOsExecution, 100);
                        WorkflowExecutionDiscoverRestClient restDiscover = new WorkflowExecutionDiscoverRestClient(this.executionContext.workflowExecution, this);
                        simpleScriptContext.setAttribute("restDiscover", restDiscover, 100);
                        simpleScriptContext.setAttribute("$restDiscover", restDiscover, 100);
                        simpleScriptContext.setAttribute("rest_discover", restDiscover, 100);
                        simpleScriptContext.setAttribute("$rest_discover", restDiscover, 100);
                        try {
                            String genAiServiceId = this.executionContext.evalParametersIfSet("{wfn_gen_ai_service_id}", this);
                            GenAiService genAiService = (GenAiService)this.thirdPartyServices.get(genAiServiceId);
                            WorkflowExecutionGenAiClient restGenAi = new WorkflowExecutionGenAiClient(genAiService);
                            simpleScriptContext.setAttribute("genAi", restGenAi, 100);
                            simpleScriptContext.setAttribute("$genAi", restGenAi, 100);
                            simpleScriptContext.setAttribute("gen_ai", restGenAi, 100);
                            simpleScriptContext.setAttribute("$gen_ai", restGenAi, 100);
                        }
                        catch (ParameterException genAiServiceId) {
                            // empty catch block
                        }
                        restRelativity = new WorkflowExecutionRelativityRestClient(this.executionContext.workflowExecution, this);
                        String authenticationMethodString = this.executionContext.evalParameters("{wfn_relativity_authentication_method}", this);
                        try {
                            restRelativity.setAuthenticationMethod(ThirdPartyAuthenticationMethod.valueOf((String)authenticationMethodString));
                        }
                        catch (Exception e) {
                            if (!LOGGER.isDebugEnabled()) break block40;
                            LOGGER.debug("Cannot set authentication method from parameter", (Throwable)e);
                        }
                    }
                    simpleScriptContext.setAttribute("restRelativity", restRelativity, 100);
                    simpleScriptContext.setAttribute("$restRelativity", restRelativity, 100);
                    simpleScriptContext.setAttribute("rest_relativity", restRelativity, 100);
                    simpleScriptContext.setAttribute("$rest_relativity", restRelativity, 100);
                    WorkflowExecutionGenericRestClient rest = new WorkflowExecutionGenericRestClient(this.executionContext.workflowExecution, this);
                    simpleScriptContext.setAttribute("rest", rest, 100);
                    simpleScriptContext.setAttribute("$rest", rest, 100);
                    if (this.executionContext.nuixUtilities != null) {
                        Object utilitiesProxy = DynamicApiTrackingProxyBuilder.createProxy(this.executionContext.nuixUtilities, "nuix.Utilities", apiMethodTrackingProcessor);
                        simpleScriptContext.setAttribute("utilities", utilitiesProxy, 100);
                        simpleScriptContext.setAttribute("$utilities", utilitiesProxy, 100);
                    }
                    if (this.executionContext.nuixCase != null) {
                        Object caseProxy = DynamicApiTrackingProxyBuilder.createProxy(this.executionContext.nuixCase, "nuix.Case", apiMethodTrackingProcessor);
                        simpleScriptContext.setAttribute("currentCase", caseProxy, 100);
                        simpleScriptContext.setAttribute("current_case", caseProxy, 100);
                        simpleScriptContext.setAttribute("$currentCase", caseProxy, 100);
                        simpleScriptContext.setAttribute("$current_case", caseProxy, 100);
                    }
                    if (this.executionContext.nuixWindow != null) {
                        simpleScriptContext.setAttribute("window", this.executionContext.nuixWindow, 100);
                        simpleScriptContext.setAttribute("$window", this.executionContext.nuixWindow, 100);
                    }
                    this.scriptOutput = new StringBuffer();
                    this.scriptError = new StringBuffer();
                    LineOutputStream lineOutputStream = new LineOutputStream();
                    lineOutputStream.addListener(line -> this.addExecutionLog(this.iu.getFormattedString("ScriptOperation.Log.LineListener", (Object)line)));
                    simpleScriptContext.setWriter(new PrintWriter(lineOutputStream, true));
                    LineOutputStream lineErrorOutputStream = new LineOutputStream();
                    lineErrorOutputStream.addListener(line -> {
                        LOGGER.warn(line);
                        this.addWarning(line);
                    });
                    simpleScriptContext.setErrorWriter(new PrintWriter(lineErrorOutputStream, true));
                    Set<String> executionStateDynamicParameterNames = this.executionContext.getExecutionStateDynamicParameterNames();
                    for (String placeholder : this.executionContext.getParameterNames()) {
                        if (executionStateDynamicParameterNames.contains(placeholder)) continue;
                        try {
                            String variableName;
                            String unpackedPlaceholder = this.executionContext.evalParameters(placeholder, this, true);
                            if (placeholder.equals(unpackedPlaceholder) || (variableName = placeholder.substring(1, placeholder.length() - 1)).isEmpty()) continue;
                            simpleScriptContext.setAttribute(variableName, unpackedPlaceholder, 100);
                            simpleScriptContext.setAttribute("$" + variableName, unpackedPlaceholder, 100);
                            try {
                                String displayValue = this.executionContext.evalParameterUserPrintableValue(placeholder);
                                simpleScriptContext.setAttribute(variableName + "_userprintable", displayValue, 100);
                                simpleScriptContext.setAttribute("$" + variableName + "_userprintable", displayValue, 100);
                            }
                            catch (ParameterException parameterException) {
                            }
                        }
                        catch (ParameterNotDefinedException e) {
                            if (!LOGGER.isDebugEnabled()) continue;
                            LOGGER.debug("Cannot evaluate parameter " + placeholder, (Throwable)e);
                        }
                        catch (ParameterException e) {
                            if (e.getCause() != null && e.getCause().getClass().getName().equals("nuix.LicenceException")) {
                                if (!LOGGER.isDebugEnabled()) continue;
                                LOGGER.debug("Cannot evaluate parameter " + placeholder, (Throwable)e);
                                continue;
                            }
                            LOGGER.warn("Cannot evaluate parameter " + placeholder, (Throwable)e);
                        }
                        catch (Exception e) {
                            this.addWarning(this.iu.getFormattedString("ScriptOperation.Warning.CannotSetParameter", new Object[]{placeholder, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                            LOGGER.warn("Cannot set parameter " + placeholder, (Throwable)e);
                        }
                    }
                    try {
                        Object scriptResult;
                        if (this.useScriptFile) {
                            this.scriptFileName = this.executionContext.evalParameters(this.scriptFileName, this);
                            File file = new File(this.scriptFileName);
                            String scriptFileCode = FileUtils.readFileWithAutodetectEncoding((File)new File(this.scriptFileName));
                            this.assertScriptLicensed(scriptFileCode);
                            simpleScriptContext.setAttribute("javax.script.filename", file.getAbsolutePath(), 100);
                            scriptResult = this.scriptEngine.eval(scriptFileCode, (ScriptContext)simpleScriptContext);
                        } else {
                            this.assertScriptLicensed(this.scriptCode);
                            scriptResult = this.scriptEngine.eval(this.scriptCode, (ScriptContext)simpleScriptContext);
                        }
                        if (scriptResult == null) {
                            scriptResult = "null";
                        }
                        simpleScriptContext.getWriter().flush();
                        simpleScriptContext.getErrorWriter().flush();
                        if (this.scriptOutput.length() > 0) {
                            this.addExecutionLog(this.iu.getFormattedString("ScriptOperation.Log.ScriptOutput", (Object)this.scriptOutput));
                        }
                        if (this.scriptError.length() > 0) {
                            this.addExecutionLog(this.iu.getFormattedString("ScriptOperation.Log.ScriptError", (Object)this.scriptError));
                        }
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((com.nuix.automate.utils.workflow.Parameter)new StaticParameter("{last_script_output}", this.scriptOutput.toString())));
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((com.nuix.automate.utils.workflow.Parameter)new StaticParameter("{last_script_error}", this.scriptError.toString())));
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((com.nuix.automate.utils.workflow.Parameter)new StaticParameter("{last_script_return_value}", scriptResult.toString())));
                        this.addExecutionLog(this.iu.getFormattedString("ScriptOperation.Log.ScriptReturnValue", scriptResult));
                        LOGGER.info("Script completed successfully with return value: " + String.valueOf(scriptResult));
                    }
                    catch (Exception ex) {
                        this.addExecutionLog(this.iu.getString("ScriptOperation.Log.ScriptInterrupted"));
                        for (Throwable lastThrowable = ex; lastThrowable != null; lastThrowable = lastThrowable.getCause()) {
                            if (!(lastThrowable instanceof UserTriggeredScriptErrorException)) continue;
                            this.exception = lastThrowable;
                            LOGGER.warn("Detected user triggered error", this.exception);
                            break;
                        }
                        if (this.exception == null) {
                            this.exception = ex;
                        }
                        this.executionState = ExecutionState.ERROR;
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((com.nuix.automate.utils.workflow.Parameter)new StaticParameter("{last_script_output}", this.scriptOutput.toString())));
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((com.nuix.automate.utils.workflow.Parameter)new StaticParameter("{last_script_error}", "Script failed due to " + this.exception.getLocalizedMessage())));
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((com.nuix.automate.utils.workflow.Parameter)new StaticParameter("{last_script_return_value}", "")));
                        apiMethodTrackingProcessor.flush();
                        if (previousLocalVariableBehavior != null) {
                            System.setProperty("org.jruby.embed.localvariable.behavior", previousLocalVariableBehavior);
                        }
                        if (previousLocalContextScope != null) {
                            System.setProperty("org.jruby.embed.localvariable.behavior", previousLocalContextScope);
                        }
                        return;
                    }
                    apiMethodTrackingProcessor.flush();
                    if (previousLocalVariableBehavior == null) break block41;
                }
                catch (Throwable e) {
                    try {
                        LOGGER.error("Operation unchecked exception", e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        apiMethodTrackingProcessor.flush();
                        if (previousLocalVariableBehavior != null) {
                            System.setProperty("org.jruby.embed.localvariable.behavior", previousLocalVariableBehavior);
                        }
                        if (previousLocalContextScope != null) {
                            System.setProperty("org.jruby.embed.localvariable.behavior", previousLocalContextScope);
                        }
                    }
                }
                System.setProperty("org.jruby.embed.localvariable.behavior", previousLocalVariableBehavior);
            }
            if (previousLocalContextScope != null) {
                System.setProperty("org.jruby.embed.localvariable.behavior", previousLocalContextScope);
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void assertScriptLicensed(String scriptContent) {
        if (scriptContent.contains(".newProductionSet") || scriptContent.contains(".addLoadFile")) {
            this.assertModuleLicensed(ModuleType.WORKFLOW_LEGAL);
        }
    }

    public void setItemsProcessed(long itemsProcessed) {
        this.itemsProcessed = itemsProcessed;
    }

    @Override
    public long getItemsProcessed() {
        return this.itemsProcessed;
    }

    @Override
    public void resumeTriggered() {
        this.executionState = ExecutionState.RUNNING;
    }

    @Override
    public void pauseTriggered() {
        this.executionState = ExecutionState.PAUSING;
    }

    @Override
    public void stopTriggered() {
        this.executionState = ExecutionState.STOPPING;
        Thread thread = new Thread(() -> {
            while (this.startTriggerThread != null && this.startTriggerThread.isAlive()) {
                try {
                    LOGGER.info("Interrupting thread");
                    this.startTriggerThread.interrupt();
                }
                catch (Throwable e) {
                    LOGGER.warn("Cannot interrupt script execution thread", e);
                }
                try {
                    LOGGER.info("Waiting for 1s for execution to complete");
                    this.startTriggerThread.join(1000L);
                }
                catch (Throwable e) {
                    LOGGER.warn("Cannot wait for execution to complete", e);
                }
                if (!this.startTriggerThread.isAlive()) {
                    this.trackStopped();
                    return;
                }
                try {
                    LOGGER.info("Stopping thread");
                    this.startTriggerThread.stop();
                }
                catch (Throwable e) {
                    LOGGER.warn("Cannot stop thread", e);
                }
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName() + " - Stop");
        thread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (percentageComplete > 0.0) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.taskName != null && !this.taskName.isEmpty()) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            result = (String)result + this.taskName;
        }
        if (this.itemsProcessed > 0L) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("ScriptOperation.Progress.ItemsProcessed", this.itemsProcessed);
        }
        return result;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.useScriptFile && this.scriptFileName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("ScriptOperation.Prerequisites.ScriptMustBeSpecified"));
        }
        return prerequisites;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setPercentageComplete(double percentageComplete) {
        this.percentageComplete = percentageComplete;
    }

    @Override
    public void setDatasetsMetadata(Map<String, DatasetMetadata> datasetsMetadata) {
        this.dataSetsMetadata = datasetsMetadata;
    }

    @Override
    public void setScheduleEvent(ScheduleEvent scheduleEvent) {
        this.scheduleEvent = scheduleEvent;
    }

    private ApiMethodTrackingProcessor buildApiMethodTrackingProcessor() {
        Consumer<Map<String, AtomicInteger>> persistenceConsumer = mapToPersist -> {
            try {
                LOGGER.info("Consuming events: " + mapToPersist.size());
                this.consumptionEvents = mapToPersist.entrySet().stream().map(entry -> {
                    try {
                        ConsumptionEvent consumptionEvent = new ConsumptionEvent();
                        consumptionEvent.setConsumptionEventId(UUID.randomUUID().toString());
                        if (this.executionContext.licenceSession != null) {
                            consumptionEvent.setLicenseId(this.executionContext.licenceSession.getLicenceInfo().getId());
                        }
                        consumptionEvent.setConsumptionStartEpoch(this.startDateTime.getMillis());
                        consumptionEvent.setConsumptionEndEpoch(this.finishedDateTime != null ? this.finishedDateTime.getMillis() : this.startDateTime.getMillis());
                        consumptionEvent.setPlatformType(ConsumptionPlatformType.NUIX_ENGINE);
                        consumptionEvent.setConsumptionType(ConsumptionType.SCRIPTING_API);
                        consumptionEvent.setUnitType(UnitType.CALLS);
                        consumptionEvent.setUnits((long)((AtomicInteger)entry.getValue()).get());
                        if (this.executionContext.getEngine() != null) {
                            consumptionEvent.setJobId(this.executionContext.getEngine().getJobId());
                        }
                        if (this.executionContext.nuixCase != null) {
                            consumptionEvent.setResourceType(ResourceType.NUIX_ENGINE_CASE_ID);
                            consumptionEvent.setResourceId(this.executionContext.nuixCase.getGuid());
                        }
                        consumptionEvent.setResourceSubType(ResourceSubType.METHOD_REFERENCE);
                        consumptionEvent.setResourceSubId((String)entry.getKey());
                        return consumptionEvent;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error consuming event", (Throwable)e);
                        return null;
                    }
                }).collect(Collectors.toList());
            }
            catch (Exception e) {
                LOGGER.error("Error consuming events", (Throwable)e);
            }
        };
        return new ApiMethodTrackingProcessor(persistenceConsumer);
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }

    @Override
    public void setLibraryFiles(Map<String, FileLibraryFile> libraryFiles) {
        this.libraryFiles = libraryFiles;
    }

    @Override
    public void updateFileLibraryFile(FileLibraryFile fileLibraryFile) {
        this.updatedLibraryFiles.put(fileLibraryFile.getId(), fileLibraryFile);
    }

    @Override
    public Map<String, FileLibraryFile> getUpdatedLibraryFiles() {
        return this.updatedLibraryFiles;
    }

    @Override
    public void addUpdatedParameter(Parameter parameter) {
        this.updatedParameters.add(parameter);
    }

    @Override
    public List<Parameter> getUpdatedParameters() {
        return this.updatedParameters;
    }
}

