/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.cells.Cell;
import com.aspose.cells.CellsException;
import com.aspose.cells.FindOptions;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.SearchAndTagOperation;
import com.nuix.automate.workflow.core.execution.operations.SearchAndTagReportItemStats;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.execution.options.searchandtag.RemoveTagsMethod;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import nuix.BulkAnnotater;
import nuix.Item;

public class SearchAndTagOperationImplementation
extends SearchAndTagOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SearchAndTagOperationImplementation.class);
    private final transient String MULTIPLE_KEYWORDS = "__AUTOMATE_MULT__";
    private transient int stageCount;
    private transient int stageId;
    private transient String stageName;
    private transient boolean stopTriggered = false;
    private transient String effectiveTagPrefix;
    private transient SortedMap<String, SearchAndTagReportItemStats> results;
    private transient SearchAndTagReportItemStats totals;
    private transient long countItemsToProcess;
    private transient ConcurrentHashMap<Item, String> uniqueHitsTracker;
    private transient ConcurrentHashMap<Item, String> uniqueTopLevelTracker;
    private transient ConcurrentHashMap<Item, String> uniqueFamilyTracker;
    private transient List<String> custodians;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.customReportTemplatePath = this.executionContext.evalParameters(this.customReportTemplatePath, this);
        if (!this.searchExcludedItems) {
            this.scope = NuixUtils.addAndQuery(this.scope, "has-exclusion:0");
            LOGGER.info("Excluded items were not selected, built search scope to:\t" + this.scope);
        } else {
            this.addExecutionLog(this.iu.getString("SearchAndTagOperation.Log.SearchExcludedItems"));
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                SearchAndTagReportItemStats resultStats;
                BulkAnnotater bulkAnnotater;
                HashSet allExclusiveTopLevelHits;
                HashSet<Item> allExclusiveFamiliesWithHits;
                HashSet<Item> allExclusiveItemsWithHits;
                HashSet allDescendantsWithHits;
                HashSet allTopLevelHits;
                HashSet<Item> allFamiliesWithHits;
                HashSet<Item> allItemsWithHits;
                block151: {
                    this.uniqueHitsTracker = new ConcurrentHashMap();
                    this.uniqueTopLevelTracker = new ConcurrentHashMap();
                    this.uniqueFamilyTracker = new ConcurrentHashMap();
                    allItemsWithHits = new HashSet<Item>();
                    allFamiliesWithHits = new HashSet<Item>();
                    allTopLevelHits = new HashSet();
                    allDescendantsWithHits = new HashSet();
                    allExclusiveItemsWithHits = new HashSet<Item>();
                    allExclusiveFamiliesWithHits = new HashSet<Item>();
                    allExclusiveTopLevelHits = new HashSet();
                    this.results = new TreeMap<String, SearchAndTagReportItemStats>();
                    this.executionContext.closeAllTabs();
                    this.effectiveTagPrefix = this.executionContext.evalParameters(this.tagPrefix, this);
                    this.effectiveTagPrefix = this.effectiveTagPrefix.trim();
                    if (this.effectiveTagPrefix.endsWith("|")) {
                        this.effectiveTagPrefix = this.effectiveTagPrefix.substring(0, this.effectiveTagPrefix.length() - 1);
                    }
                    bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    if (this.effectiveTagPrefix.length() > 0) {
                        this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.TagPrefix", (Object)this.effectiveTagPrefix));
                    }
                    if (this.assignTags && this.removePreviousTags) {
                        this.stageName = this.iu.getString("SearchAndTagOperation.Stage.RemovingPreviousTags");
                        this.addExecutionLog(this.removePreviousMethod.toString());
                        if (this.removePreviousMethod == null) {
                            this.removePreviousMethod = RemoveTagsMethod.RENAME;
                        }
                        if (this.effectiveTagPrefix.length() > 0) {
                            if (this.removePreviousMethod == RemoveTagsMethod.UNTAG_AND_DELETE || this.removePreviousMethod == RemoveTagsMethod.UNTAG) {
                                Set caseTags = this.executionContext.nuixCase.getAllTags();
                                HashSet<String> tagsToDelete = new HashSet<String>();
                                LOGGER.info("Removing previous tags");
                                for (String caseTag : caseTags) {
                                    LOGGER.info("Checking tag " + caseTag + " vs prefix " + this.effectiveTagPrefix);
                                    if (!caseTag.equals(this.effectiveTagPrefix) && !caseTag.startsWith(this.effectiveTagPrefix + "|")) continue;
                                    LOGGER.info("Removing tag: " + caseTag);
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.UntaggingItems", (Object)caseTag);
                                    String tagQuery = "tag:\"" + caseTag.replace("\"", "\\\"") + "\"";
                                    LOGGER.info("- Searching for " + tagQuery);
                                    Set taggedItems = this.executionContext.nuixCase.searchUnsorted(tagQuery);
                                    LOGGER.info("- Untagging " + taggedItems.size() + " items");
                                    bulkAnnotater.removeTag(caseTag, (Collection)taggedItems);
                                    tagsToDelete.add(caseTag);
                                }
                                if (this.removePreviousMethod == RemoveTagsMethod.UNTAG_AND_DELETE) {
                                    for (String caseTag : tagsToDelete) {
                                        LOGGER.info("Delete tag " + caseTag);
                                        this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.DeletingTag", (Object)caseTag);
                                        this.executionContext.nuixCase.deleteTag(caseTag);
                                    }
                                }
                            } else if (this.removePreviousMethod == RemoveTagsMethod.RENAME) {
                                String renameTag = "Automate|SearchAndTagOld|" + this.effectiveTagPrefix + "_" + this.executionContext.evalParameters("{date_time}", this);
                                LOGGER.info("Removing previous tags " + this.effectiveTagPrefix + " to " + renameTag);
                                try {
                                    this.executionContext.nuixCase.renameTag(this.effectiveTagPrefix, renameTag);
                                }
                                catch (Exception e) {
                                    LOGGER.error("Cannot remove previous tags.", (Throwable)e);
                                    if (e.getCause() != null) {
                                        this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CannotRemovePreviousTags", (Object)e.getCause().getLocalizedMessage()));
                                        break block151;
                                    }
                                    this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CannotRemovePreviousTags", (Object)e.getLocalizedMessage()));
                                }
                            }
                        } else {
                            this.addWarning(this.iu.getString("SearchAndTagOperation.Warning.RemoveTagsNoPrefixProvided"));
                        }
                    }
                }
                if (this.useKeywordsFile) {
                    if (this.keywordsFileName == null) {
                        this.keywordsFileName = "";
                    }
                    this.keywordsFileName = this.executionContext.evalParameters(this.keywordsFileName, this);
                    this.loadListFromFile(new File(this.keywordsFileName));
                    this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.KeywordsFile", (Object)this.keywordsFileName));
                }
                int custodiansCount = 1;
                if (this.breakdownByCustodian) {
                    custodiansCount += this.executionContext.nuixCase.getAllCustodians().size();
                }
                this.stageCount = this.searches.size() * custodiansCount + 1;
                if (this.assignTags) {
                    this.stageCount += this.searches.size() * custodiansCount;
                }
                if (this.identifyExclusiveHits) {
                    this.stageCount += this.searches.size() * custodiansCount;
                }
                if (this.writeReport) {
                    ++this.stageCount;
                }
                this.stageId = 0;
                boolean detectedSearchErrors = false;
                Object keywordErrorMessages = "";
                this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.ScopeQuery", (Object)this.scope));
                this.stageName = this.iu.getString("SearchAndTagOperation.Stage.SearchingOfItemsInScope");
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.scope = this.scope.trim();
                Set scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.countItemsToProcess = scopeItems.size();
                this.addExecutionLog(this.iu.getNumeralString("SearchAndTagOperation.Log.ScopeCount", this.countItemsToProcess));
                ++this.stageId;
                ArrayList<String> searchOptions = new ArrayList<String>();
                if (this.searchContent) {
                    searchOptions.add("content");
                }
                if (this.searchProperties) {
                    searchOptions.add("properties");
                }
                if (this.searchCommunications) {
                    searchOptions.add("communications");
                }
                if (this.searchNames) {
                    searchOptions.add("names");
                }
                if (this.searchPathNames) {
                    searchOptions.add("path names");
                }
                if (this.searchEvidenceMetadata) {
                    searchOptions.add("evidence metadata");
                }
                this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.SearchFields", (Object)(this.defaultNuixSearchLocations != false ? this.iu.getString("SearchAndTagOperation.Log.SearchFieldsAll") : String.join((CharSequence)", ", searchOptions))));
                this.custodians = new ArrayList<String>();
                if (this.breakdownByCustodian) {
                    this.custodians.addAll(this.executionContext.nuixCase.getAllCustodians());
                    this.custodians.sort(String::compareToIgnoreCase);
                }
                this.custodians.add("");
                int searchCount = 0;
                for (Object[] search : this.searches) {
                    ++searchCount;
                    Iterator<String> iterator = this.custodians.iterator();
                    while (iterator.hasNext()) {
                        void var19_24;
                        String custodian;
                        String string = custodian = iterator.next();
                        if (custodian.length() == 0) {
                            String string2 = this.iu.getString("SearchAndTagOperation.Log.NoCustodian");
                        }
                        resultStats = new SearchAndTagReportItemStats();
                        resultStats.custodian = custodian;
                        if (this.stopTriggered) {
                            this.executionState = ExecutionState.STOPPED;
                            return;
                        }
                        String tagName = search[0].toString().trim();
                        try {
                            tagName = this.executionContext.evalParameters(tagName, this);
                        }
                        catch (ParameterException e) {
                            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.ExceptionMessageWarning", (Object)e.getLocalizedMessage()));
                        }
                        Object query = search[1].toString().trim();
                        String originalQuery = query;
                        try {
                            query = this.executionContext.evalParameters((String)query, this);
                        }
                        catch (ParameterException e) {
                            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.ExceptionMessageWarning", (Object)e.getLocalizedMessage()));
                        }
                        if (tagName.length() == 0) {
                            if (((String)query).length() <= 0) continue;
                            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.SkippedQueryBlankTag", query));
                            continue;
                        }
                        if (((String)query).length() == 0) {
                            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.SkippedTagBlankQuery", (Object)tagName));
                            continue;
                        }
                        resultStats.keyword = tagName;
                        resultStats.searchQuery = query;
                        this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.SearchingForItems", (Object)tagName);
                        HashMap nuixSearchOptions = new HashMap();
                        if (!this.defaultNuixSearchLocations.booleanValue()) {
                            ArrayList<String> defaultFields = new ArrayList<String>();
                            nuixSearchOptions.put("defaultFields", defaultFields);
                            String fullScope = "(" + (String)query + ")";
                            if (this.searchContent) {
                                defaultFields.add("content");
                            }
                            if (this.searchProperties) {
                                defaultFields.add("properties");
                            }
                            if (this.searchCommunications) {
                                defaultFields.add("to");
                                defaultFields.add("from");
                                defaultFields.add("cc");
                                defaultFields.add("bcc");
                                defaultFields.add("sender");
                            }
                            if (this.searchNames) {
                                defaultFields.add("name");
                            }
                            if (this.searchPathNames) {
                                defaultFields.add("path-name");
                            }
                            if (this.searchEvidenceMetadata) {
                                defaultFields.add("evidence-metadata");
                            }
                            if (this.searchCustomMetadata) {
                                if (fullScope.length() > 0) {
                                    fullScope = fullScope + " OR ";
                                }
                                fullScope = fullScope + "custom-metadata:*:(" + (String)query + ")";
                            }
                            query = fullScope;
                            if (fullScope.trim().length() == 0) {
                                query = "flag:AUTOMATE_INEXISTANT";
                            }
                        }
                        query = NuixUtils.addAndQuery(this.scope, (String)query);
                        if (this.breakdownByCustodian) {
                            query = custodian.length() > 0 ? NuixUtils.addAndQuery((String)query, "custodian:\"" + custodian + "\"") : NuixUtils.addAndQuery((String)query, "has-custodian:0");
                        }
                        String hitsTagName = this.effectiveTagPrefix + (this.effectiveTagPrefix.length() > 0 ? "|" : "") + "Hits|" + tagName;
                        Set<Item> items = new HashSet();
                        try {
                            if (search.length > 2 && search[2] != null && search[2].toString().length() > 0) {
                                resultStats.additionalTextAfterQuery = true;
                                this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.KeywordContainsAdditionalText", (Object)tagName));
                            }
                            this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.Searching", (Object)tagName);
                            if (this.countItemsToProcess > 0L) {
                                LOGGER.info("Searching for: " + (String)query);
                                items = this.executionContext.nuixCase.searchUnsorted((String)query, nuixSearchOptions);
                            } else {
                                LOGGER.info("Skipping query because there are 0 items in scope: " + (String)query);
                                items = new HashSet();
                            }
                            if (this.logResults) {
                                if (this.breakdownByCustodian) {
                                    this.addExecutionLog((String)var19_24 + "\t" + this.iu.getFormattedString("SearchAndTagOperation.Log.HitsTagName", (Object)hitsTagName) + "\t" + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFound", (long)items.size()));
                                } else {
                                    this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.HitsTagName", (Object)hitsTagName) + "\t" + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFound", (long)items.size()));
                                }
                            }
                            resultStats.hitsCount = items.size();
                            if (this.computeSize) {
                                this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.ComputingHitsSize", (Object)tagName);
                                resultStats.hitsSize = ItemsUtils.getInstance().getItemsAuditedSize(items);
                            }
                            if (this.computeTotals) {
                                allItemsWithHits.addAll(items);
                            }
                        }
                        catch (Exception e) {
                            detectedSearchErrors = true;
                            keywordErrorMessages = (String)keywordErrorMessages + tagName + "\t" + originalQuery + "\t" + (String)query + "\n";
                            LOGGER.error("Error running query " + (String)query, (Throwable)e);
                            resultStats.invalidQuery = true;
                        }
                        if (this.identifyExclusiveHits) {
                            this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TrackingExclusiveHits", (Object)tagName);
                            for (Item hitItem : items) {
                                String previousTagName = this.uniqueHitsTracker.putIfAbsent(hitItem, custodian + "-" + tagName);
                                if (previousTagName == null || previousTagName.equals(custodian + "-" + tagName) || previousTagName.equals("__AUTOMATE_MULT__")) continue;
                                this.uniqueHitsTracker.replace(hitItem, "__AUTOMATE_MULT__");
                            }
                        }
                        Set descendantItems = new HashSet();
                        String descendantsTagName = this.effectiveTagPrefix + (this.effectiveTagPrefix.length() > 0 ? "|" : "") + "Descendants|" + tagName;
                        if (this.identifyDescendants) {
                            try {
                                if (items != null && items.size() > 0) {
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.ComputingDescendantsCount", (Object)tagName);
                                    LOGGER.info("Getting descendant items");
                                    descendantItems = this.executionContext.nuixUtilities.getItemUtility().findDescendants(items);
                                    if (this.scope.length() > 0) {
                                        LOGGER.info("Intersecting with scopeItems");
                                        descendantItems = this.executionContext.nuixUtilities.getItemUtility().intersection(descendantItems, (Collection)scopeItems);
                                    } else {
                                        LOGGER.info("Scope is empty, skipping intersection with scope items");
                                    }
                                }
                                if (this.logResults) {
                                    if (this.breakdownByCustodian) {
                                        this.addExecutionLog((String)var19_24 + "\t" + this.iu.getFormattedString("SearchAndTagOperation.Log.DescendantsTagName", (Object)descendantsTagName) + "\t" + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFound", (long)descendantItems.size()));
                                    } else {
                                        this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.DescendantsTagName", (Object)descendantsTagName) + "\t" + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFound", (long)descendantItems.size()));
                                    }
                                }
                                resultStats.descendantsCount = descendantItems.size();
                                if (this.computeSize) {
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.ComputingDescendantsSize", (Object)tagName);
                                    resultStats.descendantsSize = ItemsUtils.getInstance().getItemsAuditedSize(descendantItems);
                                }
                                if (this.computeTotals) {
                                    allDescendantsWithHits.addAll(descendantItems);
                                }
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CannotGetDescendantsItemsForTag", new Object[]{tagName, e.getLocalizedMessage()}));
                                LOGGER.warn("Cannot get descendants for " + tagName, (Throwable)e);
                            }
                        }
                        Set familyItems = new HashSet();
                        String familyTagName = this.effectiveTagPrefix + (this.effectiveTagPrefix.length() > 0 ? "|" : "") + "Families|" + tagName;
                        if (this.identifyFamilies) {
                            try {
                                if (items != null && items.size() > 0) {
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.ComputingFamiliesCount", (Object)tagName);
                                    LOGGER.info("Getting family items");
                                    familyItems = this.executionContext.nuixUtilities.getItemUtility().findFamilies(items);
                                    if (this.scope.length() > 0) {
                                        LOGGER.info("Intersecting with scopeItems");
                                        familyItems = this.executionContext.nuixUtilities.getItemUtility().intersection(familyItems, (Collection)scopeItems);
                                    } else {
                                        LOGGER.info("Scope is empty, skipping intersection with scope items");
                                    }
                                }
                                if (this.logResults) {
                                    if (this.breakdownByCustodian) {
                                        this.addExecutionLog((String)var19_24 + "\t" + this.iu.getFormattedString("SearchAndTagOperation.Log.FamiliesTagName", (Object)familyTagName) + "\t" + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFound", (long)familyItems.size()));
                                    } else {
                                        this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.FamiliesTagName", (Object)familyTagName) + "\t" + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFound", (long)familyItems.size()));
                                    }
                                }
                                resultStats.familyCount = familyItems.size();
                                if (this.computeSize) {
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.ComputingFamiliesSize", (Object)tagName);
                                    resultStats.familySize = ItemsUtils.getInstance().getItemsAuditedSize(familyItems);
                                }
                                if (this.computeTotals) {
                                    allFamiliesWithHits.addAll(familyItems);
                                }
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CannotGetFamilyItemsForTag", new Object[]{tagName, e.getLocalizedMessage()}));
                                LOGGER.warn("Cannot get family items for " + tagName, (Throwable)e);
                            }
                            if (this.identifyExclusiveHits) {
                                this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TrackingFamiliesExclusiveHits", (Object)tagName);
                                for (Item familyItem : familyItems) {
                                    String previousTagName = this.uniqueFamilyTracker.putIfAbsent(familyItem, custodian + "-" + tagName);
                                    if (previousTagName == null || previousTagName.equals(custodian + "-" + tagName) || previousTagName.equals("__AUTOMATE_MULT__")) continue;
                                    this.uniqueFamilyTracker.replace(familyItem, "__AUTOMATE_MULT__");
                                }
                            }
                        }
                        Set topLevelItems = new HashSet();
                        String topLevelTagName = this.effectiveTagPrefix + (this.effectiveTagPrefix.length() > 0 ? "|" : "") + "TopLevel|" + tagName;
                        if (this.identifyFamilies) {
                            try {
                                this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.ComputingTopLevelCount", (Object)tagName);
                                if (items != null && items.size() > 0) {
                                    LOGGER.info("Getting top-level items");
                                    topLevelItems = this.executionContext.nuixUtilities.getItemUtility().findTopLevelItems(items);
                                    if (this.scope.length() > 0) {
                                        LOGGER.info("Intersecting with scopeItems");
                                        topLevelItems = this.executionContext.nuixUtilities.getItemUtility().intersection(topLevelItems, (Collection)scopeItems);
                                    } else {
                                        LOGGER.info("Scope is empty, skipping intersection with scope items");
                                    }
                                }
                                if (this.logResults) {
                                    if (this.breakdownByCustodian) {
                                        this.addExecutionLog((String)var19_24 + "\t" + this.iu.getFormattedString("SearchAndTagOperation.Log.TopLevelTagName", (Object)topLevelTagName) + "\t" + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFound", (long)topLevelItems.size()));
                                    } else {
                                        this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.TopLevelTagName", (Object)topLevelTagName) + "\t" + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFound", (long)topLevelItems.size()));
                                    }
                                }
                                resultStats.topLevelCount = topLevelItems.size();
                                if (this.computeTotals) {
                                    allTopLevelHits.addAll(topLevelItems);
                                }
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CannotGetTopLevelItemsForTag", new Object[]{tagName, e.getLocalizedMessage()}));
                                LOGGER.warn("Cannot get top-level items for " + tagName, (Throwable)e);
                            }
                            if (this.identifyExclusiveHits) {
                                this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TrackingTopLevelExclusiveHits", (Object)tagName);
                                for (Item topLevelItem : topLevelItems) {
                                    String previousTagName = this.uniqueTopLevelTracker.putIfAbsent(topLevelItem, custodian + "-" + tagName);
                                    if (previousTagName == null || previousTagName.equals(custodian + "-" + tagName) || previousTagName.equals("__AUTOMATE_MULT__")) continue;
                                    this.uniqueTopLevelTracker.replace(topLevelItem, "__AUTOMATE_MULT__");
                                }
                            }
                        }
                        ++this.stageId;
                        if (this.assignTags) {
                            try {
                                this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TaggingHits", (Object)tagName);
                                LOGGER.info("Tagging " + items.size() + " items with " + hitsTagName);
                                if (this.alwaysCreateTags || items.size() > 0) {
                                    this.executionContext.nuixCase.createTag(hitsTagName);
                                    bulkAnnotater.addTag(hitsTagName, items);
                                }
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.ErrorApplyingTag", new Object[]{hitsTagName, e.getLocalizedMessage()}));
                                LOGGER.error("Error applying tag " + hitsTagName, (Throwable)e);
                                resultStats.invalidTag = true;
                            }
                            if (this.identifyDescendants) {
                                try {
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TaggingDescendants", (Object)tagName);
                                    LOGGER.info("Tagging " + descendantItems.size() + " items with " + familyTagName);
                                    if (this.alwaysCreateTags || descendantItems.size() > 0) {
                                        this.executionContext.nuixCase.createTag(descendantsTagName);
                                        bulkAnnotater.addTag(descendantsTagName, descendantItems);
                                    }
                                }
                                catch (Exception e) {
                                    this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.ErrorApplyingTag", new Object[]{familyTagName, e.getLocalizedMessage()}));
                                    LOGGER.error("Error applying tag " + familyTagName, (Throwable)e);
                                }
                            }
                            if (this.identifyFamilies) {
                                try {
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TaggingFamilies", (Object)tagName);
                                    LOGGER.info("Tagging " + familyItems.size() + " items with " + familyTagName);
                                    if (this.alwaysCreateTags || familyItems.size() > 0) {
                                        this.executionContext.nuixCase.createTag(familyTagName);
                                        bulkAnnotater.addTag(familyTagName, familyItems);
                                    }
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TaggingTopLevel", (Object)tagName);
                                    LOGGER.info("Tagging " + topLevelItems.size() + " items with " + topLevelTagName);
                                    if (this.alwaysCreateTags || topLevelItems.size() > 0) {
                                        this.executionContext.nuixCase.createTag(topLevelTagName);
                                        bulkAnnotater.addTag(topLevelTagName, topLevelItems);
                                    }
                                }
                                catch (Exception e) {
                                    this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.ErrorApplyingTag", new Object[]{familyTagName, e.getLocalizedMessage()}));
                                    LOGGER.error("Error applying tag " + familyTagName, (Throwable)e);
                                }
                            }
                            ++this.stageId;
                        }
                        this.results.put(custodian + "-" + String.format("%09d", searchCount) + "-" + tagName, resultStats);
                    }
                }
                this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.SearchedKeywords", (Object)this.searches.size()));
                if (this.identifyExclusiveHits) {
                    HashMap uniqueHitsPerKeyword = new HashMap();
                    HashMap exclusiveTopLevelPerKeyword = new HashMap();
                    HashMap exclusiveFamilyPerKeyword = new HashMap();
                    this.stageName = this.iu.getString("SearchAndTagOperation.Stage.ComputingExclusiveHits");
                    LOGGER.info("Computing exclusive hits");
                    for (String string : this.results.keySet()) {
                        SearchAndTagReportItemStats result = (SearchAndTagReportItemStats)this.results.get(string);
                        uniqueHitsPerKeyword.put((CallSite)((Object)(result.custodian + "-" + result.keyword)), new HashSet());
                        exclusiveTopLevelPerKeyword.put((CallSite)((Object)(result.custodian + "-" + result.keyword)), new HashSet());
                        exclusiveFamilyPerKeyword.put((CallSite)((Object)(result.custodian + "-" + result.keyword)), new HashSet());
                    }
                    for (Map.Entry entry : this.uniqueHitsTracker.entrySet()) {
                        String uniqueHitsKeyword = (String)entry.getValue();
                        if (uniqueHitsKeyword.equals("__AUTOMATE_MULT__")) continue;
                        ((Set)uniqueHitsPerKeyword.get(uniqueHitsKeyword)).add((Item)entry.getKey());
                    }
                    if (this.identifyFamilies) {
                        this.stageName = this.iu.getString("SearchAndTagOperation.Stage.ComputingExclusiveFamilies");
                        LOGGER.info("Computing exclusive families");
                        for (Map.Entry entry : this.uniqueFamilyTracker.entrySet()) {
                            String uniqueFamilyKeyword = (String)entry.getValue();
                            if (uniqueFamilyKeyword.equals("__AUTOMATE_MULT__")) continue;
                            ((Set)exclusiveFamilyPerKeyword.get(uniqueFamilyKeyword)).add((Item)entry.getKey());
                        }
                        this.stageName = this.iu.getString("SearchAndTagOperation.Stage.ComputingExclusiveTopLevel");
                        LOGGER.info("Computing exclusive top-level");
                        for (Map.Entry entry : this.uniqueTopLevelTracker.entrySet()) {
                            String uniqueTopLevelKeyword = (String)entry.getValue();
                            if (uniqueTopLevelKeyword.equals("__AUTOMATE_MULT__")) continue;
                            ((Set)exclusiveTopLevelPerKeyword.get(uniqueTopLevelKeyword)).add((Item)entry.getKey());
                        }
                    }
                    for (String string : this.results.keySet()) {
                        resultStats = (SearchAndTagReportItemStats)this.results.get(string);
                        Set exclusiveHits = (Set)uniqueHitsPerKeyword.get(resultStats.custodian + "-" + resultStats.keyword);
                        LOGGER.info("Keyword " + resultStats.keyword + " has " + exclusiveHits.size() + " exclusive hits.");
                        resultStats.exclusiveHitsCount = exclusiveHits.size();
                        String tagName = resultStats.keyword;
                        String exclusiveHitsTagName = this.effectiveTagPrefix + (this.effectiveTagPrefix.length() > 0 ? "|" : "") + "ExclusiveHits|" + resultStats.keyword;
                        String printableCustodian = resultStats.custodian;
                        if (printableCustodian.length() == 0) {
                            printableCustodian = this.iu.getString("SearchAndTagOperation.Log.NoCustodian");
                        }
                        if (this.logResults) {
                            if (this.breakdownByCustodian) {
                                this.addExecutionLog(printableCustodian + "\t" + this.iu.getFormattedString("SearchAndTagOperation.Log.HitsExclusiveTagName", (Object)exclusiveHitsTagName) + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFoundInfo", (long)exclusiveHits.size()));
                            } else {
                                this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.HitsExclusiveTagName", (Object)exclusiveHitsTagName) + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFoundInfo", (long)exclusiveHits.size()));
                            }
                        }
                        if (this.computeSize) {
                            this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.ComputingExclusiveHitsSize", (Object)tagName);
                            resultStats.exclusiveHitsSize = ItemsUtils.getInstance().getItemsAuditedSize(exclusiveHits);
                        }
                        if (this.computeTotals) {
                            allExclusiveItemsWithHits.addAll(exclusiveHits);
                        }
                        Set exclusiveFamily = null;
                        Set exclusiveTopLevel = null;
                        String exclusiveFamilyTagName = null;
                        String exclusiveTopLevelTagName = null;
                        if (this.identifyFamilies) {
                            exclusiveFamily = (Set)exclusiveFamilyPerKeyword.get(resultStats.custodian + "-" + resultStats.keyword);
                            LOGGER.info("Keyword " + resultStats.keyword + " has " + exclusiveFamily.size() + " exclusive families.");
                            resultStats.exclusiveFamilyCount = exclusiveFamily.size();
                            exclusiveFamilyTagName = this.effectiveTagPrefix + (this.effectiveTagPrefix.length() > 0 ? "|" : "") + "ExclusiveFamilies|" + resultStats.keyword;
                            if (this.logResults) {
                                if (this.breakdownByCustodian) {
                                    this.addExecutionLog(printableCustodian + "\t" + this.iu.getFormattedString("SearchAndTagOperation.Log.FamiliesExclusiveTagName", (Object)exclusiveFamilyTagName) + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFoundInfo", (long)exclusiveFamily.size()));
                                } else {
                                    this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.FamiliesExclusiveTagName", (Object)exclusiveFamilyTagName) + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFoundInfo", (long)exclusiveFamily.size()));
                                }
                            }
                            if (this.computeSize) {
                                this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.ComputingExclusiveFamiliesSize", (Object)tagName);
                                resultStats.exclusiveFamilySize = ItemsUtils.getInstance().getItemsAuditedSize(exclusiveFamily);
                            }
                            if (this.computeTotals) {
                                allExclusiveFamiliesWithHits.addAll(exclusiveFamily);
                            }
                            exclusiveTopLevel = (Set)exclusiveTopLevelPerKeyword.get(resultStats.custodian + "-" + resultStats.keyword);
                            LOGGER.info("Keyword " + resultStats.keyword + " has " + exclusiveTopLevel.size() + " exclusive top-level hits.");
                            resultStats.exclusiveTopLevelCount = exclusiveTopLevel.size();
                            exclusiveTopLevelTagName = this.effectiveTagPrefix + (this.effectiveTagPrefix.length() > 0 ? "|" : "") + "ExclusiveTopLevel|" + resultStats.keyword;
                            if (this.logResults) {
                                if (this.breakdownByCustodian) {
                                    this.addExecutionLog(printableCustodian + "\t" + this.iu.getFormattedString("SearchAndTagOperation.Log.TopLevelExclusiveTagName", (Object)exclusiveTopLevelTagName) + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFoundInfo", (long)exclusiveTopLevel.size()));
                                } else {
                                    this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.TopLevelExclusiveTagName", (Object)exclusiveTopLevelTagName) + this.iu.getNumeralString("SearchAndTagOperation.Log.ItemsFoundInfo", (long)exclusiveTopLevel.size()));
                                }
                            }
                            if (this.computeTotals) {
                                allExclusiveTopLevelHits.addAll(exclusiveTopLevel);
                            }
                        }
                        if (this.assignTags) {
                            try {
                                this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TaggingExclusiveHits", (Object)tagName);
                                LOGGER.info("Tagging " + exclusiveHits.size() + " items with " + exclusiveHitsTagName);
                                if (this.alwaysCreateTags || exclusiveHits.size() > 0) {
                                    this.executionContext.nuixCase.createTag(exclusiveHitsTagName);
                                    bulkAnnotater.addTag(exclusiveHitsTagName, (Collection)exclusiveHits);
                                }
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.ErrorApplyingTag", new Object[]{exclusiveHitsTagName, e.getLocalizedMessage()}));
                                LOGGER.error("Error applying tag " + exclusiveHitsTagName, (Throwable)e);
                                resultStats.invalidTag = true;
                            }
                            if (this.identifyFamilies) {
                                try {
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TaggingExclusiveFamilies", (Object)tagName);
                                    LOGGER.info("Tagging " + exclusiveFamily.size() + " items with " + exclusiveFamilyTagName);
                                    if (this.alwaysCreateTags || exclusiveFamily.size() > 0) {
                                        this.executionContext.nuixCase.createTag(exclusiveFamilyTagName);
                                        bulkAnnotater.addTag(exclusiveFamilyTagName, (Collection)exclusiveFamily);
                                    }
                                }
                                catch (Exception e) {
                                    this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.ErrorApplyingTag", new Object[]{exclusiveFamilyTagName, e.getLocalizedMessage()}));
                                    LOGGER.error("Error applying tag " + exclusiveFamilyTagName, (Throwable)e);
                                    resultStats.invalidTag = true;
                                }
                                try {
                                    this.stageName = this.iu.getFormattedString("SearchAndTagOperation.Stage.TaggingExclusiveTopLevel", (Object)tagName);
                                    LOGGER.info("Tagging " + exclusiveTopLevel.size() + " items with " + exclusiveTopLevelTagName);
                                    if (this.alwaysCreateTags || exclusiveTopLevel.size() > 0) {
                                        this.executionContext.nuixCase.createTag(exclusiveTopLevelTagName);
                                        bulkAnnotater.addTag(exclusiveTopLevelTagName, (Collection)exclusiveTopLevel);
                                    }
                                }
                                catch (Exception e) {
                                    this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.ErrorApplyingTag", new Object[]{exclusiveTopLevelTagName, e.getLocalizedMessage()}));
                                    LOGGER.error("Error applying tag " + exclusiveTopLevelTagName, (Throwable)e);
                                    resultStats.invalidTag = true;
                                }
                            }
                        }
                        ++this.stageId;
                    }
                }
                if (detectedSearchErrors) {
                    this.addWarning(this.iu.getString("SearchAndTagOperation.Warning.KeywordSearchesError") + "\t" + this.iu.getString("SearchAndTagOperation.Warning.Query") + "\t" + this.iu.getFormattedString("SearchAndTagOperation.Warning.EffectiveQuery", keywordErrorMessages));
                }
                if (this.computeTotals) {
                    this.totals = new SearchAndTagReportItemStats();
                    this.totals.hitsCount = allItemsWithHits.size();
                    this.totals.familyCount = allFamiliesWithHits.size();
                    this.totals.topLevelCount = allTopLevelHits.size();
                    this.totals.exclusiveHitsCount = allExclusiveItemsWithHits.size();
                    this.totals.exclusiveFamilyCount = allExclusiveFamiliesWithHits.size();
                    this.totals.exclusiveTopLevelCount = allExclusiveTopLevelHits.size();
                    if (this.computeSize) {
                        this.stageName = this.iu.getString("SearchAndTagOperation.Stage.TotalsComputingHitsSize");
                        this.totals.hitsSize = ItemsUtils.getInstance().getItemsAuditedSize(allItemsWithHits);
                        this.stageName = this.iu.getString("SearchAndTagOperation.Stage.TotalsComputingFamiliesSize");
                        this.totals.familySize = ItemsUtils.getInstance().getItemsAuditedSize(allFamiliesWithHits);
                        this.stageName = this.iu.getString("SearchAndTagOperation.Stage.TotalsComputingExclusiveHitsSize");
                        this.totals.exclusiveHitsSize = ItemsUtils.getInstance().getItemsAuditedSize(allExclusiveItemsWithHits);
                        this.stageName = this.iu.getString("SearchAndTagOperation.Stage.TotalsComputingExclusiveFamiliesSize");
                        this.totals.exclusiveFamilySize = ItemsUtils.getInstance().getItemsAuditedSize(allExclusiveFamiliesWithHits);
                    }
                }
                if (this.writeReport) {
                    this.stageName = this.iu.getString("SearchAndTagOperation.Stage.WritingReport");
                    if (this.customReportTemplatePath.length() > 0) {
                        this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.ReportTemplate", (Object)this.customReportTemplatePath));
                    }
                    this.writeReport();
                    this.addExecutionLog(this.iu.getFormattedString("SearchAndTagOperation.Log.ReportLocation", (Object)this.reportLocation));
                    ++this.stageId;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void writeReport() throws Exception {
        Cell nextCell;
        int templateWorksheetIndex;
        Object buffer;
        AsposeUtils.applyAsposeCellsLicense();
        LoadOptions loadOptions = new LoadOptions(6);
        File templateFile = null;
        if (this.customReportTemplatePath.length() > 0 && !(templateFile = new File(this.customReportTemplatePath)).exists()) {
            LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CouldNotFindReportTemplate", (Object)templateFile.getAbsoluteFile()));
        }
        if (templateFile == null || !templateFile.exists()) {
            templateFile = this.executionContext.getReportTemplate();
            LOGGER.info("Cannot find report template file " + templateFile.getAbsolutePath() + ". Creating default file");
            File templateFolder = templateFile.getParentFile();
            if (!templateFolder.exists()) {
                LOGGER.info("Creating folder " + templateFolder.getAbsolutePath());
                templateFolder.mkdirs();
            }
            try (InputStream templateStream = this.getClass().getResourceAsStream("/reports/template.xlsx");
                 OutputStream outputStream = Files.newOutputStream(templateFile.toPath(), new OpenOption[0]);){
                int bytesRead;
                buffer = new byte[1024];
                while ((bytesRead = templateStream.read((byte[])buffer)) != -1) {
                    outputStream.write((byte[])buffer, 0, bytesRead);
                }
                templateStream.close();
                outputStream.flush();
            }
        }
        Workbook workbook = new Workbook(templateFile.getAbsolutePath(), loadOptions);
        for (int worksheetId = 0; worksheetId < workbook.getWorksheets().getCount(); ++worksheetId) {
            Worksheet worksheet = workbook.getWorksheets().get(worksheetId);
            LOGGER.info("Pre-processing worksheet " + worksheet.getName());
            buffer = this.executionContext.getParameterNames().iterator();
            while (buffer.hasNext()) {
                String placeholder = (String)buffer.next();
                try {
                    FindOptions findOptions = new FindOptions();
                    findOptions.setLookAtType(3);
                    findOptions.setLookInType(1);
                    Cell matchingCell = null;
                    while ((matchingCell = worksheet.getCells().find((Object)placeholder, matchingCell, findOptions)) != null) {
                        String unpackedPlaceholder = this.executionContext.evalParameters(placeholder, this);
                        if (placeholder.equals("{date_spreadsheet}") || placeholder.equals("{date_time_spreadsheet}")) {
                            matchingCell.setValue((Object)Calendar.getInstance());
                        } else if (placeholder.equals("{time_spreadsheet}")) {
                            matchingCell.setValue((Object)new Date());
                        } else {
                            matchingCell.setValue((Object)unpackedPlaceholder);
                        }
                        LOGGER.info("Searching for " + placeholder + ", got " + String.valueOf(matchingCell));
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Cannot unpack placeholder " + placeholder, (Throwable)e);
                }
            }
        }
        String treeSizeWorksheetName = TemplateWorksheetName.TEMPLATE_SEARCH_AND_TAG.toString();
        try {
            templateWorksheetIndex = workbook.getWorksheets().addCopy(treeSizeWorksheetName);
        }
        catch (CellsException e) {
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.TemplateFileNoWorksheetNamed", (Object)treeSizeWorksheetName));
            return;
        }
        Worksheet worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
        worksheet.setName(this.iu.getString("SearchAndTagOperation.Report.SearchReport"));
        int sr = 0;
        int sc = 0;
        FindOptions findOptions = new FindOptions();
        findOptions.setLookAtType(0);
        findOptions.setLookInType(1);
        Cell matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
        if (matchingCell != null) {
            sr = matchingCell.getRow();
            sc = matchingCell.getColumn();
            matchingCell.setValue((Object)this.iu.getString("SearchAndTagOperation.Report.Custodian"));
        }
        if ((nextCell = worksheet.getCells().get(sr, sc + 1)).getValue().toString().equals("Query")) {
            LOGGER.warn("Excel template not up to date, duplicating header column");
            worksheet.getCells().insertColumn(sc);
            worksheet.getCells().copyColumn(worksheet.getCells(), sc + 1, sc);
            worksheet.getCells().get(sr, sc + 1).setValue((Object)this.iu.getString("SearchAndTagOperation.Report.Keyword"));
        }
        matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
        if (matchingCell != null) {
            matchingCell.setValue((Object)this.iu.getString("SearchAndTagOperation.Report.SearchReport"));
        }
        int rowId = 3;
        long stageProcessedItems = 0L;
        for (String string : this.results.keySet()) {
            if (this.stopRequested) {
                this.trackStopped();
                return;
            }
            SearchAndTagReportItemStats itemStats = (SearchAndTagReportItemStats)this.results.get(string);
            worksheet.getCells().insertRow(sr + ++rowId);
            Boolean isLastRow = stageProcessedItems == (long)(this.results.keySet().size() - 1);
            Boolean isFirstRow = stageProcessedItems == 0L;
            if (isFirstRow.booleanValue()) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 1, sr + rowId);
            } else if (!isLastRow.booleanValue()) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
            } else {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
            }
            int column = 0;
            String effectiveCustodian = itemStats.custodian;
            if (effectiveCustodian.length() == 0) {
                effectiveCustodian = this.iu.getString("SearchAndTagOperation.Log.NoCustodian");
            }
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)effectiveCustodian);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)itemStats.keyword);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)itemStats.searchQuery);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)itemStats.hitsCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)itemStats.familyCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)itemStats.topLevelCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)itemStats.exclusiveHitsCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)itemStats.exclusiveFamilyCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)itemStats.exclusiveTopLevelCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)((double)itemStats.hitsSize / 1024.0 / 1024.0 / 1024.0));
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)((double)itemStats.familySize / 1024.0 / 1024.0 / 1024.0));
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)((double)itemStats.exclusiveHitsSize / 1024.0 / 1024.0 / 1024.0));
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)((double)itemStats.exclusiveFamilySize / 1024.0 / 1024.0 / 1024.0));
            Object noteMessage = "";
            if (itemStats.invalidQuery.booleanValue()) {
                noteMessage = this.iu.getString("SearchAndTagOperation.Report.InvalidQuery");
            }
            if (itemStats.invalidTag.booleanValue()) {
                if (((String)noteMessage).length() > 0) {
                    noteMessage = (String)noteMessage + ", ";
                }
                noteMessage = (String)noteMessage + this.iu.getString("SearchAndTagOperation.Report.InvalidTag");
            }
            if (itemStats.additionalTextAfterQuery.booleanValue()) {
                if (((String)noteMessage).length() > 0) {
                    noteMessage = (String)noteMessage + ", ";
                }
                noteMessage = (String)noteMessage + this.iu.getString("SearchAndTagOperation.Report.AdditionalTextAfterQuery");
            }
            if (((String)noteMessage).length() > 0) {
                worksheet.getCells().get(sr + rowId, sc + column).setValue(noteMessage);
            }
            ++stageProcessedItems;
        }
        ++rowId;
        ++rowId;
        int column = 3;
        if (this.computeTotals) {
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)this.totals.hitsCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)this.totals.familyCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)this.totals.topLevelCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)this.totals.exclusiveHitsCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)this.totals.exclusiveFamilyCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)this.totals.exclusiveTopLevelCount);
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)((double)this.totals.hitsSize / 1024.0 / 1024.0 / 1024.0));
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)((double)this.totals.familySize / 1024.0 / 1024.0 / 1024.0));
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)((double)this.totals.exclusiveHitsSize / 1024.0 / 1024.0 / 1024.0));
            worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)((double)this.totals.exclusiveFamilySize / 1024.0 / 1024.0 / 1024.0));
        } else {
            worksheet.getCells().deleteRow(sr + rowId);
        }
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        column = 4;
        if (!this.identifyFamilies) {
            worksheet.getCells().deleteColumn(sr + column);
        } else {
            ++column;
        }
        if (!this.identifyFamilies) {
            worksheet.getCells().deleteColumn(sr + column);
        } else {
            ++column;
        }
        if (!this.identifyExclusiveHits) {
            worksheet.getCells().deleteColumn(sr + column);
        } else {
            ++column;
        }
        if (!this.identifyFamilies || !this.identifyExclusiveHits) {
            worksheet.getCells().deleteColumn(sr + column);
        } else {
            ++column;
        }
        if (!this.identifyFamilies || !this.identifyExclusiveHits) {
            worksheet.getCells().deleteColumn(sr + column);
        } else {
            ++column;
        }
        if (!this.computeSize) {
            worksheet.getCells().deleteColumn(sr + column);
        } else {
            ++column;
        }
        if (!this.computeSize || !this.identifyFamilies) {
            worksheet.getCells().deleteColumn(sr + column);
        } else {
            ++column;
        }
        if (!this.computeSize || !this.identifyExclusiveHits) {
            worksheet.getCells().deleteColumn(sr + column);
        } else {
            ++column;
        }
        if (!(this.computeSize && this.identifyFamilies && this.identifyExclusiveHits)) {
            worksheet.getCells().deleteColumn(sr + column);
        } else {
            ++column;
        }
        if (!this.breakdownByCustodian) {
            worksheet.getCells().deleteColumn(sr);
        }
        for (TemplateWorksheetName templateWorksheetName : TemplateWorksheetName.values()) {
            try {
                workbook.getWorksheets().removeAt(templateWorksheetName.toString());
            }
            catch (Exception e) {
                LOGGER.error("Cannot remove sheet " + String.valueOf((Object)templateWorksheetName));
            }
        }
        workbook.getBuiltInDocumentProperties().setAuthor("Automate Workflow");
        this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
        File file = new File(this.reportLocation);
        this.reportLocation = file.getAbsolutePath();
        File reportFolder = file.getParentFile();
        if (!reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        LOGGER.info("Saving report to " + file.getAbsolutePath());
        if (file.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
            PdfSaveOptions saveOptions = new PdfSaveOptions();
            saveOptions.setAllColumnsInOnePagePerSheet(true);
            workbook.save(file.getAbsolutePath(), (SaveOptions)saveOptions);
        } else {
            String reportPasswordParameter = "{report_password}";
            String reportPassword = this.executionContext.evalParameters(reportPasswordParameter, this);
            if (!reportPassword.equals(reportPasswordParameter)) {
                this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                if (reportPassword.length() == 0) {
                    this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                }
                workbook.setEncryptionOptions(3, 128);
                workbook.getSettings().setPassword(reportPassword);
            }
            workbook.save(file.getAbsolutePath());
        }
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_report_file}", file.getAbsolutePath())));
    }

    @Override
    public void stopTriggered() {
        this.stopTriggered = true;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.stageCount > 0) {
            percentageComplete = (double)this.stageId / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        return result;
    }
}

