/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldLicenseModule;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.SEMANTIC_CONFIGURE, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"SEMANTIC"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@OperationLicenseModule(module=ModuleType.SEMANTIC)
public class SemanticConfigureOperation
extends Operation {
    @FormField
    public boolean useSemanticService;
    @FormField(visibleOn={@OnField(name="useSemanticService")})
    public String semanticServiceId;
    @FormField(required=false)
    @FieldLicenseModule(value=ModuleType.SEMANTIC_TEXT_SEARCH)
    public String textEmbeddingsModel;
    @FormField(required=false)
    @FieldLicenseModule(value=ModuleType.SEMANTIC_IMAGE_SEARCH)
    public String imageEmbeddingsModel;
    @FormField(required=false)
    @FieldLicenseModule(value=ModuleType.SEMANTIC_FACE_VECTORIZATION)
    public boolean detectFaces;
    @FormField(required=false)
    @FieldLicenseModule(value=ModuleType.SEMANTIC_TRANSCRIPTION)
    public String transcriptionModel;

    public SemanticConfigureOperation() {
        this.requiresCase = false;
        this.useSemanticService = true;
        this.semanticServiceId = "{semantic_service_id}";
        this.textEmbeddingsModel = "intfloat/multilingual-e5-large-instruct";
        this.imageEmbeddingsModel = "openai/clip-vit-large-patch14";
        this.detectFaces = false;
        this.transcriptionModel = "openai/whisper-small";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("SemanticConfigureOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.SEMANTIC_CONFIGURE;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.executionContext.nuixVersion.compareTo(new Version("100.11.0")) < 0) {
            prerequisites.add(this.iu.getString("SemanticSearch.Prerequisites.RequiresNuixEngineOneHundredTwelve"));
        }
        return prerequisites;
    }
}

