/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.internal.EccUtils;
import com.nuix.automate.utils.ecc.responses.configurations.Configuration;
import com.nuix.automate.utils.ecc.responses.configurations.Configurations;
import com.nuix.automate.utils.ecc.responses.tasks.Task;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.SetEccCollectionConfigurationOperation;
import java.util.ArrayList;

public class SetEccCollectionConfigurationOperationImplementation
extends SetEccCollectionConfigurationOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SetEccCollectionConfigurationOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient EccUtils utils;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = "";
                this.utils = EccUtils.getInstance();
                this.configurationIdentifier = this.executionContext.evalParameters(this.configurationIdentifier, this);
                this.initializeEccClient();
                this.percentageComplete = 0.3;
                this.stageName = this.iu.getString("SetEccCollectionConfiguration.Stage.GettingConfiguration");
                Configuration eccConfiguration = null;
                Configurations configurations = this.eccRestClient.getConfigurations();
                eccConfiguration = (Configuration)this.utils.filter(configurations.getConfigurations(), this.configurationIdentifierType, this.configurationIdentifier);
                if (eccConfiguration == null) {
                    throw new Exception(this.iu.getFormattedString("SetEccCollectionConfiguration.Exception.ConfigurationMissing", new Object[]{this.configurationIdentifierType.toString(), this.configurationIdentifier}));
                }
                this.addExecutionLog(this.iu.getFormattedString("SetEccCollectionConfiguration.Log.ConfigurationId", (Object)eccConfiguration.getId()));
                this.addExecutionLog(this.iu.getFormattedString("SetEccCollectionConfiguration.Log.ConfigurationName", (Object)eccConfiguration.getName()));
                ArrayList<String> taskNames = new ArrayList<String>();
                for (Task task : eccConfiguration.getTasks()) {
                    taskNames.add(task.getTaskType().getDescription());
                }
                if (taskNames.size() == 0) {
                    throw new Exception(this.iu.getFormattedString("SetEccCollectionConfiguration.Exception.InvalidConfiguration", (Object)eccConfiguration.getName()));
                }
                this.addExecutionLog(this.iu.getNumeralFormattedString("SetEccCollectionConfiguration.Log.ConfigurationTasks", (long)taskNames.size(), (Object)("(" + String.join((CharSequence)", ", taskNames) + ")")));
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_configuration_id}", String.valueOf(eccConfiguration.getId()))));
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_configuration_name}", eccConfiguration.getName())));
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

