/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.internal.EccCollectableSource;
import com.nuix.automate.utils.ecc.internal.EccCollectableSources;
import com.nuix.automate.utils.ecc.internal.EccCollectionStrategy;
import com.nuix.automate.utils.ecc.internal.EccUtils;
import com.nuix.automate.utils.ecc.responses.cases.Case;
import com.nuix.automate.utils.ecc.responses.collections.CollectionByConfiguration;
import com.nuix.automate.utils.ecc.responses.collections.CollectionByPath;
import com.nuix.automate.utils.ecc.responses.collections.CollectionComputer;
import com.nuix.automate.utils.ecc.responses.collections.CollectionJob;
import com.nuix.automate.utils.ecc.responses.collections.CollectionResponse;
import com.nuix.automate.utils.ecc.responses.collections.EccCollectionArguments;
import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.ecc.responses.configurations.Configuration;
import com.nuix.automate.utils.ecc.responses.jobs.Job;
import com.nuix.automate.utils.ecc.responses.tasks.Task;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.SubmitEccCollectionOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SubmitEccCollectionOperationImplementation
extends SubmitEccCollectionOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SubmitEccCollectionOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient EccUtils eccUtils;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.eccUtils = EccUtils.getInstance();
                this.initializeEccClient();
                this.stageName = this.iu.getString("SubmitEccCollectionOperation.Stage.PreparingForCollection");
                this.percentageComplete = 0.1;
                this.collectionName = this.executionContext.evalParameters(this.collectionName, this);
                this.addExecutionLog(this.iu.getFormattedString("SubmitEccCollectionOperation.Log.CollectionName", (Object)this.collectionName));
                if (this.overrideDestinationLocation) {
                    this.destinationLocation = this.executionContext.evalParameters(this.destinationLocation, this);
                    this.addExecutionLog(this.iu.getFormattedString("SubmitEccCollectionOperation.Log.CollectionLocation", (Object)this.destinationLocation));
                } else {
                    this.destinationLocation = "";
                }
                int collectionCaseId = this.executionContext.evalIntParameter("{ecc_case_id}", this);
                String collectionCaseName = this.executionContext.evalParameters("{ecc_case_name}", this);
                Case collectionCase = this.eccRestClient.getCase(collectionCaseId);
                if (collectionCase == null) {
                    throw new Exception(this.iu.getFormattedString("SubmitEccCollectionOperation.Error.CannotFindCase", new Object[]{collectionCaseName, String.valueOf(collectionCaseId)}));
                }
                this.addExecutionLog(this.iu.getFormattedString("SubmitEccCollectionOperation.Log.CaseName", new Object[]{collectionCase.getName(), String.valueOf(collectionCaseId)}));
                String collectionConfigurationName = this.executionContext.evalParameters("{ecc_configuration_name}", this);
                int collectionConfigurationId = this.executionContext.evalIntParameter("{ecc_configuration_id}", this);
                Configuration collectionConfiguration = this.eccRestClient.getConfigurationForId(collectionConfigurationId);
                if (collectionConfiguration == null) {
                    throw new Exception(this.iu.getFormattedString("SubmitEccCollectionOperation.Error.CannotFindConfiguration", new Object[]{collectionConfigurationName, String.valueOf(collectionConfigurationId)}));
                }
                this.addExecutionLog(this.iu.getFormattedString("SubmitEccCollectionOperation.Log.ConfigurationName", new Object[]{collectionConfiguration.getName(), String.valueOf(collectionConfigurationId)}));
                ArrayList<String> taskNames = new ArrayList<String>();
                for (Task task : collectionConfiguration.getTasks()) {
                    taskNames.add(task.getTaskType().getDescription());
                }
                this.addExecutionLog(this.iu.getFormattedString("SubmitEccCollectionOperation.Log.ConfigurationType", (Object)("(" + String.join((CharSequence)", ", taskNames) + ")")));
                int jobCount = 0;
                HashMap<Integer, Object> collectionIdToJobIds = new HashMap<Integer, Object>();
                Map<String, Computer> existingComputers = this.getComputerIdMap();
                List eccCollectableSources = new ArrayList();
                String collectionSourcesJson = this.executionContext.evalParameters("{wfn_ecc_collection_sources}", this);
                if (!collectionSourcesJson.equals("{wfn_ecc_collection_sources}")) {
                    EccCollectableSources sources = (EccCollectableSources)SerializationUtils.fromJson((String)collectionSourcesJson, EccCollectableSources.class);
                    eccCollectableSources = sources.getSources();
                }
                if (eccCollectableSources == null || eccCollectableSources.size() == 0) {
                    this.addWarning(this.iu.getString("SubmitEccCollectionOperation.Error.NoCollectionSources"));
                    this.percentageComplete = 0.99;
                    this.trackFinished();
                    return;
                }
                int collectionCount = 1;
                for (EccCollectableSource source : eccCollectableSources) {
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    String computerGuid = source.getComputerGuid();
                    if (!existingComputers.containsKey(computerGuid)) {
                        this.addWarning(this.iu.getFormattedString("SubmitEccCollectionOperation.Warning.FailedToFindComputer", (Object)source.getName()));
                        continue;
                    }
                    EccCollectionArguments collectionArguments = new EccCollectionArguments(collectionCaseId, collectionConfigurationId, this.destinationLocation, source.getSourceCustomPaths());
                    try {
                        CollectionResponse response;
                        CollectionByPath arguments;
                        if (source.getSourceStrategy() == EccCollectionStrategy.CUSTOM_PATH) {
                            arguments = collectionArguments.getCollectionByPathArgument();
                            arguments.setName(this.getCollectionPart(this.collectionName, collectionCount, eccCollectableSources.size()));
                            arguments.setComputerId(computerGuid);
                            response = this.eccRestClient.launchCollection(arguments);
                        } else {
                            arguments = collectionArguments.getCollectionByConfigurationArgument();
                            arguments.setName(this.getCollectionPart(this.collectionName, collectionCount, eccCollectableSources.size()));
                            arguments.setComputerId(computerGuid);
                            response = this.eccRestClient.launchCollection((CollectionByConfiguration)arguments);
                        }
                        int collectionId = response.getCollectionId();
                        HashSet jobIds = new HashSet();
                        for (CollectionComputer computer : response.getComputers()) {
                            for (CollectionJob collectionJob : computer.getJobs()) {
                                ++jobCount;
                                jobIds.add(collectionJob.getId());
                            }
                        }
                        collectionIdToJobIds.put(collectionId, jobIds);
                    }
                    catch (IOException e) {
                        this.addWarning(this.iu.getFormattedString("SubmitEccCollectionOperation.Warning.FailedToLaunchCollection", new Object[]{source.getName(), e.getMessage()}));
                    }
                    ++collectionCount;
                }
                if (collectionIdToJobIds.keySet().size() > 0) {
                    String jobCountTranslation = this.iu.getNumeralString("SubmitEccCollectionOperation.Log.JobCount", (long)jobCount);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("SubmitEccCollectionOperation.Log.CollectionCount", (long)collectionIdToJobIds.keySet().size(), (Object)jobCountTranslation));
                    if (this.waitForCollectionToFinish) {
                        this.addExecutionLog(this.iu.getString("SubmitEccCollectionOperation.Log.WaitingForCollectionToFinish"));
                        List<Job> jobs = null;
                        HashSet<Integer> finishedJobIds = new HashSet<Integer>();
                        while (true) {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            jobs = this.eccRestClient.getJobsForCollections(collectionIdToJobIds.keySet());
                            if (jobs != null) {
                                boolean allCollectionsFinished = true;
                                double totalJobProgress = 0.0;
                                for (Job job : jobs) {
                                    boolean isJobFinished = this.isJobInFinishedState(job);
                                    if (this.isJobInWaitingState(job)) {
                                        allCollectionsFinished = false;
                                        continue;
                                    }
                                    if (job.getBytesCollected() != null && this.jobCollectsFiles(job) && !isJobFinished && job.getBytesToCollect() != 0L) {
                                        totalJobProgress += (double)job.getBytesCollected().longValue() / (double)job.getBytesToCollect().longValue();
                                    }
                                    if (isJobFinished) {
                                        finishedJobIds.add(job.getId());
                                        totalJobProgress += 1.0;
                                    }
                                    if (!allCollectionsFinished) continue;
                                    allCollectionsFinished = isJobFinished;
                                }
                                this.stageName = this.iu.getFormattedString("SubmitEccCollectionOperation.Stage.RunningCollections", new Object[]{String.valueOf(finishedJobIds.size()), String.valueOf(jobCount)});
                                this.percentageComplete = 0.1 + totalJobProgress / (double)jobCount * 0.9;
                                if (allCollectionsFinished) break;
                            }
                            Thread.sleep(500L);
                        }
                        jobs = this.eccRestClient.getJobsForCollections(collectionIdToJobIds.keySet());
                        int finishedJobCount = 0;
                        int failedJobCount = 0;
                        for (Job job : jobs) {
                            boolean jobFinishedSuccessfully = this.wasJobSuccessful(job);
                            if (jobFinishedSuccessfully) {
                                ++finishedJobCount;
                                continue;
                            }
                            ++failedJobCount;
                        }
                        if (finishedJobCount >= 1) {
                            this.addExecutionLog(this.iu.getNumeralString("SubmitEccCollectionOperation.Log.FinishedJobs", (long)finishedJobCount));
                        }
                        if (failedJobCount >= 1) {
                            this.addWarning(this.iu.getNumeralString("SubmitEccCollectionOperation.Log.FailedJobs", (long)failedJobCount));
                        }
                    }
                } else {
                    this.addWarning(this.iu.getNumeralString("SubmitEccCollectionOperation.Log.FailedCollections", (long)(collectionCount - 1)));
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

