/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.SwitchLicenceOperation;
import com.nuix.automate.workflow.core.execution.options.switchlicence.LicenceSourceType;
import com.nuix.automate.workflow.core.execution.workflow.Engine;
import java.io.IOException;
import nuix.Licence;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SwitchLicenceOperationImplementation
extends SwitchLicenceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SwitchLicenceOperation.class);
    private transient Engine engine;
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    public void startTriggered() throws Exception {
        this.filter = this.executionContext.evalParameters(this.filter, this);
        this.nmsUsername = this.executionContext.evalParameters(this.nmsUsername, this);
        this.nmsPassword = this.executionContext.evalProtectedParameter(this.nmsPassword);
        this.nmsName = this.executionContext.evalParameters(this.nmsName, this);
        try {
            this.executionContext.workflowLocalWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{}", this));
            this.executionContext.workflowParallelSettings = true;
            this.workers = this.executionContext.workflowLocalWorkersCount;
            this.addExecutionLog(this.iu.getFormattedString("SwitchLicenceOperation.Log.SetWorkerCountFromParameter", new Object[]{"{local_worker_count}", this.executionContext.workflowLocalWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                boolean licenceAcquired = false;
                this.engine = this.executionContext.getEngine();
                if (this.engine != null) {
                    if (this.licenceSourceType == LicenceSourceType.NONE) {
                        this.addExecutionLog(this.iu.getString("SwitchLicenceOperation.Log.ReleaseLicense"));
                        this.engine.switchLicence(this.filter, this.licenceSourceType, this.workers, this.nmsName, this.nmsPort, this.nmsUsername, this.nmsPassword, this.timeout);
                    } else {
                        this.addExecutionLog(this.iu.getFormattedString("SwitchLicenceOperation.Log.Filter", (Object)this.filter));
                        this.addExecutionLog(this.iu.getFormattedString("SwitchLicenceOperation.Log.Source", (Object)this.licenceSourceType));
                        this.addExecutionLog(this.iu.getFormattedString("SwitchLicenceOperation.Log.Workers", (Object)this.workers));
                        if (this.licenceSourceType == LicenceSourceType.NMS) {
                            this.addExecutionLog(this.iu.getFormattedString("SwitchLicenceOperation.Log.NuixManagementServerName", (Object)this.nmsName));
                            this.addExecutionLog(this.iu.getFormattedString("SwitchLicenceOperation.Log.NuixManagementServerPort", (Object)this.nmsPort));
                            this.addExecutionLog(this.iu.getFormattedString("SwitchLicenceOperation.Log.Username", (Object)this.nmsUsername));
                        }
                        if (this.licenceSourceType == LicenceSourceType.CLS) {
                            this.addExecutionLog(this.iu.getFormattedString("SwitchLicenceOperation.Log.Username", (Object)this.nmsUsername));
                        }
                        this.addExecutionLog(this.iu.getNumeralString("SwitchLicenceOperation.Log.Timeout", (long)this.timeout));
                        Licence licence = null;
                        try {
                            licence = this.engine.switchLicence(this.filter, this.licenceSourceType, this.workers, this.nmsName, this.nmsPort, this.nmsUsername, this.nmsPassword, this.timeout);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot acquire licence", (Throwable)e);
                        }
                        if (licence != null && licence.getWorkers() != null && licence.getWorkers() > 0) {
                            if (this.workers > 0 && this.workers > licence.getWorkers()) {
                                LOGGER.warn("Required workers: " + this.workers + ". Engine acquired workers: " + licence.getWorkers());
                            }
                            licenceAcquired = true;
                            this.addExecutionLog(this.iu.getFormattedString("SwitchLicenceOperation.Log.AcquiredLicense", new Object[]{licence.getDescription(), this.iu.getNumeralString("SwitchLicenceOperation.Log.AcquiredLicenseWorkers", (long)licence.getWorkers().intValue()), licence.isAudited() ? this.iu.getString("SwitchLicenceOperation.Log.AcquiredLicenseAudited") : ""}));
                        }
                    }
                } else {
                    this.addWarning(this.iu.getString("SwitchLicenceOperation.Warning.EngineControllerNotAvailable"));
                }
                if (!licenceAcquired && this.licenceSourceType != LicenceSourceType.NONE) {
                    this.exception = new IOException(this.iu.getString("SwitchLicenceOperation.Exception.LicenseNotAcquired"));
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void stopTriggered() {
        this.startTriggerThread.interrupt();
    }

    @Override
    protected double getPercentageComplete() {
        try {
            this.percentageComplete = (double)(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.startDateTime.getMillis()) / (1000.0 * (double)this.timeout);
        }
        catch (Exception e) {
            this.percentageComplete = 0.0;
        }
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.engine != null) {
            this.stageName = this.engine.getMessage();
            if (this.stageName != null && this.stageName.length() > 0) {
                if (((String)result).length() > 0) {
                    result = (String)result + " / ";
                }
                result = (String)result + this.stageName;
            }
        }
        return result;
    }
}

