/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.TagItemsOperation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class TagItemsOperationImplementation
extends TagItemsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(TagItemsOperation.class);
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;
    private transient int stageCount;
    private transient int stageId;
    private transient String stageName;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.tagName = this.executionContext.evalParameters(this.tagName, this);
        this.executionContext.closeAllTabs();
        this.countItemsProcessed = new AtomicLong(0L);
        this.startTriggerThread = new Thread(() -> {
            try {
                FixedSizeChunkPartitioner partitioner;
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (this.matchItemsInScope) {
                    this.addExecutionLog(this.iu.getString("TagItemsOperation.Log.MatchModeItemsInScope"));
                }
                if (this.matchDuplicatesOfItemsInScope) {
                    this.addExecutionLog(this.iu.getFormattedString("TagItemsOperation.Log.MatchModeDuplicatedItemsInScope", (Object)this.duplicatesOfItemsInScopeBy.toString().toLowerCase()));
                }
                if (this.matchNearDuplicatesOfItemsInScope) {
                    this.addExecutionLog(this.iu.getFormattedString("TagItemsOperation.Log.MatchModeNearDuplicatedItemsInScope", (Object)this.nearDuplicatesResemblanceThreshold));
                }
                this.addExecutionLog(this.iu.getFormattedString("TagItemsOperation.Log.ScopeQuery", (Object)this.scope));
                this.stageName = this.iu.getString("TagItemsOperation.Stage.MatchingItems");
                this.stageId = 0;
                this.stageCount = 1;
                if (this.matchItemsInScope) {
                    ++this.stageCount;
                }
                if (this.matchDuplicatesOfItemsInScope) {
                    ++this.stageCount;
                }
                if (this.matchNearDuplicatesOfItemsInScope) {
                    ++this.stageCount;
                }
                Set scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                Set matchedItems = Collections.newSetFromMap(new ConcurrentHashMap());
                Set itemsToTag = Collections.newSetFromMap(new ConcurrentHashMap());
                this.addExecutionLog(this.iu.getNumeralString("TagItemsOperation.Log.ScopeCount", (long)scopeItems.size()));
                this.countItemsToProcess = scopeItems.size();
                if (this.matchItemsInScope) {
                    matchedItems.addAll(scopeItems);
                }
                if (this.matchDuplicatesOfItemsInScope) {
                    partitioner = new FixedSizeChunkPartitioner((Iterable)scopeItems, ItemsUtils.getPartitionerChunkSize(1000, this));
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        while (iterator.hasNext()) {
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            Item item = (Item)iterator.next();
                            switch (this.duplicatesOfItemsInScopeBy) {
                                case INDIVIDUAL: {
                                    List duplicates = item.getDuplicates();
                                    if (duplicates == null) break;
                                    matchedItems.addAll(duplicates);
                                    break;
                                }
                                case FAMILY: {
                                    List duplicates;
                                    if (item.isTopLevel()) {
                                        duplicates = item.getDuplicates();
                                        for (Item duplicate : duplicates) {
                                            if (!duplicate.isTopLevel()) continue;
                                            matchedItems.add(duplicate);
                                        }
                                    } else {
                                        String topLevelMd5;
                                        Item topLevel = item.getTopLevelItem();
                                        if (topLevel == null || (topLevelMd5 = topLevel.getDigests().getMd5()) == null) break;
                                        for (Item duplicate : item.getDuplicates()) {
                                            String duplicateMd5;
                                            Item duplicateTopLevel = duplicate.getTopLevelItem();
                                            if (duplicateTopLevel == null || duplicateTopLevel.equals(topLevel) || (duplicateMd5 = duplicateTopLevel.getDigests().getMd5()) == null || !duplicateMd5.equals(topLevelMd5)) continue;
                                            matchedItems.add(duplicate);
                                        }
                                    }
                                    break;
                                }
                            }
                            this.countItemsProcessed.incrementAndGet();
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                    ++this.stageId;
                }
                if (this.matchNearDuplicatesOfItemsInScope) {
                    partitioner = new FixedSizeChunkPartitioner((Iterable)scopeItems, ItemsUtils.getPartitionerChunkSize(1000, this));
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        while (iterator.hasNext()) {
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            Item item = (Item)iterator.next();
                            Collection nearDuplicates = item.getNearDuplicates((float)this.nearDuplicatesResemblanceThreshold);
                            matchedItems.addAll(nearDuplicates);
                            this.countItemsProcessed.incrementAndGet();
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                    ++this.stageId;
                }
                this.addExecutionLog(this.iu.getNumeralString("TagItemsOperation.Log.MatchCount", (long)matchedItems.size()));
                this.stageName = this.iu.getString("TagItemsOperation.Stage.EvaluatingItemsInScope");
                this.countItemsProcessed.set(0L);
                this.countItemsToProcess = 0L;
                this.addExecutionLog(this.iu.getFormattedString("TagItemsOperation.Log.TagScope", (Object)this.tagScope));
                switch (this.tagScope) {
                    case MATCHES: {
                        itemsToTag = matchedItems;
                        break;
                    }
                    case ALL_FAMILIES: {
                        itemsToTag = this.executionContext.nuixUtilities.getItemUtility().findFamilies(matchedItems);
                        break;
                    }
                    case ALL_DESCENDANTS: {
                        itemsToTag = this.executionContext.nuixUtilities.getItemUtility().findDescendants(matchedItems);
                        break;
                    }
                    case MATCHES_DESCENDANTS: {
                        itemsToTag = this.executionContext.nuixUtilities.getItemUtility().findItemsAndDescendants(matchedItems);
                        break;
                    }
                    case TOP_LEVEL: {
                        itemsToTag = this.executionContext.nuixUtilities.getItemUtility().findTopLevelItems(matchedItems);
                    }
                }
                ++this.stageId;
                this.countItemsProcessed.set(0L);
                this.countItemsToProcess = 0L;
                try {
                    this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
                    long countItemsTagged = itemsToTag.size();
                    if (this.matchCreateEmptyTags || countItemsTagged > 0L) {
                        LOGGER.info("Tagging " + countItemsTagged + " items with " + this.tagName);
                        this.executionContext.nuixCase.createTag(this.tagName);
                        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tagName, (Collection)itemsToTag);
                    }
                    this.addExecutionLog(this.iu.getNumeralString("TagItemsOperation.Log.TagCount", countItemsTagged));
                    this.addExecutionLog(this.iu.getFormattedString("TagItemsOperation.Log.TagName", (Object)this.tagName));
                }
                catch (Exception e) {
                    this.addWarning(this.iu.getFormattedString("TagItemsOperation.Warning.ErrorApplyingTag", new Object[]{this.tagName, e.getLocalizedMessage()}));
                    LOGGER.error("Error applying tag " + this.tagName, (Throwable)e);
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        double stagePercent = 0.0;
        if (this.countItemsToProcess > 0L) {
            stagePercent = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        if (this.stageCount > 0) {
            percentageComplete = ((double)this.stageId + stagePercent) / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
            if (this.countItemsToProcess > 0L) {
                result = (String)result + " / ";
                result = (String)result + this.iu.getNumeralString("TagItemsOperation.Progress.ItemsProcessed", this.countItemsProcessed.get());
            }
        }
        return result;
    }
}

