/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.cells.Cell;
import com.aspose.cells.CellsException;
import com.aspose.cells.FindOptions;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.TreeCountSizeReportItemStats;
import com.nuix.automate.workflow.core.execution.operations.TreeCountSizeReportOperation;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;

public class TreeCountSizeReportOperationImplementation
extends TreeCountSizeReportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(TreeCountSizeReportOperation.class);
    private final transient String NA_VALUE = "[n/a]";
    private final transient String categorySeparator = "\u001f";
    private transient int stageCount;
    private transient int stageId;
    private transient int stageProgressWeight;
    private transient AtomicLong stageProcessedItems;
    private transient long stageTotalItems;
    private transient long countItemsToProcess;
    private transient String stageName;
    private transient ConcurrentHashMap<String, TreeCountSizeReportItemStats> itemsStats;
    private transient SortedMap<String, TreeCountSizeReportItemStats> sortedStatsItems;

    private Boolean isContainer(Item item) {
        if (!item.getKind().getName().equals("container")) {
            return false;
        }
        String itemMimeType = item.getType().getName();
        if (itemMimeType.equals("application/x-thumbs-db") || itemMimeType.equals("application/vnd.ms-outlook-msg") || itemMimeType.equals("application/pdf-portfolio") || itemMimeType.equals("application/vnd.ms-shell-scrap") || itemMimeType.equals("text/calendar") || itemMimeType.equals("application/x-self-extracting-archive") || itemMimeType.startsWith("application/vnd.openxmlformats-officedocument.")) {
            return false;
        }
        return true;
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
        this.customReportTemplatePath = this.executionContext.evalParameters(this.customReportTemplatePath, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.itemsStats = new ConcurrentHashMap();
                this.stageCount = 10;
                this.stageId = 0;
                this.stageProgressWeight = 9;
                this.stageName = this.iu.getString("TreeCountSizeReportOperation.Stage.ComputingStats");
                this.stageProcessedItems = new AtomicLong(0L);
                this.addExecutionLog(this.iu.getFormattedString("TreeCountSizeReportOperation.Log.ScopeQuery", (Object)this.scope));
                Set allItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.stageTotalItems = allItems.size();
                this.countItemsToProcess = allItems.size();
                this.addExecutionLog(this.iu.getNumeralString("TreeCountSizeReportOperation.Log.ScopeCount", this.countItemsToProcess));
                if (this.omitPathPrefixes > 0) {
                    this.addExecutionLog(this.iu.getFormattedString("TreeCountSizeReportOperation.Log.OmitPathPrefixes", (Object)this.omitPathPrefixes));
                }
                this.addExecutionLog(this.iu.getFormattedString("TreeCountSizeReportOperation.Log.MaxPathDepth", (Object)this.maxPathDepth));
                allItems.parallelStream().forEach(item -> {
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    boolean immediateParentIsInScope = true;
                    Item immediateParent = null;
                    try {
                        TreeCountSizeReportItemStats pathItemStats;
                        ConcurrentHashMap<String, TreeCountSizeReportItemStats> concurrentHashMap;
                        boolean itemIsContainer = this.isContainer((Item)item);
                        List pathItems = item.getPath();
                        boolean itemPathIsOnlyContainers = itemIsContainer;
                        for (int pathItemId = this.omitPathPrefixes; pathItemId < pathItems.size() - 1; ++pathItemId) {
                            TreeCountSizeReportItemStats pathItemStats2;
                            Item pathItem = (Item)pathItems.get(pathItemId);
                            if (pathItemId == this.maxPathDepth + this.omitPathPrefixes) {
                                immediateParentIsInScope = false;
                                break;
                            }
                            if (!this.isContainer(pathItem).booleanValue()) {
                                if (pathItemId > 0) {
                                    immediateParent = (Item)pathItems.get(pathItemId - 1);
                                }
                                itemPathIsOnlyContainers = false;
                                break;
                            }
                            TreeCountSizeReportItemStats newPathItemStats = new TreeCountSizeReportItemStats();
                            ConcurrentHashMap<String, TreeCountSizeReportItemStats> concurrentHashMap2 = this.itemsStats;
                            synchronized (concurrentHashMap2) {
                                pathItemStats2 = this.itemsStats.putIfAbsent(pathItem.getGuid(), newPathItemStats);
                                if (pathItemStats2 == null) {
                                    pathItemStats2 = newPathItemStats;
                                    pathItemStats2.initialize(pathItem, this.omitPathPrefixes);
                                }
                            }
                            if (itemIsContainer) {
                                pathItemStats2.containersCount.incrementAndGet();
                                continue;
                            }
                            pathItemStats2.totalSize.addAndGet(item.getAuditedSize());
                            pathItemStats2.itemsCount.incrementAndGet();
                        }
                        if (itemPathIsOnlyContainers && pathItems.size() > this.omitPathPrefixes && pathItems.size() - 1 < this.maxPathDepth + this.omitPathPrefixes) {
                            TreeCountSizeReportItemStats newPathItemStats = new TreeCountSizeReportItemStats();
                            concurrentHashMap = this.itemsStats;
                            synchronized (concurrentHashMap) {
                                pathItemStats = this.itemsStats.putIfAbsent(item.getGuid(), newPathItemStats);
                                if (pathItemStats == null) {
                                    pathItemStats = newPathItemStats;
                                    pathItemStats.initialize((Item)item, this.omitPathPrefixes);
                                }
                            }
                        }
                        if (!itemIsContainer) {
                            if (immediateParentIsInScope && immediateParent == null && pathItems.size() - 2 >= 0) {
                                immediateParent = (Item)pathItems.get(pathItems.size() - 2);
                            }
                            if (immediateParent != null) {
                                TreeCountSizeReportItemStats newPathItemStats = new TreeCountSizeReportItemStats();
                                concurrentHashMap = this.itemsStats;
                                synchronized (concurrentHashMap) {
                                    pathItemStats = this.itemsStats.putIfAbsent(immediateParent.getGuid(), newPathItemStats);
                                    if (pathItemStats == null) {
                                        pathItemStats = newPathItemStats;
                                        pathItemStats.initialize(immediateParent, this.omitPathPrefixes);
                                    }
                                }
                                pathItemStats.imediateDescendantsSize.addAndGet(item.getAuditedSize());
                                pathItemStats.imediateDescendantsCount.incrementAndGet();
                            }
                        }
                        this.stageProcessedItems.incrementAndGet();
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot process item " + item.getGuid(), (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("TreeCountSizeReportOperation.Warning.ErrorProcessingItem", (Object)item.getGuid()));
                    }
                });
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.stageId += this.stageProgressWeight;
                this.stageProgressWeight = 1;
                this.stageName = this.iu.getString("TreeCountSizeReportOperation.Stage.BuildingReport");
                this.stageProcessedItems.set(0L);
                this.stageTotalItems = this.itemsStats.size();
                this.addExecutionLog(this.iu.getNumeralString("TreeCountSizeReportOperation.Log.EffectiveCount", this.stageTotalItems));
                LOGGER.info("Sorting " + this.itemsStats.size() + " folders");
                this.sortedStatsItems = new TreeMap<String, TreeCountSizeReportItemStats>();
                for (String itemGuid : this.itemsStats.keySet()) {
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    TreeCountSizeReportItemStats unsortedItemStats = this.itemsStats.get(itemGuid);
                    String key = this.mergeIdenticalPaths ? unsortedItemStats.path : unsortedItemStats.uniquePath;
                    TreeCountSizeReportItemStats previousSortedItemStats = (TreeCountSizeReportItemStats)this.sortedStatsItems.get(key + "\\");
                    if (previousSortedItemStats != null) {
                        unsortedItemStats.merge(previousSortedItemStats);
                    }
                    this.sortedStatsItems.put(key + "\\", unsortedItemStats);
                }
                if (this.customReportTemplatePath.length() > 0) {
                    this.addExecutionLog(this.iu.getFormattedString("TreeCountSizeReportOperation.Log.ReportTemplate", (Object)this.customReportTemplatePath));
                }
                this.writeReport();
                this.addExecutionLog(this.iu.getFormattedString("TreeCountSizeReportOperation.Log.ReportLocation", (Object)this.reportLocation));
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                ++this.stageId;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void writeReport() throws Exception {
        int templateWorksheetIndex;
        Object buffer;
        AsposeUtils.applyAsposeCellsLicense();
        LoadOptions loadOptions = new LoadOptions(6);
        File templateFile = null;
        if (this.customReportTemplatePath.length() > 0 && !(templateFile = new File(this.customReportTemplatePath)).exists()) {
            LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
            this.addWarning(this.iu.getFormattedString("TreeCountSizeReportOperation.Warning.CouldNotFindReportTemplateFile", (Object)templateFile.getAbsolutePath()));
        }
        if (templateFile == null || !templateFile.exists()) {
            templateFile = this.executionContext.getReportTemplate();
            LOGGER.info("Cannot find report template file " + templateFile.getAbsolutePath() + ". Creating default file");
            File templateFolder = templateFile.getParentFile();
            if (!templateFolder.exists()) {
                LOGGER.info("Creating folder " + templateFolder.getAbsolutePath());
                templateFolder.mkdirs();
            }
            try (InputStream templateStream = this.getClass().getResourceAsStream("/reports/template.xlsx");
                 OutputStream outputStream = Files.newOutputStream(templateFile.toPath(), new OpenOption[0]);){
                int bytesRead;
                buffer = new byte[1024];
                while ((bytesRead = templateStream.read((byte[])buffer)) != -1) {
                    outputStream.write((byte[])buffer, 0, bytesRead);
                }
                templateStream.close();
                outputStream.flush();
            }
        }
        Workbook workbook = new Workbook(templateFile.getAbsolutePath(), loadOptions);
        for (int worksheetId = 0; worksheetId < workbook.getWorksheets().getCount(); ++worksheetId) {
            Worksheet worksheet = workbook.getWorksheets().get(worksheetId);
            LOGGER.info("Pre-processing worksheet " + worksheet.getName());
            buffer = this.executionContext.getParameterNames().iterator();
            while (buffer.hasNext()) {
                String placeholder = (String)buffer.next();
                try {
                    FindOptions findOptions = new FindOptions();
                    findOptions.setLookAtType(3);
                    findOptions.setLookInType(1);
                    Cell matchingCell = null;
                    while ((matchingCell = worksheet.getCells().find((Object)placeholder, matchingCell, findOptions)) != null) {
                        String unpackedPlaceholder = this.executionContext.evalParameters(placeholder, this);
                        if (placeholder.equals("{date_spreadsheet}") || placeholder.equals("{date_time_spreadsheet}")) {
                            matchingCell.setValue((Object)Calendar.getInstance());
                        } else if (placeholder.equals("{time_spreadsheet}")) {
                            matchingCell.setValue((Object)new Date());
                        } else {
                            matchingCell.setValue((Object)unpackedPlaceholder);
                        }
                        LOGGER.info("Searching for " + placeholder + ", got " + String.valueOf(matchingCell));
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Cannot unpack placeholder " + placeholder, (Throwable)e);
                }
            }
        }
        String treeSizeWorksheetName = TemplateWorksheetName.TEMPLATE_TREE_SIZE.toString();
        try {
            templateWorksheetIndex = workbook.getWorksheets().addCopy(treeSizeWorksheetName);
        }
        catch (CellsException e) {
            this.addWarning(this.iu.getFormattedString("TreeCountSizeReportOperation.Warning.TemplateFileNotHaveWorksheetName", (Object)treeSizeWorksheetName));
            return;
        }
        Worksheet worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
        worksheet.setName(this.iu.getString("TreeCountSizeReportOperation.Report.TreeCountSize"));
        int sr = 0;
        int sc = 0;
        FindOptions findOptions = new FindOptions();
        findOptions.setLookAtType(0);
        findOptions.setLookInType(1);
        Cell matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
        if (matchingCell != null) {
            sr = matchingCell.getRow();
            sc = matchingCell.getColumn();
            matchingCell.setValue((Object)this.iu.getString("TreeCountSizeReportOperation.Report.GUID"));
        }
        matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
        if (matchingCell != null) {
            matchingCell.setValue((Object)this.iu.getString("TreeCountSizeReportOperation.Report.TreeCountSize"));
        }
        worksheet.getCells().get(sr, sc + 2).setValue((Object)this.iu.getFormattedString("TreeCountSizeReportOperation.Report.Size", (Object)this.sizeUnit));
        int rowId = 3;
        ArrayList<String> itemPaths = new ArrayList<String>();
        Object parentPath = null;
        LOGGER.info("Inserting folders in worksheet");
        for (String itemPath : this.sortedStatsItems.keySet()) {
            if (this.stopRequested) {
                this.trackStopped();
                return;
            }
            TreeCountSizeReportItemStats itemStats = (TreeCountSizeReportItemStats)this.sortedStatsItems.get(itemPath);
            itemPaths.add(itemStats.path);
            worksheet.getCells().insertRow(sr + ++rowId);
            Object isLastRow = Boolean.valueOf(this.stageProcessedItems.get() == (long)(this.sortedStatsItems.keySet().size() - 1) && itemStats.imediateDescendantsCount.get() == 0L);
            Boolean isFirstRow = this.stageProcessedItems.get() == 0L;
            if (isFirstRow.booleanValue()) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 1, sr + rowId);
            } else if (!((Boolean)isLastRow).booleanValue()) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
            } else {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
            }
            worksheet.getCells().get(sr + rowId, sc + 0).setValue((Object)itemStats.guid);
            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)itemStats.path);
            worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)((double)itemStats.totalSize.get() / this.sizeUnit.getValue()));
            worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)itemStats.itemsCount);
            worksheet.getCells().get(sr + rowId, sc + 4).setValue((Object)itemStats.containersCount);
            if (itemStats.createdTime != null) {
                worksheet.getCells().get(sr + rowId, sc + 5).setValue((Object)itemStats.createdTime.toDate());
            } else {
                worksheet.getCells().get(sr + rowId, sc + 5).setValue((Object)"");
            }
            if (itemStats.lastModifiedTime != null) {
                worksheet.getCells().get(sr + rowId, sc + 6).setValue((Object)itemStats.lastModifiedTime.toDate());
            } else {
                worksheet.getCells().get(sr + rowId, sc + 6).setValue((Object)"");
            }
            if (itemStats.imediateDescendantsCount.get() > 0L) {
                itemPaths.add(itemStats.path + "\\*.*");
                worksheet.getCells().insertRow(sr + ++rowId);
                isLastRow = this.stageProcessedItems.get() == (long)(this.sortedStatsItems.keySet().size() - 1);
                if (!((Boolean)isLastRow).booleanValue()) {
                    worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
                } else {
                    worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
                }
                worksheet.getCells().get(sr + rowId, sc + 0).setValue((Object)itemStats.guid);
                worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)(itemStats.path + "\\*.*"));
                worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)((double)itemStats.imediateDescendantsSize.get() / this.sizeUnit.getValue()));
                worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)itemStats.imediateDescendantsCount);
                worksheet.getCells().get(sr + rowId, sc + 4).setValue((Object)0);
                worksheet.getCells().get(sr + rowId, sc + 5).setValue((Object)"");
                worksheet.getCells().get(sr + rowId, sc + 6).setValue((Object)"");
            }
            this.stageProcessedItems.incrementAndGet();
        }
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        workbook.getBuiltInDocumentProperties().setAuthor("Automate Workflow");
        this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
        File reportFile = new File(this.reportLocation);
        this.reportLocation = reportFile.getAbsolutePath();
        File reportFolder = reportFile.getParentFile();
        if (!reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        boolean reportIsPdf = false;
        reportIsPdf = reportFile.getAbsolutePath().toLowerCase().endsWith(".pdf");
        if (!reportIsPdf) {
            LOGGER.info("Grouping rows");
            this.groupRows(0, itemPaths.size() - 1, worksheet, itemPaths, 1, sr);
        }
        for (TemplateWorksheetName templateWorksheetName : TemplateWorksheetName.values()) {
            try {
                workbook.getWorksheets().removeAt(templateWorksheetName.toString());
            }
            catch (Exception e) {
                LOGGER.error("Cannot remove sheet " + String.valueOf((Object)templateWorksheetName));
            }
        }
        LOGGER.info("Saving report to " + reportFile.getAbsolutePath());
        if (reportIsPdf) {
            PdfSaveOptions saveOptions = new PdfSaveOptions();
            saveOptions.setAllColumnsInOnePagePerSheet(true);
            workbook.save(reportFile.getAbsolutePath(), (SaveOptions)saveOptions);
        } else {
            String reportPasswordParameter = "{report_password}";
            String reportPassword = this.executionContext.evalParameters(reportPasswordParameter, this);
            if (!reportPassword.equals(reportPasswordParameter)) {
                this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                if (reportPassword.length() == 0) {
                    this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                }
                workbook.setEncryptionOptions(3, 128);
                workbook.getSettings().setPassword(reportPassword);
            }
            workbook.save(reportFile.getAbsolutePath());
        }
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_report_file}", reportFile.getAbsolutePath())));
    }

    private void groupRows(int startElementId, int endElementId, Worksheet worksheet, List<String> itemPaths, int level, int sr) {
        if (this.stopRequested) {
            this.trackStopped();
            return;
        }
        if (endElementId <= startElementId) {
            return;
        }
        String commonPath = null;
        int groupStartId = 0;
        int groupEndId = 0;
        Boolean lastElementWasPartOfGroup = false;
        for (int i = startElementId; i <= endElementId; ++i) {
            if (commonPath == null) {
                commonPath = itemPaths.get(i) + "\\";
                groupStartId = i + 1;
                continue;
            }
            if (itemPaths.get(i) == null || !itemPaths.get(i).startsWith(commonPath)) {
                groupEndId = i - 1;
                if (groupEndId >= groupStartId) {
                    worksheet.getCells().groupRows(sr + groupStartId + 1, sr + groupEndId + 1, true);
                }
                this.groupRows(groupStartId, groupEndId, worksheet, itemPaths, level + 1, sr);
                commonPath = itemPaths.get(i) + "\\";
                groupStartId = i + 1;
                lastElementWasPartOfGroup = false;
                continue;
            }
            lastElementWasPartOfGroup = true;
        }
        groupEndId = endElementId;
        if (groupEndId >= groupStartId && lastElementWasPartOfGroup.booleanValue()) {
            worksheet.getCells().groupRows(sr + groupStartId + 1, sr + groupEndId + 1, true);
        }
        this.groupRows(groupStartId, groupEndId, worksheet, itemPaths, level + 1, sr);
    }

    @Override
    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    protected double getPercentageComplete() {
        double stagePercentageComplete = 0.0;
        if (this.stageTotalItems > 0L) {
            stagePercentageComplete = this.stageProcessedItems.doubleValue() / (double)this.stageTotalItems;
        }
        double percentageComplete = 0.0;
        if (this.stageCount > 0) {
            percentageComplete = ((double)this.stageId + stagePercentageComplete) * (double)this.stageProgressWeight / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.stageId != 0 && this.stageId != this.stageCount - 1 && this.stageProcessedItems != null && this.stageProcessedItems.get() > 0L) {
            result = (String)result + " / " + this.iu.getNumeralString("TreeCountSizeReportOperation.Progress.ItemsProcessed", this.stageProcessedItems.get());
        }
        return result;
    }
}

