/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ElasticsearchService;
import com.nuix.automate.utils.models.api.thirdparty.ElasticsearchUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ElasticSearchConfigureOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.operations.UseCaseOperation;
import com.nuix.automate.workflow.core.execution.options.usecase.CaseBackend;
import com.nuix.automate.workflow.core.execution.options.usecase.CaseType;
import com.nuix.automate.workflow.core.execution.options.usecase.Method;
import com.nuix.automate.workflow.core.execution.workflow.UndefinedParameter;
import com.nuix.automate.workflow.core.utils.nuix.DerbyControlUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixCaseUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Case;
import nuix.CaseFactory;
import nuix.LicenceException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class UseCaseOperationImplementation
extends UseCaseOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UseCaseOperation.class);
    private final transient int ATTEMPT_INTERVAL = 60;
    protected long caseCreationDate;
    private transient String stageName;
    private transient Case previousCase;
    private transient DerbyControlUtils derbyControlUtils;
    private transient Map<String, ThirdPartyService> thirdPartyServices;

    public long getCaseCreationEpoch() {
        return this.caseCreationDate;
    }

    private long getCaseCreationEpochFromCaseFile(Case nuixCase) {
        return NuixCaseUtils.getNuixCaseCreationTime(nuixCase.getLocation().getAbsolutePath());
    }

    @Override
    public void startTriggered() throws Exception {
        if (this.executionContext.nuixCase != null) {
            this.previousCase = this.executionContext.nuixCase;
        }
        this.stageName = "";
        LOGGER.info("Starting execution");
        this.executionContext.closeAllTabs();
        this.caseLocation = this.executionContext.evalParameters(this.caseLocation, this).trim();
        this.caseDescription = this.executionContext.evalParameters(this.caseDescription, this);
        this.caseInvestigator = this.executionContext.evalParameters(this.caseInvestigator, this);
        this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.CaseLocation", (Object)this.caseLocation));
        this.timeZoneId = this.executionContext.evalParameters(this.timeZoneId, this);
        this.caseLocation = FileUtils.normalize((String)this.caseLocation);
        this.elasticsearchServiceId = this.executionContext.evalParameters(this.elasticsearchServiceId, this);
        if (this.executionContext.nuixCase != null) {
            if (this.executionContext.getExecutionBuiltInParameters().get("{first_case_folder}") instanceof UndefinedParameter) {
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{first_case_folder}", this.executionContext.nuixCase.getLocation().getAbsolutePath())));
            }
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{previous_case_folder}", this.executionContext.nuixCase.getLocation().getAbsolutePath())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_case_name}", this.executionContext.nuixCase.getName())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_case_folder}", this.executionContext.nuixCase.getLocation().getAbsolutePath())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_case_guid}", this.executionContext.nuixCase.getGuid())));
        }
        this.startTriggerThread = new Thread(() -> {
            boolean caseOpened = false;
            boolean caseCreated = false;
            this.derbyControlUtils = new DerbyControlUtils(this.executionContext, this);
            if (!this.predefined) {
                this.addExecutionLog(this.iu.getString("UseCaseOperation.Log.PromptAtExecution"));
            }
            this.stageName = this.iu.getString("UseCaseOperation.Stage.ClosePreviousCase");
            boolean previousCaseClosed = this.executionContext.workflowExecution.closeCaseOpenedByWorkflow();
            if (previousCaseClosed) {
                try {
                    this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.ClosedPreviousCase", (Object)this.executionContext.getExecutionBuiltInParameters().get("{previous_case_folder}").getValue()));
                }
                catch (ParameterException e) {
                    LOGGER.warn("Cannot get previous case stats", (Throwable)e);
                }
            }
            try {
                if (!this.predefined) {
                    this.timeZoneId = TimeZone.getDefault().getID();
                    this.executionContext.workflowExecution.fireOnUseCasePrompt(this);
                } else {
                    String timezoneIdParameter = "{case_timezone_id}";
                    String evaluatedTimezoneIdParameter = this.executionContext.evalParameters(timezoneIdParameter, this);
                    if (!timezoneIdParameter.equals(evaluatedTimezoneIdParameter)) {
                        if (evaluatedTimezoneIdParameter.length() > 0) {
                            try {
                                DateTimeZone dateTimeZone = DateTimeZone.forID((String)evaluatedTimezoneIdParameter);
                                this.timeZoneId = dateTimeZone.getID();
                                LOGGER.info("Parsed specified timezone " + FormattingUtils.timeZoneToDisplayName((DateTimeZone)dateTimeZone) + " from ID " + timezoneIdParameter);
                                this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.SetTimezoneFromParameter", new Object[]{"{case_timezone_id}", FormattingUtils.timeZoneToDisplayName((DateTimeZone)dateTimeZone)}));
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot set timezone " + evaluatedTimezoneIdParameter, (Throwable)e);
                                this.addWarning(this.iu.getFormattedString("UseCaseOperation.Warning.ParameterInvalidTimezoneId", new Object[]{"{case_timezone_id}", evaluatedTimezoneIdParameter}));
                            }
                        } else {
                            this.timeZoneId = "";
                        }
                    }
                    this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.UseCaseMethod", (Object)this.method));
                    this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.AttemptReopenIfLocked", (Object)this.attemptReopenIfLocked));
                    if (this.attemptReopenIfLocked) {
                        this.addExecutionLog(this.iu.getNumeralString("UseCaseOperation.Log.AttemptTimeout", (long)this.attemptTimeout));
                    }
                    CaseFactory caseFactory = this.executionContext.nuixUtilities.getCaseFactory();
                    File directory = new File(this.caseLocation);
                    HashMap<String, Boolean> caseOpenOptions = new HashMap<String, Boolean>();
                    if (!FileUtils.isPathAbsolute((String)this.caseLocation)) {
                        String errorMsg = this.iu.getFormattedString("UseCaseOperation.Exception.CaseLocationRelative", (Object)this.caseLocation);
                        LOGGER.error("Case location can't be a relative path");
                        this.exception = new Exception(errorMsg);
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    if (this.method == Method.OPEN || this.method == Method.OPEN_CREATE) {
                        long timeoutTime = System.currentTimeMillis() + (long)(this.attemptTimeout * 60 * 1000);
                        long timeoutAttempts = 0L;
                        while (true) {
                            try {
                                if (this.stopRequested) {
                                    this.trackStopped();
                                    return;
                                }
                                this.stageName = this.iu.getString("UseCaseOperation.Stage.OpeningCase");
                                if (this.executionContext.workstationCase != null && this.executionContext.workstationCase.getLocation().getAbsolutePath().equals(directory.getAbsolutePath())) {
                                    this.executionContext.nuixCase = this.executionContext.workstationCase;
                                    String message = this.iu.getString("UseCaseOperation.Log.SelectedCurrentWorkstationCase");
                                    LOGGER.info("Selected current Workstation case");
                                    this.addExecutionLog(message);
                                } else {
                                    if (NuixUtils.disablePreviousProcessingQueue(directory.getAbsolutePath())) {
                                        this.addWarning(this.iu.getFormattedString("UseCaseOperation.Warning.CaseIncompleteProcessingQueue", (Object)directory.getAbsolutePath()));
                                    }
                                    if (NuixUtils.disablePreviousPersistentQueue(directory.getAbsolutePath())) {
                                        this.addWarning(this.iu.getFormattedString("AddToCompoundCaseOperation.Warning.CaseIncompletePersistentQueue", (Object)directory.getAbsolutePath()));
                                    }
                                    if (NuixUtils.disableLocalStoresProcessingQueue(directory.getAbsolutePath())) {
                                        this.addWarning(this.iu.getFormattedString("UseCaseOperation.Warning.CaseIncompleteStoresProcessingQueue", (Object)directory.getAbsolutePath()));
                                    }
                                    if (NuixUtils.disableUnfinalizedRemoteStores(directory.getAbsolutePath())) {
                                        this.addWarning(this.iu.getFormattedString("UseCaseOperation.Warning.CaseUnfinalizedRemoteStores", (Object)directory.getAbsolutePath()));
                                    }
                                    this.derbyControlUtils.prepareExistingCase(directory.getAbsolutePath());
                                    this.executionContext.nuixCase = caseFactory.open(directory);
                                    if (this.executionContext.nuixCase != null) {
                                        this.modifiesNuixCase = false;
                                        this.caseCreationDate = this.getCaseCreationEpochFromCaseFile(this.executionContext.nuixCase);
                                        try {
                                            File tempFile = Paths.get(directory.getAbsolutePath(), new String[0]).resolve("automateCase.lock").toFile();
                                            org.apache.commons.io.FileUtils.writeStringToFile((File)tempFile, (String)"lock", (String)"UTF-8");
                                            tempFile.delete();
                                        }
                                        catch (IOException e) {
                                            LOGGER.error("Cannot write in case folder", (Throwable)e);
                                            this.exception = new Exception(this.iu.getFormattedString("UseCaseOperation.Exception.CannotUseCaseDirectoryException", (Object)e));
                                            this.executionState = ExecutionState.ERROR;
                                            return;
                                        }
                                    }
                                    this.addExecutionLog(this.iu.getString("UseCaseOperation.Log.CaseOpened"));
                                }
                                caseOpened = true;
                                if (this.timeZoneId == null || this.timeZoneId.length() <= 0) break;
                                this.executionContext.nuixCase.setInvestigationTimeZone(this.timeZoneId);
                                this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.Timezone", (Object)FormattingUtils.timeZoneToDisplayName((DateTimeZone)DateTimeZone.forID((String)this.timeZoneId))));
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Cannot open case, " + ex.getLocalizedMessage());
                                Throwable cause = ex.getCause();
                                if (this.attemptReopenIfLocked && cause != null && cause.getMessage().toLowerCase().contains("locked")) {
                                    if (System.currentTimeMillis() >= timeoutTime) {
                                        String message = this.iu.getNumeralString("UseCaseOperation.Log.TimeoutReached", timeoutAttempts);
                                        this.addExecutionLog(message);
                                        this.executionContext.nuixCase = null;
                                        LOGGER.info("Timeout has been reached, Attempted to open the case " + timeoutAttempts + " times, Operation no longer attempting to reopen case");
                                        this.exception = new Exception(message, ex);
                                        this.executionState = ExecutionState.ERROR;
                                        return;
                                    }
                                    LOGGER.info("Case locked. Will attempt to reopen case in 1 minute.");
                                    AtomicLong countDown = new AtomicLong(60L);
                                    ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
                                    executorService.scheduleAtFixedRate(() -> {
                                        Thread.currentThread().setName("Automate - Use Case Operation - Open Case");
                                        if (this.stopRequested) {
                                            executorService.shutdown();
                                            this.trackStopped();
                                            return;
                                        }
                                        long value = countDown.get();
                                        if (value <= 0L) {
                                            this.stageName = this.iu.getString("UseCaseOperation.Stage.ReopeningCase");
                                            LOGGER.info("Trying to reopen case.");
                                            executorService.shutdown();
                                        } else if (value < 60L) {
                                            this.stageName = this.iu.getNumeralString("UseCaseOperation.Stage.CaseLockedRetrying", value);
                                        }
                                        countDown.decrementAndGet();
                                    }, 0L, 1L, TimeUnit.SECONDS);
                                    executorService.awaitTermination(60L, TimeUnit.SECONDS);
                                    ++timeoutAttempts;
                                    continue;
                                }
                                if (cause != null && cause.getMessage().toLowerCase().contains("migration")) {
                                    if (this.migrateCaseIfRequired) {
                                        caseOpenOptions.put("migrate", true);
                                        try {
                                            this.stageName = this.iu.getString("UseCaseOperation.Stage.MigratingCase");
                                            if (NuixUtils.disablePreviousProcessingQueue(directory.getAbsolutePath())) {
                                                this.addWarning(this.iu.getFormattedString("UseCaseOperation.Warning.CaseIncompleteProcessingQueue", (Object)directory.getAbsolutePath()));
                                            }
                                            if (NuixUtils.disablePreviousPersistentQueue(directory.getAbsolutePath())) {
                                                this.addWarning(this.iu.getFormattedString("AddToCompoundCaseOperation.Warning.CaseIncompletePersistentQueue", (Object)directory.getAbsolutePath()));
                                            }
                                            this.derbyControlUtils.prepareExistingCase(directory.getAbsolutePath());
                                            this.executionContext.nuixCase = caseFactory.open(directory, caseOpenOptions);
                                            if (this.executionContext.nuixCase != null) {
                                                this.modifiesNuixCase = true;
                                                try {
                                                    File tempFile = Paths.get(directory.getAbsolutePath(), new String[0]).resolve("automateCase.lock").toFile();
                                                    org.apache.commons.io.FileUtils.writeStringToFile((File)tempFile, (String)"lock", (String)"UTF-8");
                                                    tempFile.delete();
                                                }
                                                catch (IOException e) {
                                                    LOGGER.error("Cannot write in case folder", (Throwable)e);
                                                    this.exception = new Exception(this.iu.getFormattedString("UseCaseOperation.Exception.CannotUseCaseDirectoryException", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                                                    this.executionState = ExecutionState.ERROR;
                                                    return;
                                                }
                                            }
                                            this.addExecutionLog(this.iu.getString("UseCaseOperation.Log.CaseMigrated"));
                                            if (this.timeZoneId != null && this.timeZoneId.length() > 0) {
                                                this.executionContext.nuixCase.setInvestigationTimeZone(this.timeZoneId);
                                                this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.Timezone", (Object)FormattingUtils.timeZoneToDisplayName((DateTimeZone)DateTimeZone.forID((String)this.timeZoneId))));
                                            }
                                            caseOpened = true;
                                            break;
                                        }
                                        catch (Exception ex2) {
                                            LOGGER.warn("Cannot open case" + ex2.getLocalizedMessage());
                                            this.executionContext.nuixCase = null;
                                            this.exception = new IOException(this.iu.getString("UseCaseOperation.Exception.CannotOpenCase"), ex2);
                                            this.executionState = ExecutionState.ERROR;
                                            return;
                                        }
                                    }
                                    this.executionContext.nuixCase = null;
                                    LOGGER.warn("Cannot open case, " + ex.getLocalizedMessage());
                                    this.exception = ex;
                                    this.executionState = ExecutionState.ERROR;
                                    return;
                                }
                                if (this.method == Method.OPEN_CREATE && !(ex instanceof LicenceException) && (!directory.exists() || directory.exists() && directory.list() != null && directory.list().length == 0)) {
                                    this.addExecutionLog(this.iu.getString("UseCaseOperation.Log.NoCaseInSpecifiedDirectory"));
                                    break;
                                }
                                this.executionContext.nuixCase = null;
                                this.exception = new IOException(this.iu.getString("UseCaseOperation.Exception.CannotOpenCase"), ex);
                                this.executionState = ExecutionState.ERROR;
                                return;
                            }
                            break;
                        }
                    }
                    if (!(this.method != Method.CREATE && this.method != Method.OPEN_CREATE || caseOpened)) {
                        block64: {
                            try {
                                if (!directory.exists()) {
                                    boolean directoryCreated = directory.mkdirs();
                                    if (!directoryCreated) {
                                        String errorMsg = "Cannot create case directory or missing privileges.";
                                        LOGGER.error(errorMsg);
                                        this.exception = new Exception(this.iu.getString("UseCaseOperation.Exception.CannotCreateCaseDirectoryMissingPrivileges"));
                                        this.executionState = ExecutionState.ERROR;
                                        return;
                                    }
                                    break block64;
                                }
                                try {
                                    File tempFile = Paths.get(directory.getAbsolutePath(), new String[0]).resolve("automateCase.lock").toFile();
                                    org.apache.commons.io.FileUtils.writeStringToFile((File)tempFile, (String)"lock", (String)"UTF-8");
                                    tempFile.delete();
                                }
                                catch (IOException e) {
                                    LOGGER.error("Cannot write in case folder", (Throwable)e);
                                    this.exception = new Exception(this.iu.getFormattedString("UseCaseOperation.Exception.CannotUseCaseDirectoryException", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                                    this.executionState = ExecutionState.ERROR;
                                    return;
                                }
                            }
                            catch (Exception ex) {
                                LOGGER.error("Cannot create case directory", (Throwable)ex);
                                this.exception = new Exception(this.iu.getFormattedString("UseCaseOperation.Exception.CannotCreateCaseDirectoryException", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)ex)));
                                this.executionState = ExecutionState.ERROR;
                                return;
                            }
                        }
                        HashMap<String, Object> caseCreationOptions = new HashMap<String, Object>();
                        caseCreationOptions.put("name", directory.getName().trim());
                        caseCreationOptions.put("description", this.caseDescription);
                        caseCreationOptions.put("investigator", this.caseInvestigator);
                        caseCreationOptions.put("compound", this.caseType == CaseType.COMPOUND);
                        if (this.caseBackend == CaseBackend.ELASTIC) {
                            this.addExecutionLog(this.iu.getString("UseCaseOperation.Log.BackendElastic"));
                            HashMap<String, String> elasticOptions = new HashMap<String, String>();
                            elasticOptions.put("nuix.thirdpartyplugin", "Automate Workflow");
                            if (this.useElasticsearchService) {
                                String value;
                                String name;
                                ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), ElasticSearchConfigureOperation.class.getSimpleName(), ParameterType.RELATIVITY_SERVICE);
                                if (this.thirdPartyServices == null || this.thirdPartyServices.get(this.elasticsearchServiceId) == null) {
                                    throw new IllegalStateException(this.iu.getFormattedString("UseCaseOperation.Exception.MissingElasticsearchService", (Object)this.elasticsearchServiceId));
                                }
                                ElasticsearchService elasticsearchService = (ElasticsearchService)this.thirdPartyServices.get(this.elasticsearchServiceId);
                                ElasticsearchUserCredential userCredential = (ElasticsearchUserCredential)elasticsearchService.getUserCredential();
                                this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.ElasticsearchService", (Object)elasticsearchService.getName()));
                                for (Map.Entry property : elasticsearchService.getElasticProperties().entrySet()) {
                                    name = ((String)property.getKey()).trim();
                                    value = (String)property.getValue();
                                    value = this.executionContext.evalParameters(value, this);
                                    if (name.isEmpty() || value.isEmpty()) continue;
                                    this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.ElasticProperties", new Object[]{name, value}));
                                    elasticOptions.put(name, value);
                                }
                                if (elasticsearchService.getAuthenticationMethod().equals((Object)ThirdPartyAuthenticationMethod.SECRET_PROPERTIES)) {
                                    for (Map.Entry property : userCredential.getProperties().entrySet()) {
                                        name = ((String)property.getKey()).trim();
                                        value = (String)property.getValue();
                                        value = this.executionContext.evalParameters(value, this);
                                        if (name.isEmpty() || value.isEmpty()) continue;
                                        this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.ElasticSecureProperties", (Object)name));
                                        elasticOptions.put(name, value);
                                    }
                                }
                            } else {
                                for (Object[] elasticProperty : this.elasticProperties) {
                                    String name = elasticProperty[0].toString().trim();
                                    String value = elasticProperty[1].toString();
                                    value = this.executionContext.evalParameters(value, this);
                                    if (name.isEmpty() || value.isEmpty()) continue;
                                    this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.ElasticProperties", new Object[]{name, value}));
                                    value = elasticProperty[1].toString();
                                    value = this.executionContext.evalProtectedParameter(value);
                                    elasticOptions.put(name, value);
                                }
                            }
                            caseCreationOptions.put("elasticSearchSettings", elasticOptions);
                        }
                        LOGGER.info("Creating case at " + directory.getAbsolutePath());
                        try {
                            this.stageName = this.iu.getString("UseCaseOperation.Stage.CreatingCase");
                            this.executionContext.nuixCase = caseFactory.create(directory, caseCreationOptions);
                            this.caseCreationDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                            this.addExecutionLog(this.iu.getString("UseCaseOperation.Log.CaseCreated"));
                            this.executionContext.nuixCase = this.derbyControlUtils.reopenCreatedCase(this.executionContext.nuixCase, caseFactory);
                            if (this.timeZoneId != null && this.timeZoneId.length() > 0) {
                                this.executionContext.nuixCase.setInvestigationTimeZone(this.timeZoneId);
                                this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.Timezone", (Object)FormattingUtils.timeZoneToDisplayName((DateTimeZone)DateTimeZone.forID((String)this.timeZoneId))));
                            }
                            caseCreated = true;
                        }
                        catch (FileAlreadyExistsException ex) {
                            LOGGER.error("Cannot create case, folder " + directory.getAbsolutePath() + " is not empty");
                            this.executionContext.nuixCase = null;
                            this.exception = new Exception(this.iu.getFormattedString("UseCaseOperation.Exception.CannotCreateCaseNotEmpty", (Object)directory.getAbsolutePath()), ex);
                            this.executionState = ExecutionState.ERROR;
                            return;
                        }
                        catch (Exception ex) {
                            LOGGER.error("Cannot create case", (Throwable)ex);
                            this.executionContext.nuixCase = null;
                            this.exception = new Exception(this.iu.getFormattedString("UseCaseOperation.Exception.CannotCreateCase", (Object)ex.getLocalizedMessage()));
                            this.executionState = ExecutionState.ERROR;
                            return;
                        }
                    }
                }
                this.trackFirstCase();
                if (caseCreated) {
                    try {
                        this.executionContext.trackCaseCreated();
                    }
                    catch (Exception e) {
                        this.addWarning(ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    void trackFirstCase() {
        this.executionContext.trackCaseSession();
        if (this.executionContext.nuixCase != null) {
            String location = this.executionContext.nuixCase.getLocation().getAbsolutePath();
            if (this.executionContext.nuixCase.isCompound()) {
                this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.CaseType", (Object)CaseType.COMPOUND));
            } else {
                this.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Log.CaseType", (Object)CaseType.SIMPLE));
            }
        }
        if (this.executionContext.nuixCase == null) {
            throw new IllegalStateException(this.iu.getString("UseCaseOperation.Error.MissingCase"));
        }
        this.executionContext.workflowExecution.trackWorkBeingPerformedInCase(this.executionContext.nuixCase.getLocation().toString());
        if (this.executionContext.getExecutionBuiltInParameters().get("{first_case_folder}") instanceof UndefinedParameter) {
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{first_case_folder}", this.executionContext.nuixCase.getLocation().getAbsolutePath())));
            if (this.executionContext.nuixCase == this.executionContext.workstationCase) {
                this.executionContext.workflowExecutedInWorkstationCase = true;
            }
        }
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_case_name}", this.executionContext.nuixCase.getName())));
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_case_folder}", this.executionContext.nuixCase.getLocation().getAbsolutePath())));
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_case_guid}", this.executionContext.nuixCase.getGuid())));
        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", this.executionContext.nuixCase.getName())));
        try {
            Case previousCase = this.previousCase;
            if (previousCase != null && !previousCase.isClosed() && previousCase != this.executionContext.nuixCase && previousCase != this.executionContext.workstationCase) {
                LOGGER.info("Closing previous case " + String.valueOf(previousCase.getLocation()));
                previousCase.close();
            }
        }
        catch (Exception e) {
            this.addWarning(this.iu.getFormattedString("UseCaseOperation.Warning.CannotClosePreviousCase", (Object)e.getLocalizedMessage()));
            LOGGER.warn("Cannot close previous case", (Throwable)e);
        }
    }

    @Override
    public void resumeTriggered() {
    }

    @Override
    public void pauseTriggered() {
    }

    @Override
    public void stopTriggered() {
    }

    @Override
    public void updateState() {
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        return 0.0;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

