/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldHelper;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureDiscoverConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.DiscoverOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.usediscovercase.DiscoverFileRepositoryType;
import com.nuix.automate.workflow.core.execution.options.usediscovercase.DiscoverIdentifierType;
import com.nuix.automate.workflow.core.execution.options.usediscovercase.DiscoverUserCaseCategory;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRows(value={@FormFieldRow(name="caseIdentifierRow", children={"caseIdentifierType", "caseIdentifier"}), @FormFieldRow(name="discoverFileRepositoryRow", children={"discoverFileRepositoryType", "windowsFileRepository"}), @FormFieldRow(name="waitForCaseToBeActiveRow", children={"waitForCaseToBeActive", "waitForCaseToBeActiveTimeout"}), @FormFieldRow(name="assignUserToCaseRow", children={"assignUserToCase", "assignUserToCaseCategory"}), @FormFieldRow(name="assignUserToGroupRow", children={"assignUserToGroup", "caseUserGroupIdentifierType", "caseUserGroupIdentifier"}), @FormFieldRow(name="cloneSourceCaseIdentifierRow", children={"cloneSourceCaseIdentifierType", "cloneSourceCaseIdentifier"}), @FormFieldRow(name="clonedCaseOrgIdentifierRow", children={"clonedCaseOrgIdentifierType", "clonedCaseOrgIdentifier"})})
@FormFieldGroups(value={@FormFieldGroup(name="permissionAssignmentGroup", visibleOn={@OnField(name="waitForCaseToBeActive")}, children={"assignUserToCaseRow", "assignUserToGroupRow"}), @FormFieldGroup(name="cloneSettingsGroup", visibleOn={@OnField(name="cloneCaseIfNotExists")}, enableOn={@OnField(name="caseIdentifierType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"ID"})}, children={"clonedCaseDescription", "clonedCaseName", "cloneSourceCaseIdentifierRow", "clonedCaseOrgIdentifierRow", "clonedCaseScheduleMetrics", "clonedCaseClearData"})})
@OperationMetadata(alias=OperationAlias.USE_DISCOVER_CASE, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_DISCOVER"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@OperationParameters(value={@OperationParameter(label="queryRetrieveDiscoverCaseId", parameter="{discover_case_id}"), @OperationParameter(label="queryRetrieveDiscoverVersion", parameter="{discover_version}"), @OperationParameter(label="queryDiscoverCaseName", parameter="{discover_case_name}")})
@OperationLicenseModule(module=ModuleType.DISCOVER_REVIEW)
public class UseDiscoverCaseOperation
extends DiscoverOperation {
    @ExcludeFromPrintableOptions
    public boolean useDiscoverService;
    @ExcludeFromPrintableOptions
    public String discoverServiceId;
    @ExcludeFromPrintableOptions
    public String connectApiUrl;
    @ExcludeFromPrintableOptions
    public String apiToken;
    @FormField
    @ExcludeFromPrintableOptions
    public DiscoverIdentifierType caseIdentifierType;
    @FormField(helpers={@FormFieldHelper(location="#_set_discover_case")})
    public String caseIdentifier;
    @FormField
    public DiscoverFileRepositoryType discoverFileRepositoryType;
    @FormField(enableOn={@OnField(name="discoverFileRepositoryType", value={"WINDOWS"})})
    @ExcludeFromPrintableOptions
    public String windowsFileRepository;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    public boolean cloneCaseIfNotExists;
    @FormField
    public boolean waitForCaseToBeActive;
    @FormField(min=1.0, enableOn={@OnField(name="waitForCaseToBeActive")}, positionLabel=@PositionLabel(right="minutes"))
    @ExcludeFromPrintableOptions
    public int waitForCaseToBeActiveTimeout;
    @FormField
    public boolean assignUserToCase;
    @FormField(enableOn={@OnField(name="assignUserToCase")})
    @ExcludeFromPrintableOptions
    public DiscoverUserCaseCategory assignUserToCaseCategory;
    @FormField
    public boolean assignUserToGroup;
    @FormField(enableOn={@OnField(name="assignUserToGroup")}, allowedValues={"ID", "NAME"})
    @ExcludeFromPrintableOptions
    public DiscoverIdentifierType caseUserGroupIdentifierType;
    @FormField(enableOn={@OnField(name="assignUserToGroup")})
    @ExcludeFromPrintableOptions
    public String caseUserGroupIdentifier;
    @FormField(required=false, componentType=FieldComponentType.TEXTAREA)
    @ExcludeFromPrintableOptions
    public String clonedCaseDescription;
    @FormField(enableOn={@OnField(name="caseIdentifierType", value={"NAME_REGEX", "NAME"})})
    @ExcludeFromPrintableOptions
    public String clonedCaseName;
    @FormField(allowedValues={"ID", "NAME"})
    @ExcludeFromPrintableOptions
    public DiscoverIdentifierType cloneSourceCaseIdentifierType;
    @FormField
    @ExcludeFromPrintableOptions
    public String cloneSourceCaseIdentifier;
    @FormField(allowedValues={"ID", "NAME"})
    @ExcludeFromPrintableOptions
    public DiscoverIdentifierType clonedCaseOrgIdentifierType;
    @FormField(required=false)
    @ExcludeFromPrintableOptions
    public String clonedCaseOrgIdentifier;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean clonedCaseScheduleMetrics;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean clonedCaseClearData;

    public boolean getDisplayWindowsFileRepository() {
        return DiscoverFileRepositoryType.WINDOWS.equals((Object)this.discoverFileRepositoryType);
    }

    public boolean getDisplayWaitForCaseToBeActiveTimeout() {
        return this.waitForCaseToBeActive;
    }

    public boolean getDisplayAssignUserToCaseCategory() {
        return this.assignUserToCase;
    }

    public boolean getDisplayCaseUserGroupIdentifierType() {
        return this.assignUserToGroup;
    }

    public boolean getDisplayClonedCaseDescription() {
        return this.cloneCaseIfNotExists;
    }

    public boolean getDisplayClonedCaseName() {
        return this.cloneCaseIfNotExists;
    }

    public boolean getDisplayCloneSourceCaseIdentifierType() {
        return this.cloneCaseIfNotExists;
    }

    public boolean getDisplayCloneSourceCaseIdentifier() {
        return this.cloneCaseIfNotExists;
    }

    public boolean getDisplayClonedCaseOrgIdentifierType() {
        return this.cloneCaseIfNotExists;
    }

    public boolean getDisplayClonedCaseOrgIdentifier() {
        return this.cloneCaseIfNotExists;
    }

    public boolean getDisplayClonedCaseScheduleMetrics() {
        return this.cloneCaseIfNotExists;
    }

    public boolean getDisplayClonedCaseClearData() {
        return this.cloneCaseIfNotExists;
    }

    public UseDiscoverCaseOperation() {
        this.requiresCase = false;
        this.caseIdentifier = "";
        this.caseIdentifierType = DiscoverIdentifierType.NAME;
        this.discoverFileRepositoryType = DiscoverFileRepositoryType.AMAZON_S3;
        this.windowsFileRepository = "\\\\DISCOVER.local\\Repository\\Import\\{discover_case_name}";
        this.cloneCaseIfNotExists = false;
        this.clonedCaseDescription = "Case created by workflow";
        this.cloneSourceCaseIdentifier = "Template Case";
        this.cloneSourceCaseIdentifierType = DiscoverIdentifierType.NAME;
        this.clonedCaseOrgIdentifier = "";
        this.clonedCaseOrgIdentifierType = DiscoverIdentifierType.NAME;
        this.clonedCaseScheduleMetrics = false;
        this.clonedCaseClearData = true;
        this.waitForCaseToBeActive = false;
        this.waitForCaseToBeActiveTimeout = 60;
        this.clonedCaseName = "";
        this.assignUserToCase = false;
        this.assignUserToCaseCategory = DiscoverUserCaseCategory.ADMINISTRATOR;
        this.assignUserToGroup = false;
        this.caseUserGroupIdentifierType = DiscoverIdentifierType.NAME;
        this.caseUserGroupIdentifier = "Case Manager";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("UseDiscoverCaseOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.USE_DISCOVER_CASE;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureDiscoverConnectionOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureDiscoverConnectionOperation) {
                detectedConfigureDiscoverConnectionOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureDiscoverConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureDiscoverConnectionOperation.Prerequisites.Missing"));
        }
        if (this.caseIdentifier == null || this.caseIdentifier.trim().length() == 0) {
            prerequisites.add(this.iu.getString("UseDiscoverCaseOperation.Prerequisites.CaseIdentifierRequired"));
        }
        if (this.cloneCaseIfNotExists) {
            if (this.cloneSourceCaseIdentifier == null || this.cloneSourceCaseIdentifier.trim().length() == 0) {
                prerequisites.add(this.iu.getString("UseDiscoverCaseOperation.Prerequisites.SourceCaseIdentifierRequired"));
            }
            if (this.clonedCaseName == null || this.clonedCaseName.trim().length() == 0) {
                prerequisites.add(this.iu.getString("UseDiscoverCaseOperation.Prerequisites.ClonedCaseNameRequired"));
            }
        }
        if ((this.cloneCaseIfNotExists || this.waitForCaseToBeActive) && (activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED)) {
            try {
                this.assertModuleLicensed(ModuleType.DISCOVER_ADVANCED);
            }
            catch (LicenceValidationException e) {
                prerequisites.add(e.getMessage());
            }
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

