/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.UseDiscoverCaseOperation;
import com.nuix.automate.workflow.core.execution.options.usediscovercase.DiscoverFileRepositoryType;
import com.nuix.automate.workflow.core.execution.options.usediscovercase.DiscoverIdentifierType;
import com.nuix.automate.workflow.core.utils.discover.DiscoverCaseDoesNotExistException;
import com.nuix.automate.workflow.core.utils.discover.DiscoverError;
import com.nuix.automate.workflow.core.utils.discover.DiscoverErrors;
import com.nuix.automate.workflow.core.utils.discover.DiscoverRestException;
import com.nuix.automate.workflow.core.utils.discover.responses.Case;
import com.nuix.automate.workflow.core.utils.discover.responses.Group;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;

public class UseDiscoverCaseOperationImplementation
extends UseDiscoverCaseOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UseDiscoverCaseOperation.class);

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = "";
                this.caseIdentifier = this.executionContext.evalParameters(this.caseIdentifier, this);
                this.clonedCaseName = this.executionContext.evalParameters(this.clonedCaseName, this);
                this.clonedCaseDescription = this.executionContext.evalParameters(this.clonedCaseDescription, this);
                this.cloneSourceCaseIdentifier = this.executionContext.evalParameters(this.cloneSourceCaseIdentifier, this);
                this.clonedCaseOrgIdentifier = this.executionContext.evalParameters(this.clonedCaseOrgIdentifier, this);
                this.caseUserGroupIdentifier = this.executionContext.evalParameters(this.caseUserGroupIdentifier, this);
                this.initializeDiscoverClient();
                this.percentageComplete = 0.3;
                this.stageName = this.iu.getString("UseDiscoverCaseOperation.Stage.GettingCase");
                Case discoverCase = null;
                try {
                    switch (this.caseIdentifierType) {
                        case NAME: {
                            this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseName", (Object)this.caseIdentifier));
                            discoverCase = this.discoverRestClient.getCase(this.caseIdentifier);
                            this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseId", (Object)discoverCase.getId()));
                            this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_case_id}", String.valueOf(discoverCase.getId()))));
                            this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_case_name}", discoverCase.getName())));
                            break;
                        }
                        case NAME_REGEX: {
                            this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseNameRegex", (Object)this.caseIdentifier));
                            discoverCase = this.discoverRestClient.getCase(Pattern.compile(this.caseIdentifier));
                            this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseName", (Object)discoverCase.getName()));
                            this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseId", (Object)discoverCase.getId()));
                            this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_case_id}", String.valueOf(discoverCase.getId()))));
                            this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_case_name}", discoverCase.getName())));
                            break;
                        }
                        case ID: {
                            int caseId = Integer.parseInt(this.caseIdentifier);
                            this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseId", (Object)caseId));
                            discoverCase = this.discoverRestClient.getCase(caseId);
                            this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseName", (Object)discoverCase.getName()));
                            this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_case_id}", String.valueOf(discoverCase.getId()))));
                            this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_case_name}", discoverCase.getName())));
                            break;
                        }
                        default: {
                            throw new NotImplementedException("Case identifier type " + String.valueOf((Object)this.caseIdentifierType) + " not supported");
                        }
                    }
                }
                catch (DiscoverCaseDoesNotExistException e) {
                    if (this.cloneCaseIfNotExists) {
                        this.addExecutionLog(this.iu.getString("UseDiscoverCaseOperation.Log.CouldNotFindCaseCloning"));
                        this.stageName = this.iu.getString("UseDiscoverCaseOperation.Stage.GettingSourceCase");
                        Case discoverSourceCase = null;
                        switch (this.cloneSourceCaseIdentifierType) {
                            case NAME: {
                                try {
                                    this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.SourceCaseName", (Object)this.cloneSourceCaseIdentifier));
                                    discoverSourceCase = this.discoverRestClient.getCase(this.cloneSourceCaseIdentifier);
                                    this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.SourceCaseId", (Object)discoverSourceCase.getId()));
                                    break;
                                }
                                catch (DiscoverCaseDoesNotExistException ex) {
                                    throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.CannotFindCaseWithName", (Object)this.cloneSourceCaseIdentifier))));
                                }
                            }
                            case ID: {
                                try {
                                    int sourceCaseId = Integer.parseInt(this.cloneSourceCaseIdentifier);
                                    this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.SourceCaseId", (Object)sourceCaseId));
                                    discoverSourceCase = this.discoverRestClient.getCase(sourceCaseId);
                                    this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.SourceCaseName", (Object)discoverSourceCase.getName()));
                                    break;
                                }
                                catch (DiscoverCaseDoesNotExistException ex) {
                                    throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.CannotFindCaseWithId", (Object)this.cloneSourceCaseIdentifier))));
                                }
                            }
                        }
                        Integer organizationId = null;
                        if (this.clonedCaseOrgIdentifier.trim().length() > 0) {
                            this.stageName = this.iu.getString("UseDiscoverCaseOperation.Stage.GettingOrganization");
                            switch (this.clonedCaseOrgIdentifierType) {
                                case NAME: {
                                    try {
                                        this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.OrganizationName", (Object)this.clonedCaseOrgIdentifier));
                                        organizationId = this.discoverRestClient.getOrgId(this.clonedCaseOrgIdentifier);
                                        this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.OrganizationId", (Object)organizationId));
                                        break;
                                    }
                                    catch (DiscoverCaseDoesNotExistException ex) {
                                        throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.CannotFindOrganizationWithName", (Object)this.clonedCaseOrgIdentifier))));
                                    }
                                }
                                case ID: {
                                    try {
                                        organizationId = Integer.parseInt(this.clonedCaseOrgIdentifier);
                                        this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.OrganizationId", (Object)organizationId));
                                        String organizationName = this.discoverRestClient.getOrgName(organizationId);
                                        this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.OrganizationName", (Object)organizationName));
                                        break;
                                    }
                                    catch (DiscoverCaseDoesNotExistException ex) {
                                        throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.CannotFindOrganizationWithId", (Object)this.clonedCaseOrgIdentifier))));
                                    }
                                }
                            }
                        }
                        String caseName = this.caseIdentifier;
                        if (this.caseIdentifierType.equals((Object)DiscoverIdentifierType.NAME_REGEX)) {
                            caseName = this.clonedCaseName;
                        }
                        this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.RequestedCloneCaseName", (Object)caseName));
                        discoverCase = this.discoverRestClient.caseClone(caseName, this.clonedCaseDescription, organizationId, discoverSourceCase.getId(), this.clonedCaseScheduleMetrics, this.clonedCaseClearData);
                        this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseId", (Object)discoverCase.getId()));
                        this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseName", (Object)discoverCase.getName()));
                        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_case_id}", String.valueOf(discoverCase.getId()))));
                        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{discover_case_name}", discoverCase.getName())));
                    }
                    switch (this.caseIdentifierType) {
                        case NAME: {
                            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.CannotFindCaseWithName", (Object)this.caseIdentifier))));
                        }
                        case NAME_REGEX: {
                            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.CannotFindCaseWithNameRegex", (Object)this.caseIdentifier))));
                        }
                        case ID: {
                            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.CannotFindCaseWithId", (Object)this.caseIdentifier))));
                        }
                    }
                }
                this.percentageComplete = 0.4;
                boolean caseIsActive = false;
                try {
                    caseIsActive = this.discoverRestClient.getCaseActive(discoverCase.getId());
                }
                catch (DiscoverRestException ex) {
                    caseIsActive = false;
                    LOGGER.warn("Discover API error", (Throwable)ex);
                }
                if (this.waitForCaseToBeActive && !caseIsActive) {
                    long duration = this.waitForCaseToBeActiveTimeout * 60 * 1000;
                    long startTime = System.currentTimeMillis();
                    long timeoutTime = startTime + duration;
                    long minutesRemaining = Math.max(0L, timeoutTime - System.currentTimeMillis()) / 1000L / 60L;
                    this.stageName = this.iu.getNumeralString("UseDiscoverCaseOperation.Log.WaitingForCaseToBeActive", minutesRemaining);
                    this.addExecutionLog(this.iu.getNumeralString("UseDiscoverCaseOperation.Log.WaitForCaseToBeActive", (long)this.waitForCaseToBeActiveTimeout));
                    while (!caseIsActive) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        Thread.sleep(5000L);
                        minutesRemaining = Math.max(0L, timeoutTime - System.currentTimeMillis()) / 1000L / 60L;
                        this.stageName = this.iu.getNumeralString("UseDiscoverCaseOperation.Log.WaitingForCaseToBeActive", minutesRemaining);
                        double waitPercentageComplete = Math.max(0.0, (double)(System.currentTimeMillis() - startTime) / (double)duration);
                        this.percentageComplete = 0.4 + waitPercentageComplete * 0.4;
                        try {
                            caseIsActive = this.discoverRestClient.getCaseActive(discoverCase.getId());
                            LOGGER.info("Case active: " + caseIsActive);
                        }
                        catch (DiscoverRestException ex) {
                            caseIsActive = false;
                            LOGGER.warn("Discover API error", (Throwable)ex);
                        }
                        if (System.currentTimeMillis() < timeoutTime) continue;
                        throw new IOException(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.CaseNotActive", (Object)this.caseIdentifier));
                    }
                }
                if (this.waitForCaseToBeActive && (this.assignUserToCase || this.assignUserToGroup)) {
                    int currentUserId = this.discoverRestClient.getMeId();
                    try {
                        if (this.assignUserToCase) {
                            this.stageName = this.iu.getString("UseDiscoverCaseOperation.Stage.AssigningUser");
                            this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.AssignUserToCaseCategory", new Object[]{currentUserId, this.assignUserToCaseCategory.toConnectApiString()}));
                            this.discoverRestClient.userCaseAssign(currentUserId, discoverCase.getId(), this.assignUserToCaseCategory);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot assign user case", (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.AssignUserWarning", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                    }
                    try {
                        if (this.assignUserToGroup) {
                            int groupId;
                            this.stageName = this.iu.getString("UseDiscoverCaseOperation.Stage.AssigningUser");
                            if (this.caseUserGroupIdentifierType.equals((Object)DiscoverIdentifierType.NAME)) {
                                Group group = this.discoverRestClient.getCaseGroup(discoverCase.getId(), this.caseUserGroupIdentifier);
                                groupId = group.getId();
                                this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.AssigningUserToGroup", new Object[]{currentUserId, this.caseUserGroupIdentifier}));
                            } else {
                                groupId = Integer.parseInt(this.caseUserGroupIdentifier);
                                this.addExecutionLog(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.AssigningUserToGroupId", new Object[]{currentUserId, groupId}));
                            }
                            this.discoverRestClient.userGroupAssign(currentUserId, discoverCase.getId(), groupId);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot assign user group", (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("UseDiscoverCaseOperation.Log.AssignUserWarning", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                    }
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_discover_file_repository_type}", this.discoverFileRepositoryType.name())));
                if (this.discoverFileRepositoryType.equals((Object)DiscoverFileRepositoryType.WINDOWS)) {
                    this.percentageComplete = 0.8;
                    this.stageName = this.iu.getString("UseDiscoverCaseOperation.Stage.TestingRepositoryAccess");
                    this.windowsFileRepository = this.executionContext.evalParameters(this.windowsFileRepository, this);
                    Path repositoryPath = Paths.get(this.windowsFileRepository, new String[0]);
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_discover_windows_file_repository}", repositoryPath.toFile().getAbsolutePath())));
                    if (!Files.exists(repositoryPath, new LinkOption[0])) {
                        Files.createDirectory(repositoryPath, new FileAttribute[0]);
                    }
                    Files.list(repositoryPath);
                    Path uploadTestFolder = repositoryPath.resolve("AutomateUploadTest");
                    FileUtils.deleteRecursively((Path)uploadTestFolder);
                    Files.createDirectory(uploadTestFolder, new FileAttribute[0]);
                    if (!Files.exists(uploadTestFolder, new LinkOption[0])) {
                        throw new IOException("Cannot create folder " + uploadTestFolder.toFile().getAbsolutePath());
                    }
                    Files.delete(uploadTestFolder);
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

