/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.models.internal.vault.CorpusType;
import com.nuix.automate.utils.models.internal.vault.QueryTerm;
import com.nuix.automate.utils.models.internal.vault.VaultLocation;
import com.nuix.automate.utils.models.internal.vault.query.SearchMethod;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.VaultOperation;
import com.nuix.automate.workflow.core.execution.operations.VaultSetMatterOperation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

@FormFieldRow(name="dateRangeRow", children={"startDate", "endDate"}, enableOn={@OnField(name="useDateRange")})
@FormFieldGroups(value={@FormFieldGroup(name="mailAndGroupsOptions", children={"useDateRange", "dateRangeRow"}), @FormFieldGroup(name="driveAndChatOptions", children={"includeSharedDriveFiles", "includeChatRooms"}), @FormFieldGroup(name="holdLocationsAndTermsGroup", children={"useHoldFiles", "holdFilesGroup", "holdInputsGroup"}), @FormFieldGroup(name="holdFilesGroup", children={"holdLocationsFilePath", "queryTermsFilePath"}, styled=false, visibleOn={@OnField(name="useHoldFiles")}), @FormFieldGroup(name="holdInputsGroup", children={"holdLocations", "queryTerms"}, styled=false, visibleOn={@OnField(name="useHoldFiles", value={"false"})})})
@OperationMetadata(alias=OperationAlias.VAULT_ADD_HOLDS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"GOOGLE_VAULT"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@OperationParameters(value={@OperationParameter(label="holdIds", parameter="{vault_hold_ids}"), @OperationParameter(label="holdLocations", parameter="{vault_hold_locations}")})
@OperationLicenseModule(module=ModuleType.GOOGLE_HOLD)
public class VaultAddHoldsOperation
extends VaultOperation {
    @FormField
    protected String holdNamePrefix = "";
    @FormField
    protected boolean useDateRange = false;
    @FormField(componentType=FieldComponentType.DATE, positionLabel=@PositionLabel(left="startDate"))
    protected Date startDate;
    @FormField(componentType=FieldComponentType.DATE, positionLabel=@PositionLabel(left="endDate"))
    protected Date endDate;
    @FormField
    protected boolean includeSharedDriveFiles;
    @FormField
    protected boolean includeChatRooms;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    protected boolean useHoldFiles;
    @FormField
    protected String holdLocationsFilePath;
    @FormField
    protected String queryTermsFilePath;
    @FormField(componentType=FieldComponentType.OBJECT_TABLE, columnFields={@FormFieldColumn(label="corpusType", componentType=FieldComponentType.DROPDOWN, enumClass=CorpusType.class, excludeValues={"CORPUS_TYPE_UNSPECIFIED"}), @FormFieldColumn(label="searchMethod", componentType=FieldComponentType.DROPDOWN, enumClass=SearchMethod.class, allowedValues={"ACCOUNT", "ORG_UNIT"}), @FormFieldColumn(label="value")})
    @ExcludeFromPrintableOptions
    protected List<VaultLocation> holdLocations = new ArrayList<VaultLocation>();
    @FormField(componentType=FieldComponentType.OBJECT_TABLE, required=false, columnFields={@FormFieldColumn(label="corpusType", componentType=FieldComponentType.DROPDOWN, enumClass=CorpusType.class, allowedValues={"MAIL", "GROUPS"}), @FormFieldColumn(label="value")})
    @ExcludeFromPrintableOptions
    protected List<QueryTerm> queryTerms = new ArrayList<QueryTerm>();

    public boolean getDisplayStartDate() {
        return this.useDateRange;
    }

    public boolean getDisplayEndDate() {
        return this.useDateRange;
    }

    public boolean getDisplayHoldLocationsFilePath() {
        return this.useHoldFiles;
    }

    public boolean getDisplayQueryTermsFilePath() {
        return this.useHoldFiles;
    }

    public boolean getDisplayHoldLocations() {
        return !this.useHoldFiles;
    }

    public boolean getDisplayQueryTerms() {
        return !this.useHoldFiles;
    }

    public VaultAddHoldsOperation() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(2, 11);
        calendar.set(5, 31);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 0);
        this.endDate = calendar.getTime();
        calendar.set(1, calendar.get(1) - 10);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        this.startDate = calendar.getTime();
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.holdNamePrefix == null || this.holdNamePrefix.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("VaultAddHoldsOperation.Prerequisites.HoldNamePrefixRequired"));
            }
            if (this.useHoldFiles && (this.holdLocationsFilePath == null || this.holdLocationsFilePath.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VaultAddHoldsOperation.Prerequisites.HoldLocationsFilePathRequired"));
            }
            if (this.useHoldFiles && (this.queryTermsFilePath == null || this.queryTermsFilePath.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VaultAddHoldsOperation.Prerequisites.QueryTermsFilePathRequired"));
            }
        }
        prerequisites.addAll(this.getMissingRequiredOperations(VaultSetMatterOperation.class));
        return prerequisites;
    }
}

