/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.vault.CorpusType;
import com.nuix.automate.utils.models.internal.vault.QueryTerm;
import com.nuix.automate.utils.models.internal.vault.VaultLocation;
import com.nuix.automate.utils.models.internal.vault.VaultQuery;
import com.nuix.automate.utils.models.internal.vault.VaultSavedQuery;
import com.nuix.automate.utils.models.internal.vault.query.AccountInfo;
import com.nuix.automate.utils.models.internal.vault.query.DriveOptions;
import com.nuix.automate.utils.models.internal.vault.query.HangoutsChatInfo;
import com.nuix.automate.utils.models.internal.vault.query.HangoutsChatOptions;
import com.nuix.automate.utils.models.internal.vault.query.MailOptions;
import com.nuix.automate.utils.models.internal.vault.query.OrgUnitInfo;
import com.nuix.automate.utils.models.internal.vault.query.SearchMethod;
import com.nuix.automate.utils.models.internal.vault.query.SharedDriveInfo;
import com.nuix.automate.utils.models.internal.vault.query.SitesUrlInfo;
import com.nuix.automate.utils.models.internal.vault.query.VoiceOptions;
import com.nuix.automate.workflow.core.execution.operations.VaultCreateSavedQueriesOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class VaultCreateSavedQueriesOperationImplementation
extends VaultCreateSavedQueriesOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VaultCreateSavedQueriesOperation.class);
    private transient MailOptions mailOptions;
    private transient DriveOptions driveOptions;
    private transient HangoutsChatOptions hangoutsChatOptions;
    private transient VoiceOptions voiceOptions;

    @Override
    public void startTriggered() {
        this.stageCount = 4.0;
        this.stageId = 0.0;
        this.consumptionLocations = new ArrayList();
        this.runStartTriggeredThread(() -> {
            this.initialize();
            String dateTime = FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            this.queryNamePrefix = this.executionContext.evalParameters(this.queryNamePrefix, this);
            this.stageName = this.iu.getString("VaultCreateSavedQueriesOperation.Stage.PreparingSavedQueries");
            if (this.useQueryFiles) {
                this.queryLocationsFilePath = this.executionContext.evalParameters(this.queryLocationsFilePath, this);
                this.addExecutionLog(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Log.QueryLocationsFile", (Object)this.queryLocationsFilePath));
                this.queryLocations = this.readVaultLocationsFile(this.queryLocationsFilePath);
                this.queryTermsFilePath = this.executionContext.evalParameters(this.queryTermsFilePath, this);
                this.addExecutionLog(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Log.QueryTermsFile", (Object)this.queryTermsFilePath));
                this.queryTerms = this.readQueryTermsFile(this.queryTermsFilePath);
            }
            if (this.queryLocations.isEmpty()) {
                this.addWarning(this.iu.getString("VaultCreateSavedQueriesOperation.Log.NoQueryLocations"));
                return;
            }
            HashMap<CorpusType, String> serviceQueryTerms = new HashMap<CorpusType, String>();
            HashMap<String, VaultSavedQuery> savedQueries = new HashMap<String, VaultSavedQuery>();
            HashMap<String, List> queryConsumptions = new HashMap<String, List>();
            this.populateOptions();
            for (QueryTerm queryTerm : this.queryTerms) {
                serviceQueryTerms.putIfAbsent(queryTerm.getCorpusType(), queryTerm.getValue());
            }
            for (int i = 0; i < this.queryLocations.size(); ++i) {
                VaultLocation queryLocation = (VaultLocation)this.queryLocations.get(i);
                if (!this.validateQueryLocation(i, queryLocation)) continue;
                String queryId = this.getQueryId(queryLocation);
                VaultSavedQuery savedQuery = (VaultSavedQuery)savedQueries.get(queryId);
                if (savedQuery == null) {
                    savedQuery = new VaultSavedQuery(this.vaultMatterId);
                    savedQuery.setDisplayName(this.queryNamePrefix + " " + queryId + " " + dateTime);
                    savedQuery.setQuery(this.buildQuery(queryLocation, (String)serviceQueryTerms.get(queryLocation.getCorpusType())));
                    savedQueries.put(queryId, savedQuery);
                } else if (queryLocation.getSearchMethod() == SearchMethod.ENTIRE_ORG) {
                    this.addWarning(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Warning.SkippingDuplicateQuery", (Object)i));
                    continue;
                }
                VaultQuery query = savedQuery.getQuery();
                String value = queryLocation.getValue().trim();
                switch (query.getMethod()) {
                    case ACCOUNT: {
                        query.getAccountInfo().getEmails().add(value);
                        break;
                    }
                    case ORG_UNIT: {
                        query.getOrgUnitInfo().setOrgUnitId(value);
                        break;
                    }
                    case ROOM: {
                        query.getHangoutsChatInfo().getRoomId().add(value);
                        break;
                    }
                    case SITES_URL: {
                        query.getSitesUrlInfo().getUrls().add(value);
                        break;
                    }
                    case SHARED_DRIVE: {
                        query.getSharedDriveInfo().getSharedDriveIds().add(value);
                    }
                }
                List consumptions = queryConsumptions.computeIfAbsent(queryId, k -> new ArrayList());
                consumptions.add(queryLocation);
            }
            this.testOperationConsumption(queryConsumptions.values());
            this.stageId = 1.0;
            this.stageName = this.iu.getString("VaultCreateSavedQueriesOperation.Stage.CreatingSavedQueries");
            this.stageItems = savedQueries.size();
            this.processedItems = new AtomicLong();
            ConcurrentHashMap.KeySetView createdSaveQueryIds = ConcurrentHashMap.newKeySet();
            int failedToCreateSavedQueriesCount = 0;
            for (String queryId : savedQueries.keySet()) {
                VaultSavedQuery savedQuery = (VaultSavedQuery)savedQueries.get(queryId);
                try {
                    savedQuery = this.vaultRestClient.createSavedQuery(this.vaultMatterId, savedQuery);
                    createdSaveQueryIds.add(savedQuery.getSavedQueryId());
                    this.addExecutionLog(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Log.CreatedSavedQuery", new Object[]{savedQuery.getDisplayName(), savedQuery.getSavedQueryId()}));
                }
                catch (IOException e) {
                    LOGGER.warn("Could not create saved query, " + savedQuery.toString(), (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Warning.CouldNotCreateSavedQuery", new Object[]{savedQuery.toUserPrintableString(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    ++failedToCreateSavedQueriesCount;
                    queryConsumptions.remove(queryId);
                }
                this.processedItems.getAndIncrement();
            }
            for (List consumedLocations : queryConsumptions.values()) {
                this.consumptionLocations.addAll(consumedLocations);
            }
            this.addExecutionLog(this.iu.getNumeralString("VaultCreateSavedQueriesOperation.Log.CreatedSavedQueries", (long)createdSaveQueryIds.size()));
            if (failedToCreateSavedQueriesCount > 0) {
                this.addExecutionLog(this.iu.getNumeralString("VaultCreateSavedQueriesOperation.Log.FailedToCreateSavedQueries", (long)failedToCreateSavedQueriesCount));
            }
            this.concatenateToCollectionJson("{vault_saved_query_ids}", createdSaveQueryIds);
        });
    }

    private VaultQuery buildQuery(VaultLocation queryLocation, String terms) {
        VaultQuery query = new VaultQuery();
        query.setCorpus(queryLocation.getCorpusType());
        query.setMethod(queryLocation.getSearchMethod());
        query.setDataScope(this.queryDataScope);
        if (terms != null) {
            query.setTerms(terms.trim());
        }
        if (this.useDateRange) {
            query.setTimeZone(this.timezone);
            query.setStartTime(FormattingUtils.dateTimeToIsoString((DateTime)new DateTime((Object)this.startDate)));
            query.setEndTime(FormattingUtils.dateTimeToIsoString((DateTime)new DateTime((Object)this.endDate)));
        }
        switch (query.getMethod()) {
            case ACCOUNT: {
                query.setAccountInfo(new AccountInfo());
                break;
            }
            case ORG_UNIT: {
                query.setOrgUnitInfo(new OrgUnitInfo());
                break;
            }
            case ROOM: {
                query.setHangoutsChatInfo(new HangoutsChatInfo());
                break;
            }
            case SITES_URL: {
                query.setSitesUrlInfo(new SitesUrlInfo());
                break;
            }
            case SHARED_DRIVE: {
                query.setSharedDriveInfo(new SharedDriveInfo());
            }
        }
        switch (query.getCorpus()) {
            case MAIL: {
                query.setMailOptions(this.mailOptions);
                break;
            }
            case DRIVE: {
                query.setDriveOptions(this.driveOptions);
                break;
            }
            case HANGOUTS_CHAT: {
                query.setHangoutsChatOptions(this.hangoutsChatOptions);
                break;
            }
            case VOICE: {
                query.setVoiceOptions(this.voiceOptions);
            }
        }
        return query;
    }

    private boolean validateQueryLocation(int i, VaultLocation queryLocation) {
        if (queryLocation.getCorpusType() == null || queryLocation.getSearchMethod() == null) {
            this.addWarning(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Warning.InvalidQueryLocation", (Object)i));
            return false;
        }
        if (queryLocation.getSearchMethod() != SearchMethod.ENTIRE_ORG && (queryLocation.getValue() == null || queryLocation.getValue().trim().isEmpty())) {
            this.addWarning(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Warning.InvalidQueryLocationMissingValue", (Object)i));
            return false;
        }
        switch (queryLocation.getSearchMethod()) {
            case ENTIRE_ORG: {
                if (queryLocation.getCorpusType() == CorpusType.MAIL) break;
                this.addWarning(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Warning.InvalidQueryLocationServiceSearchMethod", new Object[]{i, queryLocation.getSearchMethod(), queryLocation.getCorpusType()}));
                return false;
            }
            case ROOM: {
                if (queryLocation.getCorpusType() == CorpusType.HANGOUTS_CHAT) break;
                this.addWarning(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Warning.InvalidQueryLocationServiceSearchMethod", new Object[]{i, queryLocation.getSearchMethod(), queryLocation.getCorpusType()}));
                return false;
            }
            case SITES_URL: 
            case SHARED_DRIVE: {
                if (queryLocation.getCorpusType() == CorpusType.DRIVE) break;
                this.addWarning(this.iu.getFormattedString("VaultCreateSavedQueriesOperation.Warning.InvalidQueryLocationServiceSearchMethod", new Object[]{i, queryLocation.getSearchMethod(), queryLocation.getCorpusType()}));
                return false;
            }
        }
        return true;
    }

    private String getQueryId(VaultLocation queryLocation) {
        Object queryId = queryLocation.getCorpusType().toLocalizedString() + "/" + queryLocation.getSearchMethod().toLocalizedString();
        queryId = String.join((CharSequence)"", ((String)queryId).split(" "));
        if (queryLocation.getSearchMethod() == SearchMethod.ORG_UNIT) {
            queryId = (String)queryId + " " + queryLocation.getValue().trim();
        }
        return queryId;
    }

    private void populateOptions() {
        this.mailOptions = this.executionContext.evalJsonParameter("{vault_saved_query_mail_options}", MailOptions.class, this);
        this.driveOptions = this.executionContext.evalJsonParameter("{vault_saved_query_drive_options}", DriveOptions.class, this);
        this.hangoutsChatOptions = this.executionContext.evalJsonParameter("{vault_saved_query_hangouts_chat_options}", HangoutsChatOptions.class, this);
        this.voiceOptions = this.executionContext.evalJsonParameter("{vault_saved_query_voice_options}", VoiceOptions.class, this);
    }

    @Override
    protected double getPercentageComplete() {
        return this.getProcessedItemsPercentageComplete(3.0);
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = super.getPrintablePercentageComplete();
        if (this.stageItems > 0L) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            if (this.stageId == 1.0) {
                result = (String)result + this.iu.getNumeralString("VaultCreateSavedQueriesOperation.Progress.ItemsProcessed", this.processedItems.get());
            }
        }
        return result;
    }
}

