/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.VaultExportsOperation;
import com.nuix.automate.workflow.core.execution.operations.VaultSetMatterOperation;
import com.nuix.automate.workflow.core.execution.options.general.ObjectIdentifierType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRow(name="retryFailedDownloadsRow", children={"retryFailedDownloads", "retryAttempts"})
@OperationMetadata(alias=OperationAlias.VAULT_DOWNLOAD_EXPORTS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"GOOGLE_VAULT"}), @OperationTag(name="Category", value={"EXPORT"})})
@OperationLicenseModule(module=ModuleType.GOOGLE_COLLECTIONS)
public class VaultDownloadExportsOperation
extends VaultExportsOperation {
    @FormField
    protected String downloadLocation;
    @FormField
    protected boolean includeLinkedExports;
    @FormField
    public boolean retryFailedDownloads;
    @FormField(enableOn={@OnField(name="retryFailedDownloads")}, positionLabel=@PositionLabel(right="retries"))
    public int retryAttempts;
    @FormField
    @ExcludeFromPrintableOptions
    protected ObjectIdentifierType exportIdentifierType = ObjectIdentifierType.ID;
    @FormField
    protected Set<String> exportIdentifiers = new HashSet<String>();

    public VaultDownloadExportsOperation() {
        this.exportIdentifiers.add("{vault_export_ids}");
        this.includeLinkedExports = true;
        this.retryFailedDownloads = true;
        this.retryAttempts = 10;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.downloadLocation == null || this.downloadLocation.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("VaultDownloadExportsOperation.Prerequisites.DownloadLocationRequired"));
            }
            if (this.exportIdentifierType == null || this.exportIdentifiers == null || this.exportIdentifiers.stream().allMatch(String::isEmpty)) {
                prerequisites.add(this.iu.getString("VaultDownloadExportsOperation.Prerequisites.ExportIdentifiersRequired"));
            }
        }
        prerequisites.addAll(this.getMissingRequiredOperations(VaultSetMatterOperation.class));
        return prerequisites;
    }
}

