/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.vault.VaultExport;
import com.nuix.automate.utils.models.internal.vault.export.CloudStorageFile;
import com.nuix.automate.utils.models.internal.vault.export.CloudStorageSink;
import com.nuix.automate.utils.models.internal.vault.export.ExportStatus;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.VaultDownloadExportsOperation;
import com.nuix.automate.workflow.core.execution.operations.VaultExportsOperation;
import com.nuix.automate.workflow.core.utils.vault.VaultOperationException;
import com.nuix.automate.workflow.core.utils.vault.VaultRestException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.input.BoundedInputStream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openimaj.util.parallel.Parallel;

public class VaultDownloadExportsOperationImplementation
extends VaultDownloadExportsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VaultDownloadExportsOperation.class);
    private static final String STORAGE_API_URL = "https://storage.googleapis.com/storage/v1/b";
    private static final int BUFFER_SIZE = 65536;
    private transient int totalFileCount;
    private transient long totalSize;
    private transient AtomicLong totalSizeWritten;
    private transient AtomicLong downloadSpeed;
    private transient AtomicInteger filesFinishedCount;
    private transient AtomicBoolean atomicStopRequested;

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.downloadLocation = this.executionContext.evalParameters(this.downloadLocation, this);
            this.exportIdentifiers = this.normalizeListIdentifiers(this.exportIdentifiers);
            this.stageName = this.iu.getString("VaultDownloadExportsOperation.Stage.GettingExports");
            VaultExportsOperation.FilteredResult<VaultExport> result = this.getFilteredVaultExports(this.exportIdentifierType, this.exportIdentifiers, this.includeLinkedExports);
            List exports = result.values;
            if (exports.isEmpty()) {
                this.addWarning(this.iu.getString("VaultDownloadExportsOperation.Log.CouldNotFindExports"));
                return;
            }
            this.addExecutionLog(this.iu.getNumeralString("VaultDownloadExportsOperation.Log.FoundExports", (long)exports.size()));
            int totalExports = exports.size();
            exports.removeIf(export -> export == null || export.getStatus() != ExportStatus.COMPLETED);
            int exportsRemoved = totalExports - exports.size();
            if (exportsRemoved > 0) {
                this.addWarning(this.iu.getNumeralString("VaultDownloadExportsOperation.Log.SkippedNonCompletedExports", (long)exportsRemoved));
            }
            for (VaultExport export2 : exports) {
                if (export2.getCloudStorageSink() == null || export2.getCloudStorageSink().getFiles() == null) continue;
                this.totalFileCount += export2.getCloudStorageSink().getFiles().size();
                this.totalSize += export2.getCloudStorageSink().getFiles().stream().mapToLong(file -> file.getSize() != null ? Long.parseLong(file.getSize()) : 0L).sum();
            }
            this.addExecutionLog(this.iu.getFormattedString("VaultDownloadExportsOperation.Log.TotalFileCount", (Object)this.totalFileCount));
            this.addExecutionLog(this.iu.getFormattedString("VaultDownloadExportsOperation.Log.TotalSize", (Object)FormattingUtils.sizeToDisplaySize((long)this.totalSize)));
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            this.stageName = this.iu.getString("VaultDownloadExportsOperation.Stage.DownloadingExports");
            this.percentageComplete = 0.1;
            Path downloadLocationPath = Paths.get(this.downloadLocation, new String[0]);
            if (Files.notExists(downloadLocationPath, new LinkOption[0])) {
                LOGGER.info("Download location does not exist, creating required directories");
                Files.createDirectories(downloadLocationPath, new FileAttribute[0]);
            }
            if (!FileUtils.isDirectoryEmpty((Path)downloadLocationPath)) {
                throw new VaultOperationException(this.iu.getFormattedString("VaultDownloadExportsOperation.Error.DownloadLocationNotEmpty", (Object)this.downloadLocation));
            }
            this.addExecutionLog(this.iu.getFormattedString("VaultDownloadExportsOperation.Log.DownloadLocation", (Object)this.downloadLocation));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{vault_export_download_location}", this.downloadLocation)));
            this.atomicStopRequested = new AtomicBoolean();
            this.filesFinishedCount = new AtomicInteger();
            this.totalSizeWritten = new AtomicLong();
            AtomicBoolean complete = new AtomicBoolean();
            ConcurrentHashMap.KeySetView errors = ConcurrentHashMap.newKeySet();
            Thread downloadThread = new Thread(() -> {
                ConcurrentLinkedQueue downloadObservers = new ConcurrentLinkedQueue();
                AtomicLong lastUpdateMillis = new AtomicLong();
                this.downloadSpeed = new AtomicLong();
                ScheduledExecutorService observerThreadPool = Executors.newScheduledThreadPool(1);
                observerThreadPool.scheduleWithFixedDelay(() -> {
                    long totalRead = 0L;
                    for (DownloadObserver downloadObserver : downloadObservers) {
                        if (downloadObserver.getDone()) continue;
                        totalRead += downloadObserver.run();
                    }
                    long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    long duration = (currentMillis - lastUpdateMillis.get()) / 1000L;
                    this.downloadSpeed.set(totalRead / duration);
                    lastUpdateMillis.set(currentMillis);
                }, 5L, 5L, TimeUnit.SECONDS);
                observerThreadPool.scheduleWithFixedDelay(new Operation.CheckUsableSpaceTask(downloadLocationPath), 0L, 30L, TimeUnit.SECONDS);
                try {
                    long startMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    lastUpdateMillis.set(startMillis);
                    for (VaultExport export : exports) {
                        CloudStorageSink cloudStorageSink = export.getCloudStorageSink();
                        if (cloudStorageSink == null) {
                            this.addWarning(this.iu.getFormattedString("VaultDownloadExportsOperation.Warning.CouldNotFindCloudStorageForExport", (Object)export.getName()));
                            continue;
                        }
                        if (cloudStorageSink.getFiles() == null || cloudStorageSink.getFiles().isEmpty()) {
                            this.addWarning(this.iu.getFormattedString("VaultDownloadExportsOperation.Warning.ExportCloudStorageSinkHasNoFiles", (Object)export.getName()));
                            continue;
                        }
                        Path exportDownloadLocationPath = downloadLocationPath.resolve(export.getName());
                        Files.createDirectories(exportDownloadLocationPath, new FileAttribute[0]);
                        AtomicLong exportSize = new AtomicLong();
                        AtomicInteger failedFiles = new AtomicInteger();
                        Parallel.forEach((Iterable)cloudStorageSink.getFiles(), cloudStorageFile -> {
                            String[] fileNameSplit = cloudStorageFile.getObjectName().split("/");
                            Path filePath = exportDownloadLocationPath.resolve(fileNameSplit[fileNameSplit.length - 1]);
                            DownloadObserver downloadObserver = new DownloadObserver(cloudStorageFile.getObjectName(), 300L);
                            downloadObservers.add(downloadObserver);
                            int attempt = 0;
                            HashSet<String> transientWarnings = new HashSet<String>();
                            while (true) {
                                if (++attempt == 1) {
                                    LOGGER.info("Starting download for file " + String.valueOf(filePath));
                                } else {
                                    LOGGER.info("Retrying (" + attempt + ") download for file " + String.valueOf(filePath));
                                }
                                try (InputStream exportInputStream = this.getExportDownloadInputStream((CloudStorageFile)cloudStorageFile);){
                                    FileChannel fileChannel = FileChannel.open(filePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                                    try {
                                        BoundedInputStream downloadInputStream = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(exportInputStream)).get();
                                        downloadObserver.setDownloadInputStream(downloadInputStream);
                                        try {
                                            FileUtils.writeWithSeparateWriteThread((FileChannel)fileChannel, (ReadableByteChannel)Channels.newChannel((InputStream)downloadInputStream), (int)65536);
                                            fileChannel.force(true);
                                            this.filesFinishedCount.getAndIncrement();
                                            exportSize.updateAndGet(prev -> prev + downloadInputStream.getCount());
                                        }
                                        finally {
                                            downloadObserver.finish();
                                        }
                                        for (String transientWarning : transientWarnings) {
                                            this.addTransientWarning(transientWarning, true);
                                        }
                                        if (fileChannel == null) break;
                                    }
                                    catch (Throwable throwable) {
                                        if (fileChannel != null) {
                                            try {
                                                fileChannel.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    fileChannel.close();
                                }
                                catch (Exception e) {
                                    LOGGER.error("Could not download file, " + cloudStorageFile.getObjectName(), (Throwable)e);
                                    if (!this.atomicStopRequested.get() && this.retryFailedDownloads && attempt <= this.retryAttempts) {
                                        Thread.interrupted();
                                        if (downloadObserver.getError() == null) {
                                            String transientWarning = this.iu.getFormattedString("VaultDownloadExportsOperation.Warning.ErrorDownloadingFileRetrying", (Object)cloudStorageFile.getObjectName());
                                            transientWarnings.add(transientWarning);
                                            this.addTransientWarning(transientWarning, false);
                                        }
                                        try {
                                            Files.deleteIfExists(filePath);
                                        }
                                        catch (IOException ex) {
                                            LOGGER.error("Error deleting failed file", (Throwable)e);
                                        }
                                        continue;
                                    }
                                    errors.add(this.iu.getFormattedString("VaultDownloadExportsOperation.Error.CouldNotDownloadFile", new Object[]{cloudStorageFile.getObjectName(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                                    failedFiles.getAndIncrement();
                                }
                                break;
                            }
                        });
                        this.addExecutionLog(this.iu.getFormattedString("VaultDownloadExportsOperation.Log.DownloadedExport", new Object[]{export.getName(), FormattingUtils.sizeToDisplaySize((long)exportSize.get())}));
                        if (failedFiles.get() <= 0) continue;
                        this.addExecutionLog(this.iu.getNumeralString("VaultDownloadExportsOperation.Log.FailedToDownloadFiles", (long)failedFiles.get()));
                    }
                    this.logDownloadSpeed(startMillis, this.totalSizeWritten.get());
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    errors.add(ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                }
                finally {
                    observerThreadPool.shutdownNow();
                    complete.set(true);
                }
            });
            downloadThread.setName("Automate - Vault Download Thread");
            downloadThread.start();
            while (!complete.get()) {
                if (this.stopRequested) {
                    this.atomicStopRequested.set(true);
                }
                Thread.sleep(5000L);
            }
            if (!errors.isEmpty()) {
                throw new VaultOperationException(String.join((CharSequence)"\n", errors));
            }
        });
    }

    private InputStream getExportDownloadInputStream(CloudStorageFile cloudStorageFile) throws IOException {
        String downloadToken = this.vaultRestClient.getCloudDownloadToken();
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Authorization", (Object)("Bearer " + downloadToken));
        String fileDownloadUrl = "https://storage.googleapis.com/storage/v1/b/" + cloudStorageFile.getBucketName() + "/o/" + URLEncoder.encode(cloudStorageFile.getObjectName(), "UTF-8") + "?alt=media";
        LOGGER.info("Downloading Cloud Storage object URL" + fileDownloadUrl);
        Response response = WsRsRestClientFactory.getClient((String)(this.getOperationName() + "-" + cloudStorageFile.getObjectName() + "-" + DateTime.now().getMillis())).target(fileDownloadUrl).request(new String[]{"application/octet-stream"}).headers((MultivaluedMap)headers).get();
        if (response.getStatus() != 200) {
            response.bufferEntity();
            String responseString = (String)response.readEntity(String.class);
            String errorMessage = "HTTP/" + response.getStatus() + " " + responseString;
            throw new VaultRestException(errorMessage);
        }
        return (InputStream)response.getEntity();
    }

    @Override
    protected double getPercentageComplete() {
        double percentage = this.percentageComplete;
        if (this.totalSize > 0L) {
            double percentageScale = 1.0 - percentage;
            percentage = percentageScale * ((double)this.totalSizeWritten.get() / (double)this.totalSize);
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentage = Math.min(percentage, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentage = Math.max(percentage, 1.0E-4);
        }
        return percentage;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = super.getPrintablePercentageComplete();
        if (this.downloadSpeed != null) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            result = (String)result + FormattingUtils.sizeToDisplaySize((long)this.downloadSpeed.get()) + "/s";
        }
        if (this.totalFileCount > 0) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("VaultDownloadExportsOperation.Progress.FileDownloaded", (long)this.filesFinishedCount.get());
        }
        return result;
    }

    private class DownloadObserver {
        final String fileName;
        final Thread writeThread = Thread.currentThread();
        BoundedInputStream downloadInputStream;
        long count;
        boolean done;
        final long throwAfterNSecondsFrozen;
        long lastReadUpdateMillis;
        String error;

        DownloadObserver(String fileName, long throwAfterNSecondsFrozen) {
            this.fileName = fileName;
            this.throwAfterNSecondsFrozen = throwAfterNSecondsFrozen;
        }

        public long run() {
            return this.run(true);
        }

        public long run(boolean interruptWriteThreadIfFrozen) {
            if (VaultDownloadExportsOperationImplementation.this.atomicStopRequested.get()) {
                this.writeThread.interrupt();
                return 0L;
            }
            long prevCount = this.count;
            this.count = this.downloadInputStream.getCount();
            long read = this.count - prevCount;
            VaultDownloadExportsOperationImplementation.this.totalSizeWritten.getAndUpdate(prev -> prev + read);
            long currentMillis = System.currentTimeMillis();
            if (read != 0L || this.lastReadUpdateMillis == 0L) {
                this.lastReadUpdateMillis = currentMillis;
                if (read != 0L) {
                    this.clearError();
                }
            } else if (interruptWriteThreadIfFrozen && (currentMillis - this.lastReadUpdateMillis) / 1000L > this.throwAfterNSecondsFrozen) {
                this.error = VaultDownloadExportsOperationImplementation.this.iu.getFormattedString("DownloadObserver.Warning.DetectedFrozenFileProgress", (Object)this.fileName);
                VaultDownloadExportsOperationImplementation.this.addTransientWarning(this.error, false);
                this.writeThread.interrupt();
            }
            return read;
        }

        public void setDownloadInputStream(BoundedInputStream bin) {
            this.downloadInputStream = bin;
            this.done = false;
            this.lastReadUpdateMillis = 0L;
            if (this.count > 0L) {
                VaultDownloadExportsOperationImplementation.this.totalSizeWritten.getAndUpdate(prev -> prev - this.count);
                this.count = 0L;
            }
        }

        public void clearError() {
            if (this.error != null) {
                VaultDownloadExportsOperationImplementation.this.addTransientWarning(this.error, true);
                this.error = null;
            }
        }

        public void finish() {
            this.run(false);
            this.done = true;
        }

        public boolean getDone() {
            return this.done;
        }

        public String getError() {
            return this.error;
        }
    }
}

