/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.vault.VaultExport;
import com.nuix.automate.utils.models.internal.vault.VaultObject;
import com.nuix.automate.utils.models.internal.vault.VaultQuery;
import com.nuix.automate.utils.models.internal.vault.VaultSavedQuery;
import com.nuix.automate.utils.models.internal.vault.export.ExportOptions;
import com.nuix.automate.utils.models.internal.vault.export.GroupsExportOptions;
import com.nuix.automate.utils.models.internal.vault.export.HangoutsChatExportOptions;
import com.nuix.automate.utils.models.internal.vault.export.VoiceExportOptions;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.VaultExportSavedQueriesOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class VaultExportSavedQueriesOperationImplementation
extends VaultExportSavedQueriesOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VaultExportSavedQueriesOperation.class);

    @Override
    public void startTriggered() {
        this.stageId = 0.0;
        this.stageCount = 5.0;
        this.runStartTriggeredThread(() -> {
            this.initialize();
            String dateTime = FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            this.exportNamePrefix = this.executionContext.evalParameters(this.exportNamePrefix, this);
            this.savedQueryIdentifiers = this.normalizeListIdentifiers(this.savedQueryIdentifiers);
            this.stageName = this.iu.getString("VaultExportSavedQueriesOperation.Stage.GettingSavedQueries");
            List<VaultSavedQuery> allSavedQueries = this.vaultRestClient.getSavedQueries(this.vaultMatterId);
            Map<String, VaultSavedQuery> savedQueriesMap = this.filterVaultObjects(this.savedQueryIdentifierType, this.savedQueryIdentifiers, allSavedQueries, VaultSavedQuery::getSavedQueryId, VaultObject::getDisplayName);
            ArrayList<VaultSavedQuery> savedQueries = new ArrayList<VaultSavedQuery>(savedQueriesMap.values());
            if (savedQueries.isEmpty()) {
                this.addWarning(this.iu.getString("VaultExportSavedQueriesOperation.Log.CouldNotFindSavedQueries"));
                return;
            }
            this.addExecutionLog(this.iu.getNumeralString("VaultExportSavedQueriesOperation.Log.FoundSavedQueries", (long)savedQueries.size()));
            this.processedItems = new AtomicLong();
            this.stageId = 0.5;
            this.stageName = this.iu.getString("VaultExportSavedQueriesOperation.Stage.CreatingExports");
            ConcurrentHashMap.KeySetView createdExportIds = ConcurrentHashMap.newKeySet();
            AtomicLong failedToCreateExportsCount = new AtomicLong();
            this.mailExportOptions.setExportFormat(this.exportFormat);
            GroupsExportOptions groupsExportOptions = new GroupsExportOptions(this.exportFormat);
            HangoutsChatExportOptions hangoutsChatExportOptions = new HangoutsChatExportOptions(this.exportFormat);
            VoiceExportOptions voiceExportOptions = new VoiceExportOptions(this.exportFormat);
            for (VaultSavedQuery savedQuery : savedQueries) {
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                VaultQuery query = savedQuery.getQuery();
                VaultExport export = new VaultExport();
                export.setName(this.exportNamePrefix + " " + dateTime + " " + FormattingUtils.getShortId((String)savedQuery.getSavedQueryId(), (int)8));
                export.setQuery(query);
                ExportOptions exportOptions = new ExportOptions();
                exportOptions.setRegion(this.exportRegion);
                switch (query.getCorpus()) {
                    case MAIL: {
                        exportOptions.setMailOptions(this.mailExportOptions);
                        break;
                    }
                    case GROUPS: {
                        exportOptions.setGroupsOptions(groupsExportOptions);
                        break;
                    }
                    case DRIVE: {
                        exportOptions.setDriveOptions(this.driveExportOptions);
                        break;
                    }
                    case HANGOUTS_CHAT: {
                        exportOptions.setHangoutsChatOptions(hangoutsChatExportOptions);
                        break;
                    }
                    case VOICE: {
                        exportOptions.setVoiceOptions(voiceExportOptions);
                    }
                }
                export.setExportOptions(exportOptions);
                try {
                    export = this.vaultRestClient.createExport(this.vaultMatterId, export);
                    createdExportIds.add(export.getId());
                    this.processedItems.getAndIncrement();
                    this.addExecutionLog(this.iu.getFormattedString("VaultExportSavedQueriesOperation.Log.CreatedExportWithSavedQuery", new Object[]{export.getName(), export.getId(), savedQuery.getDisplayName()}));
                }
                catch (Exception e) {
                    LOGGER.warn("Could not create export, " + export.toString(), (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("VaultExportSavedQueriesOperation.Warning.CouldNotCreateExport", new Object[]{export.toUserPrintableString(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    failedToCreateExportsCount.getAndIncrement();
                }
            }
            this.addExecutionLog(this.iu.getNumeralString("VaultExportSavedQueriesOperation.Log.CreatedExports", (long)createdExportIds.size()));
            if (failedToCreateExportsCount.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("VaultExportSavedQueriesOperation.Log.FailedToCreateExports", failedToCreateExportsCount.get()));
            }
            if (this.waitForCompletion) {
                HashSet<String> remainingExportIds = new HashSet<String>(createdExportIds);
                this.stageId = 1.0;
                this.stageName = this.iu.getString("VaultExportSavedQueriesOperation.Stage.WaitingForExports");
                this.stageItems = remainingExportIds.size();
                this.processedItems.set(0L);
                this.waitForExports(remainingExportIds, "Export");
                this.waitForLinkedExports(createdExportIds);
                this.stageId = 1.5;
            }
            this.concatenateToCollectionJson("{vault_export_ids}", createdExportIds);
        });
    }

    @Override
    protected double getPercentageComplete() {
        return this.getProcessedItemsPercentageComplete(1.0, 3.5);
    }
}

