/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.internal.vault.VaultExport;
import com.nuix.automate.utils.models.internal.vault.VaultObject;
import com.nuix.automate.utils.models.internal.vault.export.ExportStats;
import com.nuix.automate.utils.models.internal.vault.export.ExportStatus;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.VaultOperation;
import com.nuix.automate.workflow.core.execution.options.general.ObjectIdentifierType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class VaultExportsOperation
extends VaultOperation {
    protected FilteredResult<VaultExport> getFilteredVaultExports(ObjectIdentifierType exportIdentifierType, Set<String> exportIdentifiers, boolean includeLinkedExports) throws IOException {
        List<VaultExport> allExports = this.vaultRestClient.getExports(this.vaultMatterId);
        Map<String, VaultExport> exportsMap = this.filterVaultObjects(exportIdentifierType, exportIdentifiers, allExports, VaultExport::getId, VaultObject::getName);
        ArrayList<VaultExport> exports = new ArrayList<VaultExport>(exportsMap.values());
        HashSet<String> exportIds = new HashSet<String>(exportsMap.keySet());
        if (includeLinkedExports) {
            for (VaultExport export : allExports) {
                if (export.getParentExportId() == null || !exportIds.contains(export.getParentExportId()) || !exportIds.add(export.getId())) continue;
                exports.add(export);
            }
        }
        return new FilteredResult<VaultExport>(exports, exportIds);
    }

    protected void waitForExports(Set<String> remainingExportIds, String translationPrefix) throws IOException, InterruptedException {
        if (remainingExportIds.isEmpty()) {
            return;
        }
        int failedExports = 0;
        int completedExports = 0;
        HashMap<String, Integer> attemptsToGetStatsForCompletedExports = new HashMap<String, Integer>();
        this.addExecutionLog(this.iu.getNumeralString("VaultExportsOperation.Log.WaitingForExports", (long)remainingExportIds.size()));
        while (!remainingExportIds.isEmpty()) {
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            Thread.sleep((long)this.operationPollingDelay * 1000L);
            for (VaultExport export : this.vaultRestClient.getExports(this.vaultMatterId)) {
                if (!remainingExportIds.contains(export.getId()) || export.getStatus() == ExportStatus.IN_PROGRESS) continue;
                if (export.getStatus() == ExportStatus.COMPLETED) {
                    int attempts;
                    ExportStats exportStats = export.getStats();
                    if ((exportStats == null || exportStats.getExportedArtifactCount() == null) && (attempts = attemptsToGetStatsForCompletedExports.computeIfAbsent(export.getId(), k -> 0).intValue()) < 3) {
                        attemptsToGetStatsForCompletedExports.put(export.getId(), ++attempts);
                        continue;
                    }
                    ++completedExports;
                    this.addExecutionLog(this.iu.getFormattedString("VaultExportsOperation.Log." + translationPrefix + "Completed", (Object)export.getName()));
                    if (exportStats != null) {
                        String exportedCount = exportStats.getExportedArtifactCount() == null ? "0" : exportStats.getExportedArtifactCount();
                        this.addExecutionLog(this.iu.getFormattedString("VaultExportsOperation.Log.ExportedArtifactCount", (Object)exportedCount));
                        if (exportStats.getSizeInBytes() != null) {
                            long exportSizeBytes = Long.parseLong(exportStats.getSizeInBytes());
                            this.addExecutionLog(this.iu.getFormattedString("VaultExportsOperation.Log.ExportSize", (Object)FormattingUtils.sizeToDisplaySize((long)exportSizeBytes)));
                        }
                    }
                } else {
                    ++failedExports;
                    this.addWarning(this.iu.getFormattedString("VaultExportsOperation.Log." + translationPrefix + "Failed", (Object)export.getName()));
                }
                remainingExportIds.remove(export.getId());
                this.processedItems.getAndIncrement();
            }
        }
        this.addExecutionLog(this.iu.getNumeralString("VaultExportsOperation.Log." + translationPrefix + "sCompleted", (long)completedExports));
        if (failedExports > 0) {
            this.addExecutionLog(this.iu.getNumeralString("VaultExportsOperation.Log." + translationPrefix + "sFailed", (long)failedExports));
        }
    }

    protected void waitForLinkedExports(Set<String> exportIds) throws InterruptedException, IOException {
        Thread.sleep((long)this.operationPollingDelay * 1000L);
        HashSet<String> remainingExportIds = new HashSet<String>();
        for (VaultExport export : this.vaultRestClient.getExports(this.vaultMatterId)) {
            if (exportIds.contains(export.getId()) || export.getParentExportId() == null || !exportIds.contains(export.getParentExportId())) continue;
            exportIds.add(export.getId());
            remainingExportIds.add(export.getId());
            this.addExecutionLog(this.iu.getFormattedString("VaultExportsOperation.Log.FoundLinkedExport", new Object[]{export.getName(), export.getId()}));
        }
        if (!remainingExportIds.isEmpty()) {
            this.addExecutionLog(this.iu.getNumeralString("VaultExportsOperation.Log.FoundLinkedExports", (long)remainingExportIds.size()));
            this.stageItems += (long)remainingExportIds.size();
            this.waitForExports(remainingExportIds, "LinkedExport");
        }
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = super.getPrintablePercentageComplete();
        if (this.stageId >= 0.5) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("VaultExportsOperation.Progress.ItemsProcessed", this.processedItems.get());
        }
        return result;
    }

    protected static class FilteredResult<T> {
        List<T> values;
        Set<String> ids;

        public FilteredResult(List<T> values, Set<String> ids) {
            this.values = values;
            this.ids = ids;
        }

        public List<T> getValues() {
            return this.values;
        }

        public void setValues(List<T> values) {
            this.values = values;
        }

        public Set<String> getIds() {
            return this.ids;
        }

        public void setIds(Set<String> ids) {
            this.ids = ids;
        }
    }
}

