/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.models.internal.vault.MatterState;
import com.nuix.automate.utils.models.internal.vault.VaultMatter;
import com.nuix.automate.workflow.core.execution.operations.VaultManageMatterOperation;
import com.nuix.automate.workflow.core.execution.options.vault.ManageMatterAction;
import com.nuix.automate.workflow.core.utils.vault.VaultOperationException;
import java.io.IOException;

public class VaultManageMatterOperationImplementation
extends VaultManageMatterOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.percentageComplete = 0.1;
            MatterState matterState = MatterState.valueOf((String)this.executionContext.evalParameters("{vault_matter_state}", this));
            this.addExecutionLog(this.iu.getFormattedString("VaultManageMatterOperation.Log.ManageMatterAction", (Object)this.manageMatterAction.toLocalizedString()));
            this.addExecutionLog(this.iu.getFormattedString("VaultManageMatterOperation.Log.PreviousMatterState", (Object)matterState.toLocalizedString()));
            if (this.manageMatterAction == ManageMatterAction.DELETE && matterState == MatterState.OPEN) {
                this.executeMatterAction(ManageMatterAction.CLOSE);
            } else if (this.manageMatterAction == ManageMatterAction.REOPEN && matterState == MatterState.DELETED) {
                this.executeMatterAction(ManageMatterAction.UNDELETE);
            }
            VaultMatter matter = this.executeMatterAction(this.manageMatterAction);
            this.addExecutionLog(this.iu.getFormattedString("VaultManageMatterOperation.Log.UpdatedMatterState", (Object)matter.getState().toLocalizedString()));
        });
    }

    private VaultMatter executeMatterAction(ManageMatterAction manageMatterAction) throws IOException {
        switch (manageMatterAction) {
            case CLOSE: {
                this.stageName = this.iu.getString("VaultManageMatterOperation.Stage.ClosingCase");
                return this.vaultRestClient.closeMatter(this.vaultMatterId);
            }
            case REOPEN: {
                this.stageName = this.iu.getString("VaultManageMatterOperation.Stage.ReopeningCase");
                return this.vaultRestClient.reopenMatter(this.vaultMatterId);
            }
            case DELETE: {
                this.stageName = this.iu.getString("VaultManageMatterOperation.Stage.DeletingCase");
                return this.vaultRestClient.deleteMatter(this.vaultMatterId);
            }
            case UNDELETE: {
                this.stageName = this.iu.getString("VaultManageMatterOperation.Stage.UndeletingCase");
                return this.vaultRestClient.undeleteMatter(this.vaultMatterId);
            }
        }
        throw new VaultOperationException(this.iu.getFormattedString("VaultManageMatterOperation.Error.InvalidManageMatterAction", (Object)manageMatterAction));
    }
}

