/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.models.internal.vault.VaultMatter;
import com.nuix.automate.utils.models.internal.vault.VaultObject;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.VaultSetMatterOperation;
import com.nuix.automate.workflow.core.execution.options.general.ObjectIdentifierType;
import com.nuix.automate.workflow.core.utils.vault.VaultObjectDoesNotExistException;
import com.nuix.automate.workflow.core.utils.vault.VaultOperationException;

public class VaultSetMatterOperationImplementation
extends VaultSetMatterOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            boolean matterCreated;
            VaultMatter vaultMatter;
            block8: {
                this.initializeVaultRestClient();
                this.matterIdentifier = this.executionContext.evalParameters(this.matterIdentifier, this);
                this.stageName = this.iu.getString("VaultSetMatterOperation.Stage.GettingMatter");
                this.percentageComplete = 0.3;
                vaultMatter = null;
                matterCreated = false;
                try {
                    switch (this.matterIdentifierType) {
                        case ID: {
                            vaultMatter = this.vaultRestClient.getMatterForId(this.matterIdentifier, this.matterState);
                            break;
                        }
                        case NAME: {
                            vaultMatter = this.vaultRestClient.getMatterForName(this.matterIdentifier, this.matterState);
                            break;
                        }
                        case NAME_REGEX: {
                            vaultMatter = this.vaultRestClient.getMatterForNameRegex(this.matterIdentifier, this.matterState, VaultObject::getMatterId, VaultObject::getName);
                        }
                    }
                    this.addExecutionLog(this.iu.getFormattedString("VaultSetMatterOperation.Log.FoundExistingMatter", new Object[]{vaultMatter.getName(), vaultMatter.getMatterId()}));
                }
                catch (VaultObjectDoesNotExistException e) {
                    if (this.matterIdentifierType != ObjectIdentifierType.NAME || !this.createMatterIfNotExists) break block8;
                    this.stageName = this.iu.getString("VaultSetMatterOperation.Stage.CreatingMatter");
                    this.percentageComplete = 0.6;
                    this.addExecutionLog(this.iu.getString("VaultSetMatterOperation.Log.CouldNotFindMatterCreating"));
                    vaultMatter = new VaultMatter();
                    vaultMatter.setName(this.matterIdentifier);
                    vaultMatter.setDescription(this.matterDescription);
                    vaultMatter = this.vaultRestClient.createMatter(vaultMatter);
                    matterCreated = true;
                    this.addExecutionLog(this.iu.getString("VaultSetMatterOperation.Log.CreatedMatter"));
                    this.addExecutionLog(this.iu.getFormattedString("VaultSetMatterOperation.Log.MatterName", (Object)vaultMatter.getName()));
                    this.addExecutionLog(this.iu.getFormattedString("VaultSetMatterOperation.Log.MatterId", (Object)vaultMatter.getMatterId()));
                }
            }
            if (vaultMatter == null) {
                String errorMessage = this.iu.getFormattedString("VaultSetMatterOperation.Error.CannotFindMatterWith" + this.matterIdentifierType.name(), (Object)this.matterIdentifier);
                throw new VaultOperationException(errorMessage);
            }
            this.addExecutionLog(this.iu.getFormattedString("VaultSetMatterOperation.Log.MatterState", (Object)vaultMatter.getState().toLocalizedString()));
            String matterOverviewUrl = "https://vault.google.com/matter/" + vaultMatter.getMatterId();
            this.addExecutionLog(this.iu.getFormattedString("VaultSetMatterOperation.Log.MatterOverviewUrl", (Object)matterOverviewUrl));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{vault_matter_id}", vaultMatter.getMatterId())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{vault_matter_name}", vaultMatter.getName())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{vault_matter_state}", vaultMatter.getState().name())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{vault_matter_created}", String.valueOf(matterCreated))));
        });
    }
}

