/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.NuixQueryMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.veritone.TranscriptionTextFormat;
import com.nuix.automate.workflow.core.execution.options.veritone.VeritoneJobSaveAs;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

@FormFieldGroup(name="resultGroup", children={"resultFormat", "saveResultAs", "replaceText", "customMetadataName"})
@FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"})
@OperationMetadata(alias=OperationAlias.VERITONE_TRANSCRIBE_ITEMS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"VERITONE"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@OperationLicenseModule(module=ModuleType.VERITONE)
public class VeritoneTranscribeItemsOperation
extends NuixQueryMimeTypeVolumesUtilizationOperation {
    @FormField(required=false)
    public String scope = "flag:audited";
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.ISO3_LANGUAGES)
    public String targetLanguage = Locale.getDefault().getISO3Language();
    @FormField
    public TranscriptionTextFormat resultFormat = TranscriptionTextFormat.TIME_STAMPED;
    @FormField(allowedValues={"ITEM_TEXT", "CUSTOM_METADATA"})
    public VeritoneJobSaveAs saveResultAs = VeritoneJobSaveAs.ITEM_TEXT;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON, allowedValues={"true", "false"}, visibleOn={@OnField(name="saveResultAs", value={"ITEM_TEXT"})})
    public boolean replaceText = false;
    @FormField(visibleOn={@OnField(name="saveResultAs", value={"CUSTOM_METADATA"})})
    public String customMetadataName = "";
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagFailedItems = true;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName = "Automate|Failed Items|Veritone";
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagSuccessfulItems = true;

    public boolean getDisplayReplaceText() {
        return this.saveResultAs == VeritoneJobSaveAs.ITEM_TEXT;
    }

    public boolean getDisplayCustomMetadataName() {
        return this.saveResultAs == VeritoneJobSaveAs.CUSTOM_METADATA;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.targetLanguage == null || this.targetLanguage.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("VeritoneTranscribeItemsOperation.Prerequisites.MissingTargetLanguage"));
            }
            if (this.resultFormat == null) {
                prerequisites.add(this.iu.getString("VeritoneTranscribeItemsOperation.Prerequisites.MissingTranscriptionResultFormat"));
            }
            if (this.saveResultAs == null) {
                prerequisites.add(this.iu.getString("VeritoneTranscribeItemsOperation.Prerequisites.MissingTranscriptionResultSaveAs"));
            }
            if (this.saveResultAs == VeritoneJobSaveAs.CUSTOM_METADATA && (this.customMetadataName == null || this.customMetadataName.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VeritoneTranscribeItemsOperation.Prerequisites.MissingCustomMetadataName"));
            }
            if (this.tagFailedItems && (this.failedItemTagName == null || this.failedItemTagName.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VeritoneTranscribeItemsOperation.Prerequisites.MissingFailedItemTagName"));
            }
        }
        return prerequisites;
    }

    @Override
    public String getOperationName() {
        String className = this.getClass().getSimpleName().replace("Implementation", "");
        return this.iu.getString(className + ".Property.Name");
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        return new HashSet<Feature>();
    }

    @Override
    public Activity getActivity() {
        return Activity.AI;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.TRANSCRIBE;
    }

    @Override
    public long getVolume(WorkflowExecution workflowExecution) {
        return 0L;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return null;
    }
}

