/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.BooleanOperator;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.VeritoneOperation;
import com.nuix.automate.workflow.core.execution.options.veritone.SourceLanguageProvider;
import com.nuix.automate.workflow.core.execution.options.veritone.VeritoneJobSaveAs;
import java.util.List;
import java.util.Locale;

@FormFieldRows(value={@FormFieldRow(name="trimBodyTextRow", children={"trimBodyTextEnabled", "trimBodyTextAt"}), @FormFieldRow(name="tagTranslatedItemsRow", children={"tagTranslatedItems", "translatedItemTagName", "untagNonTranslatedItems"}), @FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"}), @FormFieldRow(name="tagUnsupportedLanguageItemsRow", children={"tagUnsupportedLanguageItems", "unsupportedLanguageItemTagName", "untagSupportedLanguageItems"})})
@FormFieldGroups(value={@FormFieldGroup(name="resultGroup", children={"saveResultAs", "replaceText", "customMetadataName", "outputFolder"}), @FormFieldGroup(name="tagGroup", children={"tagTranslatedItemsRow", "tagFailedItemsRow", "tagUnsupportedLanguageItemsRow"})})
@OperationMetadata(alias=OperationAlias.VERITONE_TRANSLATE_ITEMS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"VERITONE"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@OperationLicenseModule(module=ModuleType.VERITONE)
public class VeritoneTranslateItemsOperation
extends VeritoneOperation {
    @FormField(required=false)
    public String scope = "";
    @FormField
    public SourceLanguageProvider sourceLanguageProvider = SourceLanguageProvider.NUIX_DETECTED_LANGUAGE;
    @FormField(visibleOn={@OnField(name="sourceLanguageProvider", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"EXPLICIT"})})
    @ExcludeFromPrintableOptions
    public boolean fallbackToExplicitSourceLanguageIfNoneDetected = true;
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.ISO3_LANGUAGES, enableOn={@OnField(name="sourceLanguageProvider", value={"EXPLICIT"}), @OnField(name="fallbackToExplicitSourceLanguageIfNoneDetected")}, enableOnOperator=BooleanOperator.OR)
    public String explicitSourceLanguage = Locale.getDefault().getISO3Language();
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.ISO3_LANGUAGES)
    public String targetLanguage = Locale.getDefault().getISO3Language();
    @FormField
    public boolean trimBodyTextEnabled = true;
    @FormField(min=100.0, enableOn={@OnField(name="trimBodyTextEnabled")}, positionLabel=@PositionLabel(right="characters"))
    @ExcludeFromPrintableOptions
    public int trimBodyTextAt = 1000000;
    @FormField
    public VeritoneJobSaveAs saveResultAs = VeritoneJobSaveAs.ITEM_TEXT;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON, allowedValues={"true", "false"}, visibleOn={@OnField(name="saveResultAs", value={"ITEM_TEXT"})})
    public boolean replaceText = false;
    @FormField(visibleOn={@OnField(name="saveResultAs", value={"CUSTOM_METADATA"})})
    public String customMetadataName = "";
    @FormField(visibleOn={@OnField(name="saveResultAs", value={"CHILD_ITEM"})})
    public String outputFolder = "";
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagTranslatedItems = true;
    @FormField(enableOn={@OnField(name="tagTranslatedItems")})
    @ExcludeFromPrintableOptions
    public String translatedItemTagName = "Automate|Translated Items|Veritone";
    @FormField(enableOn={@OnField(name="tagTranslatedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagNonTranslatedItems = true;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagFailedItems = true;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName = "Automate|Failed Items|Veritone";
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagSuccessfulItems = true;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagUnsupportedLanguageItems = true;
    @FormField(enableOn={@OnField(name="tagUnsupportedLanguageItems")})
    @ExcludeFromPrintableOptions
    public String unsupportedLanguageItemTagName = "Automate|Unsupported Language Items|Veritone";
    @FormField(enableOn={@OnField(name="tagUnsupportedLanguageItems")})
    @ExcludeFromPrintableOptions
    public boolean untagSupportedLanguageItems = true;

    public boolean getDisplayFallbackToExplicitSourceLanguageIfNoneDetected() {
        return this.sourceLanguageProvider != SourceLanguageProvider.EXPLICIT;
    }

    public boolean getDisplayExplicitSourceLanguage() {
        return this.sourceLanguageProvider == SourceLanguageProvider.EXPLICIT || this.fallbackToExplicitSourceLanguageIfNoneDetected;
    }

    public boolean getDisplayTrimBodyTextAt() {
        return this.trimBodyTextEnabled;
    }

    public boolean getDisplayReplaceText() {
        return this.saveResultAs == VeritoneJobSaveAs.ITEM_TEXT;
    }

    public boolean getDisplayCustomMetadataName() {
        return this.saveResultAs == VeritoneJobSaveAs.CUSTOM_METADATA;
    }

    public boolean getDisplayOutputFolder() {
        return this.saveResultAs == VeritoneJobSaveAs.CHILD_ITEM;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.sourceLanguageProvider == null) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.MissingSourceLanguageProvider"));
            }
            if ((this.sourceLanguageProvider == SourceLanguageProvider.EXPLICIT || this.fallbackToExplicitSourceLanguageIfNoneDetected) && (this.explicitSourceLanguage == null || this.explicitSourceLanguage.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.MissingExplicitSourceLanguage"));
            }
            if (this.targetLanguage == null || this.targetLanguage.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.MissingTargetLanguage"));
            }
            if (this.trimBodyTextEnabled && this.trimBodyTextAt < 100) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.TrimBodyTextAtBelowMinimum"));
            }
            if (this.saveResultAs == null) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.MissingTranslationResultSaveAs"));
            }
            if (this.saveResultAs == VeritoneJobSaveAs.CUSTOM_METADATA && (this.customMetadataName == null || this.customMetadataName.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.MissingCustomMetadataName"));
            }
            if (this.saveResultAs == VeritoneJobSaveAs.CHILD_ITEM && (this.outputFolder == null || this.outputFolder.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.MissingOutputFolder"));
            }
            if (this.tagTranslatedItems && (this.translatedItemTagName == null || this.translatedItemTagName.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.MissingTranslatedItemTagName"));
            }
            if (this.tagFailedItems && (this.failedItemTagName == null || this.failedItemTagName.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.MissingFailedItemTagName"));
            }
            if (this.tagUnsupportedLanguageItems && (this.unsupportedLanguageItemTagName == null || this.unsupportedLanguageItemTagName.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VeritoneTranslateItemsOperation.Prerequisites.MissingUnsupportedLanguageItemTagName"));
            }
        }
        return prerequisites;
    }
}

