/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.ThreadPoolUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.veritone.VeritoneTranslationEngine;
import com.nuix.automate.utils.models.internal.veritone.output.JobOutput;
import com.nuix.automate.utils.models.internal.veritone.output.TranslationJobOutputContents;
import com.nuix.automate.utils.models.internal.veritone.payload.TaskPayload;
import com.nuix.automate.utils.models.internal.veritone.request.CreateJobRequest;
import com.nuix.automate.utils.models.internal.veritone.response.CreateJobResponse;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.workflow.core.execution.operations.VeritoneTranslateItemsOperation;
import com.nuix.automate.workflow.core.execution.operations.VeritoneTranslateOperation;
import com.nuix.automate.workflow.core.execution.options.veritone.ItemVeritoneJob;
import com.nuix.automate.workflow.core.execution.options.veritone.SourceLanguageProvider;
import com.nuix.automate.workflow.core.execution.options.veritone.VeritoneJobSaveAs;
import com.nuix.automate.workflow.core.nuix.DummyParallelProcessingConfigurable;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import com.nuix.automate.workflow.core.utils.veritone.VeritoneOperationException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import nuix.BatchLoadDetails;
import nuix.BulkAnnotater;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.ItemModifier;
import nuix.ProcessedItem;
import nuix.ProcessingJob;
import nuix.Processor;
import nuix.SimpleCase;
import nuix.Text;

public class VeritoneTranslateItemsOperationImplementation
extends VeritoneTranslateOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VeritoneTranslateItemsOperation.class);
    public String scope;
    public SourceLanguageProvider sourceLanguageProvider;
    public boolean fallbackToExplicitSourceLanguageIfNoneDetected;
    public String explicitSourceLanguage;
    public String targetLanguage;
    public boolean trimBodyTextEnabled;
    public int trimBodyTextAt;
    public VeritoneJobSaveAs saveResultAs;
    public boolean replaceText;
    public String customMetadataName;
    public String outputFolder;
    public boolean tagTranslatedItems;
    public String translatedItemTagName;
    public boolean untagNonTranslatedItems;
    public boolean tagFailedItems;
    public String failedItemTagName;
    public boolean untagSuccessfulItems;
    public boolean tagUnsupportedLanguageItems;
    public String unsupportedLanguageItemTagName;
    public boolean untagSupportedLanguageItems;
    private transient Set<Item> translatedItems;
    private transient Set<Item> failedItems;
    private transient Set<Item> unsupportedItems;
    private transient AtomicLong itemsTextTrimmed;
    private transient AtomicLong itemsWithoutText;
    private transient AtomicLong itemsWithTargetLanguage;
    private transient String tempTag;
    private transient String textSeparator;
    private transient Path translationResultsDirectory;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);
    private transient Integer workerMemory = null;

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.stageCount = 1.2;
            this.stageId = 0.0;
            this.stageName = this.iu.getString("VeritoneTranslateItemsOperation.Stage.PreparingItems");
            this.translatedItems = ConcurrentHashMap.newKeySet();
            this.failedItems = ConcurrentHashMap.newKeySet();
            this.unsupportedItems = ConcurrentHashMap.newKeySet();
            this.itemsTextTrimmed = new AtomicLong();
            this.itemsWithoutText = new AtomicLong();
            this.itemsWithTargetLanguage = new AtomicLong();
            this.initialize();
            this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.SourceLanguageProvider", (Object)this.sourceLanguageProvider.toLocalizedString()));
            if (this.sourceLanguageProvider == SourceLanguageProvider.EXPLICIT) {
                this.explicitSourceLanguage = this.executionContext.evalParameters(this.explicitSourceLanguage, this);
                this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.ExplicitSourceLanguage", (Object)this.explicitSourceLanguage));
            } else if (this.fallbackToExplicitSourceLanguageIfNoneDetected) {
                this.explicitSourceLanguage = this.executionContext.evalParameters(this.explicitSourceLanguage, this);
                this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.FallbackSourceLanguage", (Object)this.explicitSourceLanguage));
            }
            this.targetLanguage = this.executionContext.evalParameters(this.targetLanguage, this);
            this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.TargetLanguage", (Object)this.targetLanguage));
            this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.VeritoneJobSaveAs", (Object)this.saveResultAs.toLocalizedString()));
            if (this.trimBodyTextEnabled) {
                this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.TrimBodyTextAt", (Object)this.trimBodyTextAt));
            }
            try {
                this.textSeparator = this.executionContext.evalParametersIfSet("{veritone_translation_append_separator}", this);
            }
            catch (ParameterException parameterException) {
                // empty catch block
            }
            if (this.textSeparator == null) {
                this.textSeparator = "\n---\n";
            } else {
                this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.TranslatedTextCustomAppendSeparator", (Object)this.textSeparator));
            }
            switch (this.saveResultAs) {
                case ITEM_TEXT: {
                    this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.TextModifications", (Object)(this.replaceText ? "Overwrite" : "Append text")));
                    break;
                }
                case CUSTOM_METADATA: {
                    this.customMetadataName = this.executionContext.evalParameters(this.customMetadataName, this);
                    this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.CustomMetadataName", (Object)this.customMetadataName));
                    break;
                }
                case CHILD_ITEM: {
                    this.setWorkerSettings();
                    NuixWorkerUtils.verifyWorkerSettings(this.executionContext, this);
                    this.initializeProcessingProfileBuilder();
                    this.setTimeZoneSettings();
                    this.setLocaleSettings();
                    this.processor = this.createProcessor();
                    this.outputFolder = this.executionContext.evalParameters(this.outputFolder, this);
                    this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.OutputFolder", (Object)this.outputFolder));
                    this.translationResultsDirectory = Paths.get(this.outputFolder, new String[0]);
                    if (Files.notExists(this.translationResultsDirectory, new LinkOption[0])) {
                        LOGGER.info("Creating directory for translation results");
                        Files.createDirectories(this.translationResultsDirectory, new FileAttribute[0]);
                    }
                    if (FileUtils.isDirectoryEmpty((Path)this.translationResultsDirectory)) break;
                    throw new VeritoneOperationException(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Error.OutputFolderNotEmpty", (Object)this.translationResultsDirectory));
                }
            }
            this.scope = this.executionContext.evalParameters(this.scope, this);
            String scopeWithTextQuery = NuixUtils.addAndQuery(this.scope, "has-text:1");
            LOGGER.info("Searching Nuix case with scope query: " + scopeWithTextQuery);
            this.addExecutionLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Log.ScopeQuery", (Object)scopeWithTextQuery));
            Set scopeItems = this.executionContext.nuixCase.searchUnsorted(scopeWithTextQuery);
            this.addExecutionLog(this.iu.getNumeralString("VeritoneTranslateItemsOperation.Log.ScopeCount", (long)scopeItems.size()));
            if (scopeItems.isEmpty()) {
                this.addWarning(this.iu.getString("VeritoneTranslateItemsOperation.Warning.EmptyScopeItems"));
                return;
            }
            this.tempTag = "Automate|System|Run|Veritone|" + String.valueOf(UUID.randomUUID());
            LOGGER.info("Tagging " + scopeItems.size() + " items with tag " + this.tempTag);
            this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, (Collection)scopeItems);
            if (this.stopRequested) {
                this.trackStopped();
                return;
            }
            this.stageId = 0.2;
            this.stageName = this.iu.getString("VeritoneTranslateItemsOperation.Stage.RunningVeritoneTranslations");
            this.stageItems = scopeItems.size();
            this.processedItems = new AtomicLong();
            AtomicReference exception = new AtomicReference();
            this.executionContext.nuixCase.withWriteAccess(() -> {
                LOGGER.info("Starting veritone translation jobs, with " + this.veritoneService.getParallelJobSubmissions() + " in parallel");
                ThreadPoolExecutor translationJobThreadPool = ThreadPoolUtils.createTimeoutThreadPool((String)"VeritoneJobThreadPool", (int)this.veritoneService.getParallelJobSubmissions());
                ArrayList<Future> translationTaskFutures = new ArrayList<Future>();
                try {
                    this.jobId = this.executionContext.getEngine().getJobId();
                    this.jobFilesDirectory = this.executionContext.getJobFilesDirectory(this.jobId);
                    LOGGER.info("Creating job " + this.jobId + " files directory " + String.valueOf(this.jobFilesDirectory.toAbsolutePath()));
                    Files.createDirectories(this.jobFilesDirectory, new FileAttribute[0]);
                    for (Item item : scopeItems) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        Future<?> taskFuture = translationJobThreadPool.submit(() -> {
                            ItemTranslationJob translationJob = this.filterAndGetItemTranslationRequest(item);
                            if (translationJob != null) {
                                try {
                                    this.translateItem(translationJob);
                                    this.translatedItems.add(item);
                                    this.processedItems.incrementAndGet();
                                    this.clearItemVeritoneMetadata(item, "System|Error");
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error running veritone job " + translationJob.getJobId() + " for item " + item.getGuid(), (Throwable)e);
                                    this.failedItems.add(item);
                                    this.addOperationRunningLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.RunningLog.ErrorRunningVeritoneTranslation", new Object[]{translationJob.getJobId(), item.getGuid(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                                    this.setItemVeritoneMetadata(item, "System|Error", this.iu.getFormattedString("VeritoneTranslateItemsOperation.ErrorRunningItemTranslation", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                                }
                            }
                        });
                        translationTaskFutures.add(taskFuture);
                    }
                    while (!translationTaskFutures.isEmpty()) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        Thread.sleep((long)this.operationPollingDelay * 1000L);
                        translationTaskFutures.removeIf(Future::isDone);
                    }
                }
                catch (Exception e) {
                    exception.set(e);
                }
                finally {
                    try {
                        translationJobThreadPool.shutdownNow();
                        translationJobThreadPool.awaitTermination(60L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error shutting down Veritone jobs threadPool");
                    }
                    if (this.jobId != null && this.jobFilesDirectory != null) {
                        LOGGER.info("Clearing job " + this.jobId + " files directory " + String.valueOf(this.jobFilesDirectory));
                        try {
                            FileUtils.deleteRecursively((Path)this.jobFilesDirectory);
                        }
                        catch (IOException e) {
                            exception.set(e);
                        }
                    }
                }
            });
            if (exception.get() != null) {
                throw (Exception)exception.get();
            }
            this.addExecutionLog(this.iu.getNumeralFormattedString("VeritoneTranslateItemsOperation.Log.TranslatedItems", (long)this.translatedItems.size(), new Object[]{this.explicitSourceLanguage, this.targetLanguage}));
            if (!this.failedItems.isEmpty()) {
                this.addWarning(this.iu.getNumeralString("VeritoneTranslateItemsOperation.Warning.FailedItems", (long)this.failedItems.size()));
            }
            if (this.itemsTextTrimmed.get() > 0L) {
                this.addWarning(this.iu.getNumeralString("VeritoneTranslateItemsOperation.Warning.ItemBodyTrimmed", this.itemsTextTrimmed.get()));
            }
            if (this.itemsWithoutText.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("VeritoneTranslateItemsOperation.Log.SkippedItemsWithoutText", this.itemsWithoutText.get()));
            }
            if (!this.unsupportedItems.isEmpty()) {
                this.addExecutionLog(this.iu.getNumeralString("VeritoneTranslateItemsOperation.Log.SkippedUnsupportedItems", (long)this.unsupportedItems.size()));
            }
            if (this.itemsWithTargetLanguage.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("VeritoneTranslateItemsOperation.Log.SkippedItemsThatMatchedTargetLanguage", this.itemsWithTargetLanguage.get()));
            }
            if (this.stopRequested) {
                this.trackStopped();
                return;
            }
            this.stageId = 1.0;
            this.stageName = this.iu.getString("VeritoneTranslateItemsOperation.Stage.TaggingItems");
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            if (this.tagTranslatedItems) {
                if (!this.translatedItems.isEmpty()) {
                    this.tagItems(bulkAnnotater, this.translatedItems, this.translatedItemTagName);
                }
                if (this.untagNonTranslatedItems) {
                    this.untagItems(bulkAnnotater, this.translatedItems, this.translatedItemTagName, this.tempTag);
                }
            }
            if (this.tagFailedItems) {
                if (!this.failedItems.isEmpty()) {
                    this.tagItems(bulkAnnotater, this.failedItems, this.failedItemTagName);
                }
                if (this.untagSuccessfulItems) {
                    this.untagItems(bulkAnnotater, this.failedItems, this.failedItemTagName, this.tempTag);
                }
            }
            if (this.tagUnsupportedLanguageItems) {
                if (!this.unsupportedItems.isEmpty()) {
                    this.tagItems(bulkAnnotater, this.unsupportedItems, this.unsupportedLanguageItemTagName);
                }
                if (this.untagSupportedLanguageItems) {
                    this.untagItems(bulkAnnotater, this.unsupportedItems, this.unsupportedLanguageItemTagName, this.tempTag);
                }
            }
            if (!this.translatedItems.isEmpty() && this.saveResultAs == VeritoneJobSaveAs.CHILD_ITEM) {
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.stageId = 1.2;
                this.stageName = this.iu.getString("VeritoneTranslateItemsOperation.Stage.AddingChildItems");
                this.stageItems = this.translatedItems.size();
                this.processedItems.set(0L);
                try {
                    this.setConfigurationProfileSettings();
                    HashMap<String, Object> overWritingParallelProcessingSettings = new HashMap<String, Object>();
                    if (this.executionContext.jobBrokerIp != null) {
                        this.addExecutionLog(this.iu.getFormattedString("General.Log.JobRemoteBroker", (Object)(this.executionContext.jobBrokerIp + ":" + this.executionContext.jobBrokerPort)));
                        overWritingParallelProcessingSettings.put("workerBrokerAddress", this.executionContext.jobBrokerIp + ":" + this.executionContext.jobBrokerPort);
                    }
                    this.setProcessingProfileSettings(overWritingParallelProcessingSettings);
                    this.setWorkerParallelSettings(overWritingParallelProcessingSettings);
                    this.applyProcessingProfile();
                    this.printMemoryUsed("Memory used before start");
                    this.loadProcessingJob = this.processor.processAsync();
                    String processingJobGuid = this.loadProcessingJob.getJobGuid().replace("-", "");
                    LOGGER.info("Job Guid: " + processingJobGuid);
                    NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.loadProcessingJob, this.addedWorkerCount);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot start processing", (Throwable)e);
                    try {
                        if (this.loadProcessingJob != null) {
                            LOGGER.info("Attempting to stop job");
                            this.loadProcessingJob.stop();
                        }
                    }
                    catch (Exception e2) {
                        LOGGER.warn("Cannot stop job", (Throwable)e2);
                    }
                    throw new VeritoneOperationException(this.iu.getFormattedString("VeritoneTranslateItemsOperation.Error.CannotStartProcessing", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                }
                NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.loadProcessingJob);
                this.handleLoadProcessingJobFinish();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateItem(ItemTranslationJob translationJob) throws IOException, InterruptedException {
        Item item = translationJob.getItem();
        try {
            CreateJobResponse createJobResponse = this.createVeritoneJob(translationJob);
            String veritoneJobId = (String)createJobResponse.getInternalJobIds().get(0);
            translationJob.setJobId(veritoneJobId);
            this.veritoneRestClient.waitForJob(translationJob, this.operationPollingDelay);
            List<JobOutput> jobOutputs = this.veritoneRestClient.getJobOutputs(veritoneJobId);
            StringBuilder translatedText = new StringBuilder();
            for (JobOutput jobOutput : jobOutputs) {
                if (translatedText.length() > 0) {
                    translatedText.append("\n").append(this.textSeparator).append("\n");
                }
                TranslationJobOutputContents outputContents = (TranslationJobOutputContents)SerializationUtils.fromJson((String)jobOutput.getContents(), TranslationJobOutputContents.class);
                for (TranslationJobOutputContents.ContentsObject contents : outputContents.getObject()) {
                    if (!contents.getType().equalsIgnoreCase("text")) continue;
                    String normalizedText = this.normalizeTranslationResult(contents.getText());
                    translatedText.append(normalizedText);
                }
            }
            String translationResult = translatedText.toString();
            String runningLogKey = "";
            switch (this.saveResultAs) {
                case ITEM_TEXT: {
                    Object resultingItemText;
                    if (this.replaceText) {
                        resultingItemText = translationResult;
                        runningLogKey = "TranslationResultReplacedText";
                    } else {
                        String itemText = translationJob.getItemText();
                        resultingItemText = itemText + "\n" + this.textSeparator + "\n" + translationResult;
                        runningLogKey = "TranslationResultAppendedText";
                    }
                    item.modify(arg_0 -> VeritoneTranslateItemsOperationImplementation.lambda$translateItem$3((String)resultingItemText, arg_0));
                    break;
                }
                case CUSTOM_METADATA: {
                    item.getCustomMetadata().put((Object)this.customMetadataName, (Object)translationResult);
                    runningLogKey = "TranslationResultAddedAsCustomMetadata";
                    break;
                }
                case CHILD_ITEM: {
                    this.stageCount = 2.0;
                    Path translationResultDir = this.translationResultsDirectory.resolve(item.getGuid());
                    Path translationResultFilePath = translationResultDir.resolve(this.targetLanguage + ".txt");
                    Files.createDirectories(translationResultDir, new FileAttribute[0]);
                    Files.write(translationResultFilePath, translationResult.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                    this.processor.addChildItems(item, Collections.singletonList(translationResultFilePath));
                    runningLogKey = "TranslationResultAddingAsChildItem";
                }
            }
            this.addOperationRunningLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.RunningLog." + runningLogKey, (Object)item.getGuid()));
        }
        finally {
            this.veritoneRestClient.cancelJobIfRunning(translationJob);
            Path itemTextFilePath = this.jobFilesDirectory.resolve(translationJob.getFileName());
            FileUtils.deleteRecursively((Path)itemTextFilePath);
        }
    }

    private ItemTranslationJob filterAndGetItemTranslationRequest(Item item) {
        String itemLanguage;
        String nuixDetectedLanguage = item.getLanguage();
        String itemText = this.getItemText(item);
        if (itemText == null || itemText.trim().isEmpty()) {
            LOGGER.info("Skipping item " + item.getGuid() + ", has no text content");
            this.itemsWithoutText.incrementAndGet();
            return null;
        }
        if (nuixDetectedLanguage != null && nuixDetectedLanguage.equalsIgnoreCase(this.targetLanguage)) {
            LOGGER.info("Skipping item " + item.getGuid() + ", item language " + nuixDetectedLanguage + " matches the target language");
            this.itemsWithTargetLanguage.incrementAndGet();
            return null;
        }
        if (this.sourceLanguageProvider == SourceLanguageProvider.NUIX_DETECTED_LANGUAGE) {
            itemLanguage = nuixDetectedLanguage;
            if ((itemLanguage == null || itemLanguage.trim().isEmpty()) && this.fallbackToExplicitSourceLanguageIfNoneDetected) {
                LOGGER.info("Could not detect item language for " + item.getGuid() + " using fallback explicit source language");
                itemLanguage = this.explicitSourceLanguage;
            }
        } else {
            itemLanguage = this.explicitSourceLanguage;
        }
        if (itemLanguage == null || itemLanguage.trim().isEmpty()) {
            this.unsupportedItems.add(item);
            return null;
        }
        String translationKey = VeritoneTranslationEngine.getKey((String[])new String[]{itemLanguage, this.targetLanguage});
        VeritoneTranslationEngine translationEngine = (VeritoneTranslationEngine)this.translationEngineMap.get(translationKey);
        if (!this.translationEngineMap.containsKey(translationKey)) {
            LOGGER.info("Skipping item " + item.getGuid() + ", did not find translation engine for source to target language: " + translationKey);
            this.unsupportedItems.add(item);
            return null;
        }
        ItemTranslationJob translationRequest = new ItemTranslationJob(item);
        translationRequest.setItemText(itemText);
        translationRequest.setEngineId(translationEngine.getId());
        return translationRequest;
    }

    private synchronized CreateJobResponse createVeritoneJob(ItemTranslationJob translationJob) throws IOException {
        Item item = translationJob.getItem();
        String itemText = translationJob.getItemText();
        String engineId = translationJob.getEngineId();
        String itemTextFileName = translationJob.getFileName();
        Path itemTextFilePath = this.jobFilesDirectory.resolve(itemTextFileName);
        Files.write(itemTextFilePath, itemText.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        CreateJobRequest jobRequest = new CreateJobRequest();
        CreateJobRequest.CreateJobDetail job = this.veritoneRestClient.buildTranslationJobDetail();
        jobRequest.setJobs(Collections.singletonList(job));
        TaskPayload taskPayload = new TaskPayload();
        taskPayload.setUrl(this.veritoneRestClient.createFileDownloadUrl(this.jobId, itemTextFileName));
        CreateJobRequest.CreateTaskDetail translationTask = (CreateJobRequest.CreateTaskDetail)job.getTasks().get(0);
        translationTask.setEngineId(engineId);
        translationTask.setTaskPayloadJSON(SerializationUtils.toJson((Object)taskPayload));
        CreateJobRequest.CreateTaskDetail owTask = (CreateJobRequest.CreateTaskDetail)job.getTasks().get(1);
        owTask.setEngineId(this.veritoneService.getOwEngine().getId());
        CreateJobResponse createJobResponse = this.veritoneRestClient.createJobs(jobRequest);
        String veritoneJobId = (String)createJobResponse.getInternalJobIds().get(0);
        LOGGER.info("Created Veritone job " + veritoneJobId + " for item " + item.getGuid());
        this.addOperationRunningLog(this.iu.getFormattedString("VeritoneTranslateItemsOperation.RunningLog.StartedVeritoneJobForItem", new Object[]{veritoneJobId, item.getGuid()}));
        return createJobResponse;
    }

    private String normalizeTranslationResult(String text) {
        return text;
    }

    private void tagItems(BulkAnnotater bulkAnnotater, Set<Item> items, String tagName) throws IOException {
        LOGGER.info("Tagging " + items.size() + " items with tag " + tagName);
        bulkAnnotater.addTag(tagName, items);
        this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)items.size(), (Object)tagName));
    }

    private void untagItems(BulkAnnotater bulkAnnotater, Set<Item> itemsToKeep, String tagName, String tempTag) throws IOException {
        String scopeItemsWithTagQuery = NuixUtils.addAndQuery("tag:\"" + tagName + "\"", "tag:\"" + tempTag + "\"");
        LOGGER.info("Searching for items with query: " + scopeItemsWithTagQuery);
        Set scopeItemsWithTag = this.executionContext.nuixCase.searchUnsorted(scopeItemsWithTagQuery);
        Set itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)scopeItemsWithTag, itemsToKeep);
        if (!itemsToUntag.isEmpty()) {
            LOGGER.info("Untagging " + itemsToUntag.size() + " items with tag " + tagName);
            bulkAnnotater.removeTag(tagName, (Collection)itemsToUntag);
            this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUntag.size(), (Object)tagName));
        }
    }

    private void cleanUpTempTag(String tempTag) {
        if (tempTag == null || tempTag.isEmpty()) {
            return;
        }
        try {
            LOGGER.info("Searching for tag:" + tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + tempTag + "\"");
            if (!taggedItems.isEmpty()) {
                LOGGER.info("Removing tag " + tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + tempTag);
            this.executionContext.nuixCase.deleteTag(tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.cleanUpTempTag(this.tempTag);
    }

    private Processor createProcessor() throws Exception {
        SimpleCase simpleCase = NuixUtils.getSimpleCase(this.executionContext.nuixCase);
        Processor processor = simpleCase.createProcessor();
        processor.whenItemProcessed(this::itemProcessed);
        processor.getProcessingSettings().put("calculateAuditedSize", true);
        return processor;
    }

    private void itemProcessed(ProcessedItem processedItem) {
        this.processedItems.incrementAndGet();
        if (this.loadProcessingJob != null) {
            try {
                this.trackVolumeProcessed(this.loadProcessingJob.getBytesProcessed());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Processed", (Object)String.join((CharSequence)"/", processedItem.getPath())));
        this.trackItemProcessedIrregular(processedItem.getMimeType(), processedItem.isCorrupted(), processedItem.isEncrypted(), processedItem.isDeleted());
    }

    private void handleLoadProcessingJobFinish() {
        this.printMemoryUsed("Memory used after finish");
        long loadedItems = 0L;
        for (BatchLoadDetails batchLoadDetails : this.executionContext.nuixCase.getBatchLoads()) {
            if (!batchLoadDetails.getBatchId().equals(this.loadProcessingJob.getJobGuid())) continue;
            try {
                loadedItems = batchLoadDetails.getItems().size();
            }
            catch (IOException e) {
                LOGGER.error("Error handling loadedItems", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Warning.UnexpectedError", (Object)e.getLocalizedMessage()));
            }
        }
        System.gc();
        this.printMemoryUsed("Memory used after clean-up");
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.ProcessingMode", (Object)this.loadProcessingJob.getProcessingMode()));
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.TraversedCount", (Object)this.iu.getNumeralString("General.Count.Items", Math.max(this.processedItems.get(), this.loadProcessingJob.getItemsProcessed()))));
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.TraversedSize", (Object)FormattingUtils.sizeToDisplaySize((long)this.loadProcessingJob.getBytesProcessed())));
        if (loadedItems > 0L) {
            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.LoadedCount", (Object)this.iu.getNumeralString("General.Count.Items", loadedItems)));
        }
        String batchLoadGuid = this.loadProcessingJob.getJobGuid();
        this.utilizationScopeQuery = "batch-load-guid:(" + batchLoadGuid + ")";
        this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.BatchLoadGuid", (Object)this.loadProcessingJob.getJobGuid()));
    }

    private String getItemText(Item item) {
        try {
            Text itemTextObject = item.getTextObject();
            if (itemTextObject != null && itemTextObject.isAvailable()) {
                if (this.trimBodyTextEnabled) {
                    StringBuilder itemTextBuilder = new StringBuilder();
                    boolean bodyTextTrimmed = (Boolean)itemTextObject.usingText(reader -> !ItemsUtils.copyItemText(reader, itemTextBuilder, (long)this.trimBodyTextAt, "\n[Text Trimmed]"));
                    if (bodyTextTrimmed) {
                        this.itemsTextTrimmed.incrementAndGet();
                        this.setItemVeritoneMetadata(item, "System|Warning", this.iu.getString("VeritoneTranslateItemsOperation.ItemBodyTextTrimmed"));
                    } else {
                        this.clearItemVeritoneMetadata(item, "System|Warning");
                    }
                    return itemTextBuilder.toString();
                }
                return itemTextObject.toString();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error getting item " + item.getGuid() + " text", (Throwable)e);
        }
        return null;
    }

    private void setItemVeritoneMetadata(Item item, String name, String value) {
        String effectiveName = "Veritone|" + name;
        ItemCustomMetadataMap customMetadata = item.getCustomMetadata();
        customMetadata.remove((Object)effectiveName);
        customMetadata.put((Object)effectiveName, (Object)value);
    }

    private void clearItemVeritoneMetadata(Item item, String name) {
        String effectiveName = "Veritone|" + name;
        ItemCustomMetadataMap customMetadata = item.getCustomMetadata();
        customMetadata.remove((Object)effectiveName);
    }

    private void printMemoryUsed(String message) {
        long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        LOGGER.info(message + ": " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
    }

    @Override
    protected double getPercentageComplete() {
        return this.getProcessedItemsPercentageComplete(0.2, 0.8);
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && !this.stageName.isEmpty()) {
            result = (String)result + " / " + this.stageName;
        }
        if (this.stageItems > 0L) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            if (this.stageId == 0.2 || this.stageId == 1.2) {
                result = (String)result + this.iu.getNumeralString("VeritoneTranslateItemsOperation.Progress.ItemsProcessed", this.processedItems.get());
            }
        }
        return result;
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.VERITONE_TRANSLATE_ITEMS;
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        if (this.workerMemory != null) {
            return this.workerMemory;
        }
        try {
            DummyParallelProcessingConfigurable configurable = new DummyParallelProcessingConfigurable();
            NuixWorkerUtils.setWorkerSettings(this.executionContext, this, configurable, false);
            this.workerMemory = Integer.parseInt(String.valueOf(configurable.getParallelProcessingSettings().get("workerMemory")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }

    private static /* synthetic */ void lambda$translateItem$3(String resultingItemText, ItemModifier itemModifier) {
        itemModifier.replaceText(resultingItemText);
    }

    private static class ItemTranslationJob
    extends ItemVeritoneJob {
        String itemText;

        public ItemTranslationJob(Item item) {
            super(item);
        }

        @Override
        public String getFileName() {
            return this.item.getGuid();
        }

        public String getItemText() {
            return this.itemText;
        }

        public void setItemText(String itemText) {
            this.itemText = itemText;
        }
    }
}

