/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.genaichain;

import java.util.ArrayList;
import java.util.List;

public class StepTrace {
    private String stepType;
    private String description;
    private String input;
    private String settings;
    private String prompt;
    private String service;
    private String model;
    private Long startEpoch;
    private Long durationMs;
    private Long cpuTimeMs;
    private Integer promptTokens;
    private Integer responseTokens;
    private String log;
    private String exceptionStackTrace;
    private List<List<StepTrace>> subStepsTraces;
    private StepTrace assemblyStepTrace;
    private Integer outputLength;
    private String output;

    public StepTrace() {
    }

    public StepTrace(StepTrace stepTrace) {
        this.description = stepTrace.getDescription();
        this.startEpoch = stepTrace.getStartEpoch();
        this.durationMs = stepTrace.getDurationMs();
        this.cpuTimeMs = stepTrace.getCpuTimeMs();
        this.promptTokens = stepTrace.getPromptTokens();
        this.responseTokens = stepTrace.getResponseTokens();
        this.input = stepTrace.getInput();
        this.outputLength = stepTrace.getOutputLength();
        this.output = stepTrace.getOutput();
        this.stepType = stepTrace.getStepType();
        this.settings = stepTrace.getSettings();
        this.log = stepTrace.getLog();
        this.exceptionStackTrace = stepTrace.getExceptionStackTrace();
        if (stepTrace.subStepsTraces != null) {
            this.subStepsTraces = new ArrayList<List<StepTrace>>();
            for (List<StepTrace> subStepsTrace : stepTrace.getSubStepsTraces()) {
                ArrayList<StepTrace> subStepsTraceCopy = new ArrayList<StepTrace>();
                for (StepTrace subStepTrace : subStepsTrace) {
                    subStepsTraceCopy.add(new StepTrace(subStepTrace));
                }
                this.subStepsTraces.add(subStepsTraceCopy);
            }
        }
        if (stepTrace.getAssemblyStepTrace() != null) {
            this.assemblyStepTrace = new StepTrace(stepTrace.getAssemblyStepTrace());
        }
    }

    public void trim(int maxLength) {
        if (this.input != null && this.input.length() > maxLength) {
            this.input = this.input.substring(0, maxLength) + " ... (more)";
        }
        if (this.output != null && this.output.length() > maxLength) {
            this.output = this.output.substring(0, maxLength) + " ... (more)";
        }
        if (this.log != null && this.log.length() > maxLength) {
            this.log = this.log.substring(0, maxLength) + " ... (more)";
        }
        if (this.subStepsTraces != null) {
            for (List<StepTrace> subStepsTrace : this.subStepsTraces) {
                for (StepTrace subStepTrace : subStepsTrace) {
                    subStepTrace.trim(maxLength);
                }
            }
        }
    }

    public void setStepType(String stepType) {
        this.stepType = stepType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setSettings(String settings) {
        this.settings = settings;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setStartEpoch(Long startEpoch) {
        this.startEpoch = startEpoch;
    }

    public void setDurationMs(Long durationMs) {
        this.durationMs = durationMs;
    }

    public void setCpuTimeMs(Long cpuTimeMs) {
        this.cpuTimeMs = cpuTimeMs;
    }

    public void setPromptTokens(Integer promptTokens) {
        this.promptTokens = promptTokens;
    }

    public void setResponseTokens(Integer responseTokens) {
        this.responseTokens = responseTokens;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setExceptionStackTrace(String exceptionStackTrace) {
        this.exceptionStackTrace = exceptionStackTrace;
    }

    public void setSubStepsTraces(List<List<StepTrace>> subStepsTraces) {
        this.subStepsTraces = subStepsTraces;
    }

    public void setAssemblyStepTrace(StepTrace assemblyStepTrace) {
        this.assemblyStepTrace = assemblyStepTrace;
    }

    public void setOutputLength(Integer outputLength) {
        this.outputLength = outputLength;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getStepType() {
        return this.stepType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInput() {
        return this.input;
    }

    public String getSettings() {
        return this.settings;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getService() {
        return this.service;
    }

    public String getModel() {
        return this.model;
    }

    public Long getStartEpoch() {
        return this.startEpoch;
    }

    public Long getDurationMs() {
        return this.durationMs;
    }

    public Long getCpuTimeMs() {
        return this.cpuTimeMs;
    }

    public Integer getPromptTokens() {
        return this.promptTokens;
    }

    public Integer getResponseTokens() {
        return this.responseTokens;
    }

    public String getLog() {
        return this.log;
    }

    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public List<List<StepTrace>> getSubStepsTraces() {
        return this.subStepsTraces;
    }

    public StepTrace getAssemblyStepTrace() {
        return this.assemblyStepTrace;
    }

    public Integer getOutputLength() {
        return this.outputLength;
    }

    public String getOutput() {
        return this.output;
    }
}

