/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.genaichain.implementation;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.GenAiChainOperationImplementation;
import com.nuix.automate.workflow.core.execution.options.genaichain.Chain;
import com.nuix.automate.workflow.core.execution.options.genaichain.ChainExecutor;
import com.nuix.automate.workflow.core.execution.options.genaichain.ChainOutput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepInput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepOutput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepTrace;
import com.nuix.automate.workflow.core.execution.options.genaichain.step.SplitContentStep;
import java.util.ArrayList;
import java.util.List;
import nuix.Item;

public class SplitContentStepImplementation
extends SplitContentStep {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SplitContentStepImplementation.class);

    @Override
    public StepOutput execute(StepInput input, Item item, GenAiChainOperationImplementation genAiChainOperation) {
        if (this.maxSize == null && this.separator == null) {
            throw new IllegalStateException("Either maxSize or separator must be defined");
        }
        if (this.maxSize != null && this.separator != null) {
            throw new IllegalStateException("Only one of maxSize or separator must be defined");
        }
        StepOutput stepOutput = new StepOutput();
        StepTrace trace = new StepTrace();
        trace.setSubStepsTraces(new ArrayList<List<StepTrace>>());
        stepOutput.setTrace(trace);
        String lastOutput = input.getPreviousOutputs().get(input.getPreviousOutputs().size() - 1);
        ArrayList<ChainOutput> chainOutputs = new ArrayList<ChainOutput>();
        if (this.maxSize != null) {
            String[] lines = lastOutput.split("\\r?\\n");
            Object chunk = new StringBuilder();
            for (String line : lines) {
                if (((StringBuilder)chunk).length() > 0 && ((StringBuilder)chunk).length() + line.length() > this.maxSize) {
                    chainOutputs.add(this.handleChunk(input, ((StringBuilder)chunk).toString(), item, genAiChainOperation));
                    chunk = new StringBuilder();
                }
                ((StringBuilder)chunk).append("\n");
                ((StringBuilder)chunk).append(line);
            }
            if (((StringBuilder)chunk).length() > 0) {
                chainOutputs.add(this.handleChunk(input, ((StringBuilder)chunk).toString(), item, genAiChainOperation));
            }
        } else if (this.separator != null) {
            String[] chunks = lastOutput.split(this.separator);
            for (String chunk : chunks) {
                String trimmedChunk = chunk.trim();
                if (trimmedChunk.isEmpty()) continue;
                chainOutputs.add(this.handleChunk(input, trimmedChunk, item, genAiChainOperation));
            }
        } else {
            throw new IllegalStateException("Unsupported splitting method");
        }
        StepInput assemblyInput = new StepInput();
        assemblyInput.setPreviousOutputs(new ArrayList<String>());
        for (ChainOutput chainOutput : chainOutputs) {
            if (chainOutput.getOutput() != null) {
                assemblyInput.getPreviousOutputs().add(chainOutput.getOutput());
            }
            trace.getSubStepsTraces().add(chainOutput.getChainTrace().getStepsTraces());
        }
        StepOutput assemblyOutput = ChainExecutor.getInstance().executeStep(this.assembly, assemblyInput, item, genAiChainOperation);
        trace.setAssemblyStepTrace(assemblyOutput.getTrace());
        stepOutput.setOutput(assemblyOutput.getOutput());
        return stepOutput;
    }

    private ChainOutput handleChunk(StepInput input, String chunk, Item item, GenAiChainOperationImplementation genAiChainOperation) {
        StepInput subChainInput = new StepInput(input);
        subChainInput.getPreviousOutputs().add(chunk);
        Chain subChain = new Chain();
        subChain.setSteps(this.steps);
        return ChainExecutor.getInstance().execute(subChainInput, subChain, item, genAiChainOperation);
    }
}

