/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.genaichain.step;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.workflow.core.execution.operations.GenAiChainOperation;
import com.nuix.automate.workflow.core.execution.operations.GenAiChainOperationImplementation;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepInput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepOutput;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import java.util.ArrayList;
import java.util.Collections;
import nuix.Item;
import org.apache.commons.lang3.NotImplementedException;

public abstract class ChainStep {
    private String description;

    public StepOutput execute(StepInput input, Item item, GenAiChainOperationImplementation genAiChainOperation) {
        throw new NotImplementedException("Cannot run abstract step");
    }

    public String evaluateParameter(String value, StepInput input, GenAiChainOperation genAiChainOperation) {
        ArrayList<String> previousOutputs = new ArrayList<String>(input.getPreviousOutputs());
        Collections.reverse(previousOutputs);
        ExecutionContext executionContext = genAiChainOperation.getExecutionContext();
        String result = value;
        try {
            result = executionContext.evalParameters(result, genAiChainOperation);
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        if (!previousOutputs.isEmpty()) {
            result = result.replace("{last_output}", (CharSequence)previousOutputs.get(0));
        }
        for (int i = 0; i < Math.min(9, previousOutputs.size()); ++i) {
            result = result.replace("{previous_output_" + i + "}", (CharSequence)previousOutputs.get(i));
        }
        return result;
    }

    public void simplifyForTrace() {
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }
}

