/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.itemset;

import com.nuix.automate.utils.general.LocalizableEnumUtils;

public enum InclusionStrategy {
    SELECTED_ITEMS{

        @Override
        public String toNuixString() {
            return "SELECTED_ITEMS";
        }
    }
    ,
    SELECTED_ITEMS_AND_DESCENDANTS{

        @Override
        public String toNuixString() {
            return "SELECTED_ITEMS_AND_DESCENDANTS";
        }
    }
    ,
    TOP_LEVEL_ITEMS{

        @Override
        public String toNuixString() {
            return "TOP_LEVEL_ITEMS";
        }
    }
    ,
    TOP_LEVEL_ITEMS_AND_DESCENDANTS{

        @Override
        public String toNuixString() {
            return "TOP_LEVEL_ITEMS_AND_DESCENDANTS";
        }
    };


    public String toString() {
        return LocalizableEnumUtils.getLocalizedString((Enum)this);
    }

    public static InclusionStrategy getInclusionStrategy(String nuixString) {
        switch (nuixString) {
            case "SELECTED_ITEMS": {
                return SELECTED_ITEMS;
            }
            case "SELECTED_ITEMS_AND_DESCENDANTS": {
                return SELECTED_ITEMS_AND_DESCENDANTS;
            }
            case "TOP_LEVEL_ITEMS": {
                return TOP_LEVEL_ITEMS;
            }
            case "TOP_LEVEL_ITEMS_AND_DESCENDANTS": {
                return TOP_LEVEL_ITEMS_AND_DESCENDANTS;
            }
        }
        return null;
    }

    public abstract String toNuixString();
}

