/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.metadatatosql;

import com.nuix.automate.workflow.core.execution.options.sqlcommand.SqlDatabase;
import com.nuix.automate.workflow.core.execution.options.sqlcommand.SqlPlatform;
import com.nuix.automate.workflow.core.utils.sql.BindMetadata;
import com.nuix.automate.workflow.core.utils.sql.MetadataPayload;
import java.util.List;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.stringtemplate4.UseStringTemplateEngine;

public interface MetadataToSqlDao {
    @SqlQuery(value="select 1")
    public int checkConnection();

    @SqlUpdate(value="create table [<databaseName>].[dbo].[<tableName>] (<columns>)")
    @UseStringTemplateEngine
    public int createMetadataTableMS(@Define(value="tableName") String var1, @Define(value="databaseName") String var2, @Define(value="columns") String var3);

    @SqlUpdate(value="create table \"<tableName>\" (<columns>)")
    @UseStringTemplateEngine
    public int createMetadataTablePG(@Define(value="tableName") String var1, @Define(value="databaseName") String var2, @Define(value="columns") String var3);

    default public void createMetadataTable(SqlPlatform platform, String tableName, String databaseName, String columns) {
        if (platform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL) {
            this.createMetadataTableMS(tableName, databaseName, columns);
        } else if (platform.getDatabaseType() == SqlDatabase.POSTGRES) {
            this.createMetadataTablePG(tableName, databaseName, columns);
        }
    }

    @SqlQuery(value="select count(*) from [<databaseName>].[dbo].[<tableName>]")
    @UseStringTemplateEngine
    public long getExistingRecordsCountMS(@Define(value="tableName") String var1, @Define(value="databaseName") String var2);

    @SqlQuery(value="select count(*) from \"<tableName>\"")
    @UseStringTemplateEngine
    public long getExistingRecordsCountPG(@Define(value="tableName") String var1, @Define(value="databaseName") String var2);

    default public long getExistingRecordsCount(SqlPlatform platform, String tableName, String databaseName) {
        if (platform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL) {
            return this.getExistingRecordsCountMS(tableName, databaseName);
        }
        if (platform.getDatabaseType() == SqlDatabase.POSTGRES) {
            return this.getExistingRecordsCountPG(tableName, databaseName);
        }
        return 0L;
    }

    @SqlBatch(value="insert into [<databaseName>].[dbo].[<tableName>] (<columns>) values (<columnValues>)")
    @UseStringTemplateEngine
    public int[] insertMetadataMS(@Define(value="tableName") String var1, @Define(value="databaseName") String var2, @Define(value="columns") String var3, @Define(value="columnValues") String var4, @BindMetadata List<MetadataPayload> var5);

    @SqlBatch(value="insert into \"<tableName>\" (<columns>) values (<columnValues>)")
    @UseStringTemplateEngine
    public int[] insertMetadataPG(@Define(value="tableName") String var1, @Define(value="databaseName") String var2, @Define(value="columns") String var3, @Define(value="columnValues") String var4, @BindMetadata List<MetadataPayload> var5);

    default public int[] insertMetadata(SqlPlatform platform, String tableName, String databaseName, String columnNames, String columnValues, List<MetadataPayload> payload) {
        if (platform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL) {
            this.insertMetadataMS(tableName, databaseName, columnNames, columnValues, payload);
        } else if (platform == SqlPlatform.POSTGRES_SQL) {
            this.insertMetadataPG(tableName, databaseName, columnNames, columnValues, payload);
        }
        return new int[0];
    }
}

