/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.purview;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.purview.DataSourceType;

public class CustodialDataSourceSubmission {
    @FormField
    private String custodianEmail;
    @FormField
    private DataSourceType type;
    @FormField
    private String value;
    @FormField
    private boolean includeMailbox;
    @FormField
    private boolean includeSite;
    @FormField
    private boolean includeTeams;

    public CustodialDataSourceSubmission() {
    }

    public CustodialDataSourceSubmission(String custodianEmail) {
        if (custodianEmail != null) {
            this.custodianEmail = custodianEmail.trim();
        }
    }

    public static CustodialDataSourceSubmission build(Object[] dataSourceLine) {
        String custodianEmail = (String)dataSourceLine[0];
        CustodialDataSourceSubmission submission = new CustodialDataSourceSubmission(custodianEmail);
        if (dataSourceLine.length > 1) {
            String type = (String)dataSourceLine[1];
            submission.setType(type);
        }
        if (dataSourceLine.length > 2) {
            String value = (String)dataSourceLine[2];
            submission.setValue(value);
        }
        if (dataSourceLine.length > 3) {
            String includeMailbox = (String)dataSourceLine[3];
            submission.setIncludeMailbox(FormattingUtils.parseBoolean((String)includeMailbox));
        }
        if (dataSourceLine.length > 4) {
            String includeSite = (String)dataSourceLine[4];
            submission.setIncludeSite(FormattingUtils.parseBoolean((String)includeSite));
        }
        if (dataSourceLine.length > 5) {
            String includeTeams = (String)dataSourceLine[5];
            submission.setIncludeTeams(FormattingUtils.parseBoolean((String)includeTeams));
        }
        return submission;
    }

    public static DataSourceType normalizeType(String type) {
        DataSourceType dataSourceType = DataSourceType.forOdataType((String)type);
        if (dataSourceType == null) {
            dataSourceType = DataSourceType.valueOf((String)type.trim().toUpperCase().replace(" ", "_"));
        }
        return dataSourceType;
    }

    public void setType(DataSourceType type) {
        this.type = type;
    }

    public void setType(String type) {
        if (type != null) {
            this.type = CustodialDataSourceSubmission.normalizeType(type);
        }
    }

    public void setValue(String value) {
        this.value = value != null ? value.trim() : null;
    }

    public boolean getIncludeMailbox() {
        return this.includeMailbox;
    }

    public boolean getIncludeSite() {
        return this.includeSite;
    }

    public boolean getIncludeTeams() {
        return this.includeTeams;
    }

    public String toString() {
        return this.custodianEmail + " {, type=" + String.valueOf(this.type) + ", value='" + this.value + "', includeMailbox=" + this.includeMailbox + ", includeSite=" + this.includeSite + ", includeAllTeamChannels=" + this.includeTeams + "}";
    }

    public String getCustodianEmail() {
        return this.custodianEmail;
    }

    public DataSourceType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setCustodianEmail(String custodianEmail) {
        this.custodianEmail = custodianEmail;
    }

    public void setIncludeMailbox(boolean includeMailbox) {
        this.includeMailbox = includeMailbox;
    }

    public void setIncludeSite(boolean includeSite) {
        this.includeSite = includeSite;
    }

    public void setIncludeTeams(boolean includeTeams) {
        this.includeTeams = includeTeams;
    }
}

