/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.relativity.restv1;

import com.fasterxml.jackson.annotation.JsonValue;

public enum CriteriaOperator {
    IS_SET("IsSet"),
    IS("Is"),
    IS_LIKE("IsLike"),
    LESS_THAN("LessThan"),
    LESS_THAN_OR_EQUAL_TO("LessThanOrEqualTo"),
    GREATER_THAN("GreaterThan"),
    GREATER_THAN_OR_EQUAL_TO("GreaterThanOrEqualTo"),
    STARTS_WITH("StartsWith"),
    ENDS_WITH("EndsWith"),
    CONTAINS("Contains"),
    ANY_OF_THESE("AnyOfThese"),
    ALL_OF_THESE("AllOfThese"),
    IN("In"),
    IS_LOGGED_IN("IsLoggedIn"),
    IS_BEFORE("IsBefore"),
    IS_BEFORE_OR_ON("IsBeforeOrOn"),
    IS_AFTER("IsAfter"),
    IS_AFTER_OR_ON("IsAfterOrOn"),
    BETWEEN("Between");

    String relativityName;

    private CriteriaOperator(String relativityName) {
        this.relativityName = relativityName;
    }

    public static CriteriaOperator fromRelativityName(String givenRelativityName) {
        for (CriteriaOperator type : CriteriaOperator.values()) {
            if (!type.relativityName.equals(givenRelativityName)) continue;
            return type;
        }
        return null;
    }

    @JsonValue
    public String getRelativityName() {
        return this.relativityName;
    }

    public static CriteriaOperator fromQueryString(String queryString) {
        switch (queryString) {
            case "is_not_set": 
            case "is_set": {
                return IS_SET;
            }
            case "is_not": 
            case "is": {
                return IS;
            }
            case "is_not_like": 
            case "is_like": {
                return IS_LIKE;
            }
            case "is_less_than": {
                return LESS_THAN;
            }
            case "is_less_than_or_equal_to": {
                return LESS_THAN_OR_EQUAL_TO;
            }
            case "is_greater_than": {
                return GREATER_THAN;
            }
            case "is_greater_than_or_equal_to": {
                return GREATER_THAN_OR_EQUAL_TO;
            }
            case "does_not_start_with": 
            case "starts_with": {
                return STARTS_WITH;
            }
            case "does_not_end_with": 
            case "ends_with": {
                return ENDS_WITH;
            }
            case "does_not_contain": 
            case "contains": {
                return CONTAINS;
            }
            case "is_none_of_these": 
            case "is_any_of_these": {
                return ANY_OF_THESE;
            }
            case "is_not_all_of_these": 
            case "is_all_of_these": {
                return ALL_OF_THESE;
            }
            case "is_in": {
                return IN;
            }
            case "is_not_logged_in": 
            case "is_logged_in": {
                return IS_LOGGED_IN;
            }
            case "is_before": {
                return IS_BEFORE;
            }
            case "is_before_or_on": {
                return IS_BEFORE_OR_ON;
            }
            case "is_after": {
                return IS_AFTER;
            }
            case "is_after_or_on": {
                return IS_AFTER_OR_ON;
            }
            case "is_not_between": 
            case "is_between": {
                return BETWEEN;
            }
        }
        return null;
    }

    public static String toQueryString(CriteriaOperator criteria, boolean isNotOperator) {
        switch (criteria.ordinal()) {
            case 0: {
                return isNotOperator ? "is_not_set" : "is_set";
            }
            case 1: {
                return isNotOperator ? "is_not" : "is";
            }
            case 2: {
                return isNotOperator ? "is_not_like" : "is_like";
            }
            case 3: {
                return isNotOperator ? "" : "is_less_than";
            }
            case 4: {
                return isNotOperator ? "" : "is_less_than_or_equal_to";
            }
            case 5: {
                return isNotOperator ? "" : "is_greater_than";
            }
            case 6: {
                return isNotOperator ? "" : "is_greater_than_or_equal_to";
            }
            case 7: {
                return isNotOperator ? "does_not_start_with" : "starts_with";
            }
            case 8: {
                return isNotOperator ? "does_not_end_with" : "ends_with";
            }
            case 9: {
                return isNotOperator ? "does_not_contain" : "contains";
            }
            case 10: {
                return isNotOperator ? "is_none_of_these" : "is_any_of_these";
            }
            case 11: {
                return isNotOperator ? "is_not_all_of_these" : "is_all_of_these";
            }
            case 12: {
                return isNotOperator ? "" : "is_in";
            }
            case 13: {
                return isNotOperator ? "is_not_logged_in" : "is_logged_in";
            }
            case 14: {
                return isNotOperator ? "" : "is_before";
            }
            case 15: {
                return isNotOperator ? "" : "is_before_or_on";
            }
            case 16: {
                return isNotOperator ? "" : "is_after";
            }
            case 17: {
                return isNotOperator ? "" : "is_after_or_on";
            }
            case 18: {
                return isNotOperator ? "is_not_between" : "is_between";
            }
        }
        return "";
    }

    public boolean hasNotOperator() {
        return !CriteriaOperator.toQueryString(this, true).equals("");
    }
}

