/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.relativity.restv1.objectmanager;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.SerializedName;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ExportMetadataType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.objectmanager.QueryFieldIdentifier;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.objectmanager.QueryObjectType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityArtifactIdType;
import java.util.ArrayList;
import java.util.List;

public class ObjectManagerQuery {
    @SerializedName(value="ObjectType")
    private QueryObjectType objectType;
    @SerializedName(value="Fields")
    private List<QueryFieldIdentifier> fields;
    @SerializedName(value="Condition")
    private String condition;
    @SerializedName(value="executingViewId")
    private Long executingViewId;
    @SerializedName(value="executingSavedSearchId")
    private Long executingSavedSearchId;
    @JsonIgnore
    private Long workspaceArtifactId;
    @JsonIgnore
    private Long parentArtifactId;
    @JsonIgnore
    private String cacheKey;

    public ObjectManagerQuery() {
    }

    public QueryObjectType getObjectType() {
        return this.objectType;
    }

    public List<QueryFieldIdentifier> getFields() {
        return this.fields;
    }

    public String getCondition() {
        return this.condition;
    }

    public Long getWorkspaceArtifactId() {
        return this.workspaceArtifactId;
    }

    public Long getParentArtifactId() {
        return this.parentArtifactId;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public Long getExecutingViewId() {
        return this.executingViewId;
    }

    public Long getExecutingSavedSearchId() {
        return this.executingSavedSearchId;
    }

    public ObjectManagerQuery(ObjectManagerQueryBuilder builder) {
        this.objectType = builder.objectType;
        this.fields = builder.fields;
        this.condition = builder.condition;
        this.workspaceArtifactId = builder.workspaceArtifactId;
        this.parentArtifactId = builder.parentArtifactId;
        this.cacheKey = builder.cacheKey;
        this.executingViewId = builder.viewId;
        this.executingSavedSearchId = builder.savedSearchId;
    }

    public static class ObjectManagerQueryBuilder {
        private QueryObjectType objectType = new QueryObjectType();
        private List<QueryFieldIdentifier> fields = new ArrayList<QueryFieldIdentifier>();
        private Long workspaceArtifactId = null;
        private String condition = null;
        private Long parentArtifactId = null;
        private String cacheKey;
        private Long viewId = null;
        private Long savedSearchId = null;

        public ObjectManagerQueryBuilder setObjectTypeId(Long artifactTypeId) {
            this.objectType.setArtifactTypeId(artifactTypeId);
            return this;
        }

        public ObjectManagerQueryBuilder setObjectType(RelativityArtifactIdType artifactTypeId) {
            this.objectType.setArtifactTypeId(Long.valueOf(artifactTypeId.getInt()));
            return this;
        }

        public ObjectManagerQueryBuilder setObjectTypeName(String typeName) {
            this.objectType.setName(typeName);
            return this;
        }

        public ObjectManagerQueryBuilder setObjectTypeGuid(String typeGuid) {
            this.objectType.setGuid(typeGuid);
            return this;
        }

        public ObjectManagerQueryBuilder addField(String fieldName) {
            QueryFieldIdentifier fieldIdentifier = new QueryFieldIdentifier();
            fieldIdentifier.setName(fieldName);
            this.fields.add(fieldIdentifier);
            return this;
        }

        public ObjectManagerQueryBuilder addFields(String ... fieldNames) {
            for (String fieldName : fieldNames) {
                QueryFieldIdentifier fieldIdentifier = new QueryFieldIdentifier();
                fieldIdentifier.setName(fieldName);
                this.fields.add(fieldIdentifier);
            }
            return this;
        }

        public ObjectManagerQueryBuilder addFieldByArtifactId(Long fieldArtifactId) {
            QueryFieldIdentifier fieldIdentifier = new QueryFieldIdentifier();
            fieldIdentifier.setArtifactId(fieldArtifactId);
            this.fields.add(fieldIdentifier);
            return this;
        }

        public ObjectManagerQueryBuilder addFieldByGuid(String fieldGuid) {
            QueryFieldIdentifier fieldIdentifier = new QueryFieldIdentifier();
            fieldIdentifier.setGuid(fieldGuid);
            this.fields.add(fieldIdentifier);
            return this;
        }

        public ObjectManagerQueryBuilder setWorkspaceArtifactId(Long workspaceArtifactId) {
            this.workspaceArtifactId = workspaceArtifactId;
            return this;
        }

        public ObjectManagerQueryBuilder setCondition(String condition) {
            this.condition = condition;
            return this;
        }

        public ObjectManagerQueryBuilder setParentArtifactId(Long parentArtifactId) {
            this.parentArtifactId = parentArtifactId;
            return this;
        }

        public ObjectManagerQueryBuilder setCacheKey(String cacheKey) {
            this.cacheKey = cacheKey;
            return this;
        }

        public ObjectManagerQueryBuilder withViewId(Long viewId) {
            this.viewId = viewId;
            return this;
        }

        public ObjectManagerQueryBuilder withSavedSearchId(Long savedSearchId) {
            this.savedSearchId = savedSearchId;
            return this;
        }

        public ObjectManagerQueryBuilder withExecutionMetadataId(ExportMetadataType type, Long executionMetadataId) {
            if (type == ExportMetadataType.VIEW) {
                this.viewId = executionMetadataId;
            } else if (type == ExportMetadataType.SAVED_SEARCH) {
                this.savedSearchId = executionMetadataId;
            }
            return this;
        }

        public ObjectManagerQuery build() {
            return new ObjectManagerQuery(this);
        }
    }
}

