/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.report;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.workflow.core.execution.options.report.ExcludeDates;
import com.nuix.automate.workflow.core.execution.options.report.ReportViewFieldType;
import com.nuix.automate.workflow.core.execution.options.report.ReportViewProperty;
import com.nuix.automate.workflow.core.execution.options.report.ReportViewSummarizeBy;
import com.nuix.automate.workflow.core.execution.options.report.SizeUnit;
import com.nuix.automate.workflow.core.execution.options.sorting.SortOrder;
import java.io.Serializable;
import java.util.Map;

@FormFieldRow(name="customTemplateRow", children={"useCustomViewTemplate", "templateWorksheetName"})
public class ReportView
implements Serializable {
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    @FormField(allowedValues={"BATCH_LOAD_DATE", "CASE_NAME", "EVIDENCE_CONTAINER", "PROCESSING_STAGE", "CUSTODIAN", "TAG", "TOP_LEVEL_YEAR", "TOP_LEVEL_YEAR_MONTH", "TOP_LEVEL_MONTH", "TOP_LEVEL_DAY", "ITEM_YEAR", "ITEM_YEAR_MONTH", "ITEM_MONTH", "ITEM_DAY", "CATEGORY", "FILE_EXTENSION", "KIND", "TYPE", "TYPE_FILE_EXTENSION", "IMAGE_WIDTH", "IMAGE_HEIGHT", "IRREGULAR", "ITEMSET", "ITEMSET_ORIGINALS", "ITEMSET_DUPLICATES", "ITEMSET_ORIGINALS_DUPLICATES", "PRODUCTION_SET", "EXCLUSION", "METADATA", "NAMED_ENTITY_TYPE", "NAMED_ENTITY_VALUE", "NAMED_ENTITY_TYPE_AND_VALUE", "LANGUAGE", "ALL_DOMAINS", "SENDER_DOMAINS", "RECIPIENT_DOMAINS"})
    public ReportViewFieldType verticalFieldType;
    private Map<String, String> verticalFieldProperties;
    @FormField(visibleOn={@OnField(name="verticalFieldType", value={"TOP_LEVEL_YEAR", "ITEM_YEAR"})})
    public Integer verticalStartYear;
    @FormField(visibleOn={@OnField(name="verticalFieldType", value={"TOP_LEVEL_YEAR", "ITEM_YEAR"})})
    public Integer verticalEndYear;
    @FormField(visibleOn={@OnField(name="verticalFieldType", value={"TOP_LEVEL_YEAR_MONTH", "ITEM_YEAR_MONTH"})}, componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.YEAR_MONTH)
    public String verticalStartMonthYear;
    @FormField(visibleOn={@OnField(name="verticalFieldType", value={"TOP_LEVEL_YEAR_MONTH", "ITEM_YEAR_MONTH"})}, componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.YEAR_MONTH)
    public String verticalEndMonthYear;
    @FormField(visibleOn={@OnField(name="verticalFieldType", value={"TOP_LEVEL_YEAR", "ITEM_YEAR", "TOP_LEVEL_YEAR_MONTH", "ITEM_YEAR_MONTH"})})
    public ExcludeDates verticalExcludeDates;
    @FormField(visibleOn={@OnField(name="verticalFieldType", value={"TAG"})}, required=false)
    public String verticalName;
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.METADATA_PROFILES, visibleOn={@OnField(name="verticalFieldType", value={"METADATA"})})
    public String verticalMetadataProfile;
    @FormField(visibleOn={@OnField(name="verticalFieldType", value={"METADATA"})}, allowedValues={"NONE", "TOP_LEVEL_ITEM_DATE", "TOP_LEVEL_ITEMS_DESCENDING", "POSITION"})
    public SortOrder verticalSortOrder;
    @FormField(allowedValues={"NONE", "BATCH_LOAD_DATE", "CASE_NAME", "EVIDENCE_CONTAINER", "CUSTODIAN", "TAG", "TOP_LEVEL_YEAR", "TOP_LEVEL_YEAR_MONTH", "TOP_LEVEL_MONTH", "TOP_LEVEL_DAY", "ITEM_YEAR", "ITEM_YEAR_MONTH", "ITEM_MONTH", "ITEM_DAY", "CATEGORY", "FILE_EXTENSION", "KIND", "TYPE", "TYPE_FILE_EXTENSION", "IMAGE_WIDTH", "IMAGE_HEIGHT", "IRREGULAR", "ITEMSET", "ITEMSET_ORIGINALS", "ITEMSET_DUPLICATES", "ITEMSET_ORIGINALS_DUPLICATES", "PRODUCTION_SET", "EXCLUSION", "NAMED_ENTITY_TYPE", "NAMED_ENTITY_VALUE", "NAMED_ENTITY_TYPE_AND_VALUE", "LANGUAGE", "ALL_DOMAINS", "SENDER_DOMAINS", "RECIPIENT_DOMAINS"}, enableOn={@OnField(name="verticalFieldType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"METADATA"})})
    public ReportViewFieldType verticalFieldType2;
    private Map<String, String> verticalFieldProperties2;
    @FormField(visibleOn={@OnField(name="verticalFieldType2", value={"TOP_LEVEL_YEAR", "ITEM_YEAR"})})
    public Integer vertical2StartYear;
    @FormField(visibleOn={@OnField(name="verticalFieldType2", value={"TOP_LEVEL_YEAR", "ITEM_YEAR"})})
    public Integer vertical2EndYear;
    @FormField(visibleOn={@OnField(name="verticalFieldType2", value={"TOP_LEVEL_YEAR_MONTH", "ITEM_YEAR_MONTH"})}, componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.YEAR_MONTH)
    public String vertical2StartMonthYear;
    @FormField(visibleOn={@OnField(name="verticalFieldType2", value={"TOP_LEVEL_YEAR_MONTH", "ITEM_YEAR_MONTH"})}, componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.YEAR_MONTH)
    public String vertical2EndMonthYear;
    @FormField(visibleOn={@OnField(name="verticalFieldType2", value={"TOP_LEVEL_YEAR", "ITEM_YEAR", "TOP_LEVEL_YEAR_MONTH", "ITEM_YEAR_MONTH"})})
    public ExcludeDates vertical2ExcludeDates;
    @FormField(visibleOn={@OnField(name="verticalFieldType2", value={"TAG"})})
    public String vertical2Name;
    @FormField(allowedValues={"NONE", "BATCH_LOAD_DATE", "CASE_NAME", "EVIDENCE_CONTAINER", "PROCESSING_STAGE", "CUSTODIAN", "TAG", "TOP_LEVEL_YEAR", "TOP_LEVEL_YEAR_MONTH", "TOP_LEVEL_MONTH", "TOP_LEVEL_DAY", "ITEM_YEAR", "ITEM_YEAR_MONTH", "ITEM_MONTH", "ITEM_DAY", "CATEGORY", "FILE_EXTENSION", "KIND", "TYPE", "TYPE_FILE_EXTENSION", "IMAGE_WIDTH", "IMAGE_HEIGHT", "IRREGULAR", "ITEMSET", "ITEMSET_ORIGINALS", "ITEMSET_DUPLICATES", "ITEMSET_ORIGINALS_DUPLICATES", "PRODUCTION_SET", "EXCLUSION", "NAMED_ENTITY_TYPE", "NAMED_ENTITY_VALUE", "NAMED_ENTITY_TYPE_AND_VALUE", "LANGUAGE", "ALL_DOMAINS", "SENDER_DOMAINS", "RECIPIENT_DOMAINS", "CASE_NAME_EVIDENCE_CONTAINER", "EVIDENCE_CONTAINER_CUSTODIAN", "TOP_LEVEL_YEAR_AND_MONTH", "KIND_AND_TYPE", "KIND_AND_FILE_EXTENSION", "KIND_AND_TYPE_FILE_EXTENSION", "IRREGULAR_AND_TYPE", "ITEMSET_ORIGINALS_AND_DUPLICATES", "EXCLUSION_AND_TYPE", "EXCLUSION_AND_TYPE_FILE_EXTENSION"}, enableOn={@OnField(name="verticalFieldType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"METADATA"})})
    public ReportViewFieldType horizontalFieldType;
    private Map<String, String> horizontalFieldProperties;
    @FormField(visibleOn={@OnField(name="horizontalFieldType", value={"TOP_LEVEL_YEAR", "ITEM_YEAR"})})
    public Integer horizontalStartYear;
    @FormField(visibleOn={@OnField(name="horizontalFieldType", value={"TOP_LEVEL_YEAR", "ITEM_YEAR"})})
    public Integer horizontalEndYear;
    @FormField(visibleOn={@OnField(name="horizontalFieldType", value={"TOP_LEVEL_YEAR_MONTH", "ITEM_YEAR_MONTH"})}, componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.YEAR_MONTH)
    public String horizontalStartMonthYear;
    @FormField(visibleOn={@OnField(name="horizontalFieldType", value={"TOP_LEVEL_YEAR_MONTH", "ITEM_YEAR_MONTH"})}, componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.YEAR_MONTH)
    public String horizontalEndMonthYear;
    @FormField(visibleOn={@OnField(name="horizontalFieldType", value={"TOP_LEVEL_YEAR", "ITEM_YEAR", "TOP_LEVEL_YEAR_MONTH", "ITEM_YEAR_MONTH"})})
    public ExcludeDates horizontalExcludeDates;
    @FormField(visibleOn={@OnField(name="horizontalFieldType", value={"TAG"})})
    public String horizontalName;
    @FormField(visibleOn={@OnField(name="verticalFieldType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"PROCESSING_STAGE"}), @OnField(name="horizontalFieldType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"PROCESSING_STAGE"}, skipStatePropagation=true)})
    public String processingStage;
    @FormField(enableOn={@OnField(name="verticalFieldType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"METADATA"})})
    public ReportViewSummarizeBy summarizeBy;
    @FormField(enableOn={@OnField(name="summarizeBy", comparisonOperator=ComparisonOperator.EQUAL, value={"SIZE", "COUNT_AND_SIZE"})})
    public SizeUnit sizeUnit;
    @FormField
    public boolean useCustomViewTemplate;
    @FormField(enableOn={@OnField(name="useCustomViewTemplate")})
    public String templateWorksheetName;
    public transient Map<ReportViewProperty, Object> verticalFieldComputedProperties;
    public transient Map<ReportViewProperty, Object> verticalFieldComputedProperties2;
    public transient Map<ReportViewProperty, Object> horizontalFieldComputedProperties;
    public static final String NAME = "Name";
    public static final String START = "Start";
    public static final String END = "End";
    public static final String EXCLUDE = "Exclude";
    public static final String METADATA_PROFILE = "Profile";
    public static final String SORT_ORDER = "Sort order";

    public ReportView() {
        this.sizeUnit = SizeUnit.GiB;
    }

    public ReportView(ReportView original) {
        this.copy(original);
    }

    public ReportView(String processingStage, ReportViewFieldType verticalFieldType, Map<String, String> verticalFieldProperties, ReportViewFieldType verticalFieldType2, Map<String, String> verticalFieldProperties2, ReportViewFieldType horizontalFieldType, Map<String, String> horizontalFieldProperties, ReportViewSummarizeBy summarizeBy, boolean useCustomViewTemplate, String templateWorksheetName) {
        this.processingStage = processingStage;
        this.verticalFieldType = verticalFieldType;
        this.verticalFieldProperties = verticalFieldProperties;
        this.verticalFieldType2 = verticalFieldType2;
        this.verticalFieldProperties2 = verticalFieldProperties2;
        this.horizontalFieldType = horizontalFieldType;
        this.horizontalFieldProperties = horizontalFieldProperties;
        this.summarizeBy = summarizeBy;
        this.sizeUnit = SizeUnit.GiB;
        this.useCustomViewTemplate = useCustomViewTemplate;
        this.templateWorksheetName = templateWorksheetName;
    }

    public String toString() {
        Object result = "";
        if (this.processingStage != null) {
            result = (String)result + this.iu.getFormattedString("ReportView.By", (Object)this.processingStage) + " ";
        }
        Object properties = "";
        if (this.verticalFieldType != null) {
            result = (String)result + this.verticalFieldType.toString();
            if (this.verticalStartYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Start:" + this.verticalStartYear;
            }
            if (this.verticalEndYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "End:" + this.verticalEndYear;
            }
            if (this.verticalStartMonthYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Start:" + this.verticalStartMonthYear;
            }
            if (this.verticalEndMonthYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "End:" + this.verticalEndMonthYear;
            }
            if (this.verticalExcludeDates != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Exclude:" + String.valueOf((Object)this.verticalExcludeDates);
            }
            if (this.verticalName != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Name:" + this.verticalName;
            }
            if (this.verticalMetadataProfile != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Profile:" + this.verticalMetadataProfile;
            }
            if (this.verticalSortOrder != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Sort Order:" + String.valueOf((Object)this.verticalSortOrder);
            }
            if (((String)properties).length() > 0) {
                result = (String)result + " " + this.iu.getFormattedString("ReportView.Properties", properties);
            }
        }
        if (this.verticalFieldType2 != null && this.verticalFieldType2 != ReportViewFieldType.NONE) {
            result = (String)result + " " + this.iu.getFormattedString("ReportView.And", (Object)this.verticalFieldType2.toString());
            properties = "";
            if (this.vertical2StartYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Start:" + this.vertical2StartYear;
            }
            if (this.vertical2EndYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "End:" + this.vertical2EndYear;
            }
            if (this.vertical2StartMonthYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Start:" + this.vertical2StartMonthYear;
            }
            if (this.vertical2EndMonthYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "End:" + this.vertical2EndMonthYear;
            }
            if (this.vertical2ExcludeDates != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Exclude:" + String.valueOf((Object)this.vertical2ExcludeDates);
            }
            if (this.vertical2Name != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Name:" + this.vertical2Name;
            }
            if (((String)properties).length() > 0) {
                result = (String)result + " " + this.iu.getFormattedString("ReportView.Properties", properties);
            }
        }
        if (this.horizontalFieldType != null && this.horizontalFieldType != ReportViewFieldType.NONE) {
            result = (String)result + " " + this.iu.getFormattedString("ReportView.And", (Object)this.horizontalFieldType.toString());
            properties = "";
            if (this.horizontalStartYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Start:" + this.horizontalStartYear;
            }
            if (this.horizontalEndYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "End:" + this.horizontalEndYear;
            }
            if (this.horizontalStartMonthYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Start:" + this.horizontalStartMonthYear;
            }
            if (this.horizontalEndMonthYear != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "End:" + this.horizontalEndMonthYear;
            }
            if (this.horizontalExcludeDates != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Exclude:" + String.valueOf((Object)this.horizontalExcludeDates);
            }
            if (this.horizontalName != null) {
                properties = (String)properties + (((String)properties).length() > 0 ? ", " : "") + "Name:" + this.horizontalName;
            }
            if (((String)properties).length() > 0) {
                result = (String)result + " " + this.iu.getFormattedString("ReportView.Properties", properties);
            }
        }
        if (this.summarizeBy != null) {
            result = (String)result + " " + this.iu.getFormattedString("ReportView.SummarizedBy", (Object)this.summarizeBy.toString());
            if (this.summarizeBy == ReportViewSummarizeBy.SIZE || this.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                result = (String)result + " " + this.iu.getString("ReportView.In") + " " + this.sizeUnit.toString() + " ";
            }
        }
        return result;
    }

    public void copy(ReportView source) {
        this.verticalFieldType = source.verticalFieldType;
        this.verticalStartYear = source.verticalStartYear;
        this.verticalEndYear = source.verticalEndYear;
        this.verticalStartMonthYear = source.verticalStartMonthYear;
        this.verticalEndMonthYear = source.verticalEndMonthYear;
        this.verticalExcludeDates = source.verticalExcludeDates;
        this.verticalName = source.verticalName;
        this.verticalMetadataProfile = source.verticalMetadataProfile;
        this.verticalSortOrder = source.verticalSortOrder;
        this.verticalFieldType2 = source.verticalFieldType2;
        this.vertical2StartYear = source.vertical2StartYear;
        this.vertical2EndYear = source.vertical2EndYear;
        this.vertical2StartMonthYear = source.vertical2StartMonthYear;
        this.vertical2EndMonthYear = source.vertical2EndMonthYear;
        this.vertical2ExcludeDates = source.vertical2ExcludeDates;
        this.vertical2Name = source.vertical2Name;
        this.horizontalFieldType = source.horizontalFieldType;
        this.horizontalStartYear = source.horizontalStartYear;
        this.horizontalEndYear = source.horizontalEndYear;
        this.horizontalStartMonthYear = source.horizontalStartMonthYear;
        this.horizontalEndMonthYear = source.horizontalEndMonthYear;
        this.horizontalExcludeDates = source.horizontalExcludeDates;
        this.horizontalName = source.horizontalName;
        this.summarizeBy = source.summarizeBy;
        this.sizeUnit = source.sizeUnit;
        this.processingStage = source.processingStage;
        this.useCustomViewTemplate = source.useCustomViewTemplate;
        this.templateWorksheetName = source.templateWorksheetName;
    }

    public void normalize() {
        if (this.verticalFieldProperties != null) {
            if (this.verticalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR || this.verticalFieldType == ReportViewFieldType.ITEM_YEAR) {
                if (this.verticalFieldProperties.get(START) != null) {
                    this.verticalStartYear = Integer.parseInt(this.verticalFieldProperties.get(START));
                }
                if (this.verticalFieldProperties.get(END) != null) {
                    this.verticalEndYear = Integer.parseInt(this.verticalFieldProperties.get(END));
                }
                if (this.verticalFieldProperties.get(EXCLUDE) == null) {
                    this.verticalFieldProperties.put(EXCLUDE, "NONE");
                }
                this.verticalExcludeDates = ExcludeDates.fromString(this.verticalFieldProperties.get(EXCLUDE));
            } else if (this.verticalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH || this.verticalFieldType == ReportViewFieldType.ITEM_YEAR_MONTH) {
                this.verticalStartMonthYear = this.verticalFieldProperties.get(START);
                this.verticalEndMonthYear = this.verticalFieldProperties.get(END);
                if (this.verticalFieldProperties.get(EXCLUDE) == null) {
                    this.verticalFieldProperties.put(EXCLUDE, "NONE");
                }
                this.verticalExcludeDates = ExcludeDates.fromString(this.verticalFieldProperties.get(EXCLUDE));
            }
            this.verticalName = this.verticalFieldProperties.get(NAME);
            this.verticalMetadataProfile = this.verticalFieldProperties.get(METADATA_PROFILE);
            if (this.verticalFieldProperties.get(SORT_ORDER) != null) {
                this.verticalSortOrder = SortOrder.fromString(this.verticalFieldProperties.get(SORT_ORDER));
            }
        }
        if (this.verticalFieldProperties2 != null) {
            if (this.verticalFieldType2 == ReportViewFieldType.TOP_LEVEL_YEAR || this.verticalFieldType2 == ReportViewFieldType.ITEM_YEAR) {
                if (this.verticalFieldProperties2.get(START) != null) {
                    this.vertical2StartYear = Integer.parseInt(this.verticalFieldProperties2.get(START));
                }
                if (this.verticalFieldProperties2.get(END) != null) {
                    this.vertical2EndYear = Integer.parseInt(this.verticalFieldProperties2.get(END));
                }
                if (this.verticalFieldProperties2.get(EXCLUDE) == null) {
                    this.verticalFieldProperties2.put(EXCLUDE, "NONE");
                }
                this.vertical2ExcludeDates = ExcludeDates.fromString(this.verticalFieldProperties2.get(EXCLUDE));
            } else if (this.verticalFieldType2 == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH || this.verticalFieldType2 == ReportViewFieldType.ITEM_YEAR_MONTH) {
                this.vertical2StartMonthYear = this.verticalFieldProperties2.get(START);
                this.vertical2EndMonthYear = this.verticalFieldProperties2.get(END);
                if (this.verticalFieldProperties2.get(EXCLUDE) == null) {
                    this.verticalFieldProperties2.put(EXCLUDE, "NONE");
                }
                this.vertical2ExcludeDates = ExcludeDates.fromString(this.verticalFieldProperties2.get(EXCLUDE));
            }
            this.vertical2Name = this.verticalFieldProperties2.get(NAME);
        }
        if (this.horizontalFieldProperties != null) {
            if (this.horizontalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR || this.horizontalFieldType == ReportViewFieldType.ITEM_YEAR) {
                if (this.horizontalFieldProperties.get(START) != null) {
                    this.horizontalStartYear = Integer.parseInt(this.horizontalFieldProperties.get(START));
                }
                if (this.horizontalFieldProperties.get(END) != null) {
                    this.horizontalEndYear = Integer.parseInt(this.horizontalFieldProperties.get(END));
                }
                if (this.horizontalFieldProperties.get(EXCLUDE) == null) {
                    this.horizontalFieldProperties.put(EXCLUDE, "NONE");
                }
                this.horizontalExcludeDates = ExcludeDates.fromString(this.horizontalFieldProperties.get(EXCLUDE));
            } else if (this.horizontalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_MONTH || this.horizontalFieldType == ReportViewFieldType.ITEM_YEAR_MONTH) {
                this.horizontalStartMonthYear = this.horizontalFieldProperties.get(START);
                this.horizontalEndMonthYear = this.horizontalFieldProperties.get(END);
                if (this.horizontalFieldProperties.get(EXCLUDE) == null) {
                    this.horizontalFieldProperties.put(EXCLUDE, "NONE");
                }
                this.horizontalExcludeDates = ExcludeDates.fromString(this.horizontalFieldProperties.get(EXCLUDE));
            }
            this.horizontalName = this.horizontalFieldProperties.get(NAME);
        }
        this.verticalFieldProperties = null;
        this.verticalFieldProperties2 = null;
        this.horizontalFieldProperties = null;
    }
}

