/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.parameters;

import com.google.common.collect.Lists;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.exceptions.ParameterNotDefinedException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.parameters.LastBatchLoadParameter;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.nuix.ProductionSetUtils;
import java.io.IOException;
import java.util.List;
import nuix.ProductionSet;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public abstract class LastProductionSetParameter
extends LastBatchLoadParameter {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(LastProductionSetParameter.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");

    public LastProductionSetParameter(String name, String description, ExecutionContext executionContext) {
        super(name, description, executionContext);
    }

    public ProductionSet getLastProductionSet() throws ParameterNotDefinedException {
        if (this.executionContext.nuixCase == null) {
            throw new ParameterNotDefinedException(this.iu.getFormattedString("Parameters.Log.NoCase", (Object)this.getName()));
        }
        boolean multipleProductionSetsWithSameDate = false;
        try {
            ProductionSet lastProductionSet = null;
            Instant lastProductionSetCreated = null;
            List caseProductionSets = this.executionContext.nuixCase.getProductionSets();
            caseProductionSets = Lists.reverse((List)caseProductionSets);
            for (ProductionSet productionSet : caseProductionSets) {
                Instant productionSetCreated = ProductionSetUtils.getProductionSetCreation(productionSet);
                if (lastProductionSet != null && lastProductionSetCreated != null && productionSetCreated.equals(lastProductionSetCreated)) {
                    LOGGER.warn("Production sets \"" + productionSet.getName() + "\" and \"" + String.valueOf(lastProductionSet) + "\" have the same creation: " + String.valueOf(productionSetCreated));
                    multipleProductionSetsWithSameDate = true;
                }
                if (lastProductionSet != null && lastProductionSetCreated != null && !productionSetCreated.isAfter((ReadableInstant)lastProductionSetCreated)) continue;
                lastProductionSet = productionSet;
                lastProductionSetCreated = productionSetCreated;
            }
            if (multipleProductionSetsWithSameDate) {
                String parameterName = "{automate_add_to_production_set}";
                String result = this.executionContext.evalParameters("{automate_add_to_production_set}", null);
                if (!result.equals(parameterName)) {
                    for (ProductionSet caseProductionSet : this.executionContext.nuixCase.getProductionSets()) {
                        if (!caseProductionSet.getName().equals(result)) continue;
                        return caseProductionSet;
                    }
                }
            }
            if (lastProductionSet == null) {
                throw new ParameterNotDefinedException(this.iu.getFormattedString("Parameters.Log.NoProductionSets", (Object)this.getName()));
            }
            return lastProductionSet;
        }
        catch (ParameterException | IOException e) {
            throw new ParameterNotDefinedException(this.iu.getFormattedString("Parameters.Log.NoRootItems", (Object)this.getName()));
        }
    }
}

