/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.script.ApplicationRestClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AutomateRestClient
extends ApplicationRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AutomateRestClient.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");

    public AutomateRestClient(LogChannel logChannel, Set<String> fingerprints, String name) {
        super(logChannel, fingerprints, name);
    }

    public AutomateRestClient(LogChannel logChannel, String name) {
        super(logChannel, name);
    }

    protected String getCallUrl(String endpoint) throws IOException {
        if (this.baseUrl == null) {
            LOGGER.error("Automate URL is null");
            throw new IOException("Automate API URL is not defined. Call automateRest.setBaseUrl(String s) before calling this method.");
        }
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.bearerToken == null) {
            LOGGER.error("Discover token is null");
            throw new IOException("Automate API bearer token is not defined. Call automateRest.setBearerToken(String s) before calling this method.");
        }
        String callUrl = endpoint.startsWith("/") ? this.baseUrl + endpoint : this.baseUrl + "/" + endpoint;
        return callUrl;
    }

    @Override
    protected Map<String, String> getHeaders(Verb verb, String url, Object body) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.bearerToken);
        return headers;
    }

    public javax.ws.rs.core.Response getResponse(String endpoint) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        return this.getResponse(callUrl, this.getHeaders(Verb.GET, callUrl, ""));
    }

    public Response get(String endpoint) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        return this.callApi(Verb.GET, callUrl, "", this.getHeaders(Verb.GET, callUrl, ""));
    }

    public Response delete(String endpoint) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        return this.callApi(Verb.DELETE, callUrl, "", this.getHeaders(Verb.DELETE, callUrl, ""));
    }

    public Response post(String endpoint, Object data) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        Object body = this.prepareBody(data);
        return this.callApi(Verb.POST, callUrl, body, this.getHeaders(Verb.POST, callUrl, body));
    }

    public Response put(String endpoint, Object data) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        Object body = this.prepareBody(data);
        return this.callApi(Verb.PUT, callUrl, body, this.getHeaders(Verb.PUT, callUrl, body));
    }
}

