/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.exceptions.DiscoverSettingsNotDefinedException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.script.ApplicationRestClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DiscoverRestClient
extends ApplicationRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DiscoverRestClient.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");

    public DiscoverRestClient(LogChannel logChannel, String name) {
        super(logChannel, name);
    }

    protected String getCallUrl() throws IOException {
        if (this.baseUrl == null) {
            LOGGER.error("Discover URL is null");
            throw new DiscoverSettingsNotDefinedException("Discover API URL is not defined. Call discoverRest.setBaseUrl(String s) before calling this method.");
        }
        if (this.bearerToken == null) {
            LOGGER.error("Discover token is null");
            throw new DiscoverSettingsNotDefinedException("Discover API bearer token is not defined. Call discoverRest.setBearerToken(String s) before calling this method.");
        }
        return this.baseUrl;
    }

    public Response call(String query) throws IOException {
        return this.call(query, null);
    }

    public Response call(String query, Map<String, Object> variables) throws IOException {
        String callUrl = this.getCallUrl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.bearerToken);
        headers.put("ApiKey", this.bearerToken);
        HashMap<String, Object> callBody = new HashMap<String, Object>();
        Pattern parameterPattern = Pattern.compile("\\s*(query|mutation)\\s*(\\w+)");
        Matcher matcher = parameterPattern.matcher(query);
        if (!matcher.find()) {
            throw new IOException("Body must start with query or mutation");
        }
        callBody.put("operationName", matcher.group(2));
        callBody.put("query", query);
        callBody.put("variables", variables);
        return this.callApi(Verb.POST, callUrl, this.gson.toJson(callBody), headers);
    }
}

