/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.exceptions.RelativitySettingsNotDefinedException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.script.ApplicationRestClient;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public abstract class RelativityRestClient
extends ApplicationRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityRestClient.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    protected String relativityUsername;
    protected ThirdPartyAuthenticationMethod authenticationMethod;

    public RelativityRestClient(LogChannel logChannel, String name) {
        super(logChannel, name);
    }

    public void setAuthenticationMethod(ThirdPartyAuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public void setBasicAuth(String username, String password) throws ParameterException {
        this.relativityUsername = username;
        this.bearerToken = password;
    }

    protected String getCallUrl(String endpoint) throws IOException {
        if (this.baseUrl == null) {
            throw new RelativitySettingsNotDefinedException("Relativity API URL is not defined. Call relativityRest.setBaseUrl(String s) before calling this method.");
        }
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.bearerToken == null) {
            throw new RelativitySettingsNotDefinedException("Relativity API bearer token is not defined. Call relativityRest.setBearerToken(String s) before calling this method.");
        }
        String callUrl = endpoint.startsWith("/") ? this.baseUrl + endpoint : this.baseUrl + "/" + endpoint;
        return callUrl;
    }

    private Map<String, String> getAuthHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.authenticationMethod != null && this.authenticationMethod == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE) {
            headers.put("Authorization", "Bearer " + this.bearerToken);
        } else {
            String basicAuthCredentials = Base64.getEncoder().encodeToString((this.relativityUsername + ":" + this.bearerToken).getBytes(StandardCharsets.UTF_8));
            headers.put("Authorization", "Basic " + basicAuthCredentials);
        }
        headers.put("x-csrf-header", "");
        return headers;
    }

    public Response get(String endpoint) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        return this.callApi(Verb.GET, callUrl, "", this.getAuthHeaders());
    }

    public Response delete(String endpoint) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        return this.callApi(Verb.DELETE, callUrl, "", this.getAuthHeaders());
    }

    public Response post(String endpoint, Object data) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        Object body = this.prepareBody(data);
        return this.callApi(Verb.POST, callUrl, body, this.getAuthHeaders());
    }

    public Response put(String endpoint, Object data) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        Object body = this.prepareBody(data);
        return this.callApi(Verb.PUT, callUrl, body, this.getAuthHeaders());
    }

    public Response queryObjectManagerSlim(String objectTypeName, Long workspaceArtifactId, String condition, int start, int length) throws IOException {
        return this.queryObjectManager(objectTypeName, workspaceArtifactId, condition, null, start, length);
    }

    public Response queryObjectManagerSlim(String objectTypeName, Long workspaceArtifactId, String condition, String[] fieldNames, int start, int length) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap<String, Object> request = new HashMap<String, Object>();
        payload.put("request", request);
        HashMap<String, String> objectType = new HashMap<String, String>();
        request.put("ObjectType", objectType);
        objectType.put("Name", objectTypeName);
        ArrayList<Object> fields = new ArrayList<Object>();
        request.put("Fields", fields);
        if (fieldNames == null || fieldNames != null && fieldNames.length == 0) {
            HashMap fieldObject = new HashMap();
            fieldObject.put("Name", "Name");
            fields.add(fieldObject);
        } else {
            for (String field : fieldNames) {
                HashMap<String, Object> fieldObject = new HashMap<String, Object>();
                fieldObject.put("Name", field);
                fields.add(fieldObject);
            }
        }
        request.put("Condition", null);
        if (condition != null) {
            request.put("Condition", condition);
        }
        payload.put("start", Integer.valueOf(start));
        payload.put("length", Integer.valueOf(length));
        Object workspaceArtifactIdString = workspaceArtifactId == null ? "-1" : "" + workspaceArtifactId;
        String callUrl = this.getCallUrl("/Relativity.Rest/api/Relativity.ObjectManager/v1/workspace/" + (String)workspaceArtifactIdString + "/object/queryslim");
        return this.callApi(Verb.POST, callUrl, this.gson.toJson(payload), this.getAuthHeaders());
    }

    public Response queryObjectManager(String objectTypeName, Long workspaceArtifactId, String condition, int start, int length) throws IOException {
        return this.queryObjectManager(objectTypeName, workspaceArtifactId, condition, null, start, length);
    }

    public Response queryObjectManager(String objectTypeName, Long workspaceArtifactId, String condition, String[] fieldNames, int start, int length) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap<String, Object> request = new HashMap<String, Object>();
        payload.put("request", request);
        HashMap<String, String> objectType = new HashMap<String, String>();
        request.put("ObjectType", objectType);
        objectType.put("Name", objectTypeName);
        ArrayList<Object> fields = new ArrayList<Object>();
        request.put("Fields", fields);
        if (fieldNames == null || fieldNames != null && fieldNames.length == 0) {
            HashMap fieldObject = new HashMap();
            fieldObject.put("Name", "Name");
            fields.add(fieldObject);
        } else {
            for (String field : fieldNames) {
                HashMap<String, Object> fieldObject = new HashMap<String, Object>();
                fieldObject.put("Name", field);
                fields.add(fieldObject);
            }
        }
        request.put("Condition", null);
        if (condition != null) {
            request.put("Condition", condition);
        }
        payload.put("start", Integer.valueOf(start));
        payload.put("length", Integer.valueOf(length));
        Object workspaceArtifactIdString = workspaceArtifactId == null ? "-1" : "" + workspaceArtifactId;
        String callUrl = this.getCallUrl("/Relativity.Rest/api/Relativity.ObjectManager/v1/workspace/" + (String)workspaceArtifactIdString + "/object/query");
        return this.callApi(Verb.POST, callUrl, this.gson.toJson(payload), this.getAuthHeaders());
    }
}

