/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.nuix.automate.utils.api.script.RestException;
import com.nuix.automate.utils.api.script.RestSSLException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.script.MultiPartBuilder;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class RestClient
implements AutoCloseable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RestClient.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    protected final Gson gson;
    private Client client;
    private String name;
    private Path logFilePath;
    private boolean usingCustomFingerprint;
    private LogChannel logChannel;
    private transient LogHandler logHandler;
    private transient Set<String> fingerprints;

    public RestClient(LogChannel logChannel, String name) {
        this(logChannel, new HashSet<String>(), name);
    }

    public RestClient(LogChannel logChannel, Set<String> fingerprints, String name) {
        this.name = "call-api-" + name;
        this.logChannel = logChannel;
        this.fingerprints = fingerprints;
        this.initializeClient();
        this.gson = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
        this.logHandler = LogHandler.getInstance();
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    private void initializeClient() {
        this.initializeClient(true);
    }

    private void initializeClient(boolean reuseExistingClient) {
        LOGGER.info("Initializing client " + this.name);
        if (this.fingerprints.size() > 0) {
            this.usingCustomFingerprint = true;
        }
        try {
            this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)this.name, this.fingerprints, (boolean)true, (boolean)reuseExistingClient);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Cannot initialize REST client", (Throwable)e);
        }
    }

    public void setFingerprints(Set<String> fingerprints) {
        this.fingerprints = fingerprints;
        this.initializeClient();
    }

    public void setFingerprint(String fingerprint) {
        HashSet<String> fingerprints = new HashSet<String>();
        fingerprints.add(fingerprint);
        this.usingCustomFingerprint = true;
        try {
            this.client.close();
            this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)this.name, fingerprints, (boolean)true, (boolean)true);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Cannot initialize REST client", (Throwable)e);
        }
    }

    public void setLogFilePath(Path logFilePath) {
        this.logFilePath = logFilePath;
    }

    public String getName() {
        return this.name;
    }

    public MultiPartBuilder getMultiPartBuilder() {
        return new MultiPartBuilder();
    }

    protected Object prepareBody(Object data) {
        if (data instanceof MultiPart) {
            return data;
        }
        return this.gson.toJson(data);
    }

    protected Response getResponse(String url, Map<String, String> headers) throws RestException {
        LOGGER.info(String.valueOf((Object)Verb.GET) + " " + url);
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(String.valueOf((Object)Verb.GET) + " " + url));
        this.logHandler.addLogEvent(this.logChannel.getLogEvent(""));
        try {
            Invocation.Builder invocationBuilder = this.client.target(url).request(new String[]{"application/json"});
            for (String headerName : headers.keySet()) {
                invocationBuilder = invocationBuilder.header(headerName, (Object)headers.get(headerName));
            }
            File logFile = this.getLogFile();
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(String.valueOf((Object)Verb.GET) + " " + url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Call API log", (Throwable)e);
                }
            }
            Response response = invocationBuilder.get();
            response.bufferEntity();
            LOGGER.info(url + " responded with HTTP/" + response.getStatus());
            this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
            this.logHandler.addLogEvent(this.logChannel.getSeparator());
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Call API log", (Throwable)e);
                }
            }
            return response;
        }
        catch (ProcessingException e) {
            if (e.getCause() != null && e.getCause() instanceof SSLHandshakeException) {
                if (!this.usingCustomFingerprint) {
                    HashSet<String> dummyFingerprints = new HashSet<String>();
                    dummyFingerprints.add("dummy-invalid-fingerprint");
                    try {
                        Client dummyClient = WsRsRestClientFactory.getClientWithWhitelistValidation((String)(this.name + "-dummyFingerprint"), dummyFingerprints, (boolean)true, (boolean)false);
                        WebTarget dummyWebTarget = dummyClient.target(url);
                        String dummyMediaType = "application/json";
                        Invocation.Builder dummyInvocationBuilder = dummyWebTarget.request(new String[]{dummyMediaType});
                        Response dummyResponse = dummyInvocationBuilder.get();
                        LOGGER.info("Got response code " + dummyResponse.getStatus());
                    }
                    catch (Exception ex) {
                        if (ex.getCause() != null && ex.getCause() instanceof SSLHandshakeException) {
                            throw new RestSSLException(ex.getCause().getMessage());
                        }
                        throw e;
                    }
                } else {
                    throw new RestSSLException(e.getCause().getMessage());
                }
            }
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Cannot Call API", (Throwable)e);
            throw new RestException((Throwable)e);
        }
    }

    protected abstract Map<String, String> getHeaders(Verb var1, String var2, Object var3);

    protected com.nuix.automate.utils.api.script.Response callApi(Verb verb, String url, Object bodyRaw) throws RestException {
        Map<String, String> headers = this.getHeaders(verb, url, bodyRaw);
        return this.callApi(verb, url, bodyRaw, headers);
    }

    protected com.nuix.automate.utils.api.script.Response callApi(Verb verb, String url, Object bodyRaw, Map<String, String> headers) throws RestException {
        LOGGER.info(String.valueOf((Object)verb) + " " + url + " on " + this.name);
        String bodyReadable = "";
        String mediaType = null;
        if (bodyRaw instanceof MultiPart) {
            mediaType = "multipart/form-data";
            bodyReadable = "MultiPart Object";
        } else {
            mediaType = "application/json";
            bodyReadable = (String)bodyRaw;
        }
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(String.valueOf((Object)verb) + " " + url));
        if (bodyRaw != null) {
            this.logHandler.addLogEvent(this.logChannel.getLogEvent(bodyReadable));
        }
        this.logHandler.addLogEvent(this.logChannel.getLogEvent(""));
        try (Response response = null;){
            WebTarget webTarget;
            try {
                webTarget = this.client.target(url);
            }
            catch (IllegalStateException e) {
                LOGGER.warn("Client error on " + this.name, (Throwable)e);
                this.initializeClient(false);
                webTarget = this.client.target(url);
            }
            Entity entity = Entity.entity((Object)bodyRaw, (String)mediaType);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{mediaType});
            for (String headerName : headers.keySet()) {
                invocationBuilder = invocationBuilder.header(headerName, (Object)headers.get(headerName));
            }
            File logFile = this.getLogFile();
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(String.valueOf((Object)verb) + " " + url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    if (entity != null) {
                        try {
                            FileUtils.writeStringToFile((File)logFile, (String)entity.getEntity().toString(), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot write Call API log entity", (Throwable)e);
                        }
                    }
                    FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Call API log", (Throwable)e);
                }
            }
            switch (verb) {
                case GET: {
                    response = invocationBuilder.get();
                    break;
                }
                case POST: {
                    response = invocationBuilder.post(entity);
                    break;
                }
                case PUT: {
                    response = invocationBuilder.put(entity);
                    break;
                }
                case DELETE: {
                    response = invocationBuilder.delete();
                    break;
                }
                case HEAD: {
                    response = invocationBuilder.head();
                    break;
                }
                case OPTIONS: {
                    response = invocationBuilder.options();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported verb " + String.valueOf((Object)verb));
                }
            }
            response.bufferEntity();
            byte[] raw = (byte[])response.readEntity(byte[].class);
            String stringResponse = new String(raw, StandardCharsets.UTF_8);
            LOGGER.info(url + " responded with HTTP/" + response.getStatus() + " " + stringResponse.length());
            this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
            this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
            this.logHandler.addLogEvent(this.logChannel.getSeparator());
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(stringResponse + "\n\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Call API log", (Throwable)e);
                }
            }
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Map.Entry header : response.getHeaders().entrySet()) {
                List headerMultivalues = (List)header.getValue();
                StringBuilder headerFlattenValues = new StringBuilder();
                for (Object headerMultivalue : headerMultivalues) {
                    if (headerFlattenValues.length() > 0) {
                        headerFlattenValues.append("\n");
                    }
                    headerFlattenValues.append(headerMultivalue);
                }
                responseHeaders.put((String)header.getKey(), headerFlattenValues.toString());
            }
            com.nuix.automate.utils.api.script.Response response2 = new com.nuix.automate.utils.api.script.Response(response.getStatus(), response.getStatusInfo().getReasonPhrase(), stringResponse, raw, responseHeaders, url);
            return response2;
        }
    }

    private File getLogFile() {
        String logFileName;
        File logFile = null;
        if (this.logFilePath == null && (logFileName = System.getProperty("automate.scriptrestclient.log")) != null) {
            this.logFilePath = Paths.get(logFileName, new String[0]);
        }
        if (this.logFilePath != null) {
            logFile = this.logFilePath.toFile();
        }
        return logFile;
    }

    @Override
    public void close() throws Exception {
        block2: {
            try {
                this.client.close();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Cannot close client " + this.name, (Throwable)e);
            }
        }
        WsRsRestClientFactory.remove((String)this.name);
    }
}

