/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.exceptions.UserTriggeredScriptErrorException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.FileLibrary;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LinkLog;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.operations.ScriptOperationImplementation;
import com.nuix.automate.workflow.core.execution.script.Operation;
import com.nuix.automate.workflow.core.execution.script.WorkflowExecutionAutomateRestClient;
import com.nuix.automate.workflow.core.execution.workflow.Engine;
import com.nuix.automate.workflow.core.execution.workflow.Workflow;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.utils.general.ReflectionUtils;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ScriptWorkflowExecution {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ScriptWorkflowExecution.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    WorkflowExecution workflowExecution;
    ScriptOperationImplementation operation;
    WorkflowExecutionAutomateRestClient restRampiva;
    Map<String, FileLibraryFile> libraryFiles;

    public ScriptWorkflowExecution(WorkflowExecution workflowExecution, WorkflowExecutionAutomateRestClient restRampiva, ScriptOperationImplementation operation, Map<String, FileLibraryFile> libraryFiles) {
        this.restRampiva = restRampiva;
        this.workflowExecution = workflowExecution;
        this.operation = operation;
        this.libraryFiles = new HashMap<String, FileLibraryFile>();
        if (libraryFiles != null) {
            this.libraryFiles.putAll(libraryFiles);
        }
    }

    public ScriptWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowExecution = workflowExecution;
    }

    public void clearStickyParameters() {
    }

    public void clearPersistentParameters() {
        this.clearStickyParameters();
    }

    public void log(String message) {
        if (this.operation != null) {
            this.operation.addExecutionLog(message);
        } else {
            this.workflowExecution.log(message);
        }
    }

    public void logInfo(String message) {
        this.workflowExecution.log(message, LogLevel.INFO);
    }

    public void addLink(String linkUrl) {
        this.workflowExecution.addLink(new LinkLog(linkUrl));
    }

    public void addLink(String linkName, String linkUrl) {
        this.workflowExecution.addLink(new LinkLog(linkName, linkUrl));
    }

    public void addLink(String prefix, String linkName, String linkUrl) {
        this.workflowExecution.addLink(new LinkLog(prefix, linkName, linkUrl));
    }

    public void addLink(String prefix, String linkName, String linkUrl, String suffix) {
        this.workflowExecution.addLink(new LinkLog(prefix, linkName, linkUrl, suffix));
    }

    public void logWarning(String message) {
        if (this.operation != null) {
            this.operation.addWarning(message);
        } else {
            this.workflowExecution.log(message, LogLevel.WARNING);
        }
    }

    public void triggerError(String message) throws Exception {
        this.operation.setErrorMessage(message, Boolean.TRUE.equals(this.operation.softFail));
        throw new UserTriggeredScriptErrorException(message);
    }

    public void stop() {
        this.workflowExecution.stopWorkflow();
    }

    public void pause() {
        this.workflowExecution.log("Pausing execution");
        this.workflowExecution.pauseWorkflow();
        try {
            Engine engine = this.workflowExecution.getExecutionContext().getEngine();
            if (engine != null) {
                engine.pause();
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Cannot send pause information to engine", t);
        }
    }

    public void appendWorkflow(String filename) throws IOException {
        this.workflowExecution.log("Append workflow file " + filename);
        Workflow currentWorkflow = this.workflowExecution.getWorkflow();
        Workflow openedWorkflow = Workflow.fromFile(filename);
        openedWorkflow.normalize(new StringBuilder(), new HashSet<String>());
        this.getFileLibraryFiles(openedWorkflow.getOperations());
        this.splitWeight(openedWorkflow.getOperations());
        for (com.nuix.automate.workflow.core.execution.operations.Operation operation : openedWorkflow.getOperations()) {
            int i = currentWorkflow.getOperations().size() + 1;
            this.workflowExecution.log("Appended new operation #" + i + " " + String.valueOf(operation));
            currentWorkflow.getOperations().add(this.getOperationImplementation(operation));
        }
        currentWorkflow.setModified();
    }

    public void appendWorkflowXml(String workflowXml) throws IOException {
        this.workflowExecution.log("Append workflow XML content");
        Workflow currentWorkflow = this.workflowExecution.getWorkflow();
        Workflow openedWorkflow = Workflow.fromXml(workflowXml);
        openedWorkflow.normalize(new StringBuilder(), new HashSet<String>());
        this.getFileLibraryFiles(openedWorkflow.getOperations());
        this.splitWeight(openedWorkflow.getOperations());
        for (com.nuix.automate.workflow.core.execution.operations.Operation operation : openedWorkflow.getOperations()) {
            int i = currentWorkflow.getOperations().size() + 1;
            this.workflowExecution.log("Appended new operation #" + i + " " + String.valueOf(operation));
            currentWorkflow.getOperations().add(this.getOperationImplementation(operation));
        }
        currentWorkflow.setModified();
    }

    private com.nuix.automate.workflow.core.execution.operations.Operation getOperationImplementation(com.nuix.automate.workflow.core.execution.operations.Operation operation) {
        try {
            return ReflectionUtils.getOperationImplementation(operation);
        }
        catch (ConversionException | CannotResolveClassException e) {
            this.logWarning("Cannot cast operation " + operation.getOperationName() + " to implementation, " + e.getClass().getName());
            LOGGER.error("Cannot cast to implementation", e);
            return operation;
        }
    }

    public void insertWorkflow(String filename) throws IOException {
        this.workflowExecution.log("Insert workflow file " + filename);
        Workflow currentWorkflow = this.workflowExecution.getWorkflow();
        Workflow openedWorkflow = Workflow.fromFile(filename);
        openedWorkflow.normalize(new StringBuilder(), new HashSet<String>());
        int i = this.workflowExecution.getWorkflowExecutionPosition() + 1;
        this.getFileLibraryFiles(openedWorkflow.getOperations());
        this.splitWeight(openedWorkflow.getOperations());
        for (com.nuix.automate.workflow.core.execution.operations.Operation operation : openedWorkflow.getOperations()) {
            this.workflowExecution.log("Inserted new operation #" + i + " " + String.valueOf(operation));
            currentWorkflow.getOperations().add(i, this.getOperationImplementation(operation));
            ++i;
        }
        currentWorkflow.setModified();
    }

    public void insertWorkflowXml(String workflowXml) throws IOException {
        this.workflowExecution.log("Append workflow XML content");
        Workflow currentWorkflow = this.workflowExecution.getWorkflow();
        Workflow openedWorkflow = Workflow.fromXml(workflowXml);
        openedWorkflow.normalize(new StringBuilder(), new HashSet<String>());
        this.getFileLibraryFiles(openedWorkflow.getOperations());
        this.splitWeight(openedWorkflow.getOperations());
        int i = this.workflowExecution.getWorkflowExecutionPosition() + 1;
        for (com.nuix.automate.workflow.core.execution.operations.Operation operation : openedWorkflow.getOperations()) {
            this.workflowExecution.log("Inserted new operation #" + i + " " + String.valueOf(operation));
            currentWorkflow.getOperations().add(i, this.getOperationImplementation(operation));
            ++i;
        }
        currentWorkflow.setModified();
    }

    private void getFileLibraryFiles(List<com.nuix.automate.workflow.core.execution.operations.Operation> operations) {
        HashSet<String> fileLibraryIds = new HashSet<String>();
        ArrayList updatedParameters = new ArrayList();
        for (com.nuix.automate.workflow.core.execution.operations.Operation operation : operations) {
            if (!(operation instanceof ConfigureParametersOperation)) continue;
            for (StaticParameter parameter : ((ConfigureParametersOperation)operation).userParameters) {
                if (!ParameterType.LIBRARY_FILE.equals((Object)parameter.getParameterType())) continue;
                fileLibraryIds.add(parameter.getValue());
                this.operation.addUpdatedParameter(new Parameter((com.nuix.automate.utils.workflow.Parameter)parameter));
            }
            for (StaticParameter parameter : ((ConfigureParametersOperation)operation).staticParameters) {
                if (!ParameterType.LIBRARY_FILE.equals((Object)parameter.getParameterType())) continue;
                fileLibraryIds.add(parameter.getValue());
            }
        }
        if (this.libraryFiles.keySet().containsAll(fileLibraryIds) || fileLibraryIds.isEmpty()) {
            return;
        }
        fileLibraryIds.removeAll(this.libraryFiles.keySet());
        try {
            HashMap files = new HashMap();
            List<FileLibrary> fileLibraries = this.restRampiva.getFileLibraries();
            for (FileLibrary fileLibrary : fileLibraries) {
                files.putAll(fileLibrary.getFiles());
            }
            for (String fileId : fileLibraryIds) {
                try {
                    FileLibraryFile file = (FileLibraryFile)files.get(fileId);
                    if (file == null) continue;
                    file.setData(this.restRampiva.downloadLibraryFile(file.getFileLibraryId(), file.getId()));
                    this.operation.updateFileLibraryFile(file);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to retrieve file " + fileId, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to retrieve file library files", (Throwable)e);
        }
    }

    private void splitWeight(List<com.nuix.automate.workflow.core.execution.operations.Operation> addedOperations) {
        double availableWeight = this.operation.progressWeight;
        LOGGER.info("Splitting weight " + availableWeight + " between " + addedOperations.size() + " added operation(s) and the current operation");
        double totalWeight = 0.0;
        for (com.nuix.automate.workflow.core.execution.operations.Operation operation : addedOperations) {
            totalWeight += operation.progressWeight;
        }
        totalWeight += 1.0;
        for (com.nuix.automate.workflow.core.execution.operations.Operation operation : addedOperations) {
            double splitWeight = operation.progressWeight / totalWeight * availableWeight;
            LOGGER.info("Operation " + operation.getOperationName() + " with original weight " + operation.progressWeight + ", added with split weight " + splitWeight);
            operation.progressWeight = splitWeight;
            operation.normalize();
        }
        double splitWeight = 1.0 / totalWeight * availableWeight;
        LOGGER.info("Operation  " + this.operation.getOperationName() + " original weight " + this.operation.progressWeight + ", added with split weight " + splitWeight);
        this.operation.progressWeight = splitWeight;
        this.operation.normalize();
    }

    public Operation getOperationWithNoteExact(String noteText) {
        List<com.nuix.automate.workflow.core.execution.operations.Operation> executionOperations = this.workflowExecution.getWorkflow().getOperations();
        for (int i = 0; i < executionOperations.size(); ++i) {
            com.nuix.automate.workflow.core.execution.operations.Operation operation = executionOperations.get(i);
            if (!operation.notes.equals(noteText)) continue;
            return new Operation(operation, i + 1);
        }
        throw new RuntimeException(this.iu.getFormattedString("ScriptWorkflowExecution.CannotFindOperationWithExactNote", (Object)noteText));
    }

    public Operation getOperationWithNoteContaining(String noteText) {
        List<com.nuix.automate.workflow.core.execution.operations.Operation> executionOperations = this.workflowExecution.getWorkflow().getOperations();
        for (int i = 0; i < executionOperations.size(); ++i) {
            com.nuix.automate.workflow.core.execution.operations.Operation operation = executionOperations.get(i);
            if (!operation.notes.contains(noteText)) continue;
            return new Operation(operation, i + 1);
        }
        throw new RuntimeException(this.iu.getFormattedString("ScriptWorkflowExecution.CannotFindOperationWithNoteContaining", (Object)noteText));
    }

    public Operation getOperationWithNoteStartingWith(String noteText) {
        List<com.nuix.automate.workflow.core.execution.operations.Operation> executionOperations = this.workflowExecution.getWorkflow().getOperations();
        for (int i = 0; i < executionOperations.size(); ++i) {
            com.nuix.automate.workflow.core.execution.operations.Operation operation = executionOperations.get(i);
            if (!operation.notes.startsWith(noteText)) continue;
            return new Operation(operation, i + 1);
        }
        throw new RuntimeException(this.iu.getFormattedString("ScriptWorkflowExecution.CannotFindOperationWithNoteStartingWith", (Object)noteText));
    }

    public void goToOperationWithNoteExact(String noteText) throws Exception {
        ArrayList<CallSite> matchingOperationIds = new ArrayList<CallSite>();
        Integer firstMatchingOperationId = null;
        int operationId = 1;
        for (com.nuix.automate.workflow.core.execution.operations.Operation o : this.workflowExecution.getWorkflow().getOperations()) {
            if (o.notes.equals(noteText)) {
                if (firstMatchingOperationId == null) {
                    firstMatchingOperationId = operationId;
                }
                matchingOperationIds.add((CallSite)((Object)("#" + operationId)));
            }
            ++operationId;
        }
        if (matchingOperationIds.size() > 1) {
            this.operation.addWarning(this.iu.getFormattedString("ScriptWorkflowExecution.MultipleOperationsWithExactNote", new Object[]{noteText, String.join((CharSequence)", ", matchingOperationIds)}));
        }
        if (firstMatchingOperationId == null) {
            throw new RuntimeException(this.iu.getFormattedString("ScriptWorkflowExecution.CannotFindOperationWithExactNote", (Object)noteText));
        }
        this.goToOperation(firstMatchingOperationId);
    }

    public void goToOperationWithNoteContaining(String noteText) throws Exception {
        ArrayList<CallSite> matchingOperationIds = new ArrayList<CallSite>();
        Integer firstMatchingOperationId = null;
        int operationId = 1;
        for (com.nuix.automate.workflow.core.execution.operations.Operation o : this.workflowExecution.getWorkflow().getOperations()) {
            if (o.notes.contains(noteText)) {
                if (firstMatchingOperationId == null) {
                    firstMatchingOperationId = operationId;
                }
                matchingOperationIds.add((CallSite)((Object)("#" + operationId)));
            }
            ++operationId;
        }
        if (matchingOperationIds.size() > 1) {
            this.operation.addWarning(this.iu.getFormattedString("ScriptWorkflowExecution.MultipleOperationsWithNoteContaining", new Object[]{noteText, String.join((CharSequence)", ", matchingOperationIds)}));
        }
        if (firstMatchingOperationId == null) {
            throw new RuntimeException(this.iu.getFormattedString("ScriptWorkflowExecution.CannotFindOperationWithNoteContaining", (Object)noteText));
        }
        this.goToOperation(firstMatchingOperationId);
    }

    public void goToOperationWithNoteStartingWith(String noteText) throws Exception {
        ArrayList<CallSite> matchingOperationIds = new ArrayList<CallSite>();
        Integer firstMatchingOperationId = null;
        int operationId = 1;
        for (com.nuix.automate.workflow.core.execution.operations.Operation o : this.workflowExecution.getWorkflow().getOperations()) {
            if (o.notes.startsWith(noteText)) {
                if (firstMatchingOperationId == null) {
                    firstMatchingOperationId = operationId;
                }
                matchingOperationIds.add((CallSite)((Object)("#" + operationId)));
            }
            ++operationId;
        }
        if (matchingOperationIds.size() > 1) {
            this.operation.addWarning(this.iu.getFormattedString("ScriptWorkflowExecution.MultipleOperationsWithNoteStartingWith", new Object[]{noteText, String.join((CharSequence)", ", matchingOperationIds)}));
        }
        if (firstMatchingOperationId == null) {
            throw new RuntimeException(this.iu.getFormattedString("ScriptWorkflowExecution.CannotFindOperationWithNoteStartingWith", (Object)noteText));
        }
        this.goToOperation(firstMatchingOperationId);
    }

    public Collection<Operation> getOperations() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        List<com.nuix.automate.workflow.core.execution.operations.Operation> executionOperations = this.workflowExecution.getWorkflow().getOperations();
        for (int i = 0; i < executionOperations.size(); ++i) {
            com.nuix.automate.workflow.core.execution.operations.Operation operation = executionOperations.get(i);
            operations.add(new Operation(operation, i + 1));
        }
        return operations;
    }

    public Collection<Operation> getOperationsWithWarnings() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        List<com.nuix.automate.workflow.core.execution.operations.Operation> executionOperations = this.workflowExecution.getWorkflow().getOperations();
        for (int i = 0; i < executionOperations.size(); ++i) {
            com.nuix.automate.workflow.core.execution.operations.Operation operation = executionOperations.get(i);
            if (!operation.getEncounteredWarnings()) continue;
            operations.add(new Operation(operation, i + 1));
        }
        return operations;
    }

    public Collection<Operation> getOperationsWithErrors() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        List<com.nuix.automate.workflow.core.execution.operations.Operation> executionOperations = this.workflowExecution.getWorkflow().getOperations();
        for (int i = 0; i < executionOperations.size(); ++i) {
            com.nuix.automate.workflow.core.execution.operations.Operation operation = executionOperations.get(i);
            if (!operation.getEncounteredError()) continue;
            operations.add(new Operation(operation, i + 1));
        }
        return operations;
    }

    public Collection<Operation> getOperationsWithExecutionState(ExecutionState executionState) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        List<com.nuix.automate.workflow.core.execution.operations.Operation> executionOperations = this.workflowExecution.getWorkflow().getOperations();
        for (int i = 0; i < executionOperations.size(); ++i) {
            com.nuix.automate.workflow.core.execution.operations.Operation operation = executionOperations.get(i);
            if (operation.executionState != executionState) continue;
            operations.add(new Operation(operation, i + 1));
        }
        return operations;
    }

    public Operation getOperation(int id) {
        if (id <= 0 || id > this.workflowExecution.getWorkflow().getOperations().size() + 1) {
            throw new RuntimeException("Cannot get warnings for operation #" + id + ". Current workflow has " + this.workflowExecution.getWorkflow().getOperations().size() + " operations.");
        }
        return new Operation(this.workflowExecution.getWorkflow().getOperations().get(id - 1), id);
    }

    public void goToOperation(int id) throws Exception {
        if (id <= 0 || id > this.workflowExecution.getWorkflow().getOperations().size() + 1) {
            throw new RuntimeException("Cannot go to operation #" + id + ". Current workflow has " + this.workflowExecution.getWorkflow().getOperations().size() + " operations.");
        }
        this.workflowExecution.log(this.iu.getFormattedString("ScriptWorkflowExecution.JumpToOperationNumber", (Object)id));
        this.workflowExecution.setNextWorkflowExecutionPosition(id);
    }

    public int getCurrentOperationId() throws Exception {
        return this.workflowExecution.getWorkflowExecutionPosition() + 1;
    }

    public int getOperationsCount() throws Exception {
        return this.workflowExecution.getWorkflow().getOperations().size();
    }

    public void goToNthOperationOfType(int n, String type) throws Exception {
        int i = 0;
        int operationId = 1;
        for (com.nuix.automate.workflow.core.execution.operations.Operation o : this.workflowExecution.getWorkflow().getOperations()) {
            if (o.getOperationName().equalsIgnoreCase(type) && ++i == n) {
                this.goToOperation(operationId);
                return;
            }
            ++operationId;
        }
        throw new RuntimeException(this.iu.getFormattedString("ScriptWorkflowExecution.CannotFindNthOperation", new Object[]{n, type, i}));
    }

    public double getPercentageComplete() {
        return this.workflowExecution.getPercentageComplete() / 100.0;
    }

    public void setProgress(double progress) {
        this.operation.setPercentageComplete(progress);
    }

    public void setItemsProcessed(long itemsProcessed) {
        this.operation.setItemsProcessed(itemsProcessed);
    }

    public void setTaskName(String taskName) {
        this.operation.setTaskName(taskName);
    }

    public boolean tryAcquireLock(String lockName) throws ParameterException, IOException {
        String jobId = this.workflowExecution.getExecutionContext().evalParameters("{job_id}", this.operation);
        boolean lockAcquired = false;
        try {
            lockAcquired = this.restRampiva.tryAcquireLock(jobId, lockName);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot acquire lock", (Throwable)e);
        }
        if (!lockAcquired) {
            try {
                lockAcquired = this.restRampiva.releaseLock(jobId, lockName);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot release lock", (Throwable)e);
            }
        }
        return lockAcquired;
    }

    private boolean acquireLockIfAvailable(String lockName) throws ParameterException, IOException {
        String jobId = this.workflowExecution.getExecutionContext().evalParameters("{job_id}", this.operation);
        boolean lockAcquired = false;
        try {
            lockAcquired = this.restRampiva.tryAcquireLock(jobId, lockName);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot acquire lock", (Throwable)e);
        }
        return lockAcquired;
    }

    public void acquireLock(String lockName) throws ParameterException, IOException {
        boolean lockAcquired;
        this.operation.addExecutionLog(this.iu.getFormattedString("Lock.AcquiringLock", (Object)lockName));
        do {
            if (!(lockAcquired = this.acquireLockIfAvailable(lockName))) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (!this.operation.getStopRequested()) continue;
            throw new IllegalStateException("Execution stop requested");
        } while (!lockAcquired);
        if (lockAcquired) {
            this.operation.addExecutionLog(this.iu.getString("Lock.AcquiredLock"));
        }
    }

    public boolean releaseLock(String lockName) throws ParameterException, IOException {
        String jobId = this.workflowExecution.getExecutionContext().evalParameters("{job_id}", this.operation);
        try {
            boolean result = this.restRampiva.releaseLock(jobId, lockName);
            if (result) {
                this.operation.addExecutionLog(this.iu.getFormattedString("Lock.ReleasedLock", (Object)lockName));
            }
            return result;
        }
        catch (Exception e) {
            this.operation.addWarning(this.iu.getFormattedString("Lock.CannotReleaseLock", (Object)FormattingUtils.getExceptionPrintableMessage((Exception)e)));
            LOGGER.warn("Cannot release lock", (Throwable)e);
            return false;
        }
    }
}

