/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.google.gson.reflect.TypeToken;
import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.DummyLogChannel;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.FileLibrary;
import com.nuix.automate.workflow.core.execution.operations.ScriptOperationImplementation;
import com.nuix.automate.workflow.core.execution.script.AutomateRestClient;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public class WorkflowExecutionAutomateRestClient
extends AutomateRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowExecutionAutomateRestClient.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private WorkflowExecution workflowExecution;
    private ScriptOperationImplementation operation;

    public WorkflowExecutionAutomateRestClient(WorkflowExecution workflowExecution, ScriptOperationImplementation operation) {
        super((LogChannel)new DummyLogChannel(), "WorkflowExecutionAutomateRestClient");
        this.workflowExecution = workflowExecution;
        this.operation = operation;
        this.initializeUrl();
        this.initializeFingerprint();
        this.initializeBearerToken();
    }

    @Override
    public void setBearerToken(String bearerToken) {
        try {
            this.bearerToken = this.workflowExecution.getExecutionContext().evalProtectedParameter(bearerToken);
        }
        catch (ParameterException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeUrl() {
        try {
            this.baseUrl = this.workflowExecution.getExecutionContext().evalParametersIfSet("{scheduler_url}", this.operation).trim();
            LOGGER.info("Scheduler base URL: " + this.baseUrl);
        }
        catch (ParameterException e) {
            LOGGER.error("Cannot evaluate parameter {scheduler_url}");
        }
    }

    private void initializeFingerprint() {
        try {
            this.setFingerprint(this.workflowExecution.getExecutionContext().evalParametersIfSet("{scheduler_cert_fingerprint}", this.operation).trim());
        }
        catch (ParameterException e) {
            LOGGER.error("Cannot evaluate parameter {scheduler_cert_fingerprint}");
        }
    }

    private void initializeBearerToken() {
        try {
            this.bearerToken = this.workflowExecution.getExecutionContext().evalProtectedParameterIfSet("{job_bearer_token_protected}").trim();
        }
        catch (ParameterException e) {
            LOGGER.error("Cannot evaluate parameter {job_bearer_token_protected}");
        }
    }

    @Override
    protected String getCallUrl(String endpoint) throws IOException {
        if (this.baseUrl == null) {
            throw new IOException("Scheduler API URL is not defined. Define {scheduler_url} or call automateRest.setBaseUrl(String s) before calling this method.");
        }
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.bearerToken == null) {
            throw new IOException("Scheduler API bearer token is not defined. Define {job_bearer_token_protected} or call automateRest.setBearerToken(String s) before calling this method.");
        }
        String callUrl = endpoint.startsWith("/") ? this.baseUrl + endpoint : this.baseUrl + "/" + endpoint;
        return callUrl;
    }

    public String getUrl() {
        return this.baseUrl;
    }

    public boolean tryAcquireLock(String jobId, String lockName) throws IOException {
        Response response = this.post("/api/v1/scheduler/lock/" + FormattingUtils.encodeForUrl((String)jobId) + "?lockName=" + FormattingUtils.encodeForUrl((String)lockName), null);
        return (Boolean)response.json();
    }

    public boolean releaseLock(String jobId, String lockName) throws IOException {
        Response response = this.delete("/api/v1/scheduler/lock/" + FormattingUtils.encodeForUrl((String)jobId) + "?lockName=" + FormattingUtils.encodeForUrl((String)lockName));
        return (Boolean)response.json();
    }

    public List<FileLibrary> getFileLibraries() throws IOException {
        Response response = this.get("/api/v1/scheduler/resources/fileLibraries?includeFiles=true");
        Type fileLibraryType = new TypeToken<List<FileLibrary>>(){}.getType();
        return (List)response.getObject(fileLibraryType);
    }

    public String downloadLibraryFile(String fileLibraryId, String fileId) throws IOException {
        Response response = this.get("/api/v1/scheduler/resources/fileLibraries/" + fileLibraryId + "/files/" + fileId + "/download");
        return response.text;
    }
}

