/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.DummyLogChannel;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.relativity.EndpointType;
import com.nuix.automate.workflow.core.execution.operations.ScriptOperationImplementation;
import com.nuix.automate.workflow.core.execution.script.RelativityRestClient;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class WorkflowExecutionRelativityRestClient
extends RelativityRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowExecutionRelativityRestClient.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private WorkflowExecution workflowExecution;
    private ScriptOperationImplementation operation;

    public WorkflowExecutionRelativityRestClient(WorkflowExecution workflowExecution, ScriptOperationImplementation operation) {
        super((LogChannel)new DummyLogChannel(), "RelativityRestClient");
        this.workflowExecution = workflowExecution;
        this.operation = operation;
        this.initializeUrl();
        this.initializeBearerToken();
        this.applyFingerprints();
    }

    private void applyFingerprints() {
        try {
            String certificateFingerprints = this.workflowExecution.getExecutionContext().evalParameters("{wfn_relativity_whitelisted_cert_fingerprints}", this.operation);
            if (certificateFingerprints == null || certificateFingerprints.trim().equals("{wfn_relativity_whitelisted_cert_fingerprints}")) {
                return;
            }
            HashSet fingerprints = new HashSet((Collection)SerializationUtils.fromJson((String)certificateFingerprints));
            if (fingerprints != null && fingerprints.size() >= 1) {
                this.setFingerprint((String)fingerprints.iterator().next());
            }
        }
        catch (ParameterException e) {
            LOGGER.error("Cannot set Relativity fingerprints from parameters");
        }
    }

    private void initializeUrl() {
        try {
            String relativityHostname = this.workflowExecution.getExecutionContext().evalParameters("{wfn_relativity_hostname}", this.operation);
            String relativityEndpointType = this.workflowExecution.getExecutionContext().evalParametersIfSet("{wfn_relativity_endpoint_type}", this.operation);
            EndpointType endpointType = EndpointType.valueOf((String)relativityEndpointType);
            this.baseUrl = endpointType == EndpointType.HTTP ? "http://" : "https://";
            this.baseUrl = this.baseUrl + relativityHostname;
        }
        catch (ParameterException e) {
            LOGGER.debug("Cannot set Relativity URL from parameters");
        }
    }

    private void initializeBearerToken() {
        try {
            this.relativityUsername = this.workflowExecution.getExecutionContext().evalParameters("{wfn_relativity_username}", this.operation);
            this.bearerToken = this.workflowExecution.getExecutionContext().evalProtectedParameterIfSet("{wfn_relativity_password}");
        }
        catch (ParameterException e) {
            LOGGER.debug("Cannot evaluate parameter {wfn_relativity_password}");
        }
    }

    @Override
    public void setBasicAuth(String username, String password) throws ParameterException {
        this.relativityUsername = username;
        this.bearerToken = this.workflowExecution.getExecutionContext().evalProtectedParameter(password);
    }

    @Override
    protected String getCallUrl(String endpoint) throws IOException {
        if (this.baseUrl == null) {
            throw new IOException("Relativity API URL is not defined. Add the Configure Relativity Connection operation or call relativityRest.setBaseUrl(String s) before calling this method.");
        }
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.bearerToken == null) {
            throw new IOException("Relativity API bearer token is not defined. Add the Configure Relativity Connection operation or call relativityRest.setBearerToken(String s) before calling this method.");
        }
        String callUrl = endpoint.startsWith("/") ? this.baseUrl + endpoint : this.baseUrl + "/" + endpoint;
        return callUrl;
    }
}

