/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.workflow;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.Encryptor;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.OperationExecutionState;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.utils.general.SerializerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class WorkflowExecutionState {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowExecutionState.class);
    private String workflowName;
    private String executionLog;
    private int executionPosition;
    private List<OperationExecutionState> operationExecutionStates;
    private Set<String> caseFolders;
    private boolean caseOpened;
    private List<StaticParameter> executionCustomParameters;
    private List<StaticParameter> executionBuiltInparameters;
    private long startEpoch;
    public boolean workflowParallelSettings;
    public int workflowLocalWorkersCount;
    public int workflowLocalWorkersMemoryMb;
    public String workflowLocalWorkersTempFolder;
    public int workflowBrokerWorkersCount;
    public String workflowBrokerIp;
    public int workflowBrokerPort;

    public WorkflowExecutionState() {
    }

    public boolean getCaseOpened() {
        return this.caseOpened;
    }

    public WorkflowExecutionState(WorkflowExecution workflowExecution) {
        this(workflowExecution, true);
    }

    public WorkflowExecutionState(WorkflowExecution workflowExecution, boolean encryptParameters) {
        String parameterValue;
        this.startEpoch = workflowExecution.getStartEpoch();
        this.executionLog = workflowExecution.getExecutionLog();
        this.executionPosition = workflowExecution.getWorkflowExecutionPosition();
        this.workflowName = workflowExecution.getWorkflow().getName();
        this.caseFolders = workflowExecution.getCaseFolders();
        this.caseOpened = workflowExecution.getCaseOpenedBeforePausing();
        this.workflowParallelSettings = workflowExecution.getExecutionContext().workflowParallelSettings;
        this.workflowLocalWorkersCount = workflowExecution.getExecutionContext().workflowLocalWorkersCount;
        this.workflowLocalWorkersMemoryMb = workflowExecution.getExecutionContext().workflowLocalWorkersMemoryMb;
        this.workflowLocalWorkersTempFolder = workflowExecution.getExecutionContext().workflowLocalWorkersTempFolder;
        this.workflowBrokerWorkersCount = workflowExecution.getExecutionContext().workflowBrokerWorkersCount;
        this.workflowBrokerIp = workflowExecution.getExecutionContext().workflowBrokerIp;
        this.workflowBrokerPort = workflowExecution.getExecutionContext().workflowBrokerPort;
        this.executionCustomParameters = new ArrayList<StaticParameter>();
        Encryptor encryptor = Encryptor.getUserInstance();
        for (Parameter parameter : workflowExecution.getExecutionContext().getExecutionCustomParameters().getParameters()) {
            try {
                parameterValue = parameter.getValue();
                if (parameter.isEffectiveTypeMaskedOrProtected()) {
                    parameterValue = encryptParameters ? encryptor.encrypt(parameter.getProtectedValue()) : Parameter.MASKED_VALUE;
                }
                this.executionCustomParameters.add(new StaticParameter(parameter.getName(), parameterValue));
            }
            catch (ParameterException e) {
                LOGGER.error("Cannot serialize parameter " + parameter.getName());
                this.executionCustomParameters.add(new StaticParameter(parameter.getName(), null));
            }
            catch (IOException e) {
                LOGGER.error("Cannot encrypt parameter " + parameter.getName());
                this.executionCustomParameters.add(new StaticParameter(parameter.getName(), null));
            }
        }
        this.executionBuiltInparameters = new ArrayList<StaticParameter>();
        for (Parameter parameter : workflowExecution.getExecutionContext().getExecutionBuiltInParameters().getParameters()) {
            if (!parameter.getClass().equals(StaticParameter.class)) continue;
            try {
                parameterValue = parameter.getValue();
                if (parameter.isEffectiveTypeMaskedOrProtected()) {
                    parameterValue = encryptParameters ? encryptor.encrypt(parameter.getProtectedValue()) : Parameter.MASKED_VALUE;
                }
                this.executionBuiltInparameters.add(new StaticParameter(parameter.getName(), parameterValue));
            }
            catch (ParameterException e) {
                LOGGER.error("Cannot serialize parameter " + parameter.getName());
                this.executionBuiltInparameters.add(new StaticParameter(parameter.getName(), null));
            }
            catch (IOException e) {
                LOGGER.error("Cannot encrypt parameter " + parameter.getName());
                this.executionBuiltInparameters.add(new StaticParameter(parameter.getName(), null));
            }
        }
        this.operationExecutionStates = new ArrayList<OperationExecutionState>();
        for (Operation operation : workflowExecution.getWorkflow().getOperations()) {
            this.operationExecutionStates.add(new OperationExecutionState(operation));
        }
        for (OperationExecutionState operationExecutionState : this.operationExecutionStates) {
            Operation operation = operationExecutionState.getOperation();
            if (!(operation instanceof ConfigureParametersOperation)) continue;
            ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)operation;
            for (StaticParameter parameter : configureParametersOperation.staticParameters) {
                try {
                    if (!parameter.isEffectiveTypeMaskedOrProtected()) continue;
                    if (encryptParameters) {
                        parameter.setValue(encryptor.encrypt(parameter.getProtectedValue()));
                        continue;
                    }
                    parameter.setValue(Parameter.MASKED_VALUE);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot encrypt parameter " + parameter.getName());
                    parameter.setValue(null);
                }
            }
            for (StaticParameter parameter : configureParametersOperation.userParameters) {
                try {
                    if (!parameter.isEffectiveTypeMaskedOrProtected()) continue;
                    if (encryptParameters) {
                        parameter.setValue(encryptor.encrypt(parameter.getProtectedValue()));
                        continue;
                    }
                    parameter.setValue(Parameter.MASKED_VALUE);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot encrypt parameter " + parameter.getName());
                    parameter.setValue(null);
                }
            }
            String originalState = configureParametersOperation.getOriginalState();
            if (originalState == null) continue;
            try {
                ConfigureParametersOperation originalStateOperation = (ConfigureParametersOperation)SerializerFactory.getSerializer().deserialize(originalState);
                for (StaticParameter parameter : originalStateOperation.staticParameters) {
                    try {
                        if (!parameter.isEffectiveTypeMaskedOrProtected()) continue;
                        if (encryptParameters) {
                            parameter.setValue(encryptor.encrypt(parameter.getProtectedValue()));
                            continue;
                        }
                        parameter.setValue(Parameter.MASKED_VALUE);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot encrypt parameter " + parameter.getName());
                        parameter.setValue(null);
                    }
                }
                for (StaticParameter parameter : originalStateOperation.userParameters) {
                    try {
                        if (!parameter.isEffectiveTypeMaskedOrProtected()) continue;
                        if (encryptParameters) {
                            parameter.setValue(encryptor.encrypt(parameter.getProtectedValue()));
                            continue;
                        }
                        parameter.setValue(Parameter.MASKED_VALUE);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot encrypt parameter " + parameter.getName());
                        parameter.setValue(null);
                    }
                }
                originalState = SerializerFactory.getSerializer().serialize(originalStateOperation);
                operationExecutionState.setOriginalState(originalState);
                operation.setOriginalState(originalState);
            }
            catch (IOException e) {
                LOGGER.error("Cannot serialize original state", (Throwable)e);
            }
        }
    }

    public List<StaticParameter> getExecutionBuiltInparameters() {
        return this.executionBuiltInparameters;
    }

    public void setExecutionBuiltInparameters(List<StaticParameter> executionBuiltInparameters) {
        this.executionBuiltInparameters = executionBuiltInparameters;
    }

    public Set<String> getCaseFolders() {
        return this.caseFolders;
    }

    public void setCaseFolders(Set<String> caseFolders) {
        this.caseFolders = caseFolders;
    }

    public List<StaticParameter> getExecutionCustomParameters() {
        return this.executionCustomParameters;
    }

    public void setExecutionCustomParameters(List<StaticParameter> executionCustomParameters) {
        this.executionCustomParameters = executionCustomParameters;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getExecutionLog() {
        return this.executionLog;
    }

    public void setExecutionLog(String executionLog) {
        this.executionLog = executionLog;
    }

    public int getExecutionPosition() {
        return this.executionPosition;
    }

    public void setExecutionPosition(int executionPosition) {
        this.executionPosition = executionPosition;
    }

    public List<OperationExecutionState> getOperationExecutionStates() {
        return this.operationExecutionStates;
    }

    public void setOperationExecutionStates(List<OperationExecutionState> operationExecutionStates) {
        this.operationExecutionStates = operationExecutionStates;
    }

    public long getStartEpoch() {
        return this.startEpoch;
    }

    public void setStartEpoch(long startEpoch) {
        this.startEpoch = startEpoch;
    }
}

