/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.licence;

import com.google.gson.Gson;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Format;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Key;
import com.nuix.automate.workflow.core.licence.NuixLicenceFactory;
import com.nuix.automate.workflow.core.utils.nuix.NuixLicenceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nuix.Licence;

public abstract class NuixLicenceSession
extends LicenceSession {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixLicenceSession.class);
    private Licence nuixLicence;
    private String nuixVersion;

    public NuixLicenceSession(Credentials credentials, LicenceInfo licenceInfo, Licence nuixLicence, Product product, String productVersion, String nuixVersion, Key key, DiagnosticLevel diagnosticLevel) {
        super(credentials, licenceInfo, product, productVersion, key, diagnosticLevel);
        this.nuixLicence = nuixLicence;
        this.nuixVersion = nuixVersion;
    }

    public EventInfo getSessionStartEvent() {
        EventInfo eventInfo = super.getSessionStartEvent();
        HashMap<String, Object> properties = new HashMap<String, Object>(eventInfo.getProperties());
        try {
            Gson gson = new Gson();
            Map nuixLicenceDetails = (Map)gson.fromJson(NuixLicenceFactory.getInstance().getSoftwareDetails(Format.JSON), Map.class);
            properties.put("nuixLicenseDetails", nuixLicenceDetails);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse Engine license details");
            properties.put("nuixLicenseDetails", NuixLicenceFactory.getInstance().getSoftwareDetails());
        }
        properties.put("nuixVersion", this.nuixVersion);
        if (this.nuixLicence != null) {
            try {
                properties.put("nuixWorkersCount", this.nuixLicence.getWorkers());
                properties.put("nuixLicenseShortName", this.nuixLicence.getShortName());
            }
            catch (Exception e) {
                properties.put("nuixLicenseException", ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            }
        }
        Set<String> fingerprints = NuixLicenceUtils.getLicenceFingerprint(this.nuixLicence);
        String nuixLicenseFingerprint = "";
        if (!fingerprints.isEmpty()) {
            nuixLicenseFingerprint = fingerprints.iterator().next();
        }
        properties.put("nuixLicenseFingerprint", nuixLicenseFingerprint);
        properties.putAll(NuixLicenceUtils.getLicenseIdAndOwner(this.nuixLicence));
        eventInfo.setProperties(properties);
        return eventInfo;
    }
}

