/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.licence;

import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.licence.services.SerializerUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Key;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.workflow.core.licence.NuixLicenceFactory;
import com.nuix.automate.workflow.core.licence.NuixLicenceSession;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import javax.ws.rs.core.GenericType;
import nuix.Licence;

public abstract class WorkflowLicenceSession
extends NuixLicenceSession {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowLicenceSession.class);
    private SerializerUtils serializerUtils;
    private ExecutionContext executionContext;

    public WorkflowLicenceSession(ExecutionContext executionContext, Credentials credentials, LicenceInfo licenceInfo, Licence nuixLicence, Product product, String productVersion, String nuixVersion, Key key, DiagnosticLevel diagnosticLevel) {
        super(credentials, licenceInfo, nuixLicence, product, productVersion, nuixVersion, key, diagnosticLevel);
        this.executionContext = executionContext;
        executionContext.licenceSession = this;
        this.serializerUtils = new SerializerUtils();
    }

    protected void handleFailedEventTracking(EventInfo eventInfo, Exception e) {
        Path eventsFolderPath;
        File eventsFolder;
        if (this.getServerRestClient() != null) {
            LOGGER.warn("Cannot send " + String.valueOf(eventInfo), (Throwable)e);
        }
        if (!(eventsFolder = (eventsFolderPath = Paths.get(NuixLicenceFactory.getInstance().getLocation("cache"), new String[0])).toFile()).exists()) {
            eventsFolder.mkdirs();
        }
        Object filename = eventInfo.getSessionId() + "#" + String.valueOf(eventInfo.getType());
        if (eventInfo.getSubSessionId() != null && eventInfo.getSubSessionId().length() > 0) {
            filename = (String)filename + "#" + eventInfo.getSubSessionId();
        }
        filename = ((String)filename).replace("SESSION_START", "SS");
        filename = ((String)filename).replace("SESSION_PING", "SP");
        filename = ((String)filename).replace("SESSION_END", "SE");
        filename = ((String)filename).replace("SESSION_METRICS", "SM");
        try {
            this.serializerUtils.serializeEncrypted("session", (Object)eventInfo, eventsFolderPath.resolve((String)filename));
        }
        catch (IOException ex) {
            LOGGER.error("Cannot track failed event " + String.valueOf(eventInfo), (Throwable)e);
        }
    }

    protected void handleFailedConsumptionTracking(Consumption consumption, Exception e) {
        Path eventsFolderPath;
        File eventsFolder;
        if (this.getServerRestClient() != null) {
            LOGGER.warn("Cannot send " + String.valueOf(consumption), (Throwable)e);
        }
        if (!(eventsFolder = (eventsFolderPath = Paths.get(NuixLicenceFactory.getInstance().getLocation("cache"), new String[0])).toFile()).exists()) {
            eventsFolder.mkdirs();
        }
        String filename = String.valueOf(UUID.randomUUID()) + "#CE";
        try {
            this.serializerUtils.serializeEncrypted("consumption", (Object)consumption, eventsFolderPath.resolve(filename));
        }
        catch (IOException ex) {
            LOGGER.error("Cannot track failed consumption " + String.valueOf(consumption), (Throwable)e);
        }
    }

    protected void handleFailedUtilizationTracking(UtilizationRecords utilizationRecords, Exception e) {
        Path eventsFolderPath;
        File eventsFolder;
        if (this.getServerRestClient() != null) {
            LOGGER.warn("Cannot send utilization records " + String.valueOf(utilizationRecords), (Throwable)e);
        }
        if (!(eventsFolder = (eventsFolderPath = Paths.get(NuixLicenceFactory.getInstance().getLocation("cache"), new String[0])).toFile()).exists()) {
            eventsFolder.mkdirs();
        }
        String filename = utilizationRecords.getId() + "#U";
        try {
            this.serializerUtils.serializeEncrypted("utilization", (Object)utilizationRecords, eventsFolderPath.resolve(filename));
        }
        catch (IOException ex) {
            LOGGER.error("Cannot track failed utilization records " + String.valueOf(utilizationRecords), (Throwable)e);
        }
    }

    protected boolean retryTrackingPreviouslyFailedEvents() {
        boolean trackedEvents = false;
        File eventsFolder = new File(NuixLicenceFactory.getInstance().getLocation("cache"));
        if (eventsFolder.exists()) {
            for (File f : eventsFolder.listFiles()) {
                UtilizationRecords utilizationRecords;
                boolean success;
                if (f.getName().contains("#S")) {
                    try {
                        EventInfo eventInfo = (EventInfo)this.serializerUtils.deserializeEncrypted("session", Paths.get(f.getAbsolutePath(), new String[0]), (GenericType)new GenericType<EventInfo>(){});
                        success = this.tryTrackEvent(eventInfo, false);
                        if (!success) continue;
                        trackedEvents = true;
                        f.delete();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Cannot handle cached event " + f.getName());
                    }
                    continue;
                }
                if (f.getName().contains("#U")) {
                    try {
                        utilizationRecords = (UtilizationRecords)this.serializerUtils.deserializeEncrypted("utilization", Paths.get(f.getAbsolutePath(), new String[0]), (GenericType)new GenericType<UtilizationRecords>(){});
                        success = this.tryTrackUtilizationRecords(utilizationRecords, false);
                        if (!success) continue;
                        trackedEvents = true;
                        f.delete();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Cannot handle cached event " + f.getName());
                    }
                    continue;
                }
                if (!f.getName().contains("#CE")) continue;
                try {
                    utilizationRecords = (UtilizationRecords)this.serializerUtils.deserializeEncrypted("consumption", Paths.get(f.getAbsolutePath(), new String[0]), (GenericType)new GenericType<UtilizationRecords>(){});
                    success = this.tryTrackUtilizationRecords(utilizationRecords, false);
                    if (!success) continue;
                    trackedEvents = true;
                    f.delete();
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Cannot handle cached event " + f.getName());
                }
            }
        }
        return trackedEvents;
    }

    protected void onBeforePing() {
        if (this.executionContext != null && this.executionContext.nuixUtilities != null) {
            boolean licenseInvalid = false;
            try {
                if (this.executionContext.nuixUtilities.getLicence() == null) {
                    licenseInvalid = true;
                }
            }
            catch (Exception e) {
                licenseInvalid = true;
            }
            if (licenseInvalid) {
                LOGGER.info("Engine License because invalid, stopping Automate session");
                this.close();
            }
        }
    }
}

