/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.nuix;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class ApiMethodTrackingProcessor {
    final Map<String, AtomicInteger> apiMethodCountMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final Integer batchSize;
    private final AtomicInteger batchCount = new AtomicInteger(0);
    private final ExecutorService persistExecutorService = Executors.newSingleThreadExecutor();
    private final Consumer<Map<String, AtomicInteger>> persistenceConsumer;
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ApiMethodTrackingProcessor.class);

    public ApiMethodTrackingProcessor(Integer batchSize, Consumer<Map<String, AtomicInteger>> persistenceConsumer) {
        this.batchSize = batchSize;
        this.persistenceConsumer = persistenceConsumer;
    }

    public ApiMethodTrackingProcessor(Consumer<Map<String, AtomicInteger>> persistenceConsumer) {
        this.batchSize = null;
        this.persistenceConsumer = persistenceConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackRequest(String trackedApiMethod) {
        int currentBatchCount;
        this.apiMethodCountMap.computeIfAbsent(trackedApiMethod, k -> new AtomicInteger(0)).incrementAndGet();
        if (this.batchSize != null && (currentBatchCount = this.batchCount.incrementAndGet()) >= this.batchSize) {
            ApiMethodTrackingProcessor apiMethodTrackingProcessor = this;
            synchronized (apiMethodTrackingProcessor) {
                if (this.batchCount.get() >= this.batchSize) {
                    ConcurrentHashMap<String, AtomicInteger> mapToPersist = new ConcurrentHashMap<String, AtomicInteger>(this.apiMethodCountMap);
                    this.persistExecutorService.submit(() -> this.persistDataBatch(mapToPersist));
                    this.batchCount.set(0);
                    this.apiMethodCountMap.clear();
                }
            }
        }
    }

    void persistDataBatch(Map<String, AtomicInteger> mapToPersist) {
        this.persistenceConsumer.accept(mapToPersist);
    }

    public void flush() {
        if (!this.apiMethodCountMap.isEmpty()) {
            LOGGER.info("Flushing " + this.apiMethodCountMap.size() + " keys");
            this.persistDataBatch(new ConcurrentHashMap<String, AtomicInteger>(this.apiMethodCountMap));
            this.apiMethodCountMap.clear();
            this.batchCount.set(0);
        }
        this.persistExecutorService.shutdown();
        try {
            if (!this.persistExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOGGER.error("Executor service did not terminate in the expected time.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Executor service interrupted during shutdown.");
        }
    }
}

