/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.nuix;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.nuix.CustomDeduplicationField;
import com.nuix.automate.workflow.core.nuix.CustomItemExpression;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import nuix.Item;

public class CustomDeduplicatorByFamily {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CustomDeduplicatorByFamily.class);
    private static final boolean verbose = false;
    private String topLevelKey;
    private int hashCode;
    private String guid;
    private String topLevelGuid;
    private CustomItemExpression itemExpression;

    public CustomDeduplicatorByFamily(Item item, CustomItemExpression itemExpression, CustomDeduplicationField customDeduplicationField) {
        this.itemExpression = itemExpression;
        Item topLevelItem = item.getTopLevelItem();
        if (topLevelItem == null) {
            topLevelItem = item;
        }
        if (topLevelItem != null) {
            this.topLevelKey = ItemsUtils.getItemKeyOrGuid(topLevelItem, customDeduplicationField);
        }
        this.guid = item.getGuid();
        this.topLevelGuid = topLevelItem.getGuid();
        this.hashCode = this.topLevelKey == null ? 0 : this.topLevelKey.hashCode();
    }

    public String getTopLevelGuid() {
        return this.topLevelGuid;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getTopLevelKey() {
        return this.topLevelKey;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CustomDeduplicatorByFamily)) {
            return false;
        }
        CustomDeduplicatorByFamily compareTo = (CustomDeduplicatorByFamily)o;
        String prefix = "";
        if (this.guid.equals(compareTo.getGuid())) {
            if (!this.itemExpression.deduplicationSecondPhase) {
                LOGGER.info("Deduplication reached second phase");
                this.itemExpression.deduplicationSecondPhase = true;
            }
            return true;
        }
        if (this.itemExpression.deduplicationSecondPhase && this.topLevelGuid.equals(compareTo.getTopLevelGuid())) {
            return false;
        }
        String compareToKey = compareTo.getTopLevelKey();
        if (this.topLevelKey == null || compareToKey == null) {
            return false;
        }
        boolean comparisonResult = this.topLevelKey.equals(compareToKey);
        return comparisonResult;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

