/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.nuix;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.nuix.CustomItemExpression;
import nuix.Item;

public class CustomDeduplicatorByItem {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CustomDeduplicatorByItem.class);
    private String deduplicationKey;
    private int hashCode;
    private String guid;
    private CustomItemExpression itemExpression;

    public CustomDeduplicatorByItem(Item item, CustomItemExpression itemExpression) {
        this.itemExpression = itemExpression;
        this.guid = item.getGuid();
        this.deduplicationKey = itemExpression.getGuidToDeduplicationKey().get(this.guid);
        LOGGER.info("Item " + this.guid + "  - " + item.getName() + " has key " + this.deduplicationKey);
        this.hashCode = this.deduplicationKey == null ? 0 : this.deduplicationKey.hashCode();
    }

    public String getGuid() {
        return this.guid;
    }

    public String getDeduplicationKey() {
        return this.deduplicationKey;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CustomDeduplicatorByItem)) {
            return false;
        }
        CustomDeduplicatorByItem compareTo = (CustomDeduplicatorByItem)o;
        if (this.guid.equals(compareTo.getGuid())) {
            return true;
        }
        String compareToDeduplicationKey = compareTo.getDeduplicationKey();
        if (this.deduplicationKey == null || compareToDeduplicationKey == null) {
            return false;
        }
        return this.deduplicationKey.equals(compareToDeduplicationKey);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

