/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.nuix;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.options.itemset.DeduplicateBy;
import com.nuix.automate.workflow.core.nuix.CustomDeduplicationField;
import com.nuix.automate.workflow.core.nuix.CustomDeduplicatorByFamily;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.util.Map;
import nuix.Item;
import nuix.ItemExpression;

public class CustomItemExpression
implements ItemExpression {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CustomItemExpression.class);
    boolean deduplicationSecondPhase = false;
    private DeduplicateBy deduplicateBy;
    private Map<String, String> guidToDeduplicationKey;
    private CustomDeduplicationField customDeduplicationField;

    public CustomItemExpression(DeduplicateBy deduplicateBy, CustomDeduplicationField customDeduplicationField) {
        this.deduplicateBy = deduplicateBy;
        this.customDeduplicationField = customDeduplicationField;
    }

    public Map<String, String> getGuidToDeduplicationKey() {
        return this.guidToDeduplicationKey;
    }

    public Object evaluate(Item item) {
        if (this.deduplicateBy == DeduplicateBy.INDIVIDUAL) {
            return ItemsUtils.getItemKeyOrGuid(item, this.customDeduplicationField);
        }
        if (this.deduplicateBy == DeduplicateBy.FAMILY) {
            return new CustomDeduplicatorByFamily(item, this, this.customDeduplicationField);
        }
        return null;
    }
}

