/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.nuix.loadfile.edrm;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.nuix.loadfile.edrm.Batch;
import com.nuix.automate.workflow.core.nuix.loadfile.edrm.Document;
import com.nuix.automate.workflow.core.nuix.loadfile.edrm.ExternalFile;
import com.nuix.automate.workflow.core.nuix.loadfile.edrm.File;
import com.nuix.automate.workflow.core.nuix.loadfile.edrm.Root;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class Serializer {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Serializer.class);
    private XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
    private static Serializer _instance;

    public static synchronized Serializer instance() {
        if (_instance == null) {
            _instance = new Serializer();
        }
        return _instance;
    }

    private Serializer() {
        LOGGER.info("Initializing XStream");
        this.xstream.ignoreUnknownElements();
        this.xstream.allowTypesByWildcard(new String[]{"com.nuix.automate.**"});
        this.xstream.alias("Batch", Batch.class);
        this.xstream.alias("Document", Document.class);
        this.xstream.alias("ExternalFile", ExternalFile.class);
        this.xstream.alias("File", File.class);
        this.xstream.alias("Root", Root.class);
        this.xstream.processAnnotations(Batch.class);
        this.xstream.processAnnotations(Document.class);
        this.xstream.processAnnotations(ExternalFile.class);
        this.xstream.processAnnotations(File.class);
        this.xstream.processAnnotations(Root.class);
    }

    public static String formatXml(String xml) {
        try {
            TransformerFactory factory = SAXTransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer serializer = factory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
            StreamResult res = new StreamResult(new ByteArrayOutputStream());
            serializer.transform(xmlSource, res);
            return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return xml;
        }
    }

    public void serialize(Object o, java.io.File file) throws IOException {
        String xmlText = this.xstream.toXML(o);
        xmlText = Serializer.formatXml(xmlText);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            bufferedWriter.write(xmlText);
        }
    }

    public String serialize(Object o) throws IOException {
        String xmlText = this.xstream.toXML(o);
        xmlText = Serializer.formatXml(xmlText);
        return xmlText;
    }

    public Object deserialize(java.io.File file) throws IOException {
        String xml = FileUtils.readFileWithAutodetectEncoding((java.io.File)file);
        return this.deserialize(xml);
    }

    public Object deserialize(String s) throws IOException {
        return this.xstream.fromXML(s);
    }

    public Object deserialize(URL u) throws IOException {
        return this.xstream.fromXML(u);
    }
}

