/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.antlr;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.antlr.CriteriaDetails;
import com.nuix.automate.workflow.core.utils.antlr.v13.JavaConditionVisitorV13;
import com.nuix.automate.workflow.core.utils.antlr.v13.QueryParser;
import com.nuix.automate.workflow.core.utils.antlr.v7.JavaConditionVisitorV7;
import com.nuix.automate.workflow.core.utils.antlr.v7.QueryLexer;
import com.nuix.automate.workflow.core.utils.antlr.v7.QueryParser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class AntlrUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AntlrUtils.class);
    private static AntlrUtils instance;

    public static AntlrUtils getInstance() {
        if (instance == null) {
            instance = new AntlrUtils();
        }
        return instance;
    }

    public CriteriaDetails getSavedSearchConditions(String savedSearchQuery) {
        try {
            LOGGER.info("Loading ANTLR 4.7.2");
            QueryLexer lexer = new QueryLexer((CharStream)CharStreams.fromString((String)savedSearchQuery));
            QueryParser parser = new QueryParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            QueryParser.SearchCriteriaContext result = parser.searchCriteria();
            JavaConditionVisitorV7 visitor = new JavaConditionVisitorV7();
            visitor.visit((ParseTree)result);
            return new CriteriaDetails(visitor.getConditions(), visitor.getSearchCriteria());
        }
        catch (Throwable t) {
            String message = ExceptionUtils.getExceptionPrintableMessage((Throwable)t);
            if (message.contains("Could not deserialize ATN with version 3 (expected 4)")) {
                LOGGER.info("Loading ANTLR 4.13.1");
                com.nuix.automate.workflow.core.utils.antlr.v13.QueryLexer lexer = new com.nuix.automate.workflow.core.utils.antlr.v13.QueryLexer((CharStream)CharStreams.fromString((String)savedSearchQuery));
                com.nuix.automate.workflow.core.utils.antlr.v13.QueryParser parser = new com.nuix.automate.workflow.core.utils.antlr.v13.QueryParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                QueryParser.SearchCriteriaContext result = parser.searchCriteria();
                JavaConditionVisitorV13 visitor = new JavaConditionVisitorV13();
                visitor.visit((ParseTree)result);
                return new CriteriaDetails(visitor.getConditions(), visitor.getSearchCriteria());
            }
            throw t;
        }
    }
}

