/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.antlr.v13;

import com.google.gson.JsonNull;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.BooleanConditionOperator;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.CriteriaOperator;
import com.nuix.automate.workflow.core.utils.antlr.criteria.Criteria;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaBase;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaCollection;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaCondition;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaConditionBase;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaDateCondition;
import com.nuix.automate.workflow.core.utils.antlr.criteria.FieldIdentifier;
import com.nuix.automate.workflow.core.utils.antlr.v13.QueryBaseVisitor;
import com.nuix.automate.workflow.core.utils.antlr.v13.QueryParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.antlr.v4.runtime.tree.ParseTree;

public class JavaConditionVisitorV13
extends QueryBaseVisitor {
    private AtomicInteger nested = new AtomicInteger(0);
    private CriteriaCollection searchCriteria = new CriteriaCollection();
    private List<CriteriaCollection> nestedArrays = new ArrayList<CriteriaCollection>();
    private List<CriteriaConditionBase> conditions = new ArrayList<CriteriaConditionBase>();
    private Map<QueryParser.ExpressionContext, CriteriaBase> contextCriteriaMap = new HashMap<QueryParser.ExpressionContext, CriteriaBase>();

    public JavaConditionVisitorV13() {
        this.nestedArrays.add(this.searchCriteria);
        this.searchCriteria.setBooleanOperator(BooleanConditionOperator.NONE);
    }

    public CriteriaCollection getSearchCriteria() {
        return this.searchCriteria;
    }

    public List<CriteriaConditionBase> getConditions() {
        return this.conditions;
    }

    @Override
    public Object visitSearchCriteria(QueryParser.SearchCriteriaContext ctx) {
        this.handleExpression((QueryParser.ExpressionContext)((Object)ctx.children.get(0)));
        return null;
    }

    @Override
    public CriteriaDateCondition visitDateExpression(QueryParser.DateExpressionContext ctx) {
        FieldIdentifier fieldIdentifier = this.visitField(ctx.field());
        CriteriaOperator operator = this.visitBinaryOperator(ctx.binaryOperator());
        CriteriaDateCondition condition = new CriteriaDateCondition(fieldIdentifier, operator);
        condition.setMonth("NotSet");
        switch (operator) {
            case IN: {
                if (ctx.dateValue().MONTH() != null) {
                    condition.setMonth(ctx.dateValue().MONTH().getText());
                    condition.setValue("MonthOf");
                    break;
                }
                if (ctx.dateValue().THIS_WEEK() != null) {
                    condition.setValue("ThisWeek");
                    break;
                }
                if (ctx.dateValue().THIS_MONTH() != null) {
                    condition.setValue("ThisMonth");
                    break;
                }
                if (ctx.dateValue().NEXT_WEEK() != null) {
                    condition.setValue("NextWeek");
                    break;
                }
                if (ctx.dateValue().LAST_WEEK() != null) {
                    condition.setValue("LastWeek");
                    break;
                }
                if (ctx.dateValue().LAST_7_DAYS() != null) {
                    condition.setValue("Last7Days");
                    break;
                }
                if (ctx.dateValue().LAST_30_DAYS() == null) break;
                condition.setValue("Last30Days");
                break;
            }
            case IS: {
                String dateValue = ctx.dateValue().getText();
                if (dateValue.length() > 10) {
                    condition.setValue(dateValue);
                    break;
                }
                String dayStart = dateValue + "T00:00:00";
                String dayEnd = dateValue + "T23:59:59";
                String[] array = new String[]{dayStart, dayEnd};
                condition.setValue(array);
                break;
            }
            case IS_BEFORE: 
            case IS_BEFORE_OR_ON: 
            case IS_AFTER: 
            case IS_AFTER_OR_ON: {
                condition.setValue(ctx.dateValue().getText());
                break;
            }
            case BETWEEN: {
                String dateAfter = ((ParseTree)ctx.dateValue().children.get(0)).getText();
                String dateBefore = ((ParseTree)ctx.dateValue().children.get(2)).getText();
                String[] array = new String[]{dateAfter, dateBefore};
                condition.setValue(array);
                break;
            }
        }
        if (operator.hasNotOperator()) {
            boolean isNotOperator = this.isNotOperator(ctx.binaryOperator().getText(), operator);
            condition.setNotOperator(isNotOperator);
        }
        this.conditions.add(condition);
        return condition;
    }

    @Override
    public CriteriaCondition visitObjectExpression(QueryParser.ObjectExpressionContext ctx) {
        FieldIdentifier fieldIdentifier = this.visitField(ctx.field());
        CriteriaOperator operator = this.visitBinaryOperator(ctx.binaryOperator());
        AtomicInteger objectNested = new AtomicInteger(0);
        CriteriaCollection objectValue = new CriteriaCollection();
        objectValue.setBooleanOperator(BooleanConditionOperator.NONE);
        ArrayList<CriteriaCollection> objectNestedArrays = new ArrayList<CriteriaCollection>();
        objectNestedArrays.add(objectValue);
        this.handleObjectExpression(ctx.expression(), objectNested, objectNestedArrays);
        CriteriaCondition condition = new CriteriaCondition(fieldIdentifier, operator);
        condition.setValue(objectValue);
        if (operator.hasNotOperator()) {
            boolean isNotOperator = this.isNotOperator(ctx.binaryOperator().getText(), operator);
            condition.setNotOperator(isNotOperator);
        }
        this.conditions.add(condition);
        return condition;
    }

    @Override
    public CriteriaCondition visitBinaryExpression(QueryParser.BinaryExpressionContext ctx) {
        FieldIdentifier fieldIdentifier = this.visitField(ctx.field());
        CriteriaOperator operator = this.visitBinaryOperator(ctx.binaryOperator());
        CriteriaCondition condition = new CriteriaCondition(fieldIdentifier, operator);
        Object value = this.visitValue(ctx.value());
        if (fieldIdentifier.getName().equals("(Saved Search)") && fieldIdentifier.getArtifactId() == 0L) {
            condition.setValue(Integer.parseInt(value.toString()));
        } else {
            condition.setValue(value);
        }
        if (operator.hasNotOperator()) {
            boolean isNotOperator = this.isNotOperator(ctx.binaryOperator().getText(), operator);
            condition.setNotOperator(isNotOperator);
        }
        this.conditions.add(condition);
        return condition;
    }

    @Override
    public CriteriaCondition visitUnaryExpression(QueryParser.UnaryExpressionContext ctx) {
        FieldIdentifier fieldIdentifier = this.visitField(ctx.field());
        CriteriaOperator operator = this.visitUnaryOperator(ctx.unaryOperator());
        CriteriaCondition condition = new CriteriaCondition(fieldIdentifier, operator);
        condition.setValue(JsonNull.INSTANCE);
        if (operator.hasNotOperator()) {
            boolean isNotOperator = this.isNotOperator(ctx.unaryOperator().getText(), operator);
            condition.setNotOperator(isNotOperator);
        }
        this.conditions.add(condition);
        return condition;
    }

    @Override
    public CriteriaCollection visitNestedExpression(QueryParser.NestedExpressionContext ctx) {
        this.nested.addAndGet(1);
        CriteriaCollection conditions = new CriteriaCollection();
        this.nestedArrays.get(this.nestedArrays.size() - 1).getConditions().add(conditions);
        this.nestedArrays.add(conditions);
        this.handleExpression((QueryParser.ExpressionContext)((Object)ctx.children.get(1)));
        BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
        if (logicalOperator != null) {
            conditions.setBooleanOperator(logicalOperator);
        } else {
            conditions.setBooleanOperator(BooleanConditionOperator.NONE);
        }
        this.contextCriteriaMap.put(ctx, conditions);
        this.nestedArrays.remove(this.nested.get());
        this.nested.decrementAndGet();
        return null;
    }

    @Override
    public CriteriaCollection visitRecursiveExpression(QueryParser.RecursiveExpressionContext ctx) {
        for (ParseTree tree : ctx.children) {
            if (tree.getClass().equals(QueryParser.LogicalOperatorContext.class)) continue;
            this.handleExpression((QueryParser.ExpressionContext)tree);
        }
        return null;
    }

    @Override
    public FieldIdentifier visitField(QueryParser.FieldContext ctx) {
        String fieldName = ctx.getText().replace("[", "").replace("]", "");
        FieldIdentifier object = new FieldIdentifier();
        if (fieldName.equals("Saved Search")) {
            fieldName = "(Saved Search)";
            object.setArtifactId(0L);
        }
        object.setName(fieldName);
        return object;
    }

    private boolean isNotOperator(String ctx, CriteriaOperator criteriaOperator) {
        return ctx.equals(CriteriaOperator.toQueryString(criteriaOperator, true));
    }

    @Override
    public CriteriaOperator visitUnaryOperator(QueryParser.UnaryOperatorContext ctx) {
        return CriteriaOperator.fromQueryString(ctx.getText());
    }

    @Override
    public CriteriaOperator visitBinaryOperator(QueryParser.BinaryOperatorContext ctx) {
        return CriteriaOperator.fromQueryString(ctx.getText());
    }

    @Override
    public BooleanConditionOperator visitLogicalOperator(QueryParser.LogicalOperatorContext ctx) {
        return BooleanConditionOperator.valueOf(ctx.getText().toUpperCase());
    }

    @Override
    public Object visitValue(QueryParser.ValueContext ctx) {
        if (ctx.getText().startsWith("[")) {
            String[] split;
            ArrayList<Integer> array = new ArrayList<Integer>();
            for (String str : split = ctx.getText().replace("[", "").replace("]", "").split(",")) {
                array.add(Integer.parseInt(str.trim()));
            }
            return array;
        }
        String value = ctx.getText().substring(1, ctx.getText().length() - 1);
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return Boolean.valueOf(value);
        }
        return ctx.getText().substring(1, ctx.getText().length() - 1);
    }

    private void handleExpression(QueryParser.ExpressionContext ctx) {
        int childrenSize = ctx.children.size();
        if (childrenSize < 2) {
            return;
        }
        Class<?> clazz = ((Object)((Object)ctx)).getClass();
        if (clazz.equals(QueryParser.NestedExpressionContext.class)) {
            this.visitNestedExpression((QueryParser.NestedExpressionContext)ctx);
        } else if (clazz.equals(QueryParser.BinaryExpressionContext.class)) {
            Criteria condition = new Criteria();
            condition.setCondition(this.visitBinaryExpression((QueryParser.BinaryExpressionContext)ctx));
            BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
            if (logicalOperator != null) {
                condition.setBooleanOperator(logicalOperator);
            } else {
                condition.setBooleanOperator(BooleanConditionOperator.NONE);
            }
            this.contextCriteriaMap.put(ctx, condition);
            this.nestedArrays.get(this.nested.get()).getConditions().add(condition);
        } else if (clazz.equals(QueryParser.UnaryExpressionContext.class)) {
            Criteria condition = new Criteria();
            condition.setCondition(this.visitUnaryExpression((QueryParser.UnaryExpressionContext)ctx));
            BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
            if (logicalOperator != null) {
                condition.setBooleanOperator(logicalOperator);
            } else {
                condition.setBooleanOperator(BooleanConditionOperator.NONE);
            }
            this.contextCriteriaMap.put(ctx, condition);
            this.nestedArrays.get(this.nested.get()).getConditions().add(condition);
        } else if (clazz.equals(QueryParser.DateExpressionContext.class)) {
            Criteria condition = new Criteria();
            condition.setCondition(this.visitDateExpression((QueryParser.DateExpressionContext)ctx));
            BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
            if (logicalOperator != null) {
                condition.setBooleanOperator(logicalOperator);
            } else {
                condition.setBooleanOperator(BooleanConditionOperator.NONE);
            }
            this.contextCriteriaMap.put(ctx, condition);
            this.nestedArrays.get(this.nested.get()).getConditions().add(condition);
        } else if (clazz.equals(QueryParser.ObjectExpressionContext.class)) {
            Criteria condition = new Criteria();
            condition.setCondition(this.visitObjectExpression((QueryParser.ObjectExpressionContext)ctx));
            BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
            if (logicalOperator != null) {
                condition.setBooleanOperator(logicalOperator);
            }
            this.contextCriteriaMap.put(ctx, condition);
            this.nestedArrays.get(this.nested.get()).getConditions().add(condition);
        } else {
            this.visitRecursiveExpression((QueryParser.RecursiveExpressionContext)ctx);
        }
    }

    private void handleObjectExpression(QueryParser.ExpressionContext ctx, AtomicInteger objectNested, List<CriteriaCollection> objectNestedArrays) {
        int childrenSize = ctx.children.size();
        if (childrenSize < 2) {
            return;
        }
        Class<?> clazz = ((Object)((Object)ctx)).getClass();
        if (clazz.equals(QueryParser.NestedExpressionContext.class)) {
            this.handleObjectNestedExpression((QueryParser.NestedExpressionContext)ctx, objectNested, objectNestedArrays);
        } else if (clazz.equals(QueryParser.BinaryExpressionContext.class)) {
            Criteria condition = new Criteria();
            condition.setCondition(this.visitBinaryExpression((QueryParser.BinaryExpressionContext)ctx));
            BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
            if (logicalOperator != null) {
                condition.setBooleanOperator(logicalOperator);
            } else {
                condition.setBooleanOperator(BooleanConditionOperator.NONE);
            }
            this.contextCriteriaMap.put(ctx, condition);
            objectNestedArrays.get(objectNested.get()).getConditions().add(condition);
        } else if (clazz.equals(QueryParser.UnaryExpressionContext.class)) {
            Criteria condition = new Criteria();
            condition.setCondition(this.visitUnaryExpression((QueryParser.UnaryExpressionContext)ctx));
            BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
            if (logicalOperator != null) {
                condition.setBooleanOperator(logicalOperator);
            } else {
                condition.setBooleanOperator(BooleanConditionOperator.NONE);
            }
            this.contextCriteriaMap.put(ctx, condition);
            objectNestedArrays.get(objectNested.get()).getConditions().add(condition);
        } else if (clazz.equals(QueryParser.DateExpressionContext.class)) {
            Criteria condition = new Criteria();
            condition.setCondition(this.visitDateExpression((QueryParser.DateExpressionContext)ctx));
            BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
            if (logicalOperator != null) {
                condition.setBooleanOperator(logicalOperator);
            } else {
                condition.setBooleanOperator(BooleanConditionOperator.NONE);
            }
            this.contextCriteriaMap.put(ctx, condition);
            objectNestedArrays.get(objectNested.get()).getConditions().add(condition);
        } else if (clazz.equals(QueryParser.ObjectExpressionContext.class)) {
            Criteria condition = new Criteria();
            condition.setCondition(this.visitObjectExpression((QueryParser.ObjectExpressionContext)ctx));
            BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
            if (logicalOperator != null) {
                condition.setBooleanOperator(logicalOperator);
            } else {
                condition.setBooleanOperator(BooleanConditionOperator.NONE);
            }
            this.contextCriteriaMap.put(ctx, condition);
            objectNestedArrays.get(objectNested.get()).getConditions().add(condition);
        } else {
            this.handleObjectRecursiveExpression((QueryParser.RecursiveExpressionContext)ctx, objectNested, objectNestedArrays);
        }
    }

    public void handleObjectNestedExpression(QueryParser.NestedExpressionContext ctx, AtomicInteger objectNested, List<CriteriaCollection> objectNestedArrays) {
        objectNested.addAndGet(1);
        CriteriaCollection conditions = new CriteriaCollection();
        objectNestedArrays.get(objectNestedArrays.size() - 1).getConditions().add(conditions);
        objectNestedArrays.add(conditions);
        this.handleObjectExpression((QueryParser.ExpressionContext)((Object)ctx.children.get(1)), objectNested, objectNestedArrays);
        BooleanConditionOperator logicalOperator = this.getLogicalOperatorFromParent(ctx);
        if (logicalOperator != null) {
            conditions.setBooleanOperator(logicalOperator);
        } else {
            conditions.setBooleanOperator(BooleanConditionOperator.NONE);
        }
        this.contextCriteriaMap.put(ctx, conditions);
        objectNestedArrays.remove(objectNested.get());
        objectNested.decrementAndGet();
    }

    public void handleObjectRecursiveExpression(QueryParser.RecursiveExpressionContext ctx, AtomicInteger objectNested, List<CriteriaCollection> objectNestedArrays) {
        for (ParseTree tree : ctx.children) {
            if (tree.getClass().equals(QueryParser.LogicalOperatorContext.class)) continue;
            this.handleObjectExpression((QueryParser.ExpressionContext)tree, objectNested, objectNestedArrays);
        }
    }

    private BooleanConditionOperator getLogicalOperatorFromParent(QueryParser.ExpressionContext ctx) {
        if (ctx.getParent().children.size() < 3) {
            return null;
        }
        if (((ParseTree)ctx.getParent().children.get(0)).getClass().equals(QueryParser.RecursiveExpressionContext.class)) {
            QueryParser.ExpressionContext childContext = this.getLastRecursiveChildExpression((QueryParser.ExpressionContext)((Object)ctx.getParent().children.get(0)));
            CriteriaBase baseCondition = this.contextCriteriaMap.get((Object)childContext);
            if (baseCondition instanceof Criteria) {
                ((Criteria)baseCondition).setBooleanOperator(this.visitLogicalOperator((QueryParser.LogicalOperatorContext)((Object)ctx.getParent().children.get(1))));
            } else if (baseCondition instanceof CriteriaCollection) {
                ((CriteriaCollection)baseCondition).setBooleanOperator(this.visitLogicalOperator((QueryParser.LogicalOperatorContext)((Object)ctx.getParent().children.get(1))));
            }
            return null;
        }
        if (ctx.getParent().children.indexOf((Object)ctx) != 0) {
            return null;
        }
        if (((ParseTree)ctx.getParent().children.get(1)).getClass().equals(QueryParser.LogicalOperatorContext.class)) {
            return this.visitLogicalOperator((QueryParser.LogicalOperatorContext)((Object)ctx.getParent().children.get(1)));
        }
        return null;
    }

    private QueryParser.ExpressionContext getLastRecursiveChildExpression(QueryParser.ExpressionContext context) {
        if (((Object)((Object)context)).getClass().equals(QueryParser.RecursiveExpressionContext.class)) {
            return this.getLastRecursiveChildExpression((QueryParser.ExpressionContext)((Object)context.children.get(2)));
        }
        return context;
    }
}

